/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.admin.CatalogMappingStrategy;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.CatalogEventT;
import com.ibm.rmm.mtl.admin.CatalogStateT;
import com.ibm.rmm.mtl.transmitter.MLJETopicT;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.ptl.admin.CatalogEntry;

public class CatalogT {
    private static final String mn = "Admin";
    static final byte ACTION_REMOVE = 0;
    static final byte ACTION_ADD = 1;
    private static CatalogT myself;
    private static CatalogStateT catalogState;
    private static CatalogEventT catalogEvent;
    private static CatalogMappingStrategy mappingStrategy;
    private static boolean initiated;

    CatalogT(String stateName, String stateAddress, String eventName, String eventAddress) {
        CatalogT.createCatalogState(stateName, stateAddress);
        CatalogT.createCatalogEvent(eventName, eventAddress);
        myself = this;
        initiated = true;
    }

    private static void createCatalogState(String stateTopicName, String stateTopicAddress) {
        if (catalogState == null) {
            MLJETopicT stateTopicT = MTransmitter.getInstance().createLJETopicTransmitter(stateTopicName, stateTopicAddress);
            catalogState = new CatalogStateT(stateTopicT);
        }
    }

    long getStateId() {
        return catalogState.getId();
    }

    private static void createCatalogEvent(String eventTopicName, String eventTopicAddress) {
        if (catalogEvent == null) {
            MTopicT eventTopicT = MTransmitter.getInstance().createTopicTransmitter(eventTopicName, true, eventTopicAddress);
            catalogEvent = new CatalogEventT(eventTopicT);
        }
    }

    long getEventId() {
        return catalogEvent.getId();
    }

    public static void addTopic(MTopicT topicT) {
        if (!initiated) {
            return;
        }
        CatalogEntry ce = catalogState.addTopic(topicT);
        if (ce != null) {
            catalogEvent.publishEvent(ce, (byte)1);
        }
    }

    public static void removeTopic(MTopicT topicT) {
        if (!initiated) {
            return;
        }
        CatalogEntry ce = catalogState.removeTopic(topicT);
        if (ce != null) {
            catalogEvent.publishEvent(ce, (byte)0);
        }
    }

    static void setMappingStrategy(CatalogMappingStrategy strategy) {
        mappingStrategy = strategy;
    }

    public static String getAddress(String topicName) {
        if (mappingStrategy != null) {
            return mappingStrategy.getAddress(topicName);
        }
        AdminClient.rmmLogger.baseWarn("CatalogT.getAddress mappingStrategy is not set", null, mn);
        return null;
    }
}

