/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.AdminTopicR;
import com.ibm.rmm.mtl.admin.TopicInterestSession;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.admin.TopicHandle;
import com.ibm.rmm.ptl.admin.TopicInterestReport;
import com.ibm.rmm.util.RmmAddressIf;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConfirmTopicInterest
implements ReportListener {
    private static final String mn = "Admin";
    private final AdminClient adminClient;
    private final AdminTopicR adminTopic;
    private final Map openSessions = new HashMap();

    ConfirmTopicInterest() {
        this.adminClient = AdminClient.getInstance();
        this.adminTopic = this.adminClient.getAdminTopicR();
        this.adminTopic.addReportListener(this, 1);
        this.adminClient.addReportListener(this.getReportListener(), 1);
    }

    TopicInterestReport castReport(Report report) {
        try {
            return (TopicInterestReport)report;
        }
        catch (ClassCastException e2) {
            AdminClient.rmmLogger.baseError("Failed to downcast report to TopicInterestReport", e2, mn);
            return null;
        }
    }

    private boolean findInterested(TopicHandle t) {
        List topics = this.adminClient.getTopicListR();
        Iterator i = topics.iterator();
        while (i.hasNext()) {
            MStreamSetR set = (MStreamSetR)i.next();
            byte[] tag = null;
            try {
                tag = Sutils.stringToBytes(t.getTag());
            }
            catch (UnsupportedEncodingException e2) {
                AdminClient.rmmLogger.baseError("Failed to convert topic", e2, mn);
            }
            Reporter reporter = Reporter.getReporter(t.getHostId(), t.getPort(), true);
            if (!set.getStreamSelector().acceptStream(tag, tag.length, t.getStreamId(), reporter.getInetAddress(), t.getPort())) continue;
            return true;
        }
        return false;
    }

    void sendTopicInterestResponse(byte[] msg, RmmAddressIf dest) {
        this.adminTopic.sendReport(msg, dest, true, true);
    }

    boolean sendTcpTopicInterestResponse(String ip, int port2, byte[] msg) {
        Reporter center = Reporter.getReporter(ip, port2, true);
        if (center != null) {
            return center.sendMessage(msg);
        }
        return false;
    }

    private ReportListener getReportListener() {
        return new ReportListener(){

            public void onReport(Report report, Reporter reporter) {
                TopicInterestReport ti_report = ConfirmTopicInterest.this.castReport(report);
                if (ti_report == null) {
                    return;
                }
                byte[] msg = ConfirmTopicInterest.this.findInterested(ti_report.getTopicHandle()) ? ti_report.generateResponse() : ti_report.generateNotInterestedResponse();
                boolean sent = reporter.sendMessage(msg);
                if (!sent) {
                    AdminClient.rmmLogger.baseError("Can not send response back to " + reporter.getInetAddress().getHostAddress() + " socket is closed", null, ConfirmTopicInterest.mn);
                }
            }
        };
    }

    public void onReport(Report report, Reporter reporter) {
        TopicInterestReport ti_report = this.castReport(report);
        if (ti_report == null) {
            return;
        }
        if (ti_report.isResponse()) {
            this.topicInterestSuppression(ti_report);
        } else if (ti_report.isDone()) {
            this.topicInterestDone(ti_report);
        } else {
            this.startTopicInterestSession(ti_report, reporter);
        }
    }

    private void startTopicInterestSession(TopicInterestReport ti_report, Reporter reporter) {
        if (this.findInterested(ti_report.getTopicHandle())) {
            Reporter center = Reporter.getReporter(ti_report.getCenterAddress(), ti_report.getCenterPort(), true);
            if (center != null && center.connectionIsOpen() && center.sendMessage(ti_report.generateResponse())) {
                this.sendTopicInterestResponse(ti_report.generateResponse(), reporter);
                return;
            }
            TopicInterestSession ti_session = new TopicInterestSession(ti_report, reporter, this);
            this.openSessions.put(new Integer(ti_report.getSessionId()), ti_session);
        }
    }

    private void topicInterestSuppression(TopicInterestReport ti_report) {
        TopicInterestSession ti_session = (TopicInterestSession)this.openSessions.get(new Integer(ti_report.getSessionId()));
        if (ti_session != null) {
            ti_session.addSuppression();
        }
    }

    private void topicInterestDone(TopicInterestReport ti_report) {
        TopicInterestSession ti_session = (TopicInterestSession)this.openSessions.get(new Integer(ti_report.getSessionId()));
        if (ti_session != null) {
            ti_session.cancel();
        }
    }

    void removeTopicInterstSession(TopicInterestReport ti_report) {
        this.openSessions.remove(ti_report);
    }
}

