/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.Config;
import com.ibm.rmm.mtl.admin.ConfirmTopicInterest;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.admin.TopicInterestReport;

public class TopicInterestSession
implements TaskIf {
    private static final String mn = "Admin";
    private final TopicInterestReport tiReport;
    private final Reporter source;
    private final ConfirmTopicInterest parent;
    private int suppressionCounter = 0;
    private long next_time;
    private boolean firstTime;

    TopicInterestSession(TopicInterestReport ti_report, Reporter source, ConfirmTopicInterest ctr) {
        this.parent = ctr;
        this.tiReport = ti_report;
        this.source = source;
        long timeout = this.generateRandomBackoffTime();
        this.next_time = Clock.getTime() + timeout;
        this.firstTime = true;
        AdminClient.taskManR.addTask(this);
    }

    public void timerExpired(long curTime) {
        byte[] msg = this.tiReport.generateResponse();
        if (this.firstTime) {
            this.firstTime = false;
            this.parent.sendTopicInterestResponse(msg, this.source);
            this.next_time = curTime + (long)Config.waitForDoneTimeout;
        } else {
            this.sendTcpResponse();
            this.parent.removeTopicInterstSession(this.tiReport);
            AdminClient.taskManR.removeTask(this);
        }
    }

    private long generateRandomBackoffTime() {
        return (long)Sutils.randomGen.nextInt(Config.maxSuppressionBackoff) + 1L;
    }

    void addSuppression() {
        ++this.suppressionCounter;
        if (this.suppressionCounter > this.tiReport.getMaxResponses()) {
            this.cancel();
        }
    }

    private boolean sendTcpResponse() {
        return this.parent.sendTcpTopicInterestResponse(this.tiReport.getCenterAddress(), this.tiReport.getCenterPort(), this.tiReport.generateResponse());
    }

    void cancel() {
        AdminClient.taskManR.removeTask(this);
        this.parent.removeTopicInterstSession(this.tiReport);
    }

    public long getNextTime() {
        return this.next_time;
    }
}

