/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.admin;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.Config;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.admin.NackListener;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.admin.TopicInterestReport;
import com.ibm.rmm.util.TopicInterestListener;
import java.io.UnsupportedEncodingException;

public class VerifyTopicInterest
implements TaskIf,
NackListener,
ReportListener {
    private static final String mn = "Admin";
    private byte flags = (byte)31;
    private byte maxResponses = Config.maxResponses;
    private static int sessionId = Sutils.randomGen.nextInt();
    private final int mySessionId;
    private final String topicName;
    private final long streamId;
    private final String host;
    private final int port;
    private DataStreamT dataStream;
    private final TopicInterestListener listener;
    private long timeout;
    private boolean done = false;
    private AdminClient adminClient;
    private long next_time;

    public VerifyTopicInterest(String topicName, long streamId, String host, int port2, TopicInterestListener listener, long timeout_millis) {
        this.topicName = topicName;
        this.streamId = streamId;
        this.host = host;
        this.port = port2;
        this.listener = listener;
        this.timeout = timeout_millis * 1000L;
        this.mySessionId = sessionId++;
        this.adminClient = AdminClient.getInstance();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        this.registerForNacks();
        if (!this.done) {
            this.verifyInterestUsingUnicast();
        }
        if (!this.done) {
            this.adminClient.addReportListener(this, 1);
            this.adminClient.getAdminTopicT().addReportListener(this, 1);
            byte[] report = ReportFactory.generateTopicInterestRequest(this.mySessionId, this.flags, this.topicName, this.streamId, this.host, this.port, this.maxResponses, AdminClient.rmmAddress);
            this.adminClient.getAdminTopicT().submitMessage(report);
        }
        VerifyTopicInterest verifyTopicInterest = this;
        synchronized (verifyTopicInterest) {
            if (!this.done) {
                this.next_time = Clock.getTime() + this.timeout;
                AdminClient.taskManT.addTask(this);
            }
        }
    }

    private void registerForNacks() {
        try {
            byte[] tag = Sutils.stringToTag(this.topicName);
            this.dataStream = DataStreamT.getDataStream(tag);
            if (this.dataStream == null) {
                AdminClient.rmmLogger.baseWarn("No match found fot topic " + this.topicName + " at this transmitter", null, mn);
                return;
            }
            this.dataStream.addNackListener(this);
        }
        catch (UnsupportedEncodingException e2) {
            AdminClient.rmmLogger.baseError("Can not register for nacks", e2, mn);
        }
    }

    private void verifyInterestUsingUnicast() {
    }

    private synchronized void informResult(Reporter reporter) {
        if (!this.done) {
            this.done = true;
            this.sendDoneMessage();
            this.listener.interestResult(this.topicName, reporter);
            this.cleanup();
        }
    }

    public void timerExpired(long curTime) {
        this.informResult(null);
        AdminClient.taskManT.removeTask(this);
    }

    public void onReport(Report report, Reporter reporter) {
        if (this.reportForMe(report)) {
            this.informResult(reporter);
        }
    }

    public void onNack(int quantity, long ts, Reporter reporter) {
        if (this.fresh(ts)) {
            this.informResult(reporter);
        }
    }

    private boolean fresh(long last_nack_ts) {
        long current_time = Clock.getTime();
        return current_time - this.timeout < last_nack_ts;
    }

    private boolean reportForMe(Report report) {
        try {
            TopicInterestReport ti_report = (TopicInterestReport)report;
            return ti_report.isResponse() && ti_report.getSessionId() == this.mySessionId;
        }
        catch (ClassCastException e2) {
            return false;
        }
    }

    private void sendDoneMessage() {
        byte[] report = ReportFactory.generateTopicInterestDone(this.mySessionId);
        this.adminClient.getAdminTopicT().submitMessage(report);
    }

    private void cleanup() {
        if (this.dataStream != null) {
            this.dataStream.removeNackListener(this);
        }
        this.adminClient.removeReportListener(this, 1);
        this.adminClient.getAdminTopicT().removeReportListener(this, 1);
        AdminClient.taskManT.removeTask(this);
    }

    public long getNextTime() {
        return this.next_time;
    }
}

