/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.mtl.admin.AdminTopic;
import com.ibm.rmm.util.RmmLogger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class Config {
    private static final String moduleName = "MTL_R";
    static final String VERSION = "1.9.8.19 - 16/03/09";
    static final int MAX_EXC_COUNT = 0;
    int MAX_MESSAGEANNOUNCER_THREADS = 100;
    RmmLogger rmmLogger;
    String logFile;
    InetAddress multicastInterface;
    boolean bindAll = true;
    String ptlProtocol;
    int serverPort = 0;
    long receptionBufferLimit = 0L;
    long maxReceptionBufferLimit = 0L;
    public boolean enableAdmin = false;
    int dataPort;
    boolean disableMulticast = false;
    boolean disableUnicast = true;
    boolean verifyQueueSize = true;
    boolean newMtl;
    boolean collectStats;
    int statsPeriod = 2000;
    boolean useTcpChannel;
    boolean threadPerTopic = true;
    int msgAnnouncerThreads = 0;
    int clockUpdateInterval = 10;
    boolean isOK;

    Config(RmmLogger rlog, Properties props, boolean read_levels) {
        String tmp;
        this.rmmLogger = rlog;
        this.isOK = true;
        int ll = 1;
        int dl = 1;
        if (read_levels) {
            tmp = props.getProperty("LogLevel");
            if (tmp == null) {
                this.rmmLogger.baseLog(402, new Object[]{"LogLevel"}, null, moduleName);
            } else {
                ll = tmp.regionMatches(true, 0, "no", 0, 2) ? 0 : (tmp.regionMatches(true, 0, "max", 0, 3) ? 2 : 1);
            }
            this.logFile = props.getProperty("LogFile");
            if (this.logFile == null) {
                this.rmmLogger.baseLog(402, new Object[]{"LogFile"}, null, moduleName);
            }
            if ((tmp = props.getProperty("DebugLevel")) == null) {
                this.rmmLogger.baseLog(402, new Object[]{"DebugLevel"}, null, moduleName);
            } else {
                dl = tmp.regionMatches(true, 0, "no", 0, 2) ? 0 : (tmp.regionMatches(true, 0, "max", 0, 3) ? 2 : 1);
            }
            this.rmmLogger.changeLevels(ll, dl);
        }
        if ((tmp = props.getProperty("EnableAdminModule")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("EnableAdminModule", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.enableAdmin = Boolean.valueOf(tmp);
        }
        if (this.enableAdmin) {
            String admin_gr = props.getProperty("AdminMulticastGroup");
            AdminTopic.setAdminGroup(admin_gr);
        }
        if ((tmp = props.getProperty("BindAllInterfaces")) != null) {
            this.bindAll = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("ClockUpdateIntervalMilli")) != null) {
            try {
                this.clockUpdateInterval = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("ClockUpdateInterval", tmp, e2, moduleName);
                this.isOK = false;
                return;
            }
            if (this.clockUpdateInterval < 1 || this.clockUpdateInterval > 10000) {
                this.rmmLogger.baseBadParam("ClockUpdateInterval", "" + this.clockUpdateInterval, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("MulticastInterface")) == null || tmp.trim().length() == 0) {
            this.multicastInterface = null;
        } else if (tmp.equalsIgnoreCase("none") || tmp.equalsIgnoreCase("all")) {
            this.multicastInterface = null;
        } else {
            try {
                this.multicastInterface = InetAddress.getByName(tmp);
            }
            catch (UnknownHostException ex) {
                this.rmmLogger.baseError("Failed to init NW interface " + tmp, ex, moduleName);
                this.rmmLogger.baseLog(412, new Object[]{tmp}, ex, moduleName);
                this.isOK = false;
                return;
            }
            try {
                Enumeration<NetworkInterface> nws = NetworkInterface.getNetworkInterfaces();
                boolean found = false;
                while (nws.hasMoreElements()) {
                    Enumeration<InetAddress> adrs = nws.nextElement().getInetAddresses();
                    while (adrs.hasMoreElements()) {
                        InetAddress address = adrs.nextElement();
                        if (!this.multicastInterface.equals(address)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) {
                    rlog.baseError("NW interface " + tmp + " - not in local NW interface list. Using default", null, moduleName);
                    this.rmmLogger.baseBadParam("MulticastInterface", tmp, new Exception("Network Interface " + tmp + " was not found in local machine network interface list. Make sure that the NetworkInterface property is properly configured!"), moduleName);
                    this.isOK = false;
                    return;
                }
            }
            catch (Exception e3) {
                rlog.baseError("Failed to retrieve NW interf list. Cannot check interface validity", e3, moduleName);
            }
        }
        this.ptlProtocol = props.getProperty("ProtocolType");
        if (this.ptlProtocol != null && this.ptlProtocol.toLowerCase().startsWith("pgm")) {
            this.newMtl = true;
        }
        if ((tmp = props.getProperty("ReceptionBufferLimitKbytes")) != null) {
            try {
                this.receptionBufferLimit = 1024 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e4) {
                this.rmmLogger.baseBadParam("ReceptionBufferLimitKbytes", tmp, e4, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("MaxReceptionBufferLimitKbytes")) != null) {
            try {
                this.maxReceptionBufferLimit = 1024 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("MaxReceptionBufferLimitKbytes", tmp, e5, moduleName);
                this.isOK = false;
                return;
            }
            if (this.maxReceptionBufferLimit != 0L && this.maxReceptionBufferLimit < this.receptionBufferLimit) {
                this.rmmLogger.baseBadParam("MaxReceptionBufferLimitKbytes (" + this.maxReceptionBufferLimit + ") must not be less than ReceptionBufferLimit (" + this.receptionBufferLimit + ")", "" + this.maxReceptionBufferLimit, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("MaxMemoryAllowedKBytes")) != null) {
            if (this.receptionBufferLimit > 0L) {
                this.rmmLogger.baseWarn("Cannot use MaxMemoryAllowedKBytes parameter: ReceptionBufferLimitKbytes already set", null, moduleName);
            } else {
                int val;
                try {
                    val = 1024 * Integer.parseInt(tmp);
                }
                catch (NumberFormatException e6) {
                    this.rmmLogger.baseBadParam("MaxMemoryAllowedKBytes", tmp, e6, moduleName);
                    this.isOK = false;
                    return;
                }
                int n_buf = 500;
                tmp = props.getProperty("PacketBuffers");
                if (tmp != null) {
                    try {
                        n_buf = Integer.parseInt(tmp);
                    }
                    catch (NumberFormatException e7) {
                        this.rmmLogger.baseBadParam("PacketBuffers", tmp, e7, moduleName);
                        this.isOK = false;
                        return;
                    }
                }
                int p_size = 33000;
                tmp = props.getProperty("PacketBufferSizeBytes");
                if (tmp != null) {
                    try {
                        p_size = Integer.parseInt(tmp);
                    }
                    catch (NumberFormatException e8) {
                        this.rmmLogger.baseBadParam("PacketBufferSizeBytes", tmp, e8, moduleName);
                        this.isOK = false;
                        return;
                    }
                }
                this.receptionBufferLimit = val - n_buf * p_size;
                this.rmmLogger.baseInfo("ReceptionBufferLimitKbytes set to " + this.receptionBufferLimit / 1024L, moduleName);
                if (this.receptionBufferLimit < 102400L) {
                    this.rmmLogger.baseBadParam("MaxMemoryAllowedKBytes - Npack*PackSize", "" + this.receptionBufferLimit, null, moduleName);
                    this.isOK = false;
                    return;
                }
            }
        }
        if ((tmp = props.getProperty("DisableMulticast")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("DisableMulticast", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.disableMulticast = Boolean.valueOf(tmp);
            if (this.disableMulticast) {
                this.rmmLogger.baseInfo("   Multicast Disabled\n", moduleName);
            }
        }
        if (!this.disableMulticast) {
            tmp = props.getProperty("DataPort");
            if (tmp == null) {
                this.rmmLogger.baseLog(402, new Object[]{"DataPort"}, null, moduleName);
            } else {
                try {
                    this.dataPort = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e9) {
                    this.rmmLogger.baseBadParam("DataPort", tmp, e9, moduleName);
                    this.isOK = false;
                    return;
                }
            }
            if (this.dataPort <= 0 || this.dataPort >= 65535) {
                this.rmmLogger.baseBadParam("DataPort", "" + this.dataPort, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("DisableUnicast")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("DisableUnicast", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.disableUnicast = Boolean.valueOf(tmp);
            if (this.disableUnicast) {
                this.rmmLogger.baseInfo("   Unicast Disabled\n", moduleName);
            }
        }
        if (!this.disableUnicast && (tmp = props.getProperty("ServerSocketPort")) != null) {
            try {
                this.serverPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e10) {
                this.rmmLogger.baseBadParam("ServerSocketPort", tmp, e10, moduleName);
                this.isOK = false;
                return;
            }
            if (this.serverPort <= 0 || this.serverPort > 65535) {
                this.rmmLogger.baseBadParam("ServerSocketPort", "" + this.serverPort, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("CollectStats")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("CollectStats", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.collectStats = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("StatisticsPeriodSec")) != null) {
            try {
                this.statsPeriod = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e11) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", tmp, e11, moduleName);
                this.isOK = false;
                return;
            }
            if (this.statsPeriod <= 0) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", "" + this.statsPeriod, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("UseTcpChannel")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("UseTcpChannel", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.useTcpChannel = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("ThreadPerTopic")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("ThreadPerTopic", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.threadPerTopic = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("MessageAnnouncerThreads")) != null) {
            try {
                this.msgAnnouncerThreads = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e12) {
                this.rmmLogger.baseBadParam("MessageAnnouncerThreads", tmp, e12, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (!(this.threadPerTopic || this.msgAnnouncerThreads > 0 && this.msgAnnouncerThreads <= this.MAX_MESSAGEANNOUNCER_THREADS)) {
            this.rmmLogger.baseError("Ilegal value of MessageAnnouncerThreads" + this.msgAnnouncerThreads, null, moduleName);
            this.rmmLogger.baseBadParam("MessageAnnouncerThreads", tmp, null, moduleName);
            this.isOK = false;
            return;
        }
        if (!this.threadPerTopic && this.msgAnnouncerThreads > 20) {
            this.rmmLogger.baseWarn("Large value of MessageAnnouncerThreads" + this.msgAnnouncerThreads, null, moduleName);
        }
    }
}

