/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.mtl.receiver.MessageStream;

public class LongMsgStreamHash {
    int hashMaxSize;
    int nEl;
    long[] keys;
    MessageStream[] values;
    int version = 0;

    public LongMsgStreamHash(int initial_size) {
        this.hashMaxSize = initial_size;
        this.keys = new long[this.hashMaxSize];
        this.values = new MessageStream[this.hashMaxSize];
        this.nEl = 0;
    }

    public synchronized MessageStream[] getValues() {
        MessageStream[] res = new MessageStream[this.nEl];
        int i = 0;
        while (i < this.nEl) {
            res[i] = this.values[i];
            ++i;
        }
        return res;
    }

    int size() {
        return this.nEl;
    }

    public synchronized void put(long key, MessageStream value2) {
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                this.values[i] = value2;
                return;
            }
            ++i;
        }
        if (this.nEl == this.hashMaxSize) {
            long[] tmp_k = new long[2 * this.hashMaxSize];
            MessageStream[] tmp_v = new MessageStream[2 * this.hashMaxSize];
            int i2 = 0;
            while (i2 < this.hashMaxSize) {
                tmp_k[i2] = this.keys[i2];
                tmp_v[i2] = this.values[i2];
                ++i2;
            }
            this.keys = tmp_k;
            this.values = tmp_v;
            this.hashMaxSize *= 2;
        }
        this.keys[this.nEl] = key;
        this.values[this.nEl] = value2;
        ++this.nEl;
        ++this.version;
    }

    public synchronized MessageStream get(long key) {
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean containsKey(long key) {
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean remove(long key) {
        int indx = 0;
        boolean found = false;
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                indx = i;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            return false;
        }
        --this.nEl;
        this.keys[indx] = this.keys[this.nEl];
        this.values[indx] = this.values[this.nEl];
        this.keys[this.nEl] = 0L;
        this.values[this.nEl] = null;
        ++this.version;
        return true;
    }
}

