/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.intrn.util.BundlePool;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.receiver.Config;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.mtl.receiver.MTopicR;
import com.ibm.rmm.mtl.receiver.MessageAnnouncer;
import com.ibm.rmm.mtl.receiver.MessageStream;
import com.ibm.rmm.mtl.receiver.SetListenerImp;
import com.ibm.rmm.mtl.receiver.TagMatcher;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.mstp.receiver.PReceiver;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.DefaultLogListener;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.MemoryReport;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import com.ibm.rmm.util.StackTracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class MReceiver {
    private static final String moduleName = "MTL_R";
    public RmmLogger rmmLogger;
    public RmmAddress rmmAddress;
    public TaskManager taskMan;
    public Config config;
    public StatusDumper statusDumper;
    public AdminNode adminNode;
    public Vector apiJoinedGroups;
    Properties configProperties;
    Map configMap;
    MReceiver instance = null;
    MTransmitter myMTransmitter;
    PReceiverIf pReceiver;
    PReceiverIf unicastPReceiver;
    boolean isRunning;
    private static String[] eventDescr = new String[200];
    Vector topicReceivers;
    Vector queueReceivers;
    boolean checkReceptionBuffers;
    BundlePool bundlePool;
    Object nmsgAnnouncerLock;
    int msgAnnouncers_running;
    MessageAnnouncer[] maArray;
    int maArrayIndex;
    private boolean isOK;
    boolean memory_alert;
    MStreamSetR memory_alert_topic = null;
    Object memoryAlertLock;

    static {
        MReceiver.eventDescr[0] = "No such event";
        MReceiver.eventDescr[1] = "Unrecoverable packet loss";
        MReceiver.eventDescr[2] = "Control packet (heartbeat) timed out";
        MReceiver.eventDescr[3] = "Transmitter uses newer protocol version";
        MReceiver.eventDescr[4] = "Reliability modes of transmitter and receiver differ";
        MReceiver.eventDescr[5] = "Transmission closed by one source";
        MReceiver.eventDescr[10] = "New data source";
        MReceiver.eventDescr[12] = "Repair requests (Nack) suspended";
        MReceiver.eventDescr[11] = "Reception suspended";
        MReceiver.eventDescr[14] = "Data reception resumed. Nacks still suspended";
        MReceiver.eventDescr[13] = "Full reception resumed. Data received, Nacks sent";
        MReceiver.eventDescr[100] = "Reception buffer overflow";
        MReceiver.eventDescr[101] = "Reception buffer memory alert is ON";
        MReceiver.eventDescr[102] = "Reception buffer memory alert is OFF";
        MReceiver.eventDescr[103] = "Message memory allocation failure";
        MReceiver.eventDescr[17] = "No data source detected on Topic";
        MReceiver.eventDescr[19] = "Connection heartbeat timeout";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MReceiver(RmmAddress rmr, TaskManager tman, RmmLogger rlog, Properties config_props, Map config_map, boolean read_levels) {
        this.rmmLogger = rlog;
        this.isOK = true;
        this.rmmLogger.baseInfo("Start up time: " + new Date(), moduleName);
        this.rmmLogger.baseInfo("RMM Version: 1.9.8.19 - 16/03/09", moduleName);
        this.rmmLogger.baseInfo("OS Name: " + System.getProperty("os.name"), moduleName);
        this.rmmLogger.baseInfo("Receiver configuration: \n" + config_props, moduleName);
        try {
            this.rmmLogger.baseInfo("Local address: " + InetAddress.getLocalHost(), moduleName);
            this.rmmLogger.baseInfo("Listing all local interfaces: ", moduleName);
            Enumeration<NetworkInterface> nws = NetworkInterface.getNetworkInterfaces();
            while (nws.hasMoreElements()) {
                NetworkInterface ni = nws.nextElement();
                this.rmmLogger.baseInfo("local interface: " + ni, moduleName);
                Enumeration<InetAddress> adrs = ni.getInetAddresses();
                while (adrs.hasMoreElements()) {
                    InetAddress address = adrs.nextElement();
                    this.rmmLogger.baseInfo("interface address: " + address, moduleName);
                }
            }
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to retrieve local address or NW interf list.", e2, moduleName);
        }
        this.configMap = config_map;
        this.topicReceivers = new Vector();
        this.queueReceivers = new Vector();
        this.memoryAlertLock = new Object();
        this.isRunning = true;
        this.apiJoinedGroups = new Vector();
        this.configProperties = config_props;
        this.config = new Config(rlog, config_props, read_levels);
        if (!this.config.isOK) {
            this.isOK = false;
            return;
        }
        if (tman == null) {
            this.taskMan = new TaskManager(this.config.clockUpdateInterval);
            this.rmmLogger.baseInfo("Starting TaskManager with SleepTime of " + this.taskMan.nominalSleep(), moduleName);
        } else {
            this.taskMan = tman;
        }
        if (this.config.logFile != null && !this.config.logFile.equalsIgnoreCase("std")) {
            try {
                PrintStream logPrintStream = new PrintStream(new FileOutputStream(this.config.logFile));
                this.rmmLogger.baseInfo("From NOW ON,the standard and error streams redirected to " + this.config.logFile, moduleName);
                System.setOut(logPrintStream);
                System.setErr(logPrintStream);
                this.rmmLogger.baseInfo("Start up time: " + new Date(), moduleName);
                this.rmmLogger.baseInfo("RMM Version: 1.9.8.19 - 16/03/09", moduleName);
                this.rmmLogger.baseInfo("OS Name: " + System.getProperty("os.name"), moduleName);
                this.rmmLogger.baseInfo("Receiver configuration: \n" + config_props, moduleName);
            }
            catch (FileNotFoundException ex) {
                this.rmmLogger.baseLog(401, new Object[]{this.config.logFile}, ex, moduleName);
            }
        }
        if (rmr == null) {
            boolean create_sockets = !this.config.disableMulticast || this.config.serverPort == 0;
            int port2 = create_sockets ? this.config.serverPort : this.config.serverPort;
            this.rmmAddress = new RmmAddress(this.rmmLogger, this.config.multicastInterface, port2, create_sockets);
            if (!this.rmmAddress.isValid()) {
                if (this.config.disableMulticast && this.config.multicastInterface == null && this.config.bindAll) {
                    this.rmmLogger.baseWarn("RMReceiver has an invalid Rmm address but can continue." + rmr, null, moduleName);
                } else {
                    this.isOK = false;
                    return;
                }
            }
        } else {
            this.rmmAddress = rmr;
            this.rmmLogger.baseInfo("RMReceiver uses an externally provided Rmm address (id): " + rmr, moduleName);
        }
        if (!this.config.disableMulticast) {
            boolean scs;
            if (this.config.ptlProtocol == null || this.config.ptlProtocol.equalsIgnoreCase("mstp") || this.config.ptlProtocol.equalsIgnoreCase("ptl")) {
                this.pReceiver = new PReceiver();
                this.rmmLogger.baseInfo("Receiver: Selecting MSTP PTL", moduleName);
            } else {
                this.pReceiver = new com.ibm.rmm.ptl.pgm.receiver.PReceiver();
                this.rmmLogger.baseInfo("Receiver: Selecting PGM PTL", moduleName);
            }
            if (this.config.enableAdmin) {
                AdminClient.rmmAddress = this.rmmAddress;
                AdminClient.rmmLogger = this.rmmLogger;
            }
            if (!(scs = this.pReceiver.init(this.rmmAddress, this.rmmLogger, this.taskMan, config_props, config_map, this.rmmAddress.getInetAddress()))) {
                this.pReceiver = null;
                this.isOK = false;
                return;
            }
            if (this.config.enableAdmin) {
                this.adminNode = AdminNode.getInstance(this.pReceiver);
            }
        }
        if (!this.config.disableUnicast) {
            this.unicastPReceiver = this.config.useTcpChannel ? new com.ibm.rmm.ptl.tchan.receiver.PReceiver() : new com.ibm.rmm.ptl.tcp.receiver.PReceiver();
            boolean scs = this.unicastPReceiver.init(this.rmmAddress, this.rmmLogger, this.taskMan, this.configProperties, config_map, this.rmmAddress.getInetAddress());
            if (!scs) {
                this.unicastPReceiver = null;
                this.isOK = false;
                return;
            }
        }
        boolean bl = this.checkReceptionBuffers = this.config.collectStats || this.config.receptionBufferLimit > 0L;
        if (this.config.collectStats) {
            this.statusDumper = new StatusDumper(this);
        }
        this.nmsgAnnouncerLock = new Object();
        this.msgAnnouncers_running = 0;
        this.maArray = new MessageAnnouncer[this.config.MAX_MESSAGEANNOUNCER_THREADS];
        this.maArrayIndex = 0;
    }

    public static synchronized MReceiver getInstance() {
        return MReceiver.getInstance(null, null);
    }

    public static synchronized MReceiver getInstance(RmmAddress rma, TaskManager tman) {
        File config_file = null;
        String config_file_name = System.getProperty("receiver.config");
        config_file = config_file_name != null ? new File(config_file_name) : new File("receiver.config");
        return MReceiver.getInstance(rma, tman, config_file, null, null, 0, 0, null);
    }

    public static synchronized MReceiver getInstance(Properties config_props, int log_level, int debug_level, LogEventListener listener) {
        return MReceiver.getInstance(null, null, null, config_props, null, log_level, debug_level, listener);
    }

    public static synchronized MReceiver getInstance(RmmAddress rma, TaskManager tman, Properties config_props, Map config_map, int log_level, int debug_level, LogEventListener listener) {
        return MReceiver.getInstance(rma, tman, null, config_props, config_map, log_level, debug_level, listener);
    }

    private static MReceiver getInstance(RmmAddress rma, TaskManager tman, File config_file, Properties config_props, Map config_map, int log_level, int debug_level, LogEventListener listener) {
        RmmLogger rmm_logger;
        boolean read_levels = false;
        if (listener != null) {
            rmm_logger = new RmmLogger(listener, log_level, debug_level);
            rmm_logger.baseInfo("Log level: " + log_level, moduleName);
            if (log_level != 0 && log_level != 1 && log_level != 2) {
                rmm_logger.baseBadParam("logLevel", "" + log_level, null, moduleName);
                return null;
            }
            if (debug_level != 0 && debug_level != 1 && debug_level != 2) {
                rmm_logger.baseBadParam("debugLevel", "" + debug_level, null, moduleName);
                return null;
            }
        } else {
            rmm_logger = new RmmLogger(new DefaultLogListener(), 2, 2);
            read_levels = true;
        }
        if (config_file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(config_file);
            }
            catch (FileNotFoundException ex) {
                rmm_logger.baseLog(401, new Object[]{"" + config_file}, ex, moduleName);
                return null;
            }
            config_props = new Properties();
            try {
                config_props.load(fis);
            }
            catch (IOException ex) {
                rmm_logger.baseError("Failed to load configuration", ex, moduleName);
                return null;
            }
        }
        MReceiver instance = new MReceiver(rma, tman, rmm_logger, config_props, config_map, read_levels);
        if (instance.isOK) {
            return instance;
        }
        return null;
    }

    public List getTopicList() {
        return this.topicReceivers;
    }

    public String currentStatusLog(boolean writeToLog) {
        block10: {
            try {
                if (this.rmmLogger.getLogLevel() != 2 && writeToLog) {
                    return null;
                }
                StringBuffer stat = new StringBuffer();
                stat.append("_RMM_STATS_\n_RMM_STATS_********* - ").append("1.9.8.19 - 16/03/09").append(" - *********************\n");
                if (this.pReceiver != null) {
                    stat.append("_RMM_STATS_ PReceiver Status:\n_RMM_STATS_").append(this.pReceiver.getStatusLog()).append('\n');
                }
                Object[] topics = this.topicReceivers.toArray();
                int i = 0;
                while (i < topics.length) {
                    MStreamSetR mssr = (MStreamSetR)topics[i];
                    stat.append("_RMM_STATS_ ------------ TopicR: ").append(mssr).append('\n');
                    stat.append("_RMM_STATS_ Fifo Q size: ").append(mssr.totalFifoSize).append(". Msgs Q size: ").append(mssr.totalMsgSize);
                    stat.append(". MsgAnn: ").append(mssr.messageAnnouncer.nRot).append('\n');
                    MessageStream[] streams = mssr.mStreamHT.getValues();
                    int n = streams.length;
                    int j = 0;
                    while (j < n) {
                        MessageStream ms = streams[j];
                        stat.append("_RMM_STATS_  Stream: ").append(ms.pStream.getId()).append('\n');
                        stat.append("_RMM_STATS_    Front #: ").append(ms.pStream.getFrontSeqN()).append(". Trail#: ").append(ms.trailSeqN);
                        stat.append(". Contig #: ").append(ms.lastContigN).append(". Processed Packs: ").append(ms.nProcessedPackets).append('\n');
                        stat.append("_RMM_STATS_    Received Msgs: ").append(ms.totalMessagesReceived);
                        stat.append(". Delivered Msgs: ").append(ms.totalMessagesDelivered).append('\n');
                        ++j;
                    }
                    ++i;
                }
                if (this.unicastPReceiver != null) {
                    stat.append("_RMM_STATS_UnicastPReceiver Status:\n_RMM_STATS_").append(this.unicastPReceiver.getStatusLog()).append('\n');
                }
                Object[] queues = this.queueReceivers.toArray();
                int i2 = 0;
                while (i2 < queues.length) {
                    MStreamSetR mssr = (MStreamSetR)queues[i2];
                    stat.append("_RMM_STATS_------------ QueueR: ").append(mssr).append('\n');
                    stat.append("_RMM_STATS_ Fifo Q size: ").append(mssr.totalFifoSize).append(". Msgs Q size: ").append(mssr.totalMsgSize).append('\n');
                    MessageStream[] streams = mssr.mStreamHT.getValues();
                    int n = streams.length;
                    int j = 0;
                    while (j < n) {
                        MessageStream ms = streams[j];
                        stat.append("_RMM_STATS_  Stream: ").append(ms.pStream.getId()).append(" Name: ").append(ms.topicName).append('\n');
                        stat.append("_RMM_STATS_    Front #: ").append(ms.pStream.getFrontSeqN()).append(". Trail#: ").append(ms.trailSeqN);
                        stat.append(". Contig #: ").append(ms.lastContigN).append(". Processed Packs: ").append(ms.nProcessedPackets).append('\n');
                        stat.append("_RMM_STATS_    Received Msgs: ").append(ms.totalMessagesReceived).append(". Delivered Msgs: ").append(ms.totalMessagesDelivered).append('\n');
                        ++j;
                    }
                    ++i2;
                }
                stat.append("_RMM_STATS_********************************\n");
                if (writeToLog) {
                    this.rmmLogger.maxInfo(stat.toString(), moduleName);
                    break block10;
                }
                return stat.toString();
            }
            catch (Throwable ex) {
                this.rmmLogger.baseError("Exception when collecting Receiver status; ignoring.", ex, moduleName);
            }
        }
        return null;
    }

    public synchronized MTopicR createTopicReceiver(String topic, boolean reliable, boolean ordered) {
        byte[] tag;
        if (this.config.disableMulticast) {
            this.rmmLogger.baseError("Cannot create TopicR: Multicast is disabled in Config", null, moduleName);
        }
        if (this.pReceiver == null) {
            this.rmmLogger.baseError("Cannot create TopicR: pReceiver is null", null, moduleName);
            return null;
        }
        try {
            int i = 0;
            while (i < this.topicReceivers.size()) {
                MTopicR t;
                if (this.topicReceivers.elementAt(i) instanceof MTopicR && (t = (MTopicR)this.topicReceivers.elementAt(i)).getTopicName().equals(topic)) {
                    this.rmmLogger.baseError("Failed to create TopicR: Topic receivers for this topic name (" + topic + ") already exists", new StackTracer(), moduleName);
                    return null;
                }
                ++i;
            }
        }
        catch (Exception exp) {
            this.rmmLogger.baseError("Failed to create TopicR: Exception caught (" + topic + ")", exp, moduleName);
            return null;
        }
        try {
            tag = Sutils.stringToTag(topic);
        }
        catch (UnsupportedEncodingException ex) {
            this.rmmLogger.baseError("Failed to convert Topic to Tag", ex, moduleName);
            this.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, ex, moduleName);
            return null;
        }
        TagMatcher tm = new TagMatcher(tag, tag.length);
        MTopicR topic_r = new MTopicR(this, topic, ordered);
        SetListenerImp pl = new SetListenerImp(this, topic_r);
        topic_r.streamSelector = tm;
        topic_r.packetListener = pl;
        topic_r.isReliable = reliable;
        topic_r.isP2P = false;
        this.topicReceivers.add(topic_r);
        return topic_r;
    }

    public synchronized MTopicR createQueueReceiver(String queue) {
        byte[] tag;
        try {
            int i = 0;
            while (i < this.queueReceivers.size()) {
                MTopicR t;
                if (this.queueReceivers.elementAt(i) instanceof MTopicR && (t = (MTopicR)this.queueReceivers.elementAt(i)).getTopicName().equals(queue)) {
                    this.rmmLogger.baseError("Failed to create QueueR: Queue receiver for this name (" + queue + ") already exists", new StackTracer(), moduleName);
                    return null;
                }
                ++i;
            }
        }
        catch (Exception exp) {
            this.rmmLogger.baseError("Failed to create QueueR: Exception caught (" + queue + ")", exp, moduleName);
            return null;
        }
        try {
            tag = Sutils.stringToTag(queue);
        }
        catch (UnsupportedEncodingException ex) {
            this.rmmLogger.baseError("Failed to convert Topic to Tag", ex, moduleName);
            this.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, ex, moduleName);
            return null;
        }
        TagMatcher tm = new TagMatcher(tag, tag.length);
        MTopicR topic_r = new MTopicR(this, queue, true);
        SetListenerImp pl = new SetListenerImp(this, topic_r);
        if (this.unicastPReceiver == null) {
            this.unicastPReceiver = this.config.useTcpChannel ? new com.ibm.rmm.ptl.tchan.receiver.PReceiver() : new com.ibm.rmm.ptl.tcp.receiver.PReceiver();
            boolean scs = this.unicastPReceiver.init(this.rmmAddress, this.rmmLogger, this.taskMan, this.configProperties, this.configMap, this.rmmAddress.getInetAddress());
            if (!scs) {
                this.unicastPReceiver = null;
                return null;
            }
        }
        topic_r.isP2P = true;
        topic_r.streamSelector = tm;
        topic_r.packetListener = pl;
        topic_r.isReliable = true;
        this.queueReceivers.add(topic_r);
        return topic_r;
    }

    public synchronized MStreamSetR createStreamSetReceiver(StreamSelector matcher, boolean reliable, boolean ordered) {
        if (this.config.disableMulticast) {
            this.rmmLogger.baseError("Cannot create StreamSetR: Multicast is disabled in Config", null, moduleName);
        }
        if (this.pReceiver == null) {
            this.rmmLogger.baseError("Cannot create StreamSetR: pReceiver is null", null, moduleName);
            return null;
        }
        MStreamSetR topic_r = new MStreamSetR(this, ordered);
        SetListenerImp pl = new SetListenerImp(this, topic_r);
        topic_r.streamSelector = matcher;
        topic_r.packetListener = pl;
        topic_r.isReliable = reliable;
        topic_r.isP2P = false;
        this.topicReceivers.add(topic_r);
        return topic_r;
    }

    public synchronized MStreamSetR createQueueReceiver(StreamSelector matcher) {
        MStreamSetR topic_r = new MStreamSetR(this, true);
        SetListenerImp pl = new SetListenerImp(this, topic_r);
        if (this.unicastPReceiver == null) {
            this.unicastPReceiver = this.config.useTcpChannel ? new com.ibm.rmm.ptl.tchan.receiver.PReceiver() : new com.ibm.rmm.ptl.tcp.receiver.PReceiver();
            boolean scs = this.unicastPReceiver.init(this.rmmAddress, this.rmmLogger, this.taskMan, this.configProperties, this.configMap, this.rmmAddress.getInetAddress());
            if (!scs) {
                this.unicastPReceiver = null;
                return null;
            }
        }
        topic_r.isP2P = true;
        topic_r.streamSelector = matcher;
        topic_r.packetListener = pl;
        topic_r.isReliable = true;
        this.queueReceivers.add(topic_r);
        return topic_r;
    }

    public static String eventDescription(int event_type) {
        if (event_type < 0 || event_type >= eventDescr.length) {
            return "No such event";
        }
        return eventDescr[event_type];
    }

    public synchronized void stop() {
        this.isRunning = false;
        if (this.unicastPReceiver != null) {
            this.unicastPReceiver.stop();
            this.unicastPReceiver = null;
        }
        if (this.pReceiver != null) {
            this.pReceiver.stop();
            this.pReceiver = null;
        }
        if (this.statusDumper != null) {
            this.statusDumper.removeDumper();
        }
        if (this.adminNode != null) {
            this.adminNode.stop();
        }
        if (!this.config.threadPerTopic) {
            int i = 0;
            while (i < this.config.MAX_MESSAGEANNOUNCER_THREADS) {
                MessageAnnouncer ma = this.maArray[i];
                if (ma != null) {
                    ma.interrupt();
                }
                ++i;
            }
        }
        while (this.topicReceivers.size() > 0) {
            MStreamSetR topic = (MStreamSetR)this.topicReceivers.get(0);
            topic.close();
        }
        while (this.queueReceivers.size() > 0) {
            MStreamSetR topic = (MStreamSetR)this.queueReceivers.get(0);
            topic.close();
        }
        this.topicReceivers = null;
        this.queueReceivers = null;
        if (this.taskMan != null) {
            this.taskMan.close();
        }
        this.instance = null;
    }

    public String getVersion() {
        return "1.9.8.19 - 16/03/09";
    }

    public boolean joinMulticastGroup(String address, int port2, boolean from_api) {
        if (from_api && !this.apiJoinedGroups.contains(address)) {
            this.apiJoinedGroups.add(address);
        }
        InetAddress itmp = null;
        try {
            itmp = InetAddress.getByName(address);
        }
        catch (UnknownHostException e2) {
            this.rmmLogger.baseLog(412, new Object[]{address}, e2, moduleName);
            return false;
        }
        if (itmp != null && !itmp.isMulticastAddress()) {
            this.rmmLogger.baseBadParam("MulticastAddress", address, new StackTracer(), moduleName);
            return false;
        }
        boolean res = this.pReceiver.joinMulticastGroup(itmp, port2);
        return res;
    }

    public boolean leaveMulticastGroup(String address, int port2, boolean from_api) {
        if (from_api && this.apiJoinedGroups.contains(address)) {
            this.apiJoinedGroups.remove(address);
        }
        InetAddress itmp = null;
        try {
            itmp = InetAddress.getByName(address);
        }
        catch (UnknownHostException e2) {
            this.rmmLogger.baseLog(412, new Object[]{address}, e2, moduleName);
            return false;
        }
        if (itmp != null && !itmp.isMulticastAddress()) {
            this.rmmLogger.baseBadParam("MulticastAddress", address, new StackTracer(), moduleName);
            return false;
        }
        boolean res = this.pReceiver.leaveMulticastGroup(itmp, port2);
        return res;
    }

    public synchronized void setMTransmitterStack(MTransmitter mTransmitter) {
        this.myMTransmitter = mTransmitter;
        if (this.unicastPReceiver != null) {
            this.unicastPReceiver.setPtransmitter(mTransmitter.getUnicastPTransmitter());
        }
    }

    public PReceiverIf getUnicastPReceiver() {
        return this.unicastPReceiver;
    }

    public MemoryReport checkMemoryConsumption() {
        long currentUsageMessageQ;
        long currentUsageFifoQ;
        int srcPort;
        InetAddress srcAddress;
        String srcTopicName;
        long srcStreamId;
        MessageStream stream;
        int sn;
        MessageStream[] list;
        MStreamSetR topic;
        long totalFifoQ = 0L;
        long totalMessageQ = 0L;
        MemoryReport report = new MemoryReport(this.config.receptionBufferLimit, this.config.maxReceptionBufferLimit);
        int i = 0;
        while (i < this.topicReceivers.size()) {
            topic = null;
            try {
                topic = (MStreamSetR)this.topicReceivers.elementAt(i);
            }
            catch (Exception e2) {
                break;
            }
            if (topic != null) {
                list = topic.mStreamHT.getValues();
                sn = 0;
                while (sn < list.length) {
                    stream = list[sn];
                    srcStreamId = stream.pStream.getId();
                    srcTopicName = stream.topicName;
                    srcAddress = stream.sourceAddress;
                    srcPort = stream.sourcePort;
                    currentUsageFifoQ = stream.fifoQueueSize;
                    totalFifoQ += currentUsageFifoQ;
                    currentUsageMessageQ = stream.messageQueueSize;
                    totalMessageQ += currentUsageMessageQ;
                    report.addEntryToReport(srcStreamId, srcTopicName, srcAddress, srcPort, currentUsageFifoQ, currentUsageMessageQ);
                    ++sn;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.queueReceivers.size()) {
            topic = null;
            try {
                topic = (MStreamSetR)this.queueReceivers.elementAt(i);
            }
            catch (Exception e3) {
                break;
            }
            if (topic != null) {
                list = topic.mStreamHT.getValues();
                sn = 0;
                while (sn < list.length) {
                    stream = list[sn];
                    srcStreamId = stream.pStream.getId();
                    srcTopicName = stream.topicName;
                    srcAddress = stream.sourceAddress;
                    srcPort = stream.sourcePort;
                    currentUsageFifoQ = stream.fifoQueueSize;
                    totalFifoQ += currentUsageFifoQ;
                    currentUsageMessageQ = stream.messageQueueSize;
                    totalMessageQ += currentUsageMessageQ;
                    report.addEntryToReport(srcStreamId, srcTopicName, srcAddress, srcPort, currentUsageFifoQ, currentUsageMessageQ);
                    ++sn;
                }
            }
            ++i;
        }
        MemoryReport memoryReport = report;
        memoryReport.getClass();
        MemoryReport.MemoryUsed memUsed = new MemoryReport.MemoryUsed(memoryReport, totalFifoQ, totalMessageQ);
        report.setTotalMemoryUsed(memUsed);
        return report;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    class StatusDumper
    implements TaskIf {
        private MReceiver mRec;
        long lastTime;
        long period;
        private long next_time;

        StatusDumper(MReceiver mrc) {
            this.mRec = mrc;
            this.lastTime = Clock.getTime();
            this.next_time = this.lastTime + (long)this.mRec.config.statsPeriod;
            MReceiver.this.taskMan.addTask(this);
        }

        public void timerExpired(long curTime) {
            try {
                long time = curTime;
                if (time - this.lastTime >= (long)this.mRec.config.statsPeriod) {
                    this.mRec.currentStatusLog(true);
                    this.lastTime = time;
                    this.next_time = this.lastTime + (long)this.mRec.config.statsPeriod;
                }
            }
            catch (Exception ex) {
                this.mRec.rmmLogger.baseWarn("Status dump: Not initialized yet", null, MReceiver.moduleName);
            }
            catch (Throwable ex1) {
                this.mRec.rmmLogger.baseWarn("Status dump: unexpected exception", ex1, MReceiver.moduleName);
            }
        }

        public void removeDumper() {
            MReceiver.this.taskMan.removeTask(this);
        }

        public long getNextTime() {
            return this.next_time;
        }
    }
}

