/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.intrn.util.BundlePool;
import com.ibm.rmm.mtl.receiver.LongMsgStreamHash;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MessageAnnouncer;
import com.ibm.rmm.mtl.receiver.MessageStream;
import com.ibm.rmm.mtl.receiver.NewMessageStream;
import com.ibm.rmm.mtl.receiver.SetListenerImp;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetIf;
import com.ibm.rmm.receiver.AdvancedMessageListener;
import com.ibm.rmm.receiver.MessageBundleListener;
import com.ibm.rmm.receiver.MessageListener;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.util.Enumeration;
import java.util.Vector;

public class MStreamSetR {
    private static final String moduleName = "MTL_R";
    MReceiver mRec;
    boolean isP2P;
    StreamSelector streamSelector;
    SetListenerImp packetListener;
    boolean isReliable;
    boolean isFifo;
    boolean isBundle;
    StreamSetIf pStreamSet;
    LongMsgStreamHash mStreamHT;
    MessageStream[] maList = null;
    int maVersion = -1;
    Vector eventQueue;
    MessageListener messageListener;
    AdvancedMessageListener advancedMessageListener;
    MessageBundleListener bundledMessageListener;
    boolean advancedListenerSet;
    boolean listenerSet = false;
    MessageAnnouncer messageAnnouncer;
    private boolean isClosed;
    long totalMsgSize;
    long totalFifoSize;
    boolean msgAnnouncerOn;
    Object msgAnnouncerLock;
    Object recBufSizeLock = new Object();

    MStreamSetR(MReceiver mrc, boolean fifo) {
        this.mRec = mrc;
        this.mStreamHT = new LongMsgStreamHash(10);
        this.eventQueue = new Vector();
        this.isFifo = fifo;
        this.totalMsgSize = 0L;
        this.totalFifoSize = 0L;
        this.msgAnnouncerOn = false;
        this.msgAnnouncerLock = new Object();
    }

    MessageStream createMessageStream(StreamRIf stream) {
        MessageStream ms;
        if (!this.isP2P && this.mRec.config.newMtl) {
            ms = new NewMessageStream(this.mRec, this, stream, this.isFifo);
            this.mStreamHT.put(stream.getId(), ms);
        } else {
            ms = new MessageStream(this.mRec, this, stream, this.isFifo);
            this.mStreamHT.put(stream.getId(), ms);
        }
        return ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setMessageListener(MessageListener listener) {
        block12: {
            block11: {
                if (this.listenerSet) {
                    this.mRec.rmmLogger.baseWarn("Message Listener already set", new StackTracer(), moduleName);
                    return false;
                }
                if (listener == null) {
                    this.mRec.rmmLogger.baseBadParam("MessageListener", "null", new StackTracer(), moduleName);
                    return false;
                }
                this.messageListener = listener;
                this.listenerSet = true;
                this.pStreamSet = this.isP2P ? this.mRec.unicastPReceiver.createStreamSet(this.streamSelector, this.packetListener, this.isReliable, false) : this.mRec.pReceiver.createStreamSet(this.streamSelector, this.packetListener, this.isReliable, false);
                if (this.mRec.adminNode != null) {
                    this.pStreamSet.setAdminListener(this.mRec.adminNode.getAdminLayerListener());
                    this.mRec.adminNode.registerInterest(this.streamSelector);
                }
                if (this.messageAnnouncer != null) {
                    this.mRec.rmmLogger.baseWarn("MessageAnnouncer already set", new StackTracer(), moduleName);
                    return false;
                }
                if (!this.mRec.config.threadPerTopic) break block11;
                this.messageAnnouncer = new MessageAnnouncer(this.mRec, this);
                this.messageAnnouncer.start();
                break block12;
            }
            Object object = this.mRec.nmsgAnnouncerLock;
            synchronized (object) {
                block10: {
                    block13: {
                        if (this.mRec.msgAnnouncers_running >= this.mRec.config.msgAnnouncerThreads) break block13;
                        this.messageAnnouncer = new MessageAnnouncer(this.mRec, this);
                        this.messageAnnouncer.start();
                        this.mRec.maArray[this.mRec.msgAnnouncers_running] = this.messageAnnouncer;
                        ++this.mRec.msgAnnouncers_running;
                        break block12;
                    }
                    int n = 0;
                    while (n < this.mRec.msgAnnouncers_running && this.messageAnnouncer == null) {
                        this.messageAnnouncer = this.mRec.maArray[(n + this.mRec.maArrayIndex) % this.mRec.msgAnnouncers_running];
                        ++n;
                    }
                    if (this.messageAnnouncer != null) break block10;
                    this.mRec.rmmLogger.baseError("could not assign a messageAnnouncer for MstreamSetR", null, moduleName);
                    return false;
                }
                if (++this.mRec.maArrayIndex >= this.mRec.config.msgAnnouncerThreads) {
                    this.mRec.maArrayIndex = 0;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setAdvancedMessageListener(AdvancedMessageListener listener) {
        block12: {
            block11: {
                if (this.listenerSet) {
                    this.mRec.rmmLogger.baseWarn("Message Listener already set", new StackTracer(), moduleName);
                    return false;
                }
                if (listener == null) {
                    this.mRec.rmmLogger.baseBadParam("AdvancedMessageListener", "null", new StackTracer(), moduleName);
                    return false;
                }
                this.advancedMessageListener = listener;
                this.advancedListenerSet = true;
                this.listenerSet = true;
                this.pStreamSet = this.isP2P ? this.mRec.unicastPReceiver.createStreamSet(this.streamSelector, this.packetListener, this.isReliable, false) : this.mRec.pReceiver.createStreamSet(this.streamSelector, this.packetListener, this.isReliable, false);
                if (this.mRec.adminNode != null) {
                    this.pStreamSet.setAdminListener(this.mRec.adminNode.getAdminLayerListener());
                    this.mRec.adminNode.registerInterest(this.streamSelector);
                }
                if (this.messageAnnouncer != null) {
                    this.mRec.rmmLogger.baseWarn("MessageAnnouncer already set", new StackTracer(), moduleName);
                    return false;
                }
                if (!this.mRec.config.threadPerTopic) break block11;
                this.messageAnnouncer = new MessageAnnouncer(this.mRec, this);
                this.messageAnnouncer.start();
                break block12;
            }
            Object object = this.mRec.nmsgAnnouncerLock;
            synchronized (object) {
                block10: {
                    block13: {
                        if (this.mRec.msgAnnouncers_running >= this.mRec.config.msgAnnouncerThreads) break block13;
                        this.messageAnnouncer = new MessageAnnouncer(this.mRec, this);
                        this.messageAnnouncer.start();
                        this.mRec.maArray[this.mRec.msgAnnouncers_running] = this.messageAnnouncer;
                        ++this.mRec.msgAnnouncers_running;
                        break block12;
                    }
                    int n = 0;
                    while (n < this.mRec.msgAnnouncers_running && this.messageAnnouncer == null) {
                        this.messageAnnouncer = this.mRec.maArray[(n + this.mRec.maArrayIndex) % this.mRec.msgAnnouncers_running];
                        ++n;
                    }
                    if (this.messageAnnouncer != null) break block10;
                    this.mRec.rmmLogger.baseError("could not assign a messageAnnouncer for MstreamSetR", null, moduleName);
                    return false;
                }
                if (++this.mRec.maArrayIndex >= this.mRec.config.msgAnnouncerThreads) {
                    this.mRec.maArrayIndex = 0;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setMessageBundleListener(MessageBundleListener listener) {
        block16: {
            Object object;
            block15: {
                if (this.listenerSet) {
                    this.mRec.rmmLogger.baseWarn("Message Listener already set", new StackTracer(), moduleName);
                    return false;
                }
                if (listener == null) {
                    this.mRec.rmmLogger.baseBadParam("BundlesMessageListener", "null", new StackTracer(), moduleName);
                    return false;
                }
                this.bundledMessageListener = listener;
                this.isBundle = true;
                this.listenerSet = true;
                object = this.mRec.instance;
                synchronized (object) {
                    if (this.mRec.bundlePool == null) {
                        this.mRec.bundlePool = new BundlePool(1000, 7500);
                    }
                }
                this.pStreamSet = this.isP2P ? this.mRec.unicastPReceiver.createStreamSet(this.streamSelector, this.packetListener, this.isReliable, false) : this.mRec.pReceiver.createStreamSet(this.streamSelector, this.packetListener, this.isReliable, false);
                if (this.mRec.adminNode != null) {
                    this.pStreamSet.setAdminListener(this.mRec.adminNode.getAdminLayerListener());
                    this.mRec.adminNode.registerInterest(this.streamSelector);
                }
                if (this.messageAnnouncer != null) {
                    this.mRec.rmmLogger.baseWarn("MessageAnnouncer already set", new StackTracer(), moduleName);
                    return false;
                }
                if (!this.mRec.config.threadPerTopic) break block15;
                this.messageAnnouncer = new MessageAnnouncer(this.mRec, this);
                this.messageAnnouncer.start();
                break block16;
            }
            object = this.mRec.nmsgAnnouncerLock;
            synchronized (object) {
                block14: {
                    block17: {
                        if (this.mRec.msgAnnouncers_running >= this.mRec.config.msgAnnouncerThreads) break block17;
                        this.messageAnnouncer = new MessageAnnouncer(this.mRec, this);
                        this.messageAnnouncer.start();
                        this.mRec.maArray[this.mRec.msgAnnouncers_running] = this.messageAnnouncer;
                        ++this.mRec.msgAnnouncers_running;
                        break block16;
                    }
                    int n = 0;
                    while (n < this.mRec.msgAnnouncers_running && this.messageAnnouncer == null) {
                        this.messageAnnouncer = this.mRec.maArray[(n + this.mRec.maArrayIndex) % this.mRec.msgAnnouncers_running];
                        ++n;
                    }
                    if (this.messageAnnouncer != null) break block14;
                    this.mRec.rmmLogger.baseError("could not assign a messageAnnouncer for MstreamSetR", null, moduleName);
                    return false;
                }
                if (++this.mRec.maArrayIndex >= this.mRec.config.msgAnnouncerThreads) {
                    this.mRec.maArrayIndex = 0;
                }
            }
        }
        return true;
    }

    public StreamSelector getStreamSelector() {
        return this.streamSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.mRec.rmmLogger.baseInfo("StreamSet reception closed", moduleName);
        int counter = 500;
        while (counter > 0) {
            Object object = this.msgAnnouncerLock;
            synchronized (object) {
                if (!this.msgAnnouncerOn) {
                    this.msgAnnouncerOn = true;
                    break;
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException exp) {
                this.mRec.rmmLogger.baseError("Thread interrupted while processing StreamSet reception close", exp, moduleName);
                Thread.currentThread().interrupt();
            }
            if (--counter % 50 != 0) continue;
            this.mRec.rmmLogger.baseWarn("MStreamSetR.close waiting..., MessageAnnouncer is still processing this StreamSet, counter " + counter, null, moduleName);
        }
        if (counter > 0) {
            if (this.mRec.rmmLogger.isMaxLogLevel()) {
                this.mRec.rmmLogger.maxInfo("MStreamSetR.close (" + counter + "), now cleaning references", moduleName);
            }
        } else {
            this.mRec.rmmLogger.baseError("MStreamSetR.close failed, MessageAnnouncer is still processing this StreamSet, counter " + counter, null, moduleName);
        }
        if (this.mRec.config.threadPerTopic && this.messageAnnouncer != null) {
            this.messageAnnouncer.interrupt();
        }
        if (this.pStreamSet != null) {
            this.pStreamSet.close();
        }
        if (this.mRec.topicReceivers != null) {
            this.mRec.topicReceivers.remove(this);
        }
        if (this.mRec.queueReceivers != null) {
            this.mRec.queueReceivers.remove(this);
        }
        if (counter > 0) {
            this.messageAnnouncer = null;
            this.pStreamSet = null;
            this.mStreamHT = null;
            this.streamSelector = null;
            this.advancedMessageListener = null;
            this.messageListener = null;
        }
    }

    public synchronized boolean clearRejectedStreamList() {
        if (this.isClosed) {
            return false;
        }
        if (this.mRec.pReceiver != null) {
            this.mRec.pReceiver.clearRejectedStreamList();
        }
        if (this.mRec.unicastPReceiver != null) {
            this.mRec.unicastPReceiver.clearRejectedStreamList();
        }
        return true;
    }

    public synchronized boolean rejectStream(long stream_id) {
        if (this.isClosed) {
            return false;
        }
        MessageStream ms = this.mStreamHT.get(stream_id);
        if (ms != null) {
            ms.isSuspended = true;
            this.mStreamHT.remove(stream_id);
        }
        boolean found = false;
        Enumeration pstreams = this.pStreamSet.getStreamList();
        while (pstreams.hasMoreElements()) {
            try {
                StreamRIf ps = (StreamRIf)pstreams.nextElement();
                if (ps == null || stream_id != ps.getId()) continue;
                this.mRec.rmmLogger.baseInfo("StreamSetR.rejectStream: Stream " + ps + " removed", moduleName);
                this.pStreamSet.removeStream(ps);
                found = true;
            }
            catch (Exception e2) {
                this.mRec.rmmLogger.baseWarn("StreamSetR.rejectStream: Got exception ", e2, moduleName);
            }
            break;
        }
        if (!found) {
            this.mRec.rmmLogger.baseWarn("StreamSetR.rejectStream: Stream " + stream_id + " could not be found", null, moduleName);
        }
        return found;
    }

    public synchronized void refreshStreamList() {
        if (this.isClosed) {
            return;
        }
        if (this.mRec.pReceiver != null) {
            this.mRec.pReceiver.clearRejectedStreamList();
        }
        if (this.mRec.unicastPReceiver != null) {
            this.mRec.unicastPReceiver.clearRejectedStreamList();
        }
        Enumeration pstreams = this.pStreamSet.getStreamList();
        while (pstreams.hasMoreElements()) {
            try {
                StreamRIf ps = (StreamRIf)pstreams.nextElement();
                if (ps == null) continue;
                if (!this.streamSelector.acceptStream(ps.getTag(), ps.getTag().length, ps.getId(), ps.getSourceAddress(), ps.getSourcePort())) {
                    this.mRec.rmmLogger.baseInfo("StreamSetR.refreshStreamList: Stream " + ps + " removed", moduleName);
                    MessageStream ms = this.mStreamHT.get(ps.getId());
                    if (ms != null) {
                        ms.isSuspended = true;
                        this.mStreamHT.remove(ps.getId());
                    }
                    this.pStreamSet.removeStream(ps);
                    continue;
                }
                if (this.mRec.adminNode == null) continue;
                this.mRec.adminNode.registerInterest(this.streamSelector);
            }
            catch (Exception e2) {
                this.mRec.rmmLogger.baseWarn("StreamSetR.refreshStreamList: Got exception ", e2, moduleName);
                break;
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public UnicastConnectionIf getConnection(long stream_id) {
        Enumeration pstreams = this.pStreamSet.getStreamList();
        while (pstreams.hasMoreElements()) {
            try {
                StreamRIf ps = (StreamRIf)pstreams.nextElement();
                if (ps == null || ps.getId() != stream_id) continue;
                this.mRec.rmmLogger.baseInfo("StreamSetR.getConnection: found matching stream " + ps + " connection " + ps.getConnection(), moduleName);
                return ps.getConnection();
            }
            catch (Exception e2) {
                this.mRec.rmmLogger.baseWarn("StreamSetR.getConnection: Got exception ", e2, moduleName);
                break;
            }
        }
        this.mRec.rmmLogger.baseWarn("StreamSetR.getConnection: could not find a matching stream " + stream_id, null, moduleName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long checkQueueSize(boolean update) {
        long fifo_size;
        long msg_size;
        block11: {
            msg_size = 0L;
            fifo_size = 0L;
            MessageStream[] slist = this.maList;
            if (this.isClosed || this.mStreamHT == null || slist == null) {
                return 0L;
            }
            try {
                int sn = 0;
                while (sn < slist.length) {
                    MessageStream stream = slist[sn];
                    if (stream != null && !stream.isSuspended) {
                        Object object = this.recBufSizeLock;
                        synchronized (object) {
                            msg_size += stream.messageQueueSize;
                            fifo_size += stream.fifoQueueSize;
                        }
                    }
                    ++sn;
                }
                if (!update) break block11;
                Object object = this.recBufSizeLock;
                synchronized (object) {
                    this.totalFifoSize = fifo_size > 0L ? fifo_size : 0L;
                    this.totalMsgSize = msg_size > 0L ? msg_size : 0L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return msg_size + fifo_size;
    }
}

