/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.mtl.receiver.LongMsgStreamHash;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.mtl.receiver.MessageStream;
import com.ibm.rmm.ptl.ifc.receiver.REventIf;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.MessageBundle;

class MessageAnnouncer
extends Thread {
    private static final String moduleName = "MTL_R";
    MStreamSetR myOnlyTopic;
    volatile int nRot;
    int exc_count;
    Object[] tmp_q;
    boolean isSleeping;
    boolean notifyPending;
    private Throwable userEx;
    private MReceiver mRec;
    private boolean collectStats;
    private boolean goOn = true;

    MessageAnnouncer(MReceiver mrc, MStreamSetR stream) {
        this.mRec = mrc;
        this.setName("MessageAnnouncer for " + stream);
        this.collectStats = this.mRec.config.collectStats;
        this.myOnlyTopic = stream;
        this.isSleeping = false;
        this.exc_count = 0;
        this.tmp_q = new Object[8192];
    }

    private void checkEvents(MStreamSetR myTopic) {
        int n_ev = myTopic.eventQueue.size();
        if (n_ev > 0) {
            int i = 0;
            while (i < n_ev) {
                Object ev = myTopic.eventQueue.elementAt(0);
                Event event2 = null;
                if (ev instanceof REventIf) {
                    REventIf pev = (REventIf)ev;
                    event2 = new Event(pev);
                } else {
                    event2 = (Event)ev;
                }
                if (event2 == null) {
                    myTopic.eventQueue.removeElementAt(0);
                } else {
                    if (myTopic.advancedListenerSet) {
                        myTopic.advancedMessageListener.onEvent(event2);
                    } else if (myTopic.isBundle) {
                        myTopic.bundledMessageListener.onEvent(event2);
                    } else if (myTopic.messageListener != null) {
                        myTopic.messageListener.onEvent(event2);
                    } else if (this.mRec.rmmLogger.isMaxLogLevel()) {
                        this.mRec.rmmLogger.maxWarn("MessageAnnouncer failed to deliver Event type " + event2.getType() + " " + event2.getDescription() + " stream " + event2.getStreamId(), null, moduleName);
                    }
                    myTopic.eventQueue.removeElementAt(0);
                    if (this.mRec.rmmLogger.isMaxLogLevel()) {
                        this.mRec.rmmLogger.maxInfo("MessageAnnouncer delivered Event type " + event2.getType() + " " + event2.getDescription() + " stream " + event2.getStreamId(), moduleName);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTopic(MStreamSetR topic, int maxMsgs) {
        boolean res;
        this.userEx = null;
        Object object = topic.msgAnnouncerLock;
        synchronized (object) {
            block9: {
                if (!topic.msgAnnouncerOn && !topic.isClosed()) break block9;
                return false;
            }
            topic.msgAnnouncerOn = true;
        }
        try {
            res = this._processTopic(topic, maxMsgs);
        }
        catch (Throwable ex) {
            this.userEx = ex;
            res = false;
            this.mRec.rmmLogger.baseError("Exception in processTopic or in onMessage code! ", ex, moduleName);
        }
        object = topic.msgAnnouncerLock;
        synchronized (object) {
            topic.msgAnnouncerOn = false;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _processTopic(MStreamSetR myTopic, int maxMsgs) {
        MessageStream st;
        boolean sent_msg = false;
        if (myTopic == null) {
            return false;
        }
        this.checkEvents(myTopic);
        if (myTopic.mStreamHT.version != myTopic.maVersion) {
            LongMsgStreamHash longMsgStreamHash = myTopic.mStreamHT;
            synchronized (longMsgStreamHash) {
                myTopic.maList = myTopic.mStreamHT.getValues();
                myTopic.maVersion = myTopic.mStreamHT.version;
            }
        }
        if (myTopic.maList == null) {
            return false;
        }
        int sn = 0;
        while (sn < myTopic.maList.length) {
            MessageStream stream = myTopic.maList[sn];
            if (!stream.isSuspended) {
                long total_size;
                if (!myTopic.isBundle) {
                    int nmsg = stream.wholeMessages.qSize();
                    if (nmsg > 0) {
                        byte[] msg;
                        if (nmsg > maxMsgs) {
                            nmsg = maxMsgs;
                        }
                        if (nmsg > this.tmp_q.length) {
                            nmsg = this.tmp_q.length;
                        }
                        this.checkEvents(myTopic);
                        sent_msg = true;
                        total_size = 0L;
                        Object object = stream.wholeMessages;
                        synchronized (object) {
                            int i = 0;
                            while (i < nmsg) {
                                msg = stream.wholeMessages.popFirst();
                                this.tmp_q[i] = msg;
                                total_size += (long)msg.length;
                                ++i;
                            }
                        }
                        if (this.mRec.checkReceptionBuffers) {
                            object = myTopic.recBufSizeLock;
                            synchronized (object) {
                                myTopic.totalMsgSize -= total_size;
                                stream.messageQueueSize -= total_size;
                            }
                        }
                        int i = 0;
                        while (i < nmsg && !myTopic.isClosed() && !stream.isSuspended) {
                            msg = (byte[])this.tmp_q[i];
                            this.tmp_q[i] = null;
                            if (myTopic.advancedListenerSet) {
                                stream.theMessage.data = msg;
                                myTopic.advancedMessageListener.onMessage(stream.theMessage);
                                stream.theMessage.data = null;
                            } else {
                                myTopic.messageListener.onMessage(msg);
                            }
                            msg = null;
                            if (this.collectStats) {
                                ++stream.totalMessagesDelivered;
                            }
                            if (!myTopic.eventQueue.isEmpty()) {
                                this.checkEvents(myTopic);
                            }
                            ++i;
                        }
                    }
                } else {
                    int nbnd = stream.messageBundles.qSize();
                    if (nbnd > 0) {
                        if (nbnd > maxMsgs) {
                            nbnd = maxMsgs;
                        }
                        if (nbnd > this.tmp_q.length) {
                            nbnd = this.tmp_q.length;
                        }
                        this.checkEvents(myTopic);
                        sent_msg = true;
                        ObjCyclQueue i = stream.messageBundles;
                        synchronized (i) {
                            int i2 = 0;
                            while (i2 < nbnd) {
                                this.tmp_q[i2] = (MessageBundle)stream.messageBundles.popFirst();
                                ++i2;
                            }
                        }
                        total_size = 0L;
                        int i2 = 0;
                        while (i2 < nbnd) {
                            MessageBundle mb = (MessageBundle)this.tmp_q[i2];
                            if (!myTopic.isClosed() && !stream.isSuspended) {
                                myTopic.bundledMessageListener.onMessage(mb);
                            }
                            this.mRec.bundlePool.returnBundle(mb);
                            total_size += (long)mb.dataSize;
                            if (this.collectStats) {
                                stream.totalMessagesDelivered += (long)mb.nMessages;
                            }
                            ++i2;
                        }
                        if (this.mRec.checkReceptionBuffers) {
                            Object object = myTopic.recBufSizeLock;
                            synchronized (object) {
                                myTopic.totalMsgSize -= total_size;
                                stream.messageQueueSize -= total_size;
                            }
                        }
                    }
                }
            }
            ++sn;
        }
        if (this.mRec.memory_alert && sent_msg && myTopic.maList != null && myTopic.maList.length > 0 && (st = myTopic.maList[0]) != null) {
            st.queueSizeCheck();
        }
        return sent_msg;
    }

    void wakeUp() {
        this.wakeUp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            MessageAnnouncer messageAnnouncer = this;
            synchronized (messageAnnouncer) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int sleep_time;
        int MSGS_PER_ROUND;
        MStreamSetR topic = null;
        int exc_count = 0;
        if (this.mRec.config.threadPerTopic) {
            MSGS_PER_ROUND = 8000;
            sleep_time = 1000;
        } else {
            MSGS_PER_ROUND = 4000;
            sleep_time = this.mRec.msgAnnouncers_running < 2 ? 500 : 1000;
        }
        this.mRec.rmmLogger.baseInfo("MessageAnnouncer started (TperT: " + this.mRec.config.threadPerTopic + ". threads: " + this.mRec.msgAnnouncers_running + "/" + this.mRec.config.msgAnnouncerThreads + "sleepTime " + sleep_time + ")", moduleName);
        while (this.goOn) {
            ++this.nRot;
            try {
                boolean go_sleep = true;
                if (this.mRec.config.threadPerTopic) {
                    topic = this.myOnlyTopic;
                    if (this.processTopic(topic, MSGS_PER_ROUND)) {
                        go_sleep = false;
                    }
                    if (this.userEx != null) {
                        throw this.userEx;
                    }
                } else {
                    int i = 0;
                    while (i < this.mRec.topicReceivers.size()) {
                        topic = null;
                        try {
                            topic = (MStreamSetR)this.mRec.topicReceivers.elementAt(i);
                        }
                        catch (Exception e2) {
                            go_sleep = true;
                            break;
                        }
                        if (topic != null) {
                            if (this.processTopic(topic, MSGS_PER_ROUND)) {
                                go_sleep = false;
                            }
                            if (this.userEx != null) {
                                throw this.userEx;
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.mRec.queueReceivers.size()) {
                        topic = null;
                        try {
                            topic = (MStreamSetR)this.mRec.queueReceivers.elementAt(i);
                        }
                        catch (Exception e3) {
                            go_sleep = true;
                            break;
                        }
                        if (topic != null) {
                            if (this.processTopic(topic, MSGS_PER_ROUND)) {
                                go_sleep = false;
                            }
                            if (this.userEx != null) {
                                throw this.userEx;
                            }
                        }
                        ++i;
                    }
                }
                if (go_sleep) {
                    MessageAnnouncer i = this;
                    synchronized (i) {
                        if (!this.notifyPending) {
                            this.isSleeping = true;
                            this.wait();
                            this.isSleeping = false;
                        }
                    }
                }
                this.notifyPending = false;
            }
            catch (Throwable ex) {
                if (this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.mRec.config.threadPerTopic || this.myOnlyTopic.isClosed() || !this.mRec.isRunning) break;
                    this.mRec.rmmLogger.baseLog(406, new Object[]{"MessageAnnouncer"}, ex, moduleName);
                    break;
                }
                this.mRec.rmmLogger.baseError("MessageAnnouncer: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.mRec.rmmLogger.baseError("Too many exceptions. Stop MessageAnnouncer", ex, moduleName);
                this.mRec.rmmLogger.baseLog(416, new Object[]{"MessageAnnouncer"}, ex, moduleName);
                break;
            }
        }
        try {
            MessageStream ms;
            MessageStream[] list;
            if (this.mRec.isRunning && this.mRec.memory_alert && this.myOnlyTopic != null && this.myOnlyTopic.mStreamHT != null && (list = this.myOnlyTopic.mStreamHT.getValues()) != null && list.length > 0 && (ms = list[0]) != null) {
                ms.queueSizeCheck();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

