/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.intrn.util.Ba2Map;
import com.ibm.rmm.intrn.util.BaCyclQueue;
import com.ibm.rmm.intrn.util.IntBaHash;
import com.ibm.rmm.intrn.util.IntIntHash;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.ObjMap;
import com.ibm.rmm.intrn.util.PersistByteArrayInputStream;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRUpcalls;
import com.ibm.rmm.receiver.Event;
import com.ibm.rmm.receiver.Message;
import com.ibm.rmm.receiver.MessageBundle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;

public class MessageStream
implements StreamRUpcalls {
    private static final String moduleName = "MTL_R";
    MReceiver mRec;
    MStreamSetR myTopic;
    private boolean isFifo;
    private Ba2Map fifoMsgQueues;
    private ObjMap fifoBundleQueue;
    BaCyclQueue wholeMessages;
    ObjCyclQueue messageBundles;
    Message theMessage;
    String topicName;
    StreamRIf pStream;
    InetAddress sourceAddress;
    int sourcePort;
    private StreamBitmap strBitmap;
    long totalMessagesReceived;
    long totalMessagesDelivered;
    private IntIntHash leftOpenPieces;
    private IntIntHash rightOpenPieces;
    private IntIntHash openPieces;
    private IntBaHash partialMessages;
    private IntIntHash opLE;
    private IntIntHash opRE;
    int packSeqN;
    int trailSeqN;
    int lastContigN;
    private byte[][] tmpBa;
    private MessageBundle[] tmpBundleArray;
    private byte nMessages;
    private boolean isContig;
    private byte[][] tempMessageStore;
    private boolean okToProc;
    protected PersistByteArrayInputStream bais;
    protected DataInputStream dis;
    protected byte[] buffer;
    protected int msgStN;
    private short msgEnd;
    private short[] msgStarts;
    protected int dataLength;
    protected int dataOffset;
    byte lOpen;
    byte rOpen;
    int lMsgId;
    int rMsgId;
    int lMsgSize;
    int rMsgSize;
    int lMsgOffset;
    long nProcessedPackets;
    MessageBundle messageBundle;
    private int nBundles;
    boolean putBundle;
    private int writeMark;
    private boolean firstFrag;
    private boolean collectStats;
    private boolean verifyQueueSize;
    boolean isSuspended;
    long fifoQueueSize;
    long messageQueueSize;

    MessageStream() {
    }

    MessageStream(MReceiver mrc, MStreamSetR topic_r, StreamRIf pstr, boolean fifo) {
        this.mRec = mrc;
        this.collectStats = this.mRec.config.collectStats;
        this.verifyQueueSize = this.mRec.config.verifyQueueSize;
        this.totalMessagesReceived = 0L;
        this.totalMessagesDelivered = 0L;
        this.fifoQueueSize = 0L;
        this.messageQueueSize = 0L;
        this.myTopic = topic_r;
        this.pStream = pstr;
        this.isFifo = fifo;
        this.firstFrag = true;
        if (this.myTopic.isBundle) {
            this.messageBundles = new ObjCyclQueue(128);
        } else {
            this.wholeMessages = new BaCyclQueue(1024);
        }
        this.tempMessageStore = new byte[300][];
        this.tempMessageStore[0] = new byte[1];
        this.msgStarts = new short[512];
        this.sourceAddress = pstr.getSourceAddress();
        this.sourcePort = pstr.getSourcePort();
        this.bais = new PersistByteArrayInputStream(new byte[1]);
        this.dis = new DataInputStream(this.bais);
        try {
            String tmp = Sutils.bytesToString(pstr.getTag());
            this.topicName = Sutils.toPrintableString(tmp);
        }
        catch (UnsupportedEncodingException e2) {
            this.mRec.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, e2, moduleName);
        }
        catch (Exception ex) {
            this.mRec.rmmLogger.baseError("Failed to convert tag to topic name", ex, moduleName);
        }
        if (this.topicName == null) {
            this.topicName = "Nameless (ByteArray) Queue/Topic" + pstr.getTag();
        }
        this.theMessage = new Message();
        this.theMessage.sourceAddress = this.sourceAddress;
        this.theMessage.sourcePort = this.sourcePort;
        this.theMessage.topicName = this.topicName;
        this.theMessage.streamId = pstr.getId();
        this.theMessage.tag = pstr.getTag();
        this.mRec.rmmLogger.baseInfo("MTL: Receiving stream. Id: " + pstr.getId() + ". Topic: " + this.topicName + ". Sender: " + pstr.getSourceAddress().getHostAddress() + ". Port: " + pstr.getSourcePort() + ". Ordered: " + fifo, moduleName);
        this.writeMark = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeParsing() {
        boolean wakeMA = false;
        if (this.okToProc && !this.myTopic.isBundle) {
            BaCyclQueue baCyclQueue = this.wholeMessages;
            synchronized (baCyclQueue) {
                long total_len = 0L;
                int i = 0;
                while (i < this.nMessages) {
                    this.pushMessage(this.tmpBa[i + 1]);
                    if (this.mRec.checkReceptionBuffers) {
                        total_len += (long)this.tmpBa[i + 1].length;
                    }
                    this.tmpBa[i + 1] = null;
                    ++i;
                }
                if (this.mRec.checkReceptionBuffers) {
                    Object object = this.myTopic.recBufSizeLock;
                    synchronized (object) {
                        this.myTopic.totalMsgSize += total_len;
                        this.messageQueueSize += total_len;
                    }
                }
            }
            wakeMA = true;
        }
        if (this.isFifo && this.isContig && !this.myTopic.isP2P && this.strBitmap.has(this.lastContigN + 1) && this.advanceFifo(this.lastContigN + 1)) {
            wakeMA = true;
        }
        if (wakeMA && this.myTopic.messageAnnouncer != null) {
            this.myTopic.messageAnnouncer.wakeUp();
        }
    }

    public int getContigiousSeqN() {
        return this.lastContigN;
    }

    public StreamRIf getPStream() {
        return this.pStream;
    }

    protected void initParsing() {
        this.nMessages = 0;
        this.nBundles = 0;
        this.putBundle = false;
        if (!this.myTopic.isP2P) {
            this.strBitmap.set(this.packSeqN);
        }
        if (this.isFifo) {
            if (this.packSeqN == this.lastContigN + 1) {
                this.isContig = true;
                ++this.lastContigN;
                this.okToProc = true;
                this.tmpBa = this.tempMessageStore;
            } else if (this.myTopic.isP2P) {
                this.mRec.rmmLogger.baseError("Non contig packet in P2P!!! (" + this.packSeqN + " " + this.lastContigN + "). Stream: " + this.pStream, null, moduleName);
            } else {
                this.isContig = false;
                this.okToProc = false;
                if (!this.myTopic.isBundle) {
                    this.tmpBa = new byte[this.msgStN + 3][];
                    this.tmpBa[0] = new byte[1];
                    this.fifoMsgQueues.set(this.packSeqN, this.tmpBa);
                } else {
                    this.tmpBundleArray = new MessageBundle[3];
                    this.fifoBundleQueue.set(this.packSeqN, this.tmpBundleArray);
                }
            }
        } else {
            this.okToProc = true;
            this.tmpBa = this.tempMessageStore;
        }
    }

    public void onFirstPacket(int pack_seq_n, boolean late_join, int lj_mark) {
        if (!late_join) {
            this.trailSeqN = pack_seq_n - 1;
            this.lastContigN = pack_seq_n - 1;
        } else {
            this.trailSeqN = lj_mark - 1;
            this.lastContigN = lj_mark - 1;
        }
        if (!this.myTopic.isP2P) {
            int l1 = 4096;
            int l2 = 4096;
            this.strBitmap = new StreamBitmap(this.trailSeqN, l1, l2);
            if (this.isFifo) {
                if (this.myTopic.isBundle) {
                    this.fifoBundleQueue = new ObjMap(this.lastContigN, l1, l2);
                } else {
                    this.fifoMsgQueues = new Ba2Map(this.lastContigN, l1, l2);
                }
            }
        }
        this.nProcessedPackets = 0L;
    }

    public void onPacket(int pack_seq_n, byte[] buffer, int offset, int length) {
        if (this.myTopic.isClosed() || this.isSuspended) {
            if (this.mRec.rmmLogger.isMaxLogLevel()) {
                this.mRec.rmmLogger.maxWarn("onPacket called on a closed/suspended Stream", null, moduleName);
            }
            return;
        }
        ++this.nProcessedPackets;
        if (this.verifyQueueSize && this.nProcessedPackets % 100L == 0L) {
            this.queueSizeCheck();
        }
        this.parseHeader(pack_seq_n, buffer, offset, length);
        this.processData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrailAdvance(int new_trail) {
        int gap = new_trail - this.trailSeqN;
        if (gap < 0) {
            this.mRec.rmmLogger.baseWarn("PacketListener: new trail lower than old. Stream: " + this.pStream, null, moduleName);
            return;
        }
        if (!this.firstFrag) {
            int i = this.trailSeqN;
            while (new_trail - i > 0) {
                this.clear(i);
                ++i;
            }
        }
        this.trailSeqN = new_trail;
        if (this.myTopic.isP2P) {
            return;
        }
        this.strBitmap.setTrail(new_trail);
        boolean wakeMA = false;
        if (this.isFifo) {
            gap = new_trail - this.lastContigN;
            if (gap > 1 && !this.isSuspended) {
                this.mRec.rmmLogger.baseWarn("MessageStream: new trail higher than contigious mark: " + new_trail + " " + this.lastContigN + ". Stream: " + this.pStream, null, moduleName);
                if (!this.myTopic.isBundle) {
                    BaCyclQueue baCyclQueue = this.wholeMessages;
                    synchronized (baCyclQueue) {
                        long total_len = 0L;
                        int i2 = this.lastContigN;
                        while (new_trail - i2 > 0) {
                            this.tmpBa = this.fifoMsgQueues.remove(i2);
                            if (this.tmpBa != null) {
                                int n = this.tmpBa[0][0];
                                int j = 0;
                                while (j < n) {
                                    this.pushMessage(this.tmpBa[j + 1]);
                                    if (this.mRec.checkReceptionBuffers) {
                                        total_len += (long)this.tmpBa[j + 1].length;
                                    }
                                    this.tmpBa[i2 + 1] = null;
                                    ++j;
                                }
                                wakeMA = true;
                            }
                            ++i2;
                        }
                        if (this.mRec.checkReceptionBuffers) {
                            this.myTopic.totalFifoSize -= total_len;
                            this.fifoQueueSize -= total_len;
                            Object i2 = this.myTopic.recBufSizeLock;
                            synchronized (i2) {
                                this.myTopic.totalMsgSize += total_len;
                                this.messageQueueSize += total_len;
                            }
                        }
                    }
                }
                ObjCyclQueue objCyclQueue = this.messageBundles;
                synchronized (objCyclQueue) {
                    int i = this.lastContigN;
                    while (new_trail - i > 0) {
                        MessageBundle[] mbs = (MessageBundle[])this.fifoBundleQueue.remove(i);
                        if (mbs != null) {
                            int j = 0;
                            while (j < 3) {
                                MessageBundle mb = mbs[j];
                                if (mb != null) {
                                    this.putBundle(mb);
                                    if (this.mRec.checkReceptionBuffers) {
                                        this.myTopic.totalFifoSize -= (long)mb.dataSize;
                                        this.fifoQueueSize -= (long)mb.dataSize;
                                    }
                                    wakeMA = true;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                this.lastContigN = new_trail - 1;
                if (this.strBitmap.has(new_trail) && this.advanceFifo(new_trail)) {
                    wakeMA = true;
                }
            }
            if (!this.myTopic.isBundle) {
                this.fifoMsgQueues.setTrail(new_trail);
            } else {
                this.fifoBundleQueue.setTrail(new_trail);
            }
        }
        if (wakeMA && this.myTopic.messageAnnouncer != null) {
            this.myTopic.messageAnnouncer.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotBundle(MessageBundle mb) {
        if (this.okToProc) {
            ObjCyclQueue objCyclQueue = this.messageBundles;
            synchronized (objCyclQueue) {
                this.putBundle(mb);
            }
            if (this.myTopic.messageAnnouncer != null) {
                this.myTopic.messageAnnouncer.wakeUp();
            }
        } else {
            this.tmpBundleArray[this.nBundles++] = mb;
        }
    }

    protected void gotMessage(boolean create, byte[] buffer, int offset, int len) {
        if (this.isSuspended) {
            return;
        }
        if (!this.okToProc && this.mRec.checkReceptionBuffers) {
            this.myTopic.totalFifoSize += (long)len;
            this.fifoQueueSize += (long)len;
        }
        if (!this.myTopic.isBundle) {
            byte[] msg = null;
            if (create) {
                try {
                    msg = new byte[len];
                }
                catch (OutOfMemoryError er) {
                    this.isSuspended = true;
                    Event ev = new Event(103, 0L, len, null, this.sourceAddress, this.sourcePort);
                    this.myTopic.eventQueue.add(ev);
                    this.mRec.rmmLogger.baseLog(410, new Object[]{"" + len}, er, moduleName);
                    this.mRec.rmmLogger.baseError("Failed to allocate memory for message of size " + len + " on stream " + this.pStream.getId() + ". Suspending data reception", er, moduleName);
                    this.pStream.suspendDataReception();
                    return;
                }
                System.arraycopy(buffer, offset, msg, 0, len);
            } else {
                msg = buffer;
            }
            this.tmpBa[0][0] = this.nMessages = (byte)(this.nMessages + 1);
            this.tmpBa[this.nMessages] = msg;
        } else if (create) {
            if (!this.putBundle) {
                int tot_len = this.dataLength + (this.msgStN + 3) * 4;
                this.messageBundle = this.mRec.bundlePool.getBundle(tot_len);
                this.messageBundle.nMessages = 0;
                this.messageBundle.dataSize = 0;
                this.writeMark = 0;
                Sutils.insertInt(this.messageBundle.buffer, this.writeMark, 0);
                this.writeMark += 4;
                this.messageBundle.contentSize = 4;
                this.messageBundle.stream = this;
                this.messageBundle.packetSeqN = this.packSeqN;
                this.putBundle = true;
            }
            Sutils.insertInt(this.messageBundle.buffer, this.writeMark, len);
            this.writeMark += 4;
            System.arraycopy(buffer, offset, this.messageBundle.buffer, this.writeMark, len);
            this.writeMark += len;
            this.messageBundle.offset[this.messageBundle.nMessages] = 4 + this.messageBundle.contentSize;
            this.messageBundle.length[this.messageBundle.nMessages] = len;
            this.messageBundle.dataSize += len;
            this.messageBundle.contentSize += 4 + len;
            ++this.messageBundle.nMessages;
        } else {
            this.messageBundle = this.mRec.bundlePool.getBundle(len + 8);
            this.writeMark = 0;
            Sutils.insertInt(this.messageBundle.buffer, this.writeMark, 0);
            this.writeMark += 4;
            Sutils.insertInt(this.messageBundle.buffer, this.writeMark, len);
            this.writeMark += 4;
            System.arraycopy(buffer, offset, this.messageBundle.buffer, this.writeMark, len);
            this.writeMark += len;
            this.messageBundle.stream = this;
            this.messageBundle.packetSeqN = this.packSeqN;
            this.messageBundle.nMessages = 1;
            this.messageBundle.offset[0] = 8;
            this.messageBundle.length[0] = len;
            this.messageBundle.dataSize = len;
            this.messageBundle.contentSize = 8 + len;
            this.gotBundle(this.messageBundle);
        }
    }

    protected void addLeft(int offset, int length) {
        int mkey = this.lMsgId;
        if (this.isSuspended) {
            return;
        }
        byte[] msg = this.partialMessages.get(mkey);
        if (msg == null) {
            try {
                msg = new byte[this.lMsgSize];
            }
            catch (OutOfMemoryError er) {
                this.isSuspended = true;
                Event ev = new Event(103, 0L, this.lMsgSize, null, this.sourceAddress, this.sourcePort);
                this.myTopic.eventQueue.add(ev);
                this.mRec.rmmLogger.baseError("addLeft(" + length + " " + offset + "). Failed to allocate memory for left message of size " + this.lMsgSize + " on stream " + this.pStream.getId() + ". Suspending data reception", er, moduleName);
                this.mRec.rmmLogger.baseLog(410, new Object[]{"" + this.lMsgSize}, er, moduleName);
                this.pStream.suspendDataReception();
                return;
            }
            this.partialMessages.put(mkey, msg);
        }
        System.arraycopy(this.buffer, this.dataOffset + offset, msg, this.lMsgOffset, length);
        if (!this.myTopic.isP2P && !this.strBitmap.has(this.packSeqN - 1)) {
            this.leftOpenPieces.put(this.packSeqN, mkey);
            return;
        }
        int key = this.packSeqN - 1;
        if (this.rightOpenPieces.containsKey(key)) {
            this.gotMessage(false, msg, 0, msg.length);
            this.partialMessages.remove(mkey);
            this.rightOpenPieces.remove(key);
        } else {
            int lk = this.opLE.get(key);
            this.leftOpenPieces.put(lk, mkey);
            this.opLE.remove(key);
            this.opRE.remove(lk);
            this.openPieces.remove(key);
            this.openPieces.remove(lk);
        }
    }

    protected void addOpen() {
        int mkey = this.lMsgId;
        if (this.isSuspended) {
            return;
        }
        byte[] msg = this.partialMessages.get(mkey);
        if (msg == null) {
            try {
                msg = new byte[this.lMsgSize];
            }
            catch (OutOfMemoryError er) {
                this.isSuspended = true;
                Event ev = new Event(103, 0L, this.lMsgSize, null, this.sourceAddress, this.sourcePort);
                this.myTopic.eventQueue.add(ev);
                this.mRec.rmmLogger.baseError("addOpen(). Failed to allocate memory for open message of size " + this.lMsgSize + " on stream " + this.pStream.getId() + ". Suspending data reception", er, moduleName);
                this.mRec.rmmLogger.baseLog(410, new Object[]{"" + this.lMsgSize}, null, moduleName);
                this.pStream.suspendDataReception();
                return;
            }
            this.partialMessages.put(mkey, msg);
        }
        System.arraycopy(this.buffer, this.dataOffset, msg, this.lMsgOffset, this.dataLength);
        if (this.myTopic.isP2P || this.strBitmap.has(this.packSeqN - 1)) {
            if (this.myTopic.isP2P || !this.strBitmap.has(this.packSeqN + 1)) {
                int key = this.packSeqN - 1;
                if (this.rightOpenPieces.containsKey(key)) {
                    this.rightOpenPieces.put(this.packSeqN, mkey);
                    this.rightOpenPieces.remove(key);
                } else {
                    int new_key = this.packSeqN;
                    this.openPieces.put(new_key, mkey);
                    this.openPieces.remove(key);
                    int lk = this.opLE.get(key);
                    this.openPieces.put(lk, mkey);
                    this.opLE.put(new_key, lk);
                    this.opLE.remove(key);
                    this.opRE.put(lk, new_key);
                }
            } else {
                int k1 = this.packSeqN - 1;
                int k2 = this.packSeqN + 1;
                if (this.rightOpenPieces.containsKey(k1)) {
                    if (this.leftOpenPieces.containsKey(k2)) {
                        this.gotMessage(false, msg, 0, msg.length);
                        this.partialMessages.remove(mkey);
                        this.rightOpenPieces.remove(k1);
                        this.leftOpenPieces.remove(k2);
                    } else {
                        int kr = this.opRE.get(k2);
                        this.rightOpenPieces.put(kr, mkey);
                        this.rightOpenPieces.remove(k1);
                        this.openPieces.remove(k2);
                        this.openPieces.remove(kr);
                        this.opRE.remove(k2);
                        this.opLE.remove(kr);
                    }
                } else if (this.leftOpenPieces.containsKey(k2)) {
                    int kl = this.opLE.get(k1);
                    this.leftOpenPieces.put(kl, mkey);
                    this.leftOpenPieces.remove(k2);
                    this.openPieces.remove(k1);
                    this.openPieces.remove(kl);
                    this.opRE.remove(kl);
                    this.opLE.remove(k1);
                } else {
                    int kl1 = this.opLE.get(k1);
                    this.openPieces.put(kl1, mkey);
                    this.openPieces.remove(k1);
                    this.opLE.remove(k1);
                    int kr2 = this.opRE.get(k2);
                    this.openPieces.put(kr2, mkey);
                    this.openPieces.remove(k2);
                    this.opRE.remove(k2);
                    this.opLE.put(kr2, kl1);
                    this.opRE.put(kl1, kr2);
                }
            }
        } else if (!this.myTopic.isP2P && this.strBitmap.has(this.packSeqN + 1)) {
            int key = this.packSeqN + 1;
            if (this.leftOpenPieces.containsKey(key)) {
                this.leftOpenPieces.put(this.packSeqN, mkey);
                this.leftOpenPieces.remove(key);
            } else {
                int new_key = this.packSeqN;
                this.openPieces.put(new_key, mkey);
                this.openPieces.remove(key);
                int rk = this.opRE.get(key);
                this.openPieces.put(rk, mkey);
                this.opLE.put(rk, new_key);
                this.opRE.remove(key);
                this.opRE.put(new_key, rk);
            }
        } else {
            int key = this.packSeqN;
            this.openPieces.put(key, mkey);
            this.opLE.put(key, key);
            this.opRE.put(key, key);
        }
    }

    protected void addRight(int offset, int length) {
        int mkey = this.rMsgId;
        if (this.isSuspended) {
            return;
        }
        byte[] msg = this.partialMessages.get(mkey);
        if (msg == null) {
            try {
                msg = new byte[this.rMsgSize];
            }
            catch (OutOfMemoryError er) {
                this.isSuspended = true;
                Event ev = new Event(103, 0L, this.rMsgSize, null, this.sourceAddress, this.sourcePort);
                this.myTopic.eventQueue.add(ev);
                this.mRec.rmmLogger.baseError("addRight(" + length + " " + offset + "). Failed to allocate memory for right message of size " + this.rMsgSize + " on stream " + this.pStream.getId() + ". Suspending data reception", er, moduleName);
                this.mRec.rmmLogger.baseLog(410, new Object[]{"" + this.rMsgSize}, er, moduleName);
                this.pStream.suspendDataReception();
                return;
            }
            this.partialMessages.put(mkey, msg);
        }
        System.arraycopy(this.buffer, this.dataOffset + offset, msg, 0, length);
        if (this.myTopic.isP2P || !this.strBitmap.has(this.packSeqN + 1)) {
            this.rightOpenPieces.put(this.packSeqN, mkey);
            return;
        }
        int key = this.packSeqN + 1;
        if (this.leftOpenPieces.containsKey(key)) {
            this.gotMessage(false, msg, 0, msg.length);
            this.partialMessages.remove(mkey);
            this.leftOpenPieces.remove(key);
        } else {
            int rk = this.opRE.get(key);
            this.rightOpenPieces.put(rk, mkey);
            this.opRE.remove(key);
            this.opLE.remove(rk);
            this.openPieces.remove(key);
            this.openPieces.remove(rk);
        }
    }

    private void clear(int i) {
        int mkey;
        if (this.firstFrag) {
            return;
        }
        int key = i;
        boolean found = false;
        if (this.leftOpenPieces.containsKey(key)) {
            mkey = this.leftOpenPieces.get(key);
            this.leftOpenPieces.remove(key);
            this.partialMessages.remove(mkey);
            found = true;
        }
        if (this.rightOpenPieces.containsKey(key)) {
            mkey = this.rightOpenPieces.get(key);
            this.rightOpenPieces.remove(key);
            this.partialMessages.remove(mkey);
            found = true;
        }
        if (this.openPieces.containsKey(key)) {
            mkey = this.openPieces.get(key);
            this.openPieces.remove(key);
            this.partialMessages.remove(mkey);
            if (this.opRE.containsKey(key)) {
                int rk = this.opRE.get(key);
                this.opRE.remove(key);
                this.opLE.remove(rk);
            }
            found = true;
        }
        if (found && this.mRec.rmmLogger.isMaxLogLevel()) {
            this.mRec.rmmLogger.maxWarn(" MessageStream.clear(): message fragment cleared!! packet sqn= " + key, null, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBundle(MessageBundle mb) {
        this.writeMark = 0;
        Sutils.insertInt(mb.buffer, this.writeMark, mb.contentSize - 4);
        this.writeMark += 4;
        this.messageBundles.pushLast(mb);
        if (this.mRec.checkReceptionBuffers) {
            Object object = this.myTopic.recBufSizeLock;
            synchronized (object) {
                this.myTopic.totalMsgSize += (long)mb.dataSize;
                this.messageQueueSize += (long)mb.dataSize;
            }
        }
        if (this.collectStats) {
            this.totalMessagesReceived += (long)mb.nMessages;
        }
    }

    void queueSizeCheck() {
        MStreamSetR ssr;
        long mem_size = 0L;
        int i = 0;
        while (i < this.mRec.topicReceivers.size()) {
            ssr = null;
            try {
                ssr = (MStreamSetR)this.mRec.topicReceivers.elementAt(i);
            }
            catch (RuntimeException e2) {
                break;
            }
            mem_size += ssr.totalFifoSize + ssr.totalMsgSize;
            ++i;
        }
        i = 0;
        while (i < this.mRec.queueReceivers.size()) {
            ssr = null;
            try {
                ssr = (MStreamSetR)this.mRec.queueReceivers.elementAt(i);
            }
            catch (RuntimeException e3) {
                break;
            }
            mem_size += ssr.totalFifoSize + ssr.totalMsgSize;
            ++i;
        }
        if (this.mRec.config.maxReceptionBufferLimit > 0L && mem_size > this.mRec.config.maxReceptionBufferLimit || mem_size > this.mRec.config.receptionBufferLimit && !this.mRec.memory_alert || mem_size < this.mRec.config.receptionBufferLimit && this.mRec.memory_alert) {
            this.queueSizeAlert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueSizeAlert() {
        MStreamSetR ssr;
        MStreamSetR max_topic = this.myTopic;
        long fifo_size = 0L;
        long msg_size = 0L;
        int i = 0;
        while (i < this.mRec.topicReceivers.size()) {
            ssr = null;
            try {
                ssr = (MStreamSetR)this.mRec.topicReceivers.elementAt(i);
            }
            catch (RuntimeException e2) {
                break;
            }
            ssr.checkQueueSize(true);
            Object e2 = ssr.recBufSizeLock;
            synchronized (e2) {
                fifo_size += ssr.totalFifoSize;
                msg_size += ssr.totalMsgSize;
            }
            if (ssr.totalMsgSize > max_topic.totalMsgSize) {
                max_topic = ssr;
            }
            ++i;
        }
        i = 0;
        while (i < this.mRec.queueReceivers.size()) {
            ssr = null;
            try {
                ssr = (MStreamSetR)this.mRec.queueReceivers.elementAt(i);
            }
            catch (RuntimeException e3) {
                break;
            }
            ssr.checkQueueSize(true);
            Object object = ssr.recBufSizeLock;
            synchronized (object) {
                fifo_size += ssr.totalFifoSize;
                msg_size += ssr.totalMsgSize;
            }
            if (ssr.totalMsgSize > max_topic.totalMsgSize) {
                max_topic = ssr;
            }
            ++i;
        }
        Object object = this.mRec.memoryAlertLock;
        synchronized (object) {
            Event ev;
            if (this.mRec.config.maxReceptionBufferLimit > 0L && fifo_size + msg_size > this.mRec.config.maxReceptionBufferLimit) {
                ev = new Event(100, fifo_size + msg_size, (int)msg_size, null, null, 0);
                max_topic.eventQueue.add(ev);
                if (max_topic.messageAnnouncer != null) {
                    max_topic.messageAnnouncer.wakeUp();
                }
            }
            if (fifo_size + msg_size > this.mRec.config.receptionBufferLimit && !this.mRec.memory_alert) {
                this.mRec.memory_alert = true;
                this.mRec.memory_alert_topic = max_topic;
                ev = new Event(101, fifo_size + msg_size, (int)msg_size, null, null, 0);
                max_topic.eventQueue.add(ev);
                if (max_topic.messageAnnouncer != null) {
                    max_topic.messageAnnouncer.wakeUp();
                }
            }
            if (fifo_size + msg_size < this.mRec.config.receptionBufferLimit && this.mRec.memory_alert) {
                this.mRec.memory_alert = false;
                ev = new Event(102, fifo_size + msg_size, (int)msg_size, null, null, 0);
                if (this.mRec.memory_alert_topic != null && !this.mRec.memory_alert_topic.isClosed()) {
                    this.mRec.memory_alert_topic.eventQueue.add(ev);
                    if (this.mRec.memory_alert_topic.messageAnnouncer != null) {
                        this.mRec.memory_alert_topic.messageAnnouncer.wakeUp();
                    }
                } else {
                    this.mRec.memory_alert_topic = this.myTopic;
                    this.myTopic.eventQueue.add(ev);
                    if (this.myTopic.messageAnnouncer != null) {
                        this.myTopic.messageAnnouncer.wakeUp();
                    }
                }
            }
        }
    }

    private void pushMessage(byte[] msg) {
        this.wholeMessages.pushLast(msg);
        if (this.collectStats) {
            ++this.totalMessagesReceived;
        }
    }

    protected void parseHeader(int pack_seq_n, byte[] bfr, int offset, int length) {
        this.packSeqN = pack_seq_n;
        this.buffer = bfr;
        this.bais.setBuffer(this.buffer);
        try {
            long skipped = this.dis.skip(offset);
            if (skipped != (long)offset) {
                while (skipped < (long)offset) {
                    ++skipped;
                    this.dis.readByte();
                }
            }
            this.msgStN = this.dis.readByte();
            int i = 0;
            while (i < this.msgStN) {
                this.msgStarts[i] = this.dis.readShort();
                ++i;
            }
            this.msgEnd = this.dis.readShort();
            this.lOpen = this.dis.readByte();
            this.rOpen = this.dis.readByte();
            if ((this.lOpen == 1 || this.rOpen == 1) && this.firstFrag) {
                this.firstFrag = false;
                this.leftOpenPieces = new IntIntHash();
                this.rightOpenPieces = new IntIntHash();
                this.openPieces = new IntIntHash();
                this.opLE = new IntIntHash();
                this.opRE = new IntIntHash();
                this.partialMessages = new IntBaHash();
            }
            if (this.lOpen == 1) {
                this.lMsgId = this.dis.readShort();
                this.lMsgSize = this.dis.readInt();
                this.lMsgOffset = this.dis.readInt();
            }
            if (this.rOpen == 1) {
                this.rMsgId = this.dis.readShort();
                this.rMsgSize = this.dis.readInt();
            }
        }
        catch (IOException ex) {
            this.mRec.rmmLogger.baseError("failed to parsing messaging header. Stream: " + this.pStream, ex, moduleName);
        }
        int msg_head_len = 5 + 2 * this.msgStN + this.lOpen * 10 + this.rOpen * 6;
        this.dataOffset = offset + msg_head_len;
        this.dataLength = length - msg_head_len;
    }

    protected void processData() {
        this.initParsing();
        if (this.msgStN == 0) {
            if (this.msgEnd > 0) {
                this.addLeft(0, this.msgEnd);
            } else {
                this.addOpen();
            }
        } else {
            int len;
            if (this.msgStarts[0] > 0) {
                this.addLeft(0, this.msgStarts[0]);
            }
            if (this.msgStN > 1) {
                int i = 0;
                while (i < this.msgStN - 1) {
                    len = this.msgStarts[i + 1] - this.msgStarts[i];
                    this.gotMessage(true, this.buffer, this.dataOffset + this.msgStarts[i], len);
                    ++i;
                }
            }
            if (this.msgEnd > 0) {
                len = this.msgEnd - this.msgStarts[this.msgStN - 1];
                this.gotMessage(true, this.buffer, this.dataOffset + this.msgStarts[this.msgStN - 1], len);
                if (this.myTopic.isBundle && this.putBundle) {
                    this.gotBundle(this.messageBundle);
                }
            } else {
                if (this.myTopic.isBundle && this.putBundle) {
                    this.gotBundle(this.messageBundle);
                }
                len = this.dataLength - this.msgStarts[this.msgStN - 1];
                this.addRight(this.msgStarts[this.msgStN - 1], len);
            }
        }
        this.completeParsing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean advanceFifo(int start) {
        if (this.myTopic.isP2P) {
            return false;
        }
        int adv = 0;
        if (!this.myTopic.isBundle) {
            this.tmpBa = this.fifoMsgQueues.remove(start + adv);
            BaCyclQueue baCyclQueue = this.wholeMessages;
            synchronized (baCyclQueue) {
                long total_len = 0L;
                while (this.tmpBa != null) {
                    int n = this.tmpBa[0][0];
                    int i = 0;
                    while (i < n) {
                        this.pushMessage(this.tmpBa[i + 1]);
                        if (this.mRec.checkReceptionBuffers) {
                            total_len += (long)this.tmpBa[i + 1].length;
                        }
                        this.tmpBa[i + 1] = null;
                        ++i;
                    }
                    ++adv;
                    this.tmpBa = this.fifoMsgQueues.removeNext();
                }
                if (this.mRec.checkReceptionBuffers) {
                    this.myTopic.totalFifoSize -= total_len;
                    this.fifoQueueSize -= total_len;
                    Object n = this.myTopic.recBufSizeLock;
                    synchronized (n) {
                        this.myTopic.totalMsgSize += total_len;
                        this.messageQueueSize += total_len;
                    }
                }
            }
        }
        MessageBundle[] mbs = (MessageBundle[])this.fifoBundleQueue.remove(start + adv);
        ObjCyclQueue objCyclQueue = this.messageBundles;
        synchronized (objCyclQueue) {
            while (mbs != null) {
                int i = 0;
                while (i < 3) {
                    MessageBundle mb = mbs[i];
                    if (mb != null) {
                        this.putBundle(mb);
                        if (this.mRec.checkReceptionBuffers) {
                            this.myTopic.totalFifoSize -= (long)mb.dataSize;
                            this.fifoQueueSize -= (long)mb.dataSize;
                        }
                    }
                    ++i;
                }
                ++adv;
                mbs = (MessageBundle[])this.fifoBundleQueue.removeNext();
            }
        }
        this.lastContigN += adv;
        return adv > 0;
    }
}

