/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.mtl.receiver.MessageStream;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import java.io.IOException;

public class NewMessageStream
extends MessageStream {
    private static final String moduleName = "MTL_R";
    private byte fragmentType;
    private int messageId;
    private int messageLength;
    private int fragmentOffset;
    private int fragmentLength;
    private int numberOfMessages;

    NewMessageStream(MReceiver mrc, MStreamSetR topic_r, StreamRIf pstr, boolean fifo) {
        super(mrc, topic_r, pstr, fifo);
        if (mrc.rmmLogger.isMaxLogLevel()) {
            mrc.rmmLogger.maxInfo("Using new MTL for " + this.topicName, moduleName);
        }
    }

    protected void parseHeader(int pack_seq_n, byte[] bfr, int offset, int length) {
        this.packSeqN = pack_seq_n;
        this.buffer = bfr;
        this.bais.setBuffer(this.buffer);
        int has_frag = 0;
        try {
            long skipped = this.dis.skip(offset);
            if (skipped != (long)offset) {
                while (skipped < (long)offset) {
                    ++skipped;
                    this.dis.readByte();
                }
            }
            this.dis.readByte();
            this.numberOfMessages = this.dis.readShort();
            this.fragmentType = this.dis.readByte();
            if (this.fragmentType != 0) {
                has_frag = 1;
                this.messageId = this.dis.readInt();
                this.messageLength = this.dis.readInt();
                this.fragmentOffset = this.dis.readInt();
                this.fragmentLength = this.dis.readShort();
            }
        }
        catch (IOException ex) {
            this.mRec.rmmLogger.baseError("failed to parsing messaging header. Stream: " + this.pStream, ex, moduleName);
        }
        int msg_head_len = 4 + has_frag * 14;
        this.dataOffset = offset + msg_head_len;
        this.dataLength = length - msg_head_len;
        this.msgStN = this.numberOfMessages;
    }

    protected void processData() {
        this.initParsing();
        if (this.fragmentType == 1) {
            this.lOpen = 1;
            this.rOpen = 0;
            this.lMsgId = this.messageId;
            this.lMsgSize = this.messageLength;
            this.lMsgOffset = this.fragmentOffset;
            this.addLeft(0, this.fragmentLength);
        } else if (this.fragmentType == 3) {
            this.lOpen = 1;
            this.rOpen = 0;
            this.lMsgId = this.messageId;
            this.lMsgSize = this.messageLength;
            this.lMsgOffset = this.fragmentOffset;
            this.addOpen();
        } else if (this.fragmentType == 2) {
            this.lOpen = 0;
            this.rOpen = 1;
            this.rMsgId = this.messageId;
            this.rMsgSize = this.messageLength;
            this.addRight(0, this.fragmentLength);
        } else {
            this.lOpen = 0;
            this.rOpen = 0;
            try {
                int i = 0;
                while (i < this.numberOfMessages) {
                    short msg_len = this.dis.readShort();
                    this.gotMessage(true, this.buffer, this.bais.getPosition(), msg_len);
                    long skiped = this.dis.skip(msg_len);
                    if (skiped != (long)msg_len) {
                        while (skiped < (long)msg_len) {
                            ++skiped;
                            this.dis.readByte();
                        }
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                this.mRec.rmmLogger.baseError("Failed to read message length", ex, moduleName);
            }
            if (this.myTopic.isBundle && this.putBundle) {
                this.gotBundle(this.messageBundle);
            }
        }
        this.completeParsing();
    }
}

