/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.receiver;

import com.ibm.rmm.mtl.receiver.LongMsgStreamHash;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.mtl.receiver.MessageStream;
import com.ibm.rmm.ptl.ifc.receiver.REventIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetUpcalls;

class SetListenerImp
implements StreamSetUpcalls {
    private static final String moduleName = "MTL";
    private MStreamSetR myTopic;
    private MReceiver mRec;

    SetListenerImp(MReceiver mrc, MStreamSetR topic) {
        this.mRec = mrc;
        this.myTopic = topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFirstPacket(StreamRIf p_str, int pack_seq_n, byte[] buffer, int offset, int length, boolean late_join, int lj_mark) {
        MessageStream stream;
        if (this.myTopic.isClosed()) {
            if (this.mRec.rmmLogger.isMaxLogLevel()) {
                this.mRec.rmmLogger.maxWarn("onFirstPacket called on a closed StreamSet", null, moduleName);
            }
            return;
        }
        LongMsgStreamHash longMsgStreamHash = this.myTopic.mStreamHT;
        synchronized (longMsgStreamHash) {
            if (this.myTopic.mStreamHT.containsKey(p_str.getId())) {
                this.mRec.rmmLogger.baseWarn("onFirstPacket called on existing stream " + p_str.getId(), null, moduleName);
                stream = this.myTopic.mStreamHT.get(p_str.getId());
            } else {
                stream = this.myTopic.createMessageStream(p_str);
                stream.onFirstPacket(pack_seq_n, late_join, lj_mark);
                p_str.setDataListener(stream);
            }
        }
        stream.onPacket(pack_seq_n, buffer, offset, length);
    }

    public void onEvent(REventIf ev) {
        this.myTopic.eventQueue.add(ev);
        if (this.myTopic.messageAnnouncer != null) {
            this.myTopic.messageAnnouncer.wakeUp();
        }
    }

    public void onHeartbeatTimeout(StreamRIf p_str) {
        boolean res;
        if (this.myTopic == null || this.myTopic.mStreamHT == null) {
            return;
        }
        MessageStream ms = this.myTopic.mStreamHT.get(p_str.getId());
        if (ms != null) {
            ms.isSuspended = true;
        }
        if (res = this.myTopic.mStreamHT.remove(p_str.getId())) {
            if (this.mRec.rmmLogger.isMaxLogLevel()) {
                this.mRec.rmmLogger.maxInfo("Removing MessageStream " + p_str.getId() + " . Remaining: " + this.myTopic.mStreamHT.size(), moduleName);
            }
        } else if (this.mRec.rmmLogger.isMaxLogLevel()) {
            this.mRec.rmmLogger.maxWarn("Failed to remove MessageStream " + p_str.getId() + " . Happens if stream had no data. Remaining: " + this.myTopic.mStreamHT.size(), null, moduleName);
        }
    }
}

