/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.transmitter;

import com.ibm.rmm.mtl.admin.AdminTopic;
import com.ibm.rmm.util.RmmLogger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class Config {
    private static final String moduleName = "MTL_T";
    public static final String VERSION = "1.9.8.19 - 16/03/09";
    public static final int NO_RATE_LIMIT = 0;
    public static final int STATIC_RATE_LIMIT = 1;
    public static final int DYNAMIC_RATE_LIMIT = 2;
    public static final int MAX_EXC_COUNT = 0;
    public static final int MAX_CLOSE_WAIT_TIME = 120000;
    public static final int DELAY_NOT_PRESENT_EVENT = 120000;
    short packetSize;
    InetAddress multicastInterface;
    boolean bindAll = false;
    int limitTransRate;
    String logFile;
    String ptlProtocol;
    public boolean enableAdmin = false;
    int dataPort;
    int serverPort = 0;
    boolean disableMulticast = false;
    boolean disableUnicast = true;
    boolean newMtl;
    boolean useTcpChannel;
    RmmLogger rmmLogger;
    boolean collectStats;
    int statsPeriod = 2000;
    int clockUpdateInterval = 10;
    boolean isOK;

    Config(RmmLogger rlog, Properties props, boolean read_levels) {
        String admin_gr;
        String tmp;
        this.rmmLogger = rlog;
        this.isOK = true;
        int ll = 1;
        int dl = 1;
        if (read_levels) {
            tmp = props.getProperty("LogLevel");
            if (tmp == null) {
                this.rmmLogger.baseLog(402, new Object[]{"LogLevel"}, null, moduleName);
            } else {
                ll = tmp.regionMatches(true, 0, "no", 0, 2) ? 0 : (tmp.regionMatches(true, 0, "max", 0, 3) ? 2 : 1);
            }
            this.logFile = props.getProperty("LogFile");
            if (this.logFile == null) {
                this.rmmLogger.baseLog(402, new Object[]{"LogFile"}, null, moduleName);
            }
            if ((tmp = props.getProperty("DebugLevel")) == null) {
                this.rmmLogger.baseLog(402, new Object[]{"DebugLevel"}, null, moduleName);
            } else {
                dl = tmp.regionMatches(true, 0, "no", 0, 2) ? 0 : (tmp.regionMatches(true, 0, "max", 0, 3) ? 2 : 1);
            }
            this.rmmLogger.changeLevels(ll, dl);
        }
        if ((tmp = props.getProperty("PacketSizeBytes")) == null) {
            this.rmmLogger.baseLog(402, new Object[]{"PacketSizeBytes"}, null, moduleName);
            this.isOK = false;
            return;
        }
        try {
            this.packetSize = Short.parseShort(tmp);
        }
        catch (NumberFormatException e2) {
            this.rmmLogger.baseBadParam("PacketSizeBytes", tmp, e2, moduleName);
            this.isOK = false;
            return;
        }
        if (this.packetSize < 100 || this.packetSize > 32000) {
            this.rmmLogger.baseBadParam("PacketSizeBytes", "" + this.packetSize, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("BindAllInterfaces");
        if (tmp != null) {
            this.bindAll = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("ClockUpdateIntervalMilli")) != null) {
            try {
                this.clockUpdateInterval = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("ClockUpdateInterval", tmp, e3, moduleName);
                this.isOK = false;
                return;
            }
            if (this.clockUpdateInterval < 1 || this.clockUpdateInterval > 10000) {
                this.rmmLogger.baseBadParam("ClockUpdateInterval", "" + this.clockUpdateInterval, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("MulticastInterface")) == null || tmp.trim().length() == 0) {
            this.multicastInterface = null;
        } else if (tmp.equalsIgnoreCase("none") || tmp.equalsIgnoreCase("all")) {
            this.multicastInterface = null;
        } else {
            try {
                this.multicastInterface = InetAddress.getByName(tmp);
            }
            catch (UnknownHostException ex) {
                this.rmmLogger.baseError("Failed to init NW interface " + tmp, ex, moduleName);
                this.rmmLogger.baseLog(412, new Object[]{tmp}, ex, moduleName);
                this.isOK = false;
                return;
            }
            try {
                Enumeration<NetworkInterface> nws = NetworkInterface.getNetworkInterfaces();
                boolean found = false;
                while (nws.hasMoreElements()) {
                    Enumeration<InetAddress> adrs = nws.nextElement().getInetAddresses();
                    while (adrs.hasMoreElements()) {
                        InetAddress address = adrs.nextElement();
                        if (!this.multicastInterface.equals(address)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) {
                    rlog.baseError("NW interface " + tmp + " - not in local NW interface list. Using default", null, moduleName);
                    this.rmmLogger.baseBadParam("MulticastInterface", tmp, new Exception("Network Interface " + tmp + " was not found in local machine network interface list. Make sure that the NetworkInterface property is properly configured!"), moduleName);
                    this.isOK = false;
                    return;
                }
            }
            catch (Exception e4) {
                rlog.baseError("Failed to retrieve NW interf list. Cannot check interface validity", e4, moduleName);
            }
        }
        tmp = props.getProperty("LimitTransRate");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"LimitTransRate"}, null, moduleName);
            this.limitTransRate = 0;
        } else if (tmp.equalsIgnoreCase("dynamic")) {
            this.limitTransRate = 2;
        } else if (tmp.equalsIgnoreCase("static")) {
            this.limitTransRate = 1;
        } else if (tmp.equalsIgnoreCase("disabled")) {
            this.limitTransRate = 0;
        } else {
            this.limitTransRate = 0;
            this.rmmLogger.baseBadParam("LimitTransRate", tmp, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("DisableMulticast");
        if (tmp != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("DisableMulticast", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.disableMulticast = Boolean.valueOf(tmp);
            if (this.disableMulticast) {
                this.rmmLogger.baseInfo("   Multicast Disabled\n", moduleName);
            }
        }
        if ((tmp = props.getProperty("DisableUnicast")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("DisableUnicast", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.disableUnicast = Boolean.valueOf(tmp);
            if (this.disableUnicast) {
                this.rmmLogger.baseInfo("   Unicast Disabled\n", moduleName);
            }
        }
        if (!this.disableMulticast) {
            tmp = props.getProperty("DataPort");
            if (tmp == null) {
                this.rmmLogger.baseLog(402, new Object[]{"DataPort"}, null, moduleName);
                this.isOK = false;
                return;
            }
            try {
                this.dataPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("DataPort", tmp, e5, moduleName);
                this.isOK = false;
                return;
            }
            if (this.dataPort < 1 || this.dataPort >= 65535) {
                this.rmmLogger.baseBadParam("DataPort", "" + this.dataPort, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (!this.disableUnicast && (tmp = props.getProperty("ServerSocketPort")) != null) {
            try {
                this.serverPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e6) {
                this.rmmLogger.baseBadParam("ServerSocketPort", tmp, e6, moduleName);
                this.isOK = false;
                return;
            }
            if (this.serverPort <= 0 || this.serverPort > 65535) {
                this.rmmLogger.baseBadParam("ServerSocketPort", "" + this.serverPort, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        this.ptlProtocol = props.getProperty("ProtocolType");
        if (this.ptlProtocol != null && this.ptlProtocol.toLowerCase().startsWith("pgm")) {
            this.newMtl = true;
        }
        if ((tmp = props.getProperty("EnableAdminModule")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("EnableAdminModule", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.enableAdmin = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("UseTcpChannel")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("UseTcpChannel", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.useTcpChannel = Boolean.valueOf(tmp);
        }
        if (this.enableAdmin && (admin_gr = props.getProperty("AdminMulticastGroup")) != null) {
            AdminTopic.setAdminGroup(admin_gr);
        }
        if ((tmp = props.getProperty("CollectStats")) != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("CollectStats", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.collectStats = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("StatisticsPeriodSec")) != null) {
            try {
                this.statsPeriod = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e7) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", tmp, e7, moduleName);
                this.isOK = false;
                return;
            }
            if (this.statsPeriod <= 0) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", "" + this.statsPeriod, null, moduleName);
                this.isOK = false;
                return;
            }
        }
    }
}

