/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.transmitter;

import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.transmitter.Event;
import java.util.LinkedList;

public class EventAnnouncer
extends Thread {
    private static final String moduleName = "MTL_T";
    private LinkedList eventVector = new LinkedList();
    private LinkedList suspendedEvents;
    private MTransmitter mTrans;
    int nRot;
    volatile boolean threadStopped = false;
    private boolean goOn = true;
    boolean isSleeping;
    boolean notifyPending;

    public EventAnnouncer(MTransmitter mtr) {
        this.mTrans = mtr;
        this.suspendedEvents = new LinkedList();
    }

    void wakeUp() {
        this.wakeUp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            LinkedList linkedList = this.eventVector;
            synchronized (linkedList) {
                if (this.isSleeping) {
                    this.eventVector.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(Event ev, MTopicT mtt) {
        LinkedList linkedList = this.eventVector;
        synchronized (linkedList) {
            this.eventVector.addLast(ev);
            this.eventVector.addLast(mtt);
            this.wakeUp(false);
        }
    }

    private void processEvent(Event ev, MTopicT mtt) {
        if (mtt == null || ev == null || mtt.isClosed) {
            return;
        }
        if (mtt.isSuspendEvents()) {
            this.suspendedEvents.addLast(ev);
            this.suspendedEvents.addLast(mtt);
            if (this.mTrans.rmmLogger.isMaxLogLevel()) {
                this.mTrans.rmmLogger.maxInfo("EventAnnouncer: Suspending event type " + ev.getType() + (mtt.pStream == null ? " pStream is null " : " stream " + mtt.pStream.getId()) + " eventVector.size " + this.eventVector.size() + " suspendedEvents.size" + this.suspendedEvents.size() + " nRot " + this.nRot, moduleName);
            }
        } else {
            try {
                if (mtt.eventListener != null) {
                    mtt.eventListener.onEvent(ev);
                    if (this.mTrans.rmmLogger.isMaxLogLevel()) {
                        this.mTrans.rmmLogger.maxInfo("EventAnnouncer: delivered event type " + ev.getType() + (mtt.pStream == null ? " pStream is null " : " stream " + mtt.pStream.getId()) + " eventVector.size " + this.eventVector.size() + " nRot " + this.nRot, moduleName);
                    }
                } else if (!mtt.isCleaned) {
                    this.mTrans.rmmLogger.baseWarn("EventAnnouncer: eventListener is null in a none suspended topic! " + (mtt.pStream == null ? " pStream is null " : " stream " + mtt.pStream.getId()) + " eventVector.size " + this.eventVector.size() + " nRot " + this.nRot, null, moduleName);
                }
            }
            catch (Exception ex) {
                this.mTrans.rmmLogger.baseWarn("EventAnnouncer: Exception while processing event." + (mtt.pStream == null ? " pStream is null " : " stream " + mtt.pStream.getId()) + " eventVector.size " + this.eventVector.size() + " nRot " + this.nRot, ex, moduleName);
            }
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exc_count = 0;
        Event ev = null;
        MTopicT mtt = null;
        while (this.goOn) {
            ++this.nRot;
            try {
                ev = null;
                LinkedList linkedList = this.eventVector;
                synchronized (linkedList) {
                    if (this.eventVector.size() > 1) {
                        ev = (Event)this.eventVector.removeFirst();
                        mtt = (MTopicT)this.eventVector.removeFirst();
                    } else if (this.notifyPending) {
                        this.notifyPending = false;
                    } else {
                        this.isSleeping = true;
                        this.eventVector.wait();
                        this.isSleeping = false;
                    }
                }
                if (ev != null) {
                    this.processEvent(ev, mtt);
                }
                int n = this.suspendedEvents.size();
                while (n-- > 0) {
                    ev = (Event)this.suspendedEvents.removeFirst();
                    mtt = (MTopicT)this.suspendedEvents.removeFirst();
                    this.processEvent(ev, mtt);
                }
            }
            catch (Throwable ex) {
                if (this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.mTrans.isRunning) break;
                    this.mTrans.rmmLogger.baseLog(406, new Object[]{"EventAnnouncer"}, ex, moduleName);
                    break;
                }
                this.mTrans.rmmLogger.baseError("EventAnnouncer: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.mTrans.rmmLogger.baseError("Too many exceptions. Stop EventAnnouncer", null, moduleName);
                this.mTrans.rmmLogger.baseLog(416, new Object[]{"EventAnnouncer"}, ex, moduleName);
                break;
            }
        }
        LinkedList linkedList = this.eventVector;
        synchronized (linkedList) {
            this.threadStopped = true;
        }
        this.mTrans.rmmLogger.baseLog(2, new Object[]{"EventAnnouncer"}, null, moduleName);
    }
}

