/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.transmitter;

import com.ibm.rmm.intrn.util.PersistByteArrayOutputStream;
import com.ibm.rmm.mtl.admin.CatalogT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.ptl.admin.AckSessionT;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.ifc.transmitter.BufferRequestListener;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTUpcalls;
import com.ibm.rmm.transmitter.EventListener;
import com.ibm.rmm.util.AckListener;
import com.ibm.rmm.util.RmmAddressIf;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class MTopicT
implements StreamTUpcalls {
    private static final String moduleName = "MTL_T";
    public MTransmitter mTrans;
    protected String topicName;
    protected byte[] topicId;
    protected int tagLen;
    protected String topicAddress;
    protected StreamTIf pStream;
    protected boolean point2point;
    protected boolean isClosed = false;
    protected boolean isCleaned = false;
    protected boolean isClosedReported = false;
    protected boolean suspendEvents = false;
    protected EventListener eventListener;
    private byte[] mbuffer;
    private byte[] pbuffer;
    private DataOutputStream dos;
    private PersistByteArrayOutputStream pbaos;
    private short maxPktBodyL;
    short bufferLength;
    int mtlHeaderSize;
    boolean isOk;
    int maxMsgs = 125;
    private short freeBodyLen;
    byte msgStartN;
    private short[] msgStarts;
    private short msgEnd;
    private short idSeed = 0;
    private short msgId;
    protected long msgCntr;
    private byte lOpen;
    private byte rOpen;
    private short lMsgId;
    private short rMsgId;
    private int lMsgSize;
    private int rMsgSize;
    private int lMsgOffset;
    private AckSessionT ackSession;

    public MTopicT() {
    }

    protected MTopicT(MTransmitter mtr, boolean p2p, String name2, byte[] t_id, StreamTIf p_stream, String address) {
        this.mTrans = mtr;
        this.topicName = name2;
        this.pStream = p_stream;
        this.topicId = t_id;
        this.tagLen = t_id.length;
        this.topicAddress = address;
        this.point2point = p2p;
        this.mtlHeaderSize = 23;
        this.maxPktBodyL = (short)(this.mTrans.config.packetSize - mtr.ptlHeaderSize - this.tagLen - this.mtlHeaderSize);
        if (this.mTrans.rmmLogger.isMaxLogLevel()) {
            this.mTrans.rmmLogger.maxInfo(" maxPktBodyL: " + this.maxPktBodyL + "=" + this.mTrans.config.packetSize + "-" + mtr.ptlHeaderSize + "-" + this.tagLen + "-" + this.mtlHeaderSize, moduleName);
        }
        if (this.maxPktBodyL < 64) {
            this.mTrans.rmmLogger.baseError("No space left for message payload. Buffer size is " + this.maxPktBodyL, null, moduleName);
            this.isOk = false;
        } else {
            this.isOk = true;
            this.pbuffer = new byte[this.mtlHeaderSize + 2 * this.maxMsgs];
            this.pbaos = new PersistByteArrayOutputStream(this.pbuffer);
            this.dos = new DataOutputStream(this.pbaos);
            this.mbuffer = new byte[this.maxPktBodyL];
            this.bufferLength = 0;
            this.msgStartN = 0;
            this.msgStarts = new short[this.maxMsgs];
            this.freeBodyLen = this.maxPktBodyL;
            this.pStream.setBufReqListener(new BufferRequestListener(){

                public boolean onRequest() {
                    return MTopicT.this.synchBuildPacket();
                }
            });
            this.pStream.setCleanUpListener(this);
            this.pStream.wakeUp();
            this.isClosed = false;
        }
    }

    public boolean setTransmissionRate(int rate_kbps) {
        this.pStream.setTransmissionRate(rate_kbps);
        return true;
    }

    public boolean startCongestionControl(int trans_rate_kbps) {
        if (this.mTrans.config.limitTransRate == 0) {
            this.mTrans.rmmLogger.baseError("startCongestionControl: Failed since limitTransRate is off", new StackTracer(), moduleName);
            return false;
        }
        this.pStream.startCongestionControl(trans_rate_kbps);
        return true;
    }

    public boolean startConstantRatePolicy(int trans_rate_kbps, int loss_rate_threshold) {
        if (this.mTrans.config.limitTransRate == 0) {
            this.mTrans.rmmLogger.baseError("startConstantRatePolicy: Failed since limitTransRate is off", new StackTracer(), moduleName);
            return false;
        }
        this.setTransmissionRate(trans_rate_kbps);
        this.mTrans.adminNode.startConstantRatePolicy(this.pStream, loss_rate_threshold);
        return true;
    }

    public boolean startAckedDelivery() {
        if (this.ackSession != null) {
            this.mTrans.rmmLogger.baseWarn("Ack Session already exist for topic  " + this.getTopicName(), null, moduleName);
        } else {
            this.ackSession = new AckSessionT(this.pStream);
        }
        return true;
    }

    public boolean startAckedDelivery(Set members, AckListener l) {
        if (this.ackSession != null) {
            this.mTrans.rmmLogger.baseWarn("Ack Session already exist for topic  " + this.getTopicName(), null, moduleName);
        } else {
            this.ackSession = new AckSessionT(this.pStream, members, l);
        }
        return true;
    }

    public boolean setEventListener(EventListener el) {
        this.eventListener = el;
        return true;
    }

    public boolean setReceivers(Set members) {
        if (this.ackSession == null) {
            this.mTrans.rmmLogger.baseWarn("Can not set receivers. Acks are not allowed for topic " + this.getTopicName(), null, moduleName);
            return false;
        }
        return this.ackSession.setAllowedReceivers(members);
    }

    public boolean removeReceiver(RmmAddressIf receiver) {
        if (this.ackSession == null) {
            this.mTrans.rmmLogger.baseWarn("Can not remove receiver. Acks are not allowed for topic " + this.getTopicName(), null, moduleName);
            return false;
        }
        return this.ackSession.removeReceiver(receiver);
    }

    public boolean addReceiver(RmmAddressIf receiver) {
        if (this.ackSession == null) {
            this.mTrans.rmmLogger.baseWarn("Can not add receiver. Acks are not allowed for topic " + this.getTopicName(), null, moduleName);
            return false;
        }
        return this.ackSession.addReceiver(receiver);
    }

    public List getReceivers() {
        if (this.ackSession == null) {
            this.mTrans.rmmLogger.baseWarn("No receivers set. Acks are not allowed for topic " + this.getTopicName(), null, moduleName);
            return null;
        }
        return this.ackSession.getHeap();
    }

    private boolean buildPacket() {
        this.pStream.setMtlSize(0);
        if (this.bufferLength == 0) {
            if (this.mTrans.rmmLogger.isMaxLogLevel()) {
                this.mTrans.rmmLogger.maxWarn("buildPacket, zero buffer length", null, moduleName);
            }
            return false;
        }
        this.pbaos.reset();
        try {
            this.dos.writeByte(this.msgStartN);
            int i = 0;
            while (i < this.msgStartN) {
                this.dos.writeShort(this.msgStarts[i]);
                ++i;
            }
            this.dos.writeShort(this.msgEnd);
            this.dos.writeByte(this.lOpen);
            this.dos.writeByte(this.rOpen);
            if (this.lOpen == 1) {
                this.dos.writeShort(this.lMsgId);
                this.dos.writeInt(this.lMsgSize);
                this.dos.writeInt(this.lMsgOffset);
            }
            if (this.rOpen == 1) {
                this.dos.writeShort(this.rMsgId);
                this.dos.writeInt(this.rMsgSize);
            }
        }
        catch (IOException ex) {
            this.mTrans.rmmLogger.baseError("Packet building error. Stream: " + this.pStream, ex, moduleName);
            return false;
        }
        boolean res = this.pStream.submitPacketData(this.pbuffer, 0, this.pbaos.getPosition(), this.mbuffer, 0, this.bufferLength);
        this.bufferLength = 0;
        this.msgStartN = 0;
        this.msgEnd = 0;
        this.lOpen = 0;
        this.rOpen = 0;
        this.freeBodyLen = this.maxPktBodyL;
        return res;
    }

    public boolean close(boolean soft) {
        if (this.isClosed) {
            if (this.mTrans.rmmLogger.isMaxLogLevel()) {
                this.mTrans.rmmLogger.maxWarn("close() called on already closed Topic/Queue " + this.topicName + " Stream ID: " + this.pStream.getId(), null, moduleName);
            }
            return true;
        }
        this.isClosed = true;
        if (this.ackSession != null && this.ackSession.getNumReceivers() == 0) {
            soft = false;
        }
        this.mTrans.rmmLogger.baseInfo(String.valueOf(soft ? "Soft " : "Fast ") + "Closing topic " + this.topicName + " Stream ID: " + this.pStream.getId(), moduleName);
        boolean res = this.pStream.close(soft);
        if (!soft) {
            this.cleanAfterClose();
        }
        return res;
    }

    public void cleanAfterClose() {
        if (this.isCleaned) {
            return;
        }
        this.isCleaned = true;
        if (this.ackSession != null) {
            this.ackSession.close();
        }
        if (this.mTrans.adminNode != null) {
            DataStreamT.removeDataStream(this.pStream);
            if (this.mTrans.adminNode.isCatalogEnabled()) {
                CatalogT.removeTopic(this);
            }
        }
        if (!this.point2point) {
            Object res = this.mTrans.topicHashTable.remove("" + this.pStream.getId());
            this.mTrans.rmmLogger.baseInfo("Removing topic " + this.topicName + " Stream ID: " + this.pStream.getId() + ". Success: " + (res != null) + ". Remaining topics: " + this.mTrans.topicHashTable.size(), moduleName);
        } else {
            Object res = this.mTrans.queueHashTable.remove("" + this.pStream.getId());
            this.mTrans.rmmLogger.baseInfo("Removing queue " + this.topicName + " Stream ID: " + this.pStream.getId() + ". Success: " + (res != null) + ". Remaining queues: " + this.mTrans.queueHashTable.size(), moduleName);
        }
        this.eventListener = null;
    }

    public int getFrontSeqNum() {
        return this.pStream.getFrontSeqNum();
    }

    public int getTrailSeqNum() {
        return this.pStream.getTrailSeqNum();
    }

    public long getStreamId() {
        return this.pStream.getId();
    }

    public long getBytesTransmitted() {
        return this.pStream.getBytesTransmitted();
    }

    public long getPendingQueueSize() {
        return this.pStream.getPendingQueueSize();
    }

    public long getBytesRetransmitted() {
        return this.pStream.getBytesRetransmitted();
    }

    public long getMsgsSent() {
        return this.msgCntr;
    }

    public String getTopicAddress() {
        return this.topicAddress;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public UnicastConnectionIf getUnicastConnection() {
        return this.pStream.getUnicastConnection();
    }

    public boolean isReliable() {
        return this.pStream.isReliable();
    }

    public boolean isActive() {
        return this.pStream.isActive();
    }

    public boolean isConnected(String address, int port2) {
        return this.pStream.isConnected(address, port2);
    }

    public boolean isQuarantined() {
        return this.pStream.isQuarantined();
    }

    public boolean submitMessage(byte[] msg) {
        if (msg == null) {
            this.mTrans.rmmLogger.baseError("submitMessage(): null msg arg!", null, moduleName);
            return false;
        }
        return this.submitMessage(msg, 0, msg.length);
    }

    protected boolean preSubmitCheck() {
        if (this.isClosed) {
            if (!this.isClosedReported) {
                this.mTrans.rmmLogger.baseWarn("Message submitted to closed Topic/Queue " + this.pStream.getId(), null, moduleName);
                this.isClosedReported = true;
            }
            return false;
        }
        return true;
    }

    public boolean nbSubmitMessage(byte[] msg, int offset, int msg_length) {
        if (this.pStream.isCongested()) {
            return false;
        }
        this.submitMessage(msg, offset, msg_length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitMessage(byte[] msg, int offset, int msg_length) {
        if (msg == null) {
            this.mTrans.rmmLogger.baseError("submitMessage(): null msg arg!", null, moduleName);
            return false;
        }
        if (offset < 0 || msg_length < 0 || offset + msg_length > msg.length) {
            this.mTrans.rmmLogger.baseError("submitMessage(): invalid offset/length :" + offset + " " + msg_length + " " + msg.length, null, moduleName);
            return false;
        }
        byte[] byArray = this.mbuffer;
        synchronized (this.mbuffer) {
            if (!this.preSubmitCheck()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            ++this.msgCntr;
            boolean msg_id_built = false;
            if (msg_length <= this.freeBodyLen) {
                System.arraycopy(msg, offset, this.mbuffer, this.bufferLength, msg_length);
                this.msgStarts[this.msgStartN] = this.bufferLength;
                this.msgStartN = (byte)(this.msgStartN + 1);
                this.bufferLength = (short)(this.bufferLength + msg_length);
                this.freeBodyLen = (short)(this.freeBodyLen - (msg_length + 2));
                this.msgEnd = this.bufferLength;
                if (!(this.msgStartN != this.maxMsgs && this.freeBodyLen >= 16 || this.buildPacket())) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
            } else {
                short msg_res;
                int shift = 0;
                if (this.freeBodyLen < 512) {
                    this.msgEnd = this.bufferLength;
                    shift = 0;
                } else {
                    this.msgEnd = 0;
                    System.arraycopy(msg, offset, this.mbuffer, this.bufferLength, this.freeBodyLen);
                    shift = this.freeBodyLen;
                    this.msgStarts[this.msgStartN] = this.bufferLength;
                    this.msgStartN = (byte)(this.msgStartN + 1);
                    this.bufferLength = (short)(this.bufferLength + this.freeBodyLen);
                    this.rOpen = 1;
                    if (!msg_id_built) {
                        msg_id_built = true;
                        short s = this.idSeed;
                        this.idSeed = (short)(s + 1);
                        this.msgId = s;
                    }
                    this.rMsgId = this.msgId;
                    this.rMsgSize = msg_length;
                }
                if (!this.buildPacket()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                int n_whole_chunks = (msg_length - shift) / this.maxPktBodyL;
                if (n_whole_chunks > 0) {
                    int i = 0;
                    while (i < n_whole_chunks) {
                        if (shift == 0) {
                            this.msgStartN = 1;
                            this.msgStarts[0] = 0;
                        } else {
                            this.msgStartN = 0;
                            this.lOpen = 1;
                            if (!msg_id_built) {
                                msg_id_built = true;
                                this.idSeed = (short)(this.idSeed + 1);
                                this.msgId = this.msgId;
                            }
                            this.lMsgId = this.msgId;
                            this.lMsgSize = msg_length;
                            this.lMsgOffset = shift;
                        }
                        System.arraycopy(msg, offset + shift, this.mbuffer, 0, this.maxPktBodyL);
                        this.bufferLength = this.maxPktBodyL;
                        if ((shift += this.maxPktBodyL) == msg_length) {
                            this.msgEnd = this.maxPktBodyL;
                        } else {
                            this.msgEnd = 0;
                            if (this.msgStartN == 1) {
                                this.rOpen = 1;
                                if (!msg_id_built) {
                                    msg_id_built = true;
                                    this.idSeed = (short)(this.idSeed + 1);
                                    this.msgId = this.msgId;
                                }
                                this.rMsgId = this.msgId;
                                this.rMsgSize = msg_length;
                            }
                        }
                        if (!this.buildPacket()) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return false;
                        }
                        ++i;
                    }
                }
                if ((msg_res = (short)(msg_length - shift)) > 0) {
                    if (shift == 0) {
                        this.msgStartN = 1;
                        this.msgStarts[0] = 0;
                    } else {
                        this.msgStartN = 0;
                        this.lOpen = 1;
                        if (!msg_id_built) {
                            msg_id_built = true;
                            short s = this.idSeed;
                            this.idSeed = (short)(s + 1);
                            this.msgId = s;
                        }
                        this.lMsgId = this.msgId;
                        this.lMsgSize = msg_length;
                        this.lMsgOffset = shift;
                    }
                    this.freeBodyLen = (short)(this.maxPktBodyL - msg_res - 2 * this.msgStartN);
                    System.arraycopy(msg, offset + shift, this.mbuffer, 0, msg_res);
                    this.bufferLength = msg_res;
                    this.msgEnd = msg_res;
                }
            }
            this.pStream.setMtlSize(this.bufferLength);
            if (this.bufferLength > 0) {
                this.pStream.wakeUp();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.msgCntr % 1000L == 0L) {
                Thread.yield();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean synchBuildPacket() {
        byte[] byArray = this.mbuffer;
        synchronized (this.mbuffer) {
            block4: {
                if (this.bufferLength != 0) break block4;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return false;
            }
            boolean ret = this.buildPacket();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return ret;
        }
    }

    public boolean sendHeartbeat() {
        return this.pStream.sendHeartbeat();
    }

    void setSuspendEvents(boolean suspend) {
        this.suspendEvents = suspend;
        this.mTrans.eventAnnouncer.wakeUp();
    }

    boolean isSuspendEvents() {
        return this.suspendEvents;
    }
}

