/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.CatalogT;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.transmitter.Config;
import com.ibm.rmm.mtl.transmitter.CreateConnectionImpl;
import com.ibm.rmm.mtl.transmitter.EventAnnouncer;
import com.ibm.rmm.mtl.transmitter.MLJETopicT;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.NewMLJETopicT;
import com.ibm.rmm.mtl.transmitter.NewMTopicT;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.ifc.transmitter.EventListener;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.transmitter.TEventIf;
import com.ibm.rmm.ptl.tcp.transmitter.PTransmitter;
import com.ibm.rmm.transmitter.CreateQueueTListener;
import com.ibm.rmm.transmitter.Event;
import com.ibm.rmm.util.DefaultLogListener;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class MTransmitter {
    private static final String moduleName = "MTL_T";
    public RmmLogger rmmLogger;
    public RmmAddress rmmAddress;
    public TaskManager taskMan;
    MReceiver myMReceiver;
    PTransmitterIf pTransmitter;
    PTransmitterIf unicastPTransmitter;
    int ptlHeaderSize;
    public Config config;
    public StatusDumper statusDumper;
    private Properties configProperties;
    AdminNode adminNode;
    Hashtable topicHashTable;
    Hashtable queueHashTable;
    boolean isRunning;
    private PrintStream logPrintStream;
    EventAnnouncer eventAnnouncer;
    Map configMap;
    private boolean isOK;

    private MTransmitter(RmmLogger rlog, Properties config_props, Map config_map, boolean read_levels) {
        this.rmmLogger = rlog;
        this.configMap = config_map;
        this.isOK = true;
        this.rmmLogger.baseInfo("Start up time: " + new Date(), moduleName);
        this.rmmLogger.baseInfo("RMM Version: 1.9.8.19 - 16/03/09", moduleName);
        this.rmmLogger.baseInfo("OS Name: " + System.getProperty("os.name"), moduleName);
        this.rmmLogger.baseInfo("Transmitter Configuration: \n" + config_props, moduleName);
        try {
            this.rmmLogger.baseInfo("Local address: " + InetAddress.getLocalHost(), moduleName);
            this.rmmLogger.baseInfo("Listing all local interfaces: ", moduleName);
            Enumeration<NetworkInterface> nws = NetworkInterface.getNetworkInterfaces();
            while (nws.hasMoreElements()) {
                NetworkInterface ni = nws.nextElement();
                this.rmmLogger.baseInfo("local interface: " + ni, moduleName);
                Enumeration<InetAddress> adrs = ni.getInetAddresses();
                while (adrs.hasMoreElements()) {
                    InetAddress address = adrs.nextElement();
                    this.rmmLogger.baseInfo("interface address: " + address, moduleName);
                }
            }
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to retrieve local address or NW interf list.", e2, moduleName);
        }
        this.config = new Config(rlog, config_props, read_levels);
        if (!this.config.isOK) {
            this.isOK = false;
            return;
        }
        this.taskMan = new TaskManager(this.config.clockUpdateInterval);
        this.rmmLogger.baseInfo("Starting TaskManager with SleepTime of " + this.taskMan.nominalSleep(), moduleName);
        this.topicHashTable = new Hashtable();
        this.queueHashTable = new Hashtable();
        if (this.config.logFile != null && !this.config.logFile.equalsIgnoreCase("std")) {
            try {
                this.logPrintStream = new PrintStream(new FileOutputStream(this.config.logFile));
                this.rmmLogger.baseInfo("From NOW ON,the standard and error streams redirected to " + this.config.logFile, moduleName);
                System.setOut(this.logPrintStream);
                System.setErr(this.logPrintStream);
                this.rmmLogger.baseInfo("Start up time: " + new Date(), moduleName);
                this.rmmLogger.baseInfo("RMM Version: 1.9.8.19 - 16/03/09", moduleName);
                this.rmmLogger.baseInfo("OS Name: " + System.getProperty("os.name"), moduleName);
                this.rmmLogger.baseInfo("Transmitter Configuration: \n" + config_props, moduleName);
            }
            catch (FileNotFoundException ex) {
                this.rmmLogger.baseLog(401, new Object[]{this.config.logFile}, ex, moduleName);
            }
        }
        this.configProperties = config_props;
        this.isRunning = true;
        boolean create_sockets = !this.config.disableMulticast || this.config.serverPort == 0;
        int port2 = create_sockets ? this.config.serverPort : this.config.serverPort;
        this.rmmAddress = new RmmAddress(this.rmmLogger, this.config.multicastInterface, port2, create_sockets);
        if (!this.rmmAddress.isValid()) {
            if (this.config.disableMulticast && this.config.multicastInterface == null && this.config.bindAll) {
                this.rmmLogger.baseWarn("MTransmitter has an invalid Rmm address but can continue.", null, moduleName);
            } else {
                this.isOK = false;
                return;
            }
        }
        this.ptlHeaderSize = 0;
        if (!this.config.disableMulticast) {
            boolean scs;
            if (this.config.ptlProtocol == null || this.config.ptlProtocol.equalsIgnoreCase("mstp") || this.config.ptlProtocol.equalsIgnoreCase("ptl")) {
                this.pTransmitter = new com.ibm.rmm.ptl.mstp.transmitter.PTransmitter();
                this.rmmLogger.baseInfo("Transmitter: Selecting MSTP PTL", moduleName);
            } else {
                this.pTransmitter = new com.ibm.rmm.ptl.pgm.transmitter.PTransmitter();
                this.rmmLogger.baseInfo("Transmitter: Selecting PGM PTL", moduleName);
            }
            if (this.config.enableAdmin) {
                AdminClient.rmmAddress = this.rmmAddress;
                AdminClient.rmmLogger = this.rmmLogger;
            }
            if (!(scs = this.pTransmitter.init(this.rmmAddress, this.rmmLogger, this.taskMan, config_props, config_map, this.config.packetSize, this.rmmAddress.getInetAddress()))) {
                this.pTransmitter = null;
                this.isOK = false;
                return;
            }
            int size = this.pTransmitter.getHeaderSize();
            if (this.ptlHeaderSize < size) {
                this.ptlHeaderSize = size;
            }
            if (this.config.enableAdmin) {
                this.adminNode = AdminNode.getInstance(this.pTransmitter);
            }
        }
        if (!this.config.disableUnicast) {
            this.unicastPTransmitter = this.config.useTcpChannel ? new com.ibm.rmm.ptl.tchan.transmitter.PTransmitter() : new PTransmitter();
            boolean scs = this.unicastPTransmitter.init(this.rmmAddress, this.rmmLogger, this.taskMan, this.configProperties, config_map, this.config.packetSize, this.rmmAddress.getInetAddress());
            if (!scs) {
                this.unicastPTransmitter = null;
                this.isOK = false;
                return;
            }
            int size = this.unicastPTransmitter.getHeaderSize();
            if (this.ptlHeaderSize < size) {
                this.ptlHeaderSize = size;
            }
        }
        this.eventAnnouncer = new EventAnnouncer(this);
        this.eventAnnouncer.setName("Mtl_Tx_EventAnnouncer");
        this.eventAnnouncer.start();
        if (this.config.collectStats) {
            this.statusDumper = new StatusDumper(this);
        }
    }

    public static synchronized MTransmitter getInstance() {
        File config_file = null;
        String config_file_name = System.getProperty("transmitter.config");
        config_file = config_file_name != null ? new File(config_file_name) : new File("transmitter.config");
        return MTransmitter.getInstance(config_file, null, null, 0, 0, null);
    }

    public static synchronized MTransmitter getInstance(Properties config_props, Map config_map, int log_level, int debug_level, LogEventListener listener) {
        return MTransmitter.getInstance(null, config_props, config_map, log_level, debug_level, listener);
    }

    private static MTransmitter getInstance(File config_file, Properties config_props, Map config_map, int log_level, int debug_level, LogEventListener listener) {
        RmmLogger rmm_logger;
        boolean read_levels = false;
        if (listener != null) {
            rmm_logger = new RmmLogger(listener, log_level, debug_level);
            rmm_logger.baseInfo("Log level: " + log_level, moduleName);
            if (log_level != 0 && log_level != 1 && log_level != 2) {
                rmm_logger.baseBadParam("logLevel", "" + log_level, null, moduleName);
                return null;
            }
            if (debug_level != 0 && debug_level != 1 && debug_level != 2) {
                rmm_logger.baseBadParam("debugLevel", "" + debug_level, null, moduleName);
                return null;
            }
        } else {
            rmm_logger = new RmmLogger(new DefaultLogListener(), 2, 2);
            read_levels = true;
        }
        if (config_file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(config_file);
            }
            catch (FileNotFoundException ex) {
                rmm_logger.baseLog(401, new Object[]{"" + config_file}, ex, moduleName);
                return null;
            }
            config_props = new Properties();
            try {
                config_props.load(fis);
            }
            catch (IOException ex) {
                rmm_logger.baseError("Failed to load configuration", ex, moduleName);
            }
        }
        MTransmitter instance = new MTransmitter(rmm_logger, config_props, config_map, read_levels);
        if (instance.isOK) {
            return instance;
        }
        return null;
    }

    public Map getTopicList() {
        return this.topicHashTable;
    }

    public synchronized MTopicT createTopicTransmitter(String topic, boolean reliable, String address) {
        return this.createTopicTransmitter(topic, reliable, address, -1, false);
    }

    public synchronized void addFullBufferListener(FullBufferListener fbl) {
        if (this.pTransmitter == null) {
            return;
        }
        this.pTransmitter.addFullBufferListener(fbl);
    }

    public synchronized void removeFullBufferListener(FullBufferListener fbl) {
        if (this.pTransmitter == null) {
            return;
        }
        this.pTransmitter.removeFullBufferListener(fbl);
    }

    public synchronized MLJETopicT createLJETopicTransmitter(String topic, String address) {
        return (MLJETopicT)this.createTopicTransmitter(topic, true, address, -1, true);
    }

    private MTopicT createTopicTransmitter(String topic, boolean reliable, String address, int port2, boolean lj_enabled) {
        MTopicT tmp;
        StreamTIf p_str;
        byte[] tag;
        if (this.config.disableMulticast) {
            this.rmmLogger.baseError("Cannot create TopicT: Multicast is disabled in Config", null, moduleName);
        }
        if (this.pTransmitter == null) {
            this.rmmLogger.baseError("Cannot create TopicT: pTransmitter is null", null, moduleName);
            return null;
        }
        if (address == null || address.equals("")) {
            address = CatalogT.getAddress(topic);
        }
        InetAddress itmp = null;
        try {
            itmp = InetAddress.getByName(address);
        }
        catch (UnknownHostException e2) {
            this.rmmLogger.baseError("Failed to process address " + address, e2, moduleName);
            this.rmmLogger.baseLog(412, new Object[]{address}, e2, moduleName);
            return null;
        }
        if (itmp != null && !itmp.isMulticastAddress()) {
            this.rmmLogger.baseBadParam("MulticastAddress", address, new StackTracer(), moduleName);
            return null;
        }
        try {
            tag = Sutils.stringToTag(topic);
        }
        catch (UnsupportedEncodingException ex) {
            this.rmmLogger.baseError("Failed to convert Topic to Tag", ex, moduleName);
            this.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, ex, moduleName);
            return null;
        }
        if (lj_enabled) {
            p_str = this.pTransmitter.createStreamTransmitter(true, itmp, port2, tag, true);
            if (p_str == null) {
                return null;
            }
            tmp = this.config.newMtl ? new NewMLJETopicT(this, topic, tag, p_str, address) : new MLJETopicT(this, topic, tag, p_str, address);
        } else {
            p_str = this.pTransmitter.createStreamTransmitter(reliable, itmp, port2, tag, false);
            if (p_str == null) {
                return null;
            }
            tmp = this.config.newMtl ? new NewMTopicT(this, false, topic, tag, p_str, address) : new MTopicT(this, false, topic, tag, p_str, address);
        }
        p_str.setEventListener(new EvListener(tmp));
        this.rmmLogger.baseInfo("Creating Stream: Id: " + p_str.getId() + ". Topic: " + topic + ". Mcast address: " + address + ". Rel: " + reliable + ". Lj: " + lj_enabled, moduleName);
        this.topicHashTable.put("" + p_str.getId(), tmp);
        if (this.adminNode != null && this.adminNode.isCatalogEnabled()) {
            CatalogT.addTopic(tmp);
        }
        return tmp;
    }

    public synchronized MTopicT createQueueTransmitter(String queue_name, byte[] tag, UnicastConnectionIf connection) {
        if (queue_name != null) {
            try {
                tag = Sutils.stringToTag(queue_name);
            }
            catch (UnsupportedEncodingException ex) {
                this.rmmLogger.baseError("Failed to convert Topic to Tag", ex, moduleName);
                this.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, ex, moduleName);
                return null;
            }
        } else {
            queue_name = "Nameless (ByteArray) Queue" + tag;
        }
        StreamTIf p_str = this.unicastPTransmitter.createStreamTransmitter(true, null, -1, tag, true);
        if (p_str == null) {
            return null;
        }
        String qAddress = String.valueOf(connection.getRemoteAddress().getHostAddress()) + ":" + connection.getRemotePort();
        MTopicT tmp = new MTopicT(this, true, queue_name, tag, p_str, qAddress);
        p_str.setEventListener(new EvListener(tmp));
        this.rmmLogger.baseInfo("Creating Unicast Stream: Id: " + p_str.getId() + ". Queue: " + queue_name + ", length " + p_str.getTagLength() + ". Destination address: " + qAddress + ", ucon " + connection, moduleName);
        this.queueHashTable.put("" + p_str.getId(), tmp);
        boolean res = false;
        res = p_str.addP2Pdestination(connection);
        if (!res) {
            long s_id = p_str.getId();
            res = tmp.close(false);
            if (!res) {
                this.rmmLogger.baseError("Failed to close stream after addP2Pdestination faile stream id " + s_id, null, moduleName);
            }
            this.queueHashTable.remove("" + p_str.getId());
            return null;
        }
        return tmp;
    }

    public synchronized MTopicT createQueueTransmitter(String queue_name, byte[] tag, String address, int port2, boolean useExisting, CreateQueueTListener listener, int timeout) {
        StreamTIf p_str;
        InetAddress itmp = null;
        try {
            itmp = InetAddress.getByName(address);
        }
        catch (UnknownHostException e2) {
            this.rmmLogger.baseError("Failed to process address " + address, e2, moduleName);
            this.rmmLogger.baseLog(412, new Object[]{address}, e2, moduleName);
            return null;
        }
        if (itmp != null && itmp.isMulticastAddress()) {
            this.rmmLogger.baseBadParam("UnicastAddress", address, new StackTracer(), moduleName);
            return null;
        }
        if (queue_name != null) {
            try {
                tag = Sutils.stringToTag(queue_name);
            }
            catch (UnsupportedEncodingException ex) {
                this.rmmLogger.baseError("Failed to convert Topic to Tag", ex, moduleName);
                this.rmmLogger.baseLog(411, new Object[]{"UTF-8"}, ex, moduleName);
                return null;
            }
        } else {
            queue_name = "Nameless (ByteArray) Queue" + tag;
        }
        if (this.unicastPTransmitter == null) {
            this.unicastPTransmitter = this.config.useTcpChannel ? new com.ibm.rmm.ptl.tchan.transmitter.PTransmitter() : new PTransmitter();
            boolean scs = this.unicastPTransmitter.init(this.rmmAddress, this.rmmLogger, this.taskMan, this.configProperties, this.configMap, this.config.packetSize, this.rmmAddress.getInetAddress());
            if (!scs) {
                this.unicastPTransmitter = null;
                return null;
            }
            int size = this.unicastPTransmitter.getHeaderSize();
            if (this.ptlHeaderSize < size) {
                this.ptlHeaderSize = size;
            }
        }
        if ((p_str = this.unicastPTransmitter.createStreamTransmitter(true, null, -1, tag, true)) == null) {
            return null;
        }
        String qAddress = String.valueOf(address) + ":" + port2;
        MTopicT tmp = new MTopicT(this, true, queue_name, tag, p_str, qAddress);
        p_str.setEventListener(new EvListener(tmp));
        this.rmmLogger.baseInfo("Creating Unicast Stream: Id: " + p_str.getId() + ". Queue: " + queue_name + ", length " + p_str.getTagLength() + ". Destination address: " + qAddress + ", listener " + listener + ", useExisting " + useExisting, moduleName);
        this.queueHashTable.put("" + p_str.getId(), tmp);
        boolean res = false;
        if (listener == null) {
            res = p_str.addP2Pdestination(new InetSocketAddress(itmp, port2), useExisting);
        } else {
            CreateConnectionImpl connectionListener = new CreateConnectionImpl(tmp, listener, queue_name, address, port2);
            res = p_str.addP2PdestinationNonBlocking(new InetSocketAddress(itmp, port2), connectionListener, timeout);
        }
        if (!res) {
            long s_id = p_str.getId();
            res = tmp.close(false);
            if (!res) {
                this.rmmLogger.baseError("Failed to close stream after addP2Pdestination faile stream id " + s_id, null, moduleName);
            }
            this.queueHashTable.remove("" + p_str.getId());
            return null;
        }
        return tmp;
    }

    public long getPendingQueueSize() {
        if (this.pTransmitter == null) {
            return 0L;
        }
        return this.pTransmitter.getPendingQueueSize();
    }

    public double getAverageRetransmissionRate() {
        if (this.pTransmitter == null) {
            return 0.0;
        }
        return this.pTransmitter.getAverageRetransmissionRate();
    }

    public String currentStatusLog(boolean writeToLog) {
        block8: {
            try {
                MTopicT t;
                if (this.rmmLogger.getLogLevel() != 2 && writeToLog) {
                    return null;
                }
                StringBuffer stat = new StringBuffer();
                stat.append("_RMM_STATS_\n_RMM_STATS_********* - ").append("1.9.8.19 - 16/03/09").append(" | ").append(this.rmmAddress).append(" - *********************\n");
                stat.append("_RMM_STATS_ EventAnnouncer nRot: ").append(this.eventAnnouncer.nRot).append('\n');
                if (this.pTransmitter != null) {
                    stat.append("_RMM_STATS_ Multicast Pending #: ").append(this.pTransmitter.getPendingQueueSize()).append("\n");
                    stat.append("_RMM_STATS_ PTransmitter status: \n_RMM_STATS_ ").append(this.pTransmitter.getStatusLog()).append('\n');
                }
                EnumArray entries = new EnumArray(this.topicHashTable, false);
                while (entries.hasMoreElements()) {
                    t = (MTopicT)entries.nextElement();
                    if (t == null) continue;
                    stat.append("_RMM_STATS_------------ TopicT: ").append(t.topicName).append(". Stream Id: ").append(t.pStream.getId()).append('\n');
                    stat.append("_RMM_STATS_ Messages: ").append(t.getMsgsSent()).append(". Front: ").append(t.getFrontSeqNum());
                    stat.append(". Trail: ").append(t.getTrailSeqNum()).append(". Pending: ").append(t.getPendingQueueSize());
                    stat.append(". mBuffer: ").append(t.bufferLength).append(". msgStartN: ").append(t.msgStartN).append('\n');
                }
                if (this.unicastPTransmitter != null) {
                    stat.append("_RMM_STATS_ Unicast Pending #: ").append(this.unicastPTransmitter.getPendingQueueSize()).append("\n");
                    stat.append("_RMM_STATS_ UnicastPTransmitter status: \n_RMM_STATS_").append(this.unicastPTransmitter.getStatusLog()).append('\n');
                }
                entries = new EnumArray(this.queueHashTable, false);
                while (entries.hasMoreElements()) {
                    t = (MTopicT)entries.nextElement();
                    if (t == null) continue;
                    stat.append("_RMM_STATS_------------ QueueT: ").append(t.topicName).append(". Stream Id: ").append(t.pStream.getId()).append('\n');
                    stat.append("_RMM_STATS_ Messages: ").append(t.getMsgsSent()).append(". Front: ").append(t.getFrontSeqNum());
                    stat.append(". Pending: ").append(t.getPendingQueueSize()).append(". Quarantine: ").append(t.isQuarantined()).append('\n');
                }
                stat.append("_RMM_STATS_********************************\n");
                if (writeToLog) {
                    this.rmmLogger.maxInfo(stat.toString(), moduleName);
                    break block8;
                }
                return stat.toString();
            }
            catch (Throwable ex) {
                this.rmmLogger.baseError("Exception when collecting Receiver stats; ignoring.", ex, moduleName);
            }
        }
        return null;
    }

    public String getVersion() {
        return "1.9.8.19 - 16/03/09";
    }

    public int getLocalPort() {
        return this.rmmAddress.getPort();
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized boolean setTransmissionRate(int new_rate_Kbps) {
        if (this.pTransmitter == null) {
            return false;
        }
        this.rmmLogger.baseInfo("Setting global rate limit to :" + new_rate_Kbps, moduleName);
        this.pTransmitter.changeTransmissionRate(new_rate_Kbps);
        return true;
    }

    public synchronized boolean stop(boolean soft) {
        MTopicT t;
        this.rmmLogger.baseInfo(String.valueOf(soft ? "Soft " : "Fast ") + "Stopping MTransmitter", moduleName);
        EnumArray entries = new EnumArray(this.topicHashTable, false);
        while (entries.hasMoreElements()) {
            t = (MTopicT)entries.nextElement();
            if (t == null) continue;
            t.close(soft);
        }
        entries = new EnumArray(this.queueHashTable, false);
        while (entries.hasMoreElements()) {
            t = (MTopicT)entries.nextElement();
            if (t == null) continue;
            t.close(soft);
        }
        if (this.unicastPTransmitter != null) {
            this.unicastPTransmitter.stop(soft);
        }
        this.unicastPTransmitter = null;
        if (this.pTransmitter != null) {
            this.pTransmitter.stop(soft);
        }
        this.pTransmitter = null;
        if (this.statusDumper != null) {
            this.statusDumper.removeDumper();
        }
        this.isRunning = false;
        if (this.eventAnnouncer != null) {
            this.rmmLogger.baseInfo("Stoping eventAnnouncer thread", moduleName);
            this.eventAnnouncer.interrupt();
            int i = 0;
            while (!this.eventAnnouncer.threadStopped && i < 10) {
                this.eventAnnouncer.interrupt();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            if (!this.eventAnnouncer.threadStopped) {
                this.rmmLogger.baseError("Failed to properly stop eventAnnouncer thread", null, moduleName);
            }
        }
        if (this.taskMan != null) {
            this.taskMan.close();
        }
        return true;
    }

    public synchronized void setMReceiverStack(MReceiver mReceiver) {
        this.myMReceiver = mReceiver;
        if (this.unicastPTransmitter != null) {
            this.unicastPTransmitter.setPreceiver(mReceiver.getUnicastPReceiver());
        }
    }

    public synchronized PTransmitterIf getUnicastPTransmitter() {
        return this.unicastPTransmitter;
    }

    class StatusDumper
    implements TaskIf {
        private MTransmitter mTrans;
        private long lastTime;
        private long next_time;

        StatusDumper(MTransmitter mtr) {
            this.mTrans = mtr;
            this.lastTime = Clock.getTime();
            this.next_time = this.lastTime + (long)this.mTrans.config.statsPeriod;
            MTransmitter.this.taskMan.addTask(this);
        }

        public void timerExpired(long curTime) {
            try {
                long time = curTime;
                if (time - this.lastTime >= (long)this.mTrans.config.statsPeriod) {
                    this.mTrans.currentStatusLog(true);
                    this.lastTime = time;
                    this.next_time = this.lastTime + (long)this.mTrans.config.statsPeriod;
                }
            }
            catch (Exception ex) {
                this.mTrans.rmmLogger.baseWarn("Status dump: Not initialized yet", null, MTransmitter.moduleName);
            }
            catch (Throwable ex1) {
                this.mTrans.rmmLogger.baseWarn("Status dump: unexpected exception", ex1, MTransmitter.moduleName);
            }
        }

        public void removeDumper() {
            MTransmitter.this.taskMan.removeTask(this);
        }

        public long getNextTime() {
            return this.next_time;
        }
    }

    class EvListener
    implements EventListener {
        MTopicT myTopic;

        EvListener(MTopicT topic) {
            this.myTopic = topic;
        }

        public void onEvent(TEventIf tev) {
            Event ev = new Event(tev);
            MTransmitter.this.eventAnnouncer.addEvent(ev, this.myTopic);
        }
    }
}

