/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.mtl.transmitter;

import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.ptl.ifc.transmitter.BufferRequestListener;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import java.nio.ByteBuffer;

public class NewMTopicT
extends MTopicT {
    private static final String moduleName = "MTL_T";
    public static final byte L_OPEN = 1;
    public static final byte R_OPEN = 2;
    public static final byte LR_OPEN = 3;
    private byte[] packBuffer;
    private byte[] msgBuffer;
    private int bufferMaxSize;
    private int bufferSpaceLeft;
    private int messageId;
    private short nMessages;
    private int msgBufferLen;
    private int messageLength;
    private int messageOffset;
    private byte[] messageBuffer;
    private ByteBuffer mbb;
    private ByteBuffer pbb;

    public NewMTopicT() {
    }

    NewMTopicT(MTransmitter mtr, boolean p2p, String name2, byte[] tag, StreamTIf p_stream, String address) {
        this.mTrans = mtr;
        if (this.mTrans.rmmLogger.isMaxLogLevel()) {
            this.mTrans.rmmLogger.maxInfo("Using new MTL for " + name2, moduleName);
        }
        this.topicName = name2;
        this.pStream = p_stream;
        this.topicId = tag;
        this.tagLen = tag.length;
        this.topicAddress = address;
        this.point2point = p2p;
        this.mtlHeaderSize = 18;
        this.bufferMaxSize = this.mTrans.config.packetSize - mtr.ptlHeaderSize - this.tagLen - this.mtlHeaderSize;
        if (this.bufferMaxSize < 64) {
            this.mTrans.rmmLogger.baseError("No space left for message payload. Buffer size is " + this.bufferMaxSize, null, moduleName);
            this.isOk = false;
        } else {
            this.isOk = true;
            this.bufferSpaceLeft = this.bufferMaxSize;
            this.packBuffer = new byte[this.mtlHeaderSize];
            this.pbb = ByteBuffer.wrap(this.packBuffer);
            this.msgBuffer = new byte[this.bufferMaxSize];
            this.mbb = ByteBuffer.wrap(this.msgBuffer);
            this.pStream.setBufReqListener(new BufferRequestListener(){

                public boolean onRequest() {
                    return NewMTopicT.this.synchBuildAndSubmitMsgs();
                }
            });
            this.pStream.wakeUp();
            this.isClosed = false;
        }
    }

    private void addMessage(byte[] msg, int off, int len) {
        try {
            this.mbb.putShort((short)len);
            this.mbb.put(msg, off, len);
        }
        catch (Exception e2) {
            this.mTrans.rmmLogger.baseError("Failed to write a message", e2, moduleName);
        }
        this.nMessages = (short)(this.nMessages + 1);
        this.msgBufferLen += 2 + len;
        this.bufferSpaceLeft = this.bufferMaxSize - this.msgBufferLen;
    }

    private boolean buildAndSubmitMsgs() {
        this.pStream.setMtlSize(0);
        if (this.nMessages == 0) {
            return false;
        }
        this.pbb.clear();
        try {
            this.pbb.put((byte)0);
            this.pbb.putShort(this.nMessages);
            this.pbb.put((byte)0);
        }
        catch (Exception e2) {
            this.mTrans.rmmLogger.baseError("Failed to write message payload", e2, moduleName);
            return false;
        }
        boolean res = this.pStream.submitPacketData(this.packBuffer, 0, this.pbb.position(), this.msgBuffer, 0, this.msgBufferLen);
        this.nMessages = 0;
        this.bufferSpaceLeft = this.bufferMaxSize;
        this.msgBufferLen = 0;
        this.mbb.clear();
        return res;
    }

    private boolean buildAndSubmitFrag(byte frag_type, int frag_offset, int frag_length) {
        this.pStream.setMtlSize(0);
        this.pbb.clear();
        try {
            this.pbb.put((byte)0);
            this.pbb.putShort((short)1);
            this.pbb.put(frag_type);
            this.pbb.putInt(this.messageId);
            this.pbb.putInt(this.messageLength);
            this.pbb.putInt(frag_offset);
            this.pbb.putShort((short)frag_length);
        }
        catch (Exception e2) {
            this.mTrans.rmmLogger.baseError("Failed to write fragment payload", e2, moduleName);
            return false;
        }
        return this.pStream.submitPacketData(this.packBuffer, 0, this.pbb.position(), this.messageBuffer, this.messageOffset + frag_offset, frag_length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitMessage(byte[] msg, int offset, int msg_length) {
        if (msg == null) {
            this.mTrans.rmmLogger.baseError("submitMessage(): null msg arg!", null, moduleName);
            return false;
        }
        if (offset < 0 || msg_length < 0 || offset + msg_length > msg.length) {
            this.mTrans.rmmLogger.baseError("submitMessage(): invalid offset/length :" + offset + " " + msg_length + " " + msg.length, null, moduleName);
            return false;
        }
        if (!this.preSubmitCheck()) {
            return false;
        }
        byte[] byArray = this.msgBuffer;
        synchronized (this.msgBuffer) {
            ++this.msgCntr;
            if (this.bufferSpaceLeft < msg_length && this.nMessages > 0) {
                this.buildAndSubmitMsgs();
            }
            if (this.bufferSpaceLeft >= msg_length) {
                this.addMessage(msg, offset, msg_length);
                if (this.nMessages >= this.maxMsgs) {
                    this.buildAndSubmitMsgs();
                }
            } else {
                this.messageId = this.pStream.getFrontSeqNum() + 1;
                this.messageLength = msg_length;
                this.messageOffset = offset;
                this.messageBuffer = msg;
                int frag_offset = 0;
                if (!this.buildAndSubmitFrag((byte)2, frag_offset, this.bufferMaxSize)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                frag_offset += this.bufferMaxSize;
                while (true) {
                    if (frag_offset + this.bufferMaxSize >= msg_length) {
                        int remains = msg_length - frag_offset;
                        this.buildAndSubmitFrag((byte)1, frag_offset, remains);
                        break;
                    }
                    this.buildAndSubmitFrag((byte)3, frag_offset, this.bufferMaxSize);
                    frag_offset += this.bufferMaxSize;
                }
            }
            this.pStream.setMtlSize(this.msgBufferLen);
            if (this.msgBufferLen > 0) {
                this.pStream.wakeUp();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (this.msgCntr % 1000L == 0L) {
                Thread.yield();
            }
            return true;
        }
    }

    public boolean submitMessage(byte[] msg) {
        if (msg == null) {
            this.mTrans.rmmLogger.baseError("submitMessage(): null msg arg!", null, moduleName);
            return false;
        }
        return this.submitMessage(msg, 0, msg.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean synchBuildAndSubmitMsgs() {
        byte[] byArray = this.msgBuffer;
        synchronized (this.msgBuffer) {
            boolean ret = this.buildAndSubmitMsgs();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return ret;
        }
    }
}

