/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.util.AckListener;
import com.ibm.rmm.util.RmmAddressIf;
import java.util.LinkedList;

public class AckAnnouncer
extends Thread {
    private static final String moduleName;
    LinkedList events = new LinkedList();
    int exceptionCounter = 0;
    volatile boolean threadStopped = false;
    private boolean goOn = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.rmm.ptl.admin.AckAnnouncer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        moduleName = clazz.toString();
    }

    AckAnnouncer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(AckListener listener, RmmAddressIf reporter, int type, int seq, long streamId) {
        AckEvent event2 = new AckEvent(listener, reporter, type, seq, streamId);
        LinkedList linkedList = this.events;
        synchronized (linkedList) {
            this.events.addLast(event2);
            this.events.notify();
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AdminClient.rmmLogger.baseLog(1, new Object[]{"AckAnnouncer"}, null, moduleName);
        while (this.goOn) {
            try {
                AckEvent event2;
                LinkedList linkedList = this.events;
                synchronized (linkedList) {
                    while (this.events.isEmpty()) {
                        this.events.wait();
                    }
                    event2 = (AckEvent)this.events.removeFirst();
                }
                if (event2 == null || event2.listener == null) continue;
                event2.listener.delayer(event2.type, event2.seq, event2.reporter, event2.streamId);
            }
            catch (Throwable ex) {
                if (this.isInterrupted() || ex instanceof InterruptedException) break;
                AdminClient.rmmLogger.baseError("AckAnnouncer: Exception in thread loop", ex, moduleName);
                ++this.exceptionCounter;
                if (this.exceptionCounter <= 100 && !(ex instanceof Error)) continue;
                AdminClient.rmmLogger.baseError("AckAnnouncer: to many exceptions exsiting...", ex, moduleName);
                AdminClient.rmmLogger.baseLog(416, new Object[]{"AckAnnouncer"}, ex, moduleName);
                break;
            }
        }
        this.threadStopped = true;
        AdminClient.rmmLogger.baseLog(2, new Object[]{"AckAnnouncer"}, null, moduleName);
    }

    private class AckEvent {
        private final AckListener listener;
        private final RmmAddressIf reporter;
        private final int type;
        private final int seq;
        private final long streamId;

        AckEvent(AckListener listener, RmmAddressIf reporter, int type, int seq, long streamId) {
            this.listener = listener;
            this.reporter = reporter;
            this.type = type;
            this.seq = seq;
            this.streamId = streamId;
        }
    }
}

