/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.DataStreamR;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import java.nio.ByteBuffer;

public class AckSessionR {
    private static final String mn = "Admin";
    private static AckSessionR myself;
    private static final int minTimeout = 0;
    private static final int minRetries = 3;
    private static AckSender ackSender;
    private static Object asLock;
    private static int asMax;
    private static int asSize;
    private static AckSessionR[] asArray;
    private static ByteBuffer ackBB;
    private int period;
    private final DataStreamR streamR;
    private int timeout;
    private boolean block = false;
    private StreamRIf streamRIf;
    private int nSkip = 10;
    private int lastHBsent;
    private int numHBsent = 0;
    private long lastHBtime;

    static {
        asLock = new Object();
        asMax = 0;
        asSize = 0;
        ackBB = ByteBuffer.allocate(14);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AckSessionR(StreamRIf streamRIf, int period_millis) {
        myself = this;
        this.streamR = DataStreamR.getDataStream(streamRIf);
        this.streamRIf = streamRIf;
        this.period = period_millis;
        this.timeout = this.calculateTimeout(0);
        Object object = asLock;
        synchronized (object) {
            if (asSize >= asMax) {
                asMax = 64 + 5 * asMax / 4;
                AckSessionR[] tmp = new AckSessionR[asMax];
                int i = 0;
                while (i < asSize) {
                    tmp[i] = asArray[i];
                    ++i;
                }
                asArray = tmp;
            }
            AckSessionR.asArray[AckSessionR.asSize++] = this;
            streamRIf.setAckSessionR(this);
            if (ackSender == null) {
                ackSender = new AckSender();
                ackSender.setName("AckSessionR ackSenderThread");
                ackSender.start();
            } else {
                asLock.notify();
            }
        }
        AdminClient.rmmLogger.baseInfo("_AckSessionR: <init> acks for stream " + streamRIf, mn);
    }

    private void sendHeartbeat() {
        if (this.block) {
            return;
        }
        int curContig = this.streamR.getContiguous() + 1;
        if (curContig != this.lastHBsent || this.nSkip > 9) {
            this.lastHBsent = curContig;
            this.nSkip = 0;
            ackBB.clear();
            ackBB.put((byte)3);
            ackBB.put((byte)0);
            ackBB.putInt(curContig);
            ackBB.putInt(this.timeout);
            ackBB.putInt(this.streamR.getTotPacks());
            this.streamR.sendReportPacket(ackBB.array(), true, false);
            ++this.numHBsent;
            if (this.numHBsent % 1000 == 1) {
                AdminClient.rmmLogger.baseInfo("_AckSessionR: " + this.numHBsent + " acks sent for stream " + this.streamRIf + " , lastSQN reported: " + this.lastHBsent, mn);
            } else if (this.numHBsent % 10 == 1 && AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("_AckSessionR: " + this.numHBsent + " acks sent for stream " + this.streamRIf + " , lastSQN reported: " + this.lastHBsent, mn);
            }
        } else {
            ++this.nSkip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stop() {
        Object object = asLock;
        synchronized (object) {
            int i = 0;
            while (i < asSize) {
                AckSessionR session = asArray[i];
                StreamRIf stream = session.streamRIf;
                AdminClient.rmmLogger.baseInfo("_AckSessionR: Stop acks for stream " + stream, mn);
                ++i;
            }
            asSize = 0;
        }
        if (ackSender != null) {
            AdminClient.rmmLogger.baseInfo("Stoping receiver ack sender thread", mn);
            int i = 0;
            while (!AckSessionR.ackSender.threadStopped && i < 5) {
                ackSender.interrupt();
                Object object2 = asLock;
                synchronized (object2) {
                    asLock.notify();
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            if (!AckSessionR.ackSender.threadStopped) {
                AdminClient.rmmLogger.baseError("Failed to properly stop receiver ack sender thread", null, mn);
            }
            ackSender = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stop(StreamRIf streamRIf) {
        Object object = asLock;
        synchronized (object) {
            int i = 0;
            while (i < asSize) {
                AckSessionR session = asArray[i];
                StreamRIf stream = session.streamRIf;
                if (stream == streamRIf) {
                    AckSessionR.asArray[i] = asArray[--asSize];
                    AdminClient.rmmLogger.baseInfo("_AckSessionR: Stop acks for stream " + streamRIf, mn);
                    break;
                }
                ++i;
            }
        }
    }

    static void newRate(StreamRIf streamRIf, int period) {
        int isNew = 0;
        AckSessionR rhs = streamRIf.getAckSessionR();
        if (rhs == null) {
            rhs = new AckSessionR(streamRIf, period);
            isNew = 1;
        } else if (rhs.period != period) {
            rhs.period = period;
            isNew = 2;
        }
        if (isNew == 1) {
            AdminClient.rmmLogger.baseInfo("_AckSessionR: newRate(" + isNew + ") (" + period + ") for acks for stream " + streamRIf, mn);
        } else if (isNew == 2 && AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("_AckSessionR: newRate(" + isNew + ") (" + period + ") for acks for stream " + streamRIf, mn);
        }
    }

    static void setDurability(StreamRIf streamRIf, int durability) {
        AckSessionR rhs = streamRIf.getAckSessionR();
        if (rhs != null) {
            rhs.timeout = rhs.calculateTimeout(durability);
        }
    }

    static void blockHeartbeat(StreamRIf streamRIf, boolean block) {
        AckSessionR rhs = streamRIf.getAckSessionR();
        if (rhs != null) {
            rhs.block = block;
        }
    }

    private int calculateTimeout(int absolutTimeout) {
        if (absolutTimeout == 0) {
            return 0;
        }
        return Math.max(absolutTimeout, this.period * 3);
    }

    private class AckSender
    extends Thread {
        private final String moduleName;
        int exceptionCounter;
        long curTime;
        long sleepTime;
        long diffTime;
        volatile boolean threadStopped;
        private boolean goOn;
        static /* synthetic */ Class class$0;

        AckSender() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.rmm.ptl.admin.AckSessionR$AckSender");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.moduleName = clazz.toString();
            this.threadStopped = false;
            this.goOn = true;
            this.exceptionCounter = 0;
        }

        public void interrupt() {
            this.goOn = false;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AdminClient.rmmLogger.baseLog(1, new Object[]{"AckSender"}, null, this.moduleName);
            while (this.goOn) {
                try {
                    this.sleepTime = 10000L;
                    this.curTime = Clock.getTime();
                    Object object = asLock;
                    synchronized (object) {
                        int i = 0;
                        while (i < asSize) {
                            AckSessionR session = asArray[i];
                            this.diffTime = session.lastHBtime + (long)session.period - this.curTime;
                            if (this.diffTime <= 0L) {
                                session.sendHeartbeat();
                                session.lastHBtime = this.curTime;
                                this.diffTime = session.period;
                            }
                            if (this.sleepTime > this.diffTime) {
                                this.sleepTime = this.diffTime;
                            }
                            ++i;
                        }
                        asLock.wait(this.sleepTime);
                    }
                }
                catch (Throwable ex) {
                    if (this.isInterrupted() || ex instanceof InterruptedException) break;
                    AdminClient.rmmLogger.baseError("AckSender: Exception in thread loop", ex, this.moduleName);
                    ++this.exceptionCounter;
                    if (this.exceptionCounter <= 100 && !(ex instanceof Error)) continue;
                    AdminClient.rmmLogger.baseError("AckSender: to many exceptions exsiting...", ex, this.moduleName);
                    AdminClient.rmmLogger.baseLog(416, new Object[]{"AckAnnouncer"}, ex, this.moduleName);
                    break;
                }
            }
            this.threadStopped = true;
            AdminClient.rmmLogger.baseLog(2, new Object[]{"AckSender"}, null, this.moduleName);
        }
    }
}

