/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AckAnnouncer;
import com.ibm.rmm.ptl.admin.AckReporter;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.admin.ReceiverAckReport;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.admin.ReportersHeap;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.util.AckListener;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.RmmAddressIf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AckSessionT
implements ReportListener,
TaskIf {
    private static final String mn = "Admin";
    private static AckSessionT myself;
    private static Map activeSeesions;
    private static final int deafultHeartbeatRate = 100;
    private static final int defaultStartupTime = 20000;
    private static final int deafultHeartbeatPeriod = 100;
    private static final int minHeartbeatPeriod = 50;
    private static final int maxHeartbeatPeriod = 5000;
    public static final int RCV_STATUS_INITIALIZED = -1;
    public static final int RCV_STATUS_LISTENING = 0;
    public static final int RCV_STATUS_ACTIVE = 1;
    private static int totalReports;
    private static FullBufferListener fullBufferListener;
    private static AckAnnouncer announcerThread;
    private static int heartbeatRate;
    private static int heartbeatPeriod;
    private static long heartbeatLastTime;
    private static int startupTime;
    private static ByteBuffer hbPeriodOption;
    public DataStreamT dataStreamT;
    private Set allowedReceivers;
    private Set rejectedReceivers;
    private AckListener ackListener;
    private ReportersHeap reportersHeap = new ReportersHeap();
    private Map reporters = new HashMap();
    private boolean afterStartupPeriod;
    public long next_time;

    static {
        activeSeesions = Collections.synchronizedMap(new HashMap());
        heartbeatRate = 100;
        heartbeatPeriod = 100;
        heartbeatLastTime = 0L;
        startupTime = 20000;
        hbPeriodOption = ByteBuffer.allocate(4);
    }

    public AckSessionT(StreamTIf streamT, Set allowed, AckListener l) {
        this.init(streamT);
        this.ackListener = l;
        this.setAllowedReceivers(allowed);
        this.afterStartupPeriod = true;
        this.registerMe();
    }

    public AckSessionT(StreamTIf streamT) {
        this.init(streamT);
        this.registerMe();
    }

    private void init(StreamTIf streamT) {
        myself = this;
        if (fullBufferListener == null) {
            fullBufferListener = AckSessionT.createFullBufferListener();
            AdminNode an = AdminNode.getInstance();
            an.setFullBufferListener(fullBufferListener);
        }
        if (announcerThread == null) {
            announcerThread = new AckAnnouncer();
            announcerThread.setName("AckSessionT announcerThread");
            announcerThread.start();
        }
        this.dataStreamT = DataStreamT.getDataStream(streamT);
        this.dataStreamT.addReportListener(this, 3);
        if (heartbeatLastTime == 0L) {
            heartbeatLastTime = Clock.getTime();
        }
        streamT.setRedLine(streamT.getFrontSeqNum());
        if (AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("Creating AckSessionT. Initial RedLine: " + streamT.getFrontSeqNum() + ". Stream: " + streamT.getId(), mn);
        }
        this.createStartupPeriodFinishedEvent(startupTime);
        AdminClient.rmmLogger.baseInfo("AckSessionT.<init> stream=" + streamT.getId() + " ack rate=" + heartbeatPeriod, mn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMe() {
        Map map = activeSeesions;
        synchronized (map) {
            activeSeesions.put(this.dataStreamT, this);
            hbPeriodOption.clear();
            hbPeriodOption.putInt(heartbeatPeriod);
            this.sendNewHeartbeatRateMessage();
        }
    }

    private void addEvent(AckListener listener, RmmAddressIf reporter, int type, int seq, long streamId) {
        if (listener == null || announcerThread == null) {
            AdminClient.rmmLogger.baseInfo("AckSessionT.addEvent: either the listener or the announcerThread are null!", mn);
        } else {
            announcerThread.addEvent(listener, reporter, type, seq, streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.dataStreamT.removeReportListener(this, 3);
        this.ackListener = null;
        this.reporters.clear();
        Map map = activeSeesions;
        synchronized (map) {
            activeSeesions.remove(this.dataStreamT);
        }
        AdminClient.rmmLogger.baseInfo("Closing transmitter ack session for stream " + this.dataStreamT.getStreamId() + " ack rate=" + heartbeatPeriod, mn);
    }

    public static void stop() {
        if (announcerThread != null) {
            AdminClient.rmmLogger.baseInfo("Stoping transmitter ack announcer thread", mn);
            announcerThread.interrupt();
            int i = 0;
            while (!AckSessionT.announcerThread.threadStopped && i < 5) {
                announcerThread.interrupt();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            if (!AckSessionT.announcerThread.threadStopped) {
                AdminClient.rmmLogger.baseError("Failed to properly stop transmitter ack announcer thread", null, mn);
            }
            announcerThread = null;
        }
    }

    public void setAckListener(AckListener listener) {
        this.ackListener = listener;
    }

    public synchronized boolean setAllowedReceivers(Set receivers) {
        if (receivers == null) {
            this.allowedReceivers = null;
            return true;
        }
        if (this.allowedReceivers == null) {
            this.allowedReceivers = new HashSet();
        } else {
            this.allowedReceivers.clear();
        }
        if (this.rejectedReceivers == null) {
            this.rejectedReceivers = new HashSet();
        }
        Iterator<Object> i = receivers.iterator();
        while (i.hasNext()) {
            this.addReceiver((RmmAddressIf)i.next());
        }
        ArrayList<RmmAddressIf> toRemove = new ArrayList<RmmAddressIf>();
        i = this.reporters.keySet().iterator();
        while (i.hasNext()) {
            RmmAddressIf reporter = (RmmAddressIf)i.next();
            if (this.allowedReceivers.contains(reporter)) continue;
            toRemove.add(reporter);
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeReceiver((RmmAddressIf)i.next());
        }
        this.afterStartupPeriod = true;
        return true;
    }

    public synchronized boolean removeReceiver(RmmAddressIf receiver) {
        Reporter reporter;
        if (receiver == null) {
            AdminClient.rmmLogger.baseWarn("RmmAddress is null" + receiver, null, mn);
            return false;
        }
        if (this.allowedReceivers == null) {
            AdminClient.rmmLogger.baseWarn("Can not remove receiver " + receiver + "Not in an allowed receivers mode", null, mn);
            return false;
        }
        boolean heapWasEmpty = this.reportersHeap.isEmpty();
        int oldContig = 0;
        if (!heapWasEmpty) {
            oldContig = this.reportersHeap.first().getContiguous();
        }
        if ((reporter = Reporter.getReporter(receiver, true)) == null) {
            AdminClient.rmmLogger.baseWarn("Not a valid RmmAddress " + receiver, null, mn);
            return false;
        }
        this.allowedReceivers.remove(reporter);
        AckReporter acker = (AckReporter)this.reporters.remove(reporter);
        if (acker == null) {
            AdminClient.rmmLogger.baseWarn("removeReceiver: receiver not in the heap: " + receiver + " Stream: " + this.dataStreamT.getStreamId() + " _HeapSize_: " + this.reporters.size(), null, mn);
            return false;
        }
        this.reportersHeap.remove(acker);
        AdminClient.rmmLogger.baseInfo("removeReceiver: receiver: " + acker + " Stream: " + this.dataStreamT.getStreamId() + " _HeapSize_: " + this.reporters.size(), mn);
        if (this.ackListener == null) {
            return true;
        }
        if (this.reportersHeap.isEmpty()) {
            int frontsq = this.dataStreamT.getFrontSeqNum();
            int redline = this.dataStreamT.getRedLine();
            if (redline - frontsq < 0) {
                AdminClient.rmmLogger.baseInfo("removeReceiver: No receivers! advancing redLine (" + redline + ") to frontSeqNum (" + frontsq + ") Stream: " + this.dataStreamT.getStreamId(), mn);
                this.dataStreamT.setRedLine(frontsq);
                this.addEvent(this.ackListener, reporter, 2, frontsq, this.dataStreamT.getStreamId());
            }
        } else {
            int newContig = this.reportersHeap.first().getContiguous();
            if (oldContig != newContig) {
                this.dataStreamT.setRedLine(newContig);
                this.addEvent(this.ackListener, this.reportersHeap.first().getReporter(), 2, newContig, this.dataStreamT.getStreamId());
            }
        }
        return true;
    }

    public synchronized boolean addReceiver(RmmAddressIf receiver) {
        Reporter reporter;
        if (receiver == null) {
            AdminClient.rmmLogger.baseWarn("RmmAddress is null" + receiver, null, mn);
            return false;
        }
        if (this.allowedReceivers == null) {
            this.allowedReceivers = new HashSet();
        }
        if (this.rejectedReceivers == null) {
            this.rejectedReceivers = new HashSet();
        }
        if ((reporter = Reporter.getReporter(receiver, true)) == null) {
            AdminClient.rmmLogger.baseWarn("Not a valid RmmAddress " + receiver, null, mn);
            return false;
        }
        boolean heapWasEmpty = this.reportersHeap.isEmpty();
        int oldContig = 0;
        if (!heapWasEmpty) {
            oldContig = this.reportersHeap.first().getContiguous();
        }
        this.allowedReceivers.add(reporter);
        this.rejectedReceivers.remove(reporter);
        AckReporter acker = (AckReporter)this.reporters.get(reporter);
        if (acker != null) {
            AdminClient.rmmLogger.baseWarn("Receiver already at the heap. " + receiver, null, mn);
            return false;
        }
        acker = new AckReporter(reporter);
        this.reporters.put(reporter, acker);
        acker.setContiguous(this.dataStreamT.getPossibleJoin());
        acker.setTimeout(0);
        this.reportersHeap.add(acker);
        AdminClient.rmmLogger.baseInfo("addReceiver: receiver: " + acker + " Stream: " + this.dataStreamT.getStreamId() + " _HeapSize_: " + this.reporters.size(), mn);
        this.afterStartupPeriod = true;
        int newContig = this.reportersHeap.first().getContiguous();
        if (heapWasEmpty || oldContig != newContig) {
            this.dataStreamT.setRedLine(newContig);
            this.addEvent(this.ackListener, this.reportersHeap.first().getReporter(), 2, newContig, this.dataStreamT.getStreamId());
        }
        return true;
    }

    public List getHeap() {
        return this.reportersHeap.getHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onReport(Report report, Reporter reporter) {
        boolean isNew;
        ReceiverAckReport rhr = null;
        try {
            rhr = (ReceiverAckReport)report;
        }
        catch (ClassCastException e2) {
            AdminClient.rmmLogger.baseWarn("Failed to down cast report", e2, mn);
            return;
        }
        int seq = rhr.getContiguous();
        int to = rhr.getTimeout();
        int tp = rhr.getTotPacks();
        AckReporter acker = (AckReporter)this.reporters.get(reporter);
        boolean bl = isNew = acker == null;
        if (this.allowedReceivers != null && isNew) {
            if (this.rejectedReceivers == null) {
                this.rejectedReceivers = new HashSet();
            }
            if (!this.rejectedReceivers.contains(reporter)) {
                this.rejectedReceivers.add(reporter);
                if (AdminClient.rmmLogger.isMaxLogLevel()) {
                    AdminClient.rmmLogger.maxWarn("Receive ack from receiver not in my list (now added to rejected list): " + reporter, null, mn);
                }
            }
            return;
        }
        if (isNew) {
            int tmp = this.dataStreamT.getPossibleJoin();
            if (seq - tmp < 0) {
                seq = tmp;
            }
            acker = new AckReporter(reporter);
            this.reporters.put(reporter, acker);
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxWarn("Receive ack from new receiver: " + reporter, null, mn);
            }
        }
        int oldContig = 0;
        boolean heapChanged = this.reportersHeap.isEmpty();
        if (!heapChanged) {
            oldContig = this.reportersHeap.first().getContiguous();
        }
        int oldseq = acker.getContiguous();
        int oldStatus = acker.getStatus();
        acker.setTimeout(to);
        if (oldStatus == -1) {
            acker.setStatus(0);
            this.addEvent(this.ackListener, reporter, 0, seq, this.dataStreamT.getStreamId());
        }
        if (oldStatus != 1 && tp > 0) {
            acker.setStatus(1);
            this.addEvent(this.ackListener, reporter, 1, seq, this.dataStreamT.getStreamId());
        }
        int newStatus = acker.getStatus();
        if (isNew) {
            acker.setContiguous(seq);
            this.reportersHeap.add(acker);
            AdminClient.rmmLogger.baseInfo("onReport: receiver added to heap: " + acker + " Stream: " + this.dataStreamT.getStreamId() + " _HeapSize_: " + this.reporters.size(), mn);
        } else if (newStatus == 1 && seq - oldseq > 0) {
            acker.setContiguous(seq);
            this.reportersHeap.update(acker);
        }
        int newContig = this.reportersHeap.first().getContiguous();
        if (!heapChanged) {
            boolean bl2 = heapChanged = oldContig != newContig;
        }
        if (heapChanged) {
            if (this.afterStartupPeriod) {
                this.dataStreamT.setRedLine(newContig);
            }
            this.addEvent(this.ackListener, this.reportersHeap.first().getReporter(), 2, newContig, this.dataStreamT.getStreamId());
        }
        totalReports = newStatus == 1 && seq == oldseq ? (totalReports += 10) : ++totalReports;
        if (totalReports > 5 * heartbeatRate) {
            long elapsedTime = Clock.getTime() - heartbeatLastTime;
            long change = elapsedTime == 0L ? 200L : 500000L / elapsedTime;
            change = 100L + (change - 100L) / 2L;
            change = Math.max(85L, Math.min(145L, change));
            int newhbp = (int)change * heartbeatPeriod / 100;
            if (100 * Math.abs((newhbp = Math.max(50, Math.min(5000, newhbp))) - heartbeatPeriod) / heartbeatPeriod > 10) {
                heartbeatPeriod = newhbp;
                Map map = activeSeesions;
                synchronized (map) {
                    hbPeriodOption.clear();
                    hbPeriodOption.putInt(heartbeatPeriod);
                    Iterator i = activeSeesions.values().iterator();
                    while (i.hasNext()) {
                        AckSessionT ths = (AckSessionT)i.next();
                        ths.sendNewHeartbeatRateMessage();
                    }
                }
                AdminClient.rmmLogger.baseInfo("heartbeatPeriod changed by " + (change - 100L) + "% to " + heartbeatPeriod, mn);
            }
            heartbeatLastTime += elapsedTime;
            totalReports = 0;
        }
    }

    int cleanFullBuffer() {
        AckReporter lowest_reporter;
        int n_erased = 0;
        if (this.reportersHeap.isEmpty()) {
            int frontsq = this.dataStreamT.getFrontSeqNum();
            int redline = this.dataStreamT.getRedLine();
            if (redline - frontsq < 0) {
                this.dataStreamT.setRedLine(frontsq);
                AdminClient.rmmLogger.baseInfo("cleanFullBuffer: No receivers! advancing redLine (" + redline + ") to frontSeqNum (" + frontsq + ") Stream: " + this.dataStreamT.getStreamId(), mn);
            }
        }
        if ((lowest_reporter = this.reportersHeap.first()) == null) {
            n_erased = this.cleanBuffer();
        } else if (lowest_reporter.getTimeout() != 0L && Clock.getTime() > lowest_reporter.getTimeout()) {
            this.reportersHeap.remove(lowest_reporter);
            AdminClient.rmmLogger.baseInfo("cleanFullBuffer: receiver: " + lowest_reporter + " Stream: " + this.dataStreamT.getStreamId() + " _HeapSize_: " + this.reporters.size(), mn);
            AckReporter removed = (AckReporter)this.reporters.remove(lowest_reporter.getReporter());
            n_erased = this.cleanBuffer();
            AdminClient.rmmLogger.baseWarn("TransmitterHeartbeatSession:cleanFullBuffer  Remove reporter " + removed + " because no buffer left", null, mn);
        } else {
            n_erased = this.cleanBuffer();
        }
        return n_erased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanBuffer() {
        AckReporter lowest_reporter;
        if (!this.afterStartupPeriod) {
            return 0;
        }
        int n_erased = 0;
        int contig = -1;
        AckSessionT ackSessionT = this;
        synchronized (ackSessionT) {
            lowest_reporter = this.reportersHeap.first();
            if (lowest_reporter != null) {
                contig = lowest_reporter.getContiguous();
            }
        }
        if (lowest_reporter == null) {
            n_erased = this.dataStreamT.cleanBuffer();
            AdminClient.rmmLogger.baseInfo("TransmitterHeartbeatSession:cleanBuffer  no receivers - cleaning the buffer erasing " + n_erased + " packets", mn);
        } else {
            n_erased = this.dataStreamT.cleanBuffer(contig);
        }
        return n_erased;
    }

    private void sendNewHeartbeatRateMessage() {
        this.dataStreamT.setControlOption((byte)1, hbPeriodOption.array());
    }

    public void timerExpired(long curTime) {
        this.afterStartupPeriod = true;
        AdminClient.taskManT.removeTask(this);
    }

    public long getNextTime() {
        return this.next_time;
    }

    private void createStartupPeriodFinishedEvent(int startup_millis) {
        this.next_time = Clock.getTime() + (long)startup_millis;
        AdminClient.taskManT.addTask(this);
    }

    static FullBufferListener createFullBufferListener() {
        return new FullBufferListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFullBuffer(int n_packets) {
                int n_erased = 1;
                int total_erased = 0;
                Map map = activeSeesions;
                synchronized (map) {
                    while (total_erased < n_packets && n_erased > 0) {
                        Iterator i = activeSeesions.values().iterator();
                        n_erased = 0;
                        while (i.hasNext()) {
                            AckSessionT ths = (AckSessionT)i.next();
                            n_erased += ths.cleanFullBuffer();
                        }
                        total_erased += n_erased;
                    }
                }
            }
        };
    }

    public int getHeartbeatRate() {
        return heartbeatRate;
    }

    public int getHeartbeatPeriod() {
        return heartbeatPeriod;
    }

    public String getHeapDump() {
        return this.reportersHeap.toString();
    }

    public Set getAllowedReceivers() {
        return this.allowedReceivers;
    }

    public String getFirstReporter() {
        if (this.reportersHeap.isEmpty()) {
            return null;
        }
        return this.reportersHeap.dumpReporter(1);
    }

    public int getNumReceivers() {
        return this.reporters.size();
    }
}

