/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AckSessionR;
import com.ibm.rmm.ptl.admin.AckSessionT;
import com.ibm.rmm.ptl.admin.CatalogBook;
import com.ibm.rmm.ptl.admin.CongestionControl;
import com.ibm.rmm.ptl.admin.ConstantRatePolicy;
import com.ibm.rmm.ptl.admin.ConstantRateReceiver;
import com.ibm.rmm.ptl.admin.DataStreamR;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.admin.ServerTcpChannel;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.receiver.REventIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.ifc.util.EventIf;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.StackTracer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class AdminNode {
    private static final String mn = "Admin";
    private static AdminNode myself;
    private PTransmitterIf transmitter;
    private PReceiverIf receiver;
    private ServerTcpChannel unicastServerChannel;
    private ConstantRateReceiver constantRateReceiver;
    private AdminLayerListener adminLayerListener;
    private boolean catalogIsActive = false;
    private static boolean jmxSupport;

    static {
        jmxSupport = false;
    }

    private AdminNode() {
    }

    private static void init() {
        if (myself == null) {
            myself = new AdminNode();
        }
    }

    public static AdminNode getInstance() {
        if (myself == null) {
            AdminNode.init();
        }
        return myself;
    }

    public static AdminNode getInstance(PTransmitterIf t) {
        if (myself == null) {
            AdminNode.init();
        }
        if (AdminNode.myself.transmitter != null) {
            AdminClient.rmmLogger.baseWarn("PTransmitter already set at this admin node", null, mn);
        }
        AdminNode.myself.transmitter = t;
        myself.initDataStreamsT();
        return myself;
    }

    public static AdminNode getInstance(PReceiverIf r) {
        if (myself == null) {
            AdminNode.init();
        }
        if (AdminNode.myself.receiver != null) {
            AdminClient.rmmLogger.baseWarn("PReceiver already set at this admin node", null, mn);
        }
        AdminNode.myself.receiver = r;
        return myself;
    }

    public void stop() {
        DataStreamR.removeDataStreams();
        AckSessionR.stop();
        AckSessionT.stop();
        CongestionControl.stop();
        ConstantRatePolicy.stop();
        Reporter.close();
        if (this.constantRateReceiver != null) {
            this.constantRateReceiver.stop();
        }
        if (this.unicastServerChannel != null) {
            this.unicastServerChannel.close();
        }
    }

    private void initDataStreamsT() {
        if (!DataStreamT.getDataStreams().isEmpty()) {
            AdminClient.rmmLogger.baseWarn("Initialization warning: Admin's streams table is not empty", null, mn);
        }
        if (this.transmitter == null) {
            return;
        }
        Enumeration i = this.transmitter.listStreams();
        while (i.hasMoreElements()) {
            StreamTIf stream = (StreamTIf)i.nextElement();
            if (stream == null) continue;
            DataStreamT.getDataStream(stream);
        }
    }

    public void startCongestionControl(StreamTIf streamT, int max_rate) {
        new CongestionControl(streamT, max_rate);
    }

    public void stopCongestionControl(StreamTIf streamT) {
        CongestionControl.stop(streamT);
    }

    public void startConstantRatePolicy(StreamTIf streamT, int loss_rate_threshold) {
        new ConstantRatePolicy(streamT, loss_rate_threshold);
    }

    public void stopConstantRatePolicy(StreamTIf streamT) {
        ConstantRatePolicy.stop(streamT);
    }

    public void setReceiverDurability(StreamRIf streamR, int durability_millis) {
        AckSessionR.setDurability(streamR, durability_millis);
    }

    public void blockReceiverHeartbeat(StreamRIf streamR, boolean block) {
        AckSessionR.blockHeartbeat(streamR, block);
    }

    public void stopReceiverHeartbeat(StreamRIf streamR) {
        AckSessionR.stop(streamR);
    }

    public void startAckedDelivery(StreamTIf streamT) {
        new AckSessionT(streamT);
    }

    void setFullBufferListener(FullBufferListener listener) {
        if (this.transmitter == null) {
            AdminClient.rmmLogger.baseError("Can not register FullBufferListener - transmitter is null", null, mn);
            return;
        }
    }

    public AdminLayerListener getAdminLayerListener() {
        if (this.adminLayerListener == null) {
            this.adminLayerListener = this.createAdminListener();
        }
        return this.adminLayerListener;
    }

    public void setJmxSupport(boolean active) {
        jmxSupport = active;
    }

    public static boolean isJmxSupport() {
        return jmxSupport;
    }

    public void enableCatalog(boolean active) {
        this.catalogIsActive = active;
    }

    public boolean isCatalogEnabled() {
        return this.catalogIsActive;
    }

    public void registerInterest(StreamSelector matcher) {
        if (this.catalogIsActive) {
            CatalogBook.registerInterest(matcher);
        }
    }

    public void initServerChannel() {
        if (this.unicastServerChannel != null) {
            AdminClient.rmmLogger.baseWarn("Unicast channel already open", new StackTracer(), mn);
        } else {
            this.unicastServerChannel = new ServerTcpChannel(AdminClient.rmmAddress.getServerSocket());
        }
    }

    public void addReportListener(ReportListener listener, int report_type) {
        if (this.unicastServerChannel != null) {
            this.unicastServerChannel.addReportListener(listener, report_type);
        }
    }

    public void removeReportListener(ReportListener listener, int report_type) {
        if (this.unicastServerChannel != null) {
            this.unicastServerChannel.removeReportListener(listener, report_type);
        }
    }

    private AdminLayerListener createAdminListener() {
        return new AdminLayerListener(){

            public void onEvent(EventIf eIf) {
                try {
                    REventIf e2 = (REventIf)eIf;
                    if (e2.getType() == 10) {
                        DataStreamR.getDataStream(e2.getStream());
                    } else if (e2.getType() == 6) {
                        DataStreamR.removeDataStream(e2.getStream());
                    }
                }
                catch (ClassCastException ex) {
                    AdminClient.rmmLogger.baseError("failed to down cast from EventIf to PEventIf ", ex, AdminNode.mn);
                }
            }
        };
    }

    void joinMulticastGroup(String address) {
        if (this.receiver == null) {
            AdminClient.rmmLogger.baseError("Receiver is null, can not join to =" + address, null, mn);
        } else {
            InetAddress itmp = null;
            try {
                itmp = InetAddress.getByName(address);
            }
            catch (UnknownHostException e2) {
                AdminClient.rmmLogger.baseLog(412, new Object[]{address}, e2, mn);
                return;
            }
            if (itmp.getHostAddress().equals("127.0.0.1")) {
                AdminClient.rmmLogger.baseWarn("Multicast address is 127.0.0.1. No Join needed", null, mn);
                return;
            }
            if (itmp != null && !itmp.isMulticastAddress()) {
                AdminClient.rmmLogger.baseBadParam("Multicast Inet Address", itmp.toString(), new StackTracer(), mn);
                AdminClient.rmmLogger.baseBadParam("MulticastAddress", address, new StackTracer(), mn);
                return;
            }
            this.receiver.joinMulticastGroup(itmp, -1);
        }
    }

    void leaveMulticastGroup(String address) {
        if (this.receiver == null) {
            AdminClient.rmmLogger.baseWarn("Receiver is null, can not leave to =" + address, null, mn);
        } else {
            InetAddress itmp = null;
            try {
                itmp = InetAddress.getByName(address);
            }
            catch (UnknownHostException e2) {
                AdminClient.rmmLogger.baseLog(412, new Object[]{address}, e2, mn);
                return;
            }
            if (itmp != null && !itmp.isMulticastAddress()) {
                AdminClient.rmmLogger.baseBadParam("MulticastAddress", address, new StackTracer(), mn);
                return;
            }
            this.receiver.leaveMulticastGroup(itmp, -1);
            AdminClient.rmmLogger.baseInfo("Leave Multicast Group " + address, mn);
        }
    }

    public StreamTIf findStreamT(byte[] tag) {
        if (this.transmitter == null) {
            AdminClient.rmmLogger.baseError("Transmitter is null, can not find stream with tag=" + tag, null, mn);
            return null;
        }
        return this.transmitter.getStream(tag);
    }

    public StreamRIf findStreamR(byte[] tag, InetAddress source, int port2) {
        if (this.receiver == null) {
            AdminClient.rmmLogger.baseError("Receiver is null, can not find stream with tag=" + tag + " source=" + source + " port=" + port2, null, mn);
            return null;
        }
        return this.receiver.getStream(tag, source, port2);
    }

    StreamRIf findStreamR(long id) {
        if (this.receiver == null) {
            AdminClient.rmmLogger.baseError("Receiver is null, can not find stream " + id, null, mn);
            return null;
        }
        return this.receiver.getStream(id);
    }
}

