/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.admin.CatalogEntry;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.receiver.StreamSelector;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CatalogBook {
    private static final String mn = "Admin";
    private static final CatalogBook myself;
    private static Set interests;
    private static Map book;

    static {
        interests = Collections.synchronizedSet(new HashSet());
        book = Collections.synchronizedMap(new HashMap());
        myself = new CatalogBook();
    }

    public static synchronized void add(Reporter reporter, CatalogEntry ce) {
        HashMap<String, CatalogEntry> topicEntries = (HashMap<String, CatalogEntry>)book.get(reporter);
        if (topicEntries == null) {
            topicEntries = new HashMap<String, CatalogEntry>();
            book.put(reporter, topicEntries);
        }
        topicEntries.put(ce.name, ce);
        CatalogBook.bookChanged(reporter, ce);
    }

    public static synchronized void remove(Reporter reporter, CatalogEntry ce) {
        Map topicEntries = (Map)book.get(reporter);
        CatalogEntry toRemove = null;
        if (topicEntries != null && ce != null) {
            toRemove = (CatalogEntry)topicEntries.remove(ce.name);
        }
        if (toRemove != null && AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("Removed CatalogEntry " + ce + " for reporter " + reporter, mn);
        }
    }

    public static synchronized void removeEntriesByReporter(Reporter reporter) {
        book.remove(reporter);
    }

    public static synchronized void updateStateForReporter(Reporter reporter, Collection entries) {
        CatalogBook.removeEntriesByReporter(reporter);
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            CatalogEntry ce = (CatalogEntry)i.next();
            CatalogBook.add(reporter, ce);
        }
    }

    public static synchronized Collection getEntriesByReporter(Reporter reporter) {
        return (Collection)book.get(reporter);
    }

    static synchronized void registerInterest(StreamSelector selector) {
        if (selector == null) {
            AdminClient.rmmLogger.baseError("CatalogBook:registerInterest Selector is null", new Throwable(), mn);
            return;
        }
        interests.add(selector);
        Iterator i = book.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            Reporter reporter = (Reporter)me.getKey();
            if (reporter == null) {
                AdminClient.rmmLogger.baseError("CatalogBook:registerInterest  - data inconsisency - reporter is null", new Throwable(), mn);
                continue;
            }
            Map topicEntries = (Map)me.getValue();
            Iterator j = topicEntries.values().iterator();
            while (j.hasNext()) {
                CatalogEntry ce = (CatalogEntry)j.next();
                byte[] tag = null;
                try {
                    tag = Sutils.stringToBytes(ce.name);
                }
                catch (UnsupportedEncodingException e2) {
                    e2.printStackTrace();
                }
                if (!selector.acceptStream(tag, tag.length, ce.id, reporter.getInetAddress(), reporter.getPort())) continue;
                AdminNode.getInstance().joinMulticastGroup(ce.address);
            }
        }
    }

    private static synchronized void bookChanged(Reporter reporter, CatalogEntry ce) {
        if (reporter == null) {
            AdminClient.rmmLogger.baseError("CatalogBook:bookChanged - inconsistency data - reporter is null", new Exception(), mn);
            return;
        }
        Iterator i = interests.iterator();
        while (i.hasNext()) {
            StreamSelector selector = (StreamSelector)i.next();
            if (selector == null) {
                AdminClient.rmmLogger.baseError("CatalogBook:bookChanged inconsistency data selector is null", new Exception(), mn);
                continue;
            }
            byte[] tag = null;
            try {
                tag = Sutils.stringToBytes(ce.name);
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            if (!selector.acceptStream(tag, tag.length, ce.id, reporter.getInetAddress(), reporter.getPort())) continue;
            AdminNode.getInstance().joinMulticastGroup(ce.address);
            return;
        }
    }
}

