/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.admin.NackListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CongestionControl
implements NackListener {
    private static final String mn = "Admin";
    private static CongestionControl myself;
    private static Map activeSeesions;
    private static TaskIf calculationLoop;
    private static final int rtt = 500;
    private final DataStreamT dataStream;
    private final float lowerLossRateTreshold = 0.001f;
    private final float upperLossRateTreshold = 0.01f;
    private final float bandPassFilter = 0.075f;
    private final int minRate = 1000;
    private final float slowStartConst = 1.5f;
    private final float adaptiveConst = 0.02f;
    private final int maxRate;
    private int ssTresh;
    private int nextRate = 1000;
    private float nacks = 0.0f;
    private float transRate = 0.0f;
    private float lossRate = 0.0f;
    private int counter = 0;

    static {
        activeSeesions = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CongestionControl(StreamTIf streamT, int max_rate) {
        myself = this;
        this.dataStream = DataStreamT.getDataStream(streamT);
        this.maxRate = max_rate;
        this.ssTresh = this.maxRate / 2;
        Map map = activeSeesions;
        synchronized (map) {
            if (activeSeesions.get(this.dataStream) != null) {
                return;
            }
            activeSeesions.put(this.dataStream, this);
        }
        this.dataStream.addNackListener(this);
        if (calculationLoop == null) {
            calculationLoop = this.initCalculationLoop();
        }
    }

    private TaskIf initCalculationLoop() {
        CalculationLoop task = new CalculationLoop(500L);
        AdminClient.taskManT.addTask(task);
        return task;
    }

    static void stop() {
        LinkedList tmp = new LinkedList(activeSeesions.keySet());
        Iterator i = tmp.iterator();
        while (i.hasNext()) {
            CongestionControl.stopStream((DataStreamT)i.next());
        }
    }

    static void stop(StreamTIf streamT) {
        DataStreamT data_stream = DataStreamT.getDataStream(streamT);
        CongestionControl.stopStream(data_stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStream(DataStreamT data_stream) {
        Map map = activeSeesions;
        synchronized (map) {
            CongestionControl cc = (CongestionControl)activeSeesions.get(data_stream);
            if (cc != null) {
                data_stream.removeNackListener(cc);
            }
            activeSeesions.remove(data_stream);
            if (activeSeesions.isEmpty() && calculationLoop != null) {
                AdminClient.taskManT.removeTask(calculationLoop);
            }
        }
    }

    public void onNack(int quantity, long ts, Reporter reporter) {
        this.nacks += (float)quantity;
    }

    private void calculateNextRate() {
        this.transRate = this.dataStream.getTransmissionRate();
        float loss_rate = this.transRate == 0.0f && this.nacks == 0.0f ? 0.0f : (this.transRate == 0.0f && this.nacks != 0.0f ? 1.0f : this.nacks / this.transRate);
        this.lossRate = 0.075f * this.lossRate + 0.925f * loss_rate;
        if (this.lossRate < 0.001f) {
            if (this.nextRate >= this.maxRate) {
                return;
            }
            this.nextRate = this.nextRate < this.ssTresh ? (1.5f * (float)this.nextRate > (float)this.ssTresh ? this.ssTresh : Math.max((int)(1.5f * (float)this.nextRate), this.nextRate + 1)) : (int)((float)this.nextRate + Math.max(0.02f * (float)this.nextRate, 1.0f));
        } else if (this.lossRate > 0.01f) {
            this.ssTresh = Math.max(1000, (this.ssTresh + this.nextRate) / 2);
            this.nextRate = Math.max(1000, this.nextRate / 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRates() {
        Map map = activeSeesions;
        synchronized (map) {
            Iterator i = activeSeesions.values().iterator();
            while (i.hasNext()) {
                CongestionControl.updateRates((CongestionControl)i.next());
            }
        }
    }

    private static void updateRates(CongestionControl cc) {
        ++cc.counter;
        cc.calculateNextRate();
        cc.dataStream.setTransmissionRate(cc.nextRate);
        if (cc.counter % 5 == 0 || cc.nacks > 0.0f) {
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("CongestionControl::updateRates nextR=" + cc.nextRate + " ssTresh=" + cc.ssTresh + " transRate=" + cc.transRate + " nacks=" + cc.nacks + " lossRate=" + cc.lossRate, mn);
            }
            cc.counter = 0;
        }
        cc.nacks = 0.0f;
    }

    public class CalculationLoop
    implements TaskIf {
        private long period;
        private long next_time;

        CalculationLoop(long period) {
            this.period = period;
            this.next_time = 0L;
        }

        public void timerExpired(long curTime) {
            CongestionControl.updateRates();
            this.next_time = curTime + this.period;
        }

        public long getNextTime() {
            return this.next_time;
        }
    }
}

