/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.DataStreamT;
import com.ibm.rmm.ptl.admin.NackListener;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConstantRatePolicy
implements NackListener {
    private static final String mn = "Admin";
    private static ConstantRatePolicy myself;
    private final float bandPassFilter = 0.075f;
    private static Map activeSeesions;
    private Map reporters = new HashMap();
    private List tmpList = new LinkedList();
    private static TaskIf calculationLoop;
    private static final int deltaT = 1000;
    private final int cleanUpThreshold = 1;
    private final int silencePeriod = 10;
    private final int retries = 3;
    private final int blockingPeriod = 10;
    private DataStreamT dataStream;
    private int cryingBabyThreshold;

    static {
        activeSeesions = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConstantRatePolicy(StreamTIf streamT, int threshold) {
        this.dataStream = DataStreamT.getDataStream(streamT);
        this.cryingBabyThreshold = threshold;
        Map map = activeSeesions;
        synchronized (map) {
            if (activeSeesions.get(this.dataStream) != null) {
                return;
            }
            activeSeesions.put(this.dataStream, this);
        }
        if (this.cryingBabyThreshold < 2) {
            AdminClient.rmmLogger.baseWarn("Can not set the loss rate threshold below 2%. You ask to set it to " + threshold + "%." + " I am setting it to 2%", null, mn);
            this.cryingBabyThreshold = 2;
        }
        if (calculationLoop == null) {
            calculationLoop = this.initCalculationLoop();
        }
        this.registerForNacks();
    }

    private void registerForNacks() {
        this.dataStream.addNackListener(this);
    }

    private TaskIf initCalculationLoop() {
        CalculationLoop task = new CalculationLoop(1000L);
        AdminClient.taskManT.addTask(task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectNacks(Reporter reporter, int quantity) {
        NackMonitor nack_monitor = (NackMonitor)this.reporters.get(reporter);
        if (nack_monitor == null) {
            Map map = this.reporters;
            synchronized (map) {
                this.reporters.put(reporter, new NackMonitor(quantity));
            }
        } else {
            nack_monitor.addNacks(quantity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stop() {
        Map map = activeSeesions;
        synchronized (map) {
            LinkedList tmp = new LinkedList(activeSeesions.keySet());
            Iterator i = tmp.iterator();
            while (i.hasNext()) {
                ConstantRatePolicy.stopStream((DataStreamT)i.next());
            }
        }
    }

    static void stop(StreamTIf streamT) {
        DataStreamT data_stream = DataStreamT.getDataStream(streamT);
        ConstantRatePolicy.stopStream(data_stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStream(DataStreamT data_stream) {
        Map map = activeSeesions;
        synchronized (map) {
            ConstantRatePolicy crp = (ConstantRatePolicy)activeSeesions.get(data_stream);
            if (crp != null) {
                data_stream.removeNackListener(crp);
            }
            activeSeesions.remove(data_stream);
            if (activeSeesions.isEmpty() && calculationLoop != null) {
                AdminClient.taskManT.removeTask(calculationLoop);
            }
        }
    }

    public void onNack(int quantity, long seq_num, Reporter reporter) {
        this.collectNacks(reporter, quantity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookForCryingBaby() {
        Map map = activeSeesions;
        synchronized (map) {
            Iterator i = activeSeesions.values().iterator();
            while (i.hasNext()) {
                ConstantRatePolicy.lookForCryingBaby((ConstantRatePolicy)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookForCryingBaby(ConstantRatePolicy crp) {
        float trans_rate = crp.dataStream.getTransmissionRate();
        crp.tmpList.clear();
        Map map = crp.reporters;
        synchronized (map) {
            Iterator i = crp.reporters.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Reporter reporter = (Reporter)entry.getKey();
                NackMonitor nack_monitor = (NackMonitor)entry.getValue();
                float loss_rate = nack_monitor.calculateLossRate(trans_rate, 1.0f);
                if (loss_rate * 100.0f > (float)crp.cryingBabyThreshold) {
                    crp.cryingBabyDetected(reporter);
                    continue;
                }
                crp.getClass();
                if (!(loss_rate * 100.0f <= 1.0f)) continue;
                crp.tmpList.add(reporter);
            }
            i = crp.tmpList.iterator();
            while (i.hasNext()) {
                crp.reporters.remove(i.next());
            }
        }
    }

    private void cryingBabyDetected(Reporter reporter) {
        byte[] crying_baby_msg = ReportFactory.generateCryingBabyReport(reporter.getInetAddress().getAddress(), this.dataStream.getStreamId(), this.cryingBabyThreshold - 1, 10, 3, 10);
        if (AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("ConstantRate:cryingBabyDetected send message " + Sutils.pb(crying_baby_msg, 30), mn);
        }
        reporter.sendMessage(crying_baby_msg);
    }

    private class NackMonitor {
        float currentNacks;
        float lossRate;

        NackMonitor(int nacks) {
            this.currentNacks = nacks;
        }

        private void addNacks(int nacks) {
            this.currentNacks += (float)nacks;
        }

        private float calculateLossRate(float trans_rate, float dt) {
            float loss_rate;
            float nack_rate = this.currentNacks / dt;
            float f = loss_rate = trans_rate == 0.0f ? 0.0f : nack_rate / trans_rate;
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("ConstantRate.NackMonitor.calculateLossRate  trans_rate=" + trans_rate + " dt=" + dt + " nack_rate=" + nack_rate + " loss_rate" + loss_rate, ConstantRatePolicy.mn);
            }
            this.lossRate = 0.075f * this.lossRate + 0.925f * loss_rate;
            this.currentNacks = 0.0f;
            return this.lossRate;
        }
    }

    public class CalculationLoop
    implements TaskIf {
        private long period;
        private long next_time;

        CalculationLoop(long period) {
            this.period = period;
            this.next_time = 0L;
        }

        public void timerExpired(long curTime) {
            ConstantRatePolicy.lookForCryingBaby();
            this.next_time = curTime + this.period;
        }

        public long getNextTime() {
            return this.next_time;
        }
    }
}

