/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.admin.ConstantRateSession;
import com.ibm.rmm.ptl.admin.CryingBabyReport;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConstantRateReceiver
implements ReportListener {
    private static final String mn = "Admin";
    private static ConstantRateReceiver myself;
    private static Map activeSessions;
    private AdminNode parent;

    static {
        activeSessions = Collections.synchronizedMap(new HashMap());
    }

    public ConstantRateReceiver(AdminNode node) {
        this.parent = node;
        this.registerForReports();
        myself = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.parent.removeReportListener(this, 2);
        Map map = activeSessions;
        synchronized (map) {
            Iterator i = activeSessions.values().iterator();
            while (i.hasNext()) {
                ConstantRateSession session = (ConstantRateSession)i.next();
                session.stop();
            }
        }
    }

    private void registerForReports() {
        this.parent.addReportListener(this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeSession(StreamRIf stream) {
        Map map = activeSessions;
        synchronized (map) {
            ConstantRateSession session = (ConstantRateSession)activeSessions.remove(stream);
            if (session != null) {
                session.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReport(Report report, Reporter reporter) {
        try {
            CryingBabyReport cryingBabyReport = (CryingBabyReport)report;
            long stream_id = cryingBabyReport.getStreamId();
            StreamRIf stream = this.parent.findStreamR(stream_id);
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("ConstantRateReceiver:onReport StreamId=" + stream_id + "stream=" + stream, mn);
            }
            Map map = activeSessions;
            synchronized (map) {
                if (stream != null && activeSessions.get(stream) == null) {
                    activeSessions.put(stream, new ConstantRateSession(stream, cryingBabyReport));
                }
            }
        }
        catch (ClassCastException e2) {
            AdminClient.rmmLogger.baseError("Internal error - report not from type CryingBabyReport", e2, mn);
        }
    }
}

