/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.ConstantRateReceiver;
import com.ibm.rmm.ptl.admin.CryingBabyReport;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;

public class ConstantRateSession {
    private static final String mn = "Admin";
    private final int silencePeriod;
    private final int retryLimit;
    private final int blockingPeriod;
    private final int rateThreshold;
    private final StreamRIf stream;
    private int oldFrontSeq;
    private int tries = 0;
    private int cycles = 1;
    private TaskIf timer;

    ConstantRateSession(StreamRIf stream, CryingBabyReport report) {
        this.stream = stream;
        this.silencePeriod = report.getSilencePeriod() * 1000;
        this.retryLimit = report.getRetries();
        this.blockingPeriod = report.getBlockingPeriod() * 1000;
        this.rateThreshold = report.getRate();
        AdminClient.rmmLogger.baseWarn("Suspend nacks", null, mn);
        stream.suspendNackSending();
        this.oldFrontSeq = stream.getFrontSeqN();
        ++this.tries;
        this.firstStageTimer();
    }

    void stop() {
        AdminClient.taskManR.removeTask(this.timer);
    }

    private void firstStageTimer() {
        this.timer = new Timer1(this.silencePeriod);
        AdminClient.taskManR.addTask(this.timer);
    }

    private void secondStageTimer() {
        this.timer = new Timer2(this.blockingPeriod * this.cycles);
        AdminClient.taskManR.addTask(this.timer);
    }

    private void firstStageAction() {
        float loss_rate = this.calcLossRate();
        if (AdminClient.rmmLogger.isMaxLogLevel()) {
            AdminClient.rmmLogger.maxInfo("ConstantRateSession.firstStageAction lose rate is " + loss_rate + " threshold=" + this.rateThreshold, mn);
        }
        if (loss_rate * 100.0f < (float)this.rateThreshold) {
            AdminClient.rmmLogger.baseInfo("Resume data and nacks", mn);
            this.stream.resumeNackAndData();
            ConstantRateReceiver.removeSession(this.stream);
        } else {
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("ConstantRateSession.firstStageAction wait another period", mn);
            }
            ++this.tries;
            this.firstStageTimer();
        }
    }

    private void secondStageActions() {
        AdminClient.rmmLogger.baseInfo("Resume data but not nacks", mn);
        this.stream.resumeDataReception(true);
        this.tries = 0;
        ++this.cycles;
        this.firstStageTimer();
    }

    private float calcLossRate() {
        if (this.stream.getFrontSeqN() == this.oldFrontSeq) {
            return 0.0f;
        }
        int new_front = this.stream.getFrontSeqN();
        float loss_rate = (float)this.stream.missingPackets(this.oldFrontSeq, new_front) / (float)(new_front - this.oldFrontSeq);
        this.oldFrontSeq = new_front;
        return loss_rate;
    }

    public class Timer1
    implements TaskIf {
        private long next_time;

        Timer1(long delay) {
            this.next_time = Clock.getTime() + delay;
        }

        public void timerExpired(long curTime) {
            AdminClient.taskManR.removeTask(this);
            if (ConstantRateSession.this.tries <= ConstantRateSession.this.retryLimit) {
                ConstantRateSession.this.firstStageAction();
            } else {
                AdminClient.rmmLogger.baseWarn("Suspend data retries=" + ConstantRateSession.this.tries + " limit=" + ConstantRateSession.this.retryLimit, null, ConstantRateSession.mn);
                ConstantRateSession.this.stream.suspendDataAndNack();
                ConstantRateSession.this.secondStageTimer();
            }
        }

        public long getNextTime() {
            return this.next_time;
        }
    }

    public class Timer2
    implements TaskIf {
        private long next_time;

        Timer2(long delay) {
            this.next_time = Clock.getTime() + delay;
        }

        public void timerExpired(long curTime) {
            AdminClient.taskManR.removeTask(this);
            ConstantRateSession.this.secondStageActions();
        }

        public long getNextTime() {
            return this.next_time;
        }
    }
}

