/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AckSessionR;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.admin.ConstantRateReceiver;
import com.ibm.rmm.ptl.admin.ReportDispatcher;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.ifc.util.EventIf;
import com.ibm.rmm.util.RmmAddressIf;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataStreamR
implements AdminLayerListener {
    private static final String mn = "Admin";
    private static DataStreamR myself;
    private static Map dataStreams;
    private final ReportDispatcher reportDispatcher;
    public final StreamRIf streamR;

    static {
        dataStreams = Collections.synchronizedMap(new HashMap());
    }

    private DataStreamR(StreamRIf streamR) {
        this.streamR = streamR;
        myself = this;
        streamR.setAdminListener(this);
        this.reportDispatcher = new ReportDispatcher();
    }

    public static Map getDataStreams() {
        return dataStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataStreamR getDataStream(StreamRIf streamR) {
        if (streamR == null) {
            AdminClient.rmmLogger.baseError("StreamRIf is null", new Exception(), mn);
            return null;
        }
        Map map = dataStreams;
        synchronized (map) {
            DataStreamR data_stream = (DataStreamR)dataStreams.get(streamR);
            if (data_stream == null) {
                data_stream = new DataStreamR(streamR);
                dataStreams.put(streamR, data_stream);
            }
            return data_stream;
        }
    }

    public static DataStreamR getDataStream(byte[] tag, RmmAddressIf address) {
        return DataStreamR.getDataStream(tag, address.getInetAddress(), address.getPort());
    }

    public static DataStreamR getDataStream(byte[] tag, InetAddress source, int port2) {
        StreamRIf streamR = AdminNode.getInstance().findStreamR(tag, source, port2);
        return DataStreamR.getDataStream(streamR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDataStream(StreamRIf streamR) {
        Map map = dataStreams;
        synchronized (map) {
            AckSessionR.stop(streamR);
            ConstantRateReceiver.removeSession(streamR);
            streamR.removeAdminListener();
            dataStreams.remove(streamR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDataStreams() {
        Map map = dataStreams;
        synchronized (map) {
            Iterator i = dataStreams.keySet().iterator();
            while (i.hasNext()) {
                StreamRIf stream = (StreamRIf)i.next();
                stream.removeAdminListener();
            }
            dataStreams.clear();
        }
    }

    public void addReportListener(ReportListener listener, int type) {
        this.reportDispatcher.addReportListener(listener, type);
    }

    public void removeReportListener(ReportListener listener, int type) {
        this.reportDispatcher.removeReportListener(listener, type);
    }

    public void sendReportPacket(byte[] msg, boolean unicast, boolean multicast) {
        if (this.streamR == null) {
            AdminClient.rmmLogger.baseError("Can not send report - Stream is null", null, mn);
            return;
        }
        this.streamR.sendReportPacket(msg, unicast, multicast);
    }

    public int getContiguous() {
        return this.streamR.getContigSeqN();
    }

    public int getTotPacks() {
        return this.streamR.getTotPacks();
    }

    public void onEvent(EventIf e2) {
        if (e2.getType() == 15) {
            byte controlType = (byte)e2.getIntField();
            byte[] controlData = (byte[])e2.getObjectField();
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("DataStreamR.onEvent stream " + this.streamR.getId() + " CONTROL_OPTION event " + e2.getIntField() + " " + Sutils.pb(controlData), mn);
            }
            this.onControlOption(controlType, controlData);
        } else if (e2.getType() == 16) {
            byte[] msg = (byte[])e2.getObjectField();
            if (AdminClient.rmmLogger.isMaxLogLevel()) {
                AdminClient.rmmLogger.maxInfo("DataStreamR.onEvent " + this.streamR.getId() + "report received " + Sutils.pb(msg) + " " + e2.getSourceAddress() + " " + e2.getSourcePort(), mn);
            }
            this.reportDispatcher.reportReceived(ReportFactory.buildReport(msg, 10), Reporter.getReporter(e2.getSourceAddress(), e2.getSourcePort(), false));
        } else if (e2.getType() != 5 && e2.getType() == 2) {
            AdminClient.rmmLogger.baseInfo("DataStreamR.onEvent Heartbeat Timeout" + this.streamR.getId(), mn);
            DataStreamR.removeDataStream(this.streamR);
        }
    }

    private void onControlOption(byte type, byte[] data) {
        if (type == 1) {
            try {
                int period_millis = Sutils.byteArrayToInt(data);
                if (period_millis > 0) {
                    AckSessionR.newRate(this.streamR, period_millis);
                }
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseError("Failed to parse control option", e2, mn);
            }
        }
    }
}

