/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AdminNode;
import com.ibm.rmm.ptl.admin.NackListener;
import com.ibm.rmm.ptl.admin.ReportDispatcher;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.ifc.util.EventIf;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataStreamT
implements AdminLayerListener,
TaskIf {
    static final byte HAERTBEAT_RATE_TYPE = 1;
    private static final String mn = "Admin";
    private static DataStreamT myself;
    private static final int deltaT = 500;
    private static final Map dataStreams;
    private final List nackListeners = Collections.synchronizedList(new LinkedList());
    private final ReportDispatcher reportDispatcher;
    public final StreamTIf streamT;
    private int lastFrontSeqNum;
    private float transmissionRatePackets = 0.0f;
    private long next_time;

    static {
        dataStreams = Collections.synchronizedMap(new HashMap());
    }

    private DataStreamT(StreamTIf streamT) {
        myself = this;
        this.streamT = streamT;
        streamT.setAdminListener(this);
        this.reportDispatcher = new ReportDispatcher();
        this.initRateCalculator();
    }

    private void initRateCalculator() {
        this.next_time = 0L;
        AdminClient.taskManT.addTask(this);
    }

    public static Map getDataStreams() {
        return dataStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataStreamT getDataStream(StreamTIf streamT) {
        Map map = dataStreams;
        synchronized (map) {
            DataStreamT data_stream = (DataStreamT)dataStreams.get(streamT);
            if (data_stream == null && streamT != null) {
                data_stream = new DataStreamT(streamT);
                dataStreams.put(streamT, data_stream);
            }
            return data_stream;
        }
    }

    public static DataStreamT getDataStream(byte[] tag) {
        StreamTIf streamT = AdminNode.getInstance().findStreamT(tag);
        return DataStreamT.getDataStream(streamT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDataStream(StreamTIf streamT) {
        if (streamT == null) {
            return;
        }
        streamT.setAdminListener(null);
        DataStreamT dataStream = null;
        Map map = dataStreams;
        synchronized (map) {
            dataStream = (DataStreamT)dataStreams.remove(streamT);
        }
        if (dataStream != null) {
            AdminClient.taskManT.removeTask(dataStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNackListener(NackListener listener) {
        List list = this.nackListeners;
        synchronized (list) {
            this.nackListeners.add(listener);
        }
        this.streamT.setAdminListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNackListener(NackListener listener) {
        List list = this.nackListeners;
        synchronized (list) {
            this.nackListeners.remove(listener);
        }
        if (this.nackListeners.isEmpty()) {
            this.reportDispatcher.isEmpty();
        }
    }

    public void addReportListener(ReportListener listener, int type) {
        this.reportDispatcher.addReportListener(listener, type);
    }

    public void removeReportListener(ReportListener listener, int type) {
        this.reportDispatcher.removeReportListener(listener, type);
        if (this.nackListeners.isEmpty()) {
            this.reportDispatcher.isEmpty();
        }
    }

    public void onEvent(EventIf e2) {
        if (e2.getType() == 1) {
            byte[] msg = (byte[])e2.getObjectField();
            int offset = e2.getIntField();
            this.reportDispatcher.reportReceived(ReportFactory.buildReport(msg, offset), Reporter.getReporter(e2.getSourceAddress(), e2.getSourcePort(), true));
        } else if (e2.getType() == 2) {
            this.onNack(e2.getIntField(), e2.getLongField(), e2.getSourceAddress(), e2.getSourcePort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNack(int quantity, long ts, InetAddress source, int port2) {
        if (source == null) {
            return;
        }
        List list = this.nackListeners;
        synchronized (list) {
            if (this.nackListeners == null) {
                return;
            }
            ArrayList list2 = new ArrayList(this.nackListeners);
            Iterator i = list2.iterator();
            while (i.hasNext()) {
                NackListener nl = (NackListener)i.next();
                nl.onNack(quantity, ts, Reporter.getReporter(source, port2, false));
            }
        }
    }

    void setControlOption(byte type, byte[] value2) {
        this.streamT.setAdminOption(type, value2);
    }

    public void timerExpired(long curTime) {
        int current_seq = this.streamT.getFrontSeqNum();
        this.transmissionRatePackets = (float)(current_seq - this.lastFrontSeqNum) * 1000.0f / 500.0f;
        this.lastFrontSeqNum = current_seq;
        this.next_time = curTime + 500L;
    }

    public long getNextTime() {
        return this.next_time;
    }

    int cleanBuffer(int threshold) {
        return this.streamT.cleanBuffer(threshold - 2);
    }

    int cleanBuffer() {
        this.streamT.removeRedLine();
        int gap = this.streamT.getFrontSeqNum() - this.streamT.getTrailSeqNum();
        if (gap > 100) {
            return this.streamT.cleanBuffer(this.streamT.getFrontSeqNum() - 100);
        }
        return 0;
    }

    int getRedLine() {
        return this.streamT.getRedLine();
    }

    void setRedLine(int redLine) {
        this.streamT.setRedLine(redLine);
    }

    long getStreamId() {
        return this.streamT.getId();
    }

    int getFrontSeqNum() {
        return this.streamT.getFrontSeqNum();
    }

    int getTrailSeqNum() {
        return this.streamT.getTrailSeqNum();
    }

    int getPossibleJoin() {
        return this.streamT.getPossibleJoin();
    }

    float getTransmissionRate() {
        return this.transmissionRatePackets;
    }

    void setTransmissionRate(int rate_kbytes) {
        this.streamT.setTransmissionRate(rate_kbytes);
    }
}

