/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportListener;
import com.ibm.rmm.ptl.admin.Reporter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReportDispatcher {
    private static final String mn = "Admin";
    private Map reportListeners = Collections.synchronizedMap(new HashMap());

    public void reportReceived(Report report, Reporter reporter) {
        Integer key = new Integer(report.getType());
        Object tmp = this.reportListeners.get(key);
        if (tmp == null) {
            AdminClient.rmmLogger.baseWarn("No one is listening to " + report.getDescription(report.getType()) + " reports coming from " + reporter, null, mn);
            return;
        }
        LinkedList list = new LinkedList((Collection)tmp);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ReportListener rl = (ReportListener)i.next();
            rl.onReport(report, reporter);
        }
    }

    public void addReportListener(ReportListener listener, int report_type) {
        Integer type = new Integer(report_type);
        this.addObject(this.reportListeners, type, listener);
        AdminClient.rmmLogger.baseInfo("ReportDispatcher.addReportListener: " + listener + "|" + report_type, mn);
    }

    public void removeReportListener(ReportListener listener, int report_type) {
        Integer type = new Integer(report_type);
        this.removeObject(this.reportListeners, type, listener);
    }

    public boolean isEmpty() {
        return this.reportListeners.isEmpty();
    }

    private void addObject(Map map, Object key, Object value2) {
        List<Object> list = (List<Object>)map.get(key);
        if (list == null) {
            list = Collections.synchronizedList(new LinkedList());
            list.add(value2);
            map.put(key, list);
        } else {
            list.add(value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObject(Map map, Object key, Object value2) {
        List list = (List)map.get(key);
        if (list == null) {
            return;
        }
        List list2 = list;
        synchronized (list2) {
            list.remove(value2);
            if (list.isEmpty()) {
                map.remove(key);
            }
        }
    }
}

