/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AdminInfoReport;
import com.ibm.rmm.ptl.admin.CatalogEntry;
import com.ibm.rmm.ptl.admin.CatalogEventReport;
import com.ibm.rmm.ptl.admin.CatalogStateReport;
import com.ibm.rmm.ptl.admin.CryingBabyReport;
import com.ibm.rmm.ptl.admin.ReceiverAckReport;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.TopicInterestReport;
import com.ibm.rmm.util.RmmAddressIf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class ReportFactory {
    private static final String mn = "Admin";
    private static final ReportFactory myself = new ReportFactory();
    private static Object lock = new Object();
    private static ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static DataOutputStream dos = new DataOutputStream(baos);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateTopicInterestRequest(int sessionId, byte flags, String topicName, long streamId, String host, int port2, byte maxResponses, RmmAddressIf source) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(1);
                dos.writeByte(0);
                dos.writeInt(sessionId);
                dos.writeByte(flags);
                dos.writeUTF(topicName);
                dos.writeLong(streamId);
                dos.writeUTF(host);
                dos.writeInt(port2);
                dos.writeByte(maxResponses);
                dos.writeUTF(source.getInetAddress().getHostAddress());
                dos.writeInt(source.getPort());
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Topic Interest Request"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateTopicInterestResponse(int sessionId) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(1);
                dos.writeByte(1);
                dos.writeInt(sessionId);
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Topic Interest Response"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateNotInterestedResponse(int sessionId) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(1);
                dos.writeByte(3);
                dos.writeInt(sessionId);
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Topic Not Interested Response"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateTopicInterestDone(int sessionId) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(1);
                dos.writeByte(2);
                dos.writeInt(sessionId);
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Topic Interest Done"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateCryingBabyReport(byte[] address, long stream_id, int rate, int silence_period, int retries, int blocking_period) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(2);
                dos.writeByte(0);
                dos.write(address);
                dos.writeLong(stream_id);
                dos.writeInt(rate);
                dos.writeInt(silence_period);
                dos.writeInt(retries);
                dos.writeInt(blocking_period);
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Crying Baby Report"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateReceiverHeartbeatReport(int seq, int timeout, int totpacks) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(3);
                dos.writeByte(0);
                dos.writeInt(seq);
                dos.writeInt(timeout);
                dos.writeInt(totpacks);
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Receiver Heartbeat"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateAdminInfoReport(Properties prop) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(5);
                dos.writeByte(0);
                prop.store(dos, "AdminInfo");
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Admin Info"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateCatalogStateReport(Collection catalogEntries) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(4);
                dos.writeByte(1);
                Collection collection = catalogEntries;
                synchronized (collection) {
                    dos.writeInt(catalogEntries.size());
                    Iterator i = catalogEntries.iterator();
                    while (i.hasNext()) {
                        CatalogEntry ce = (CatalogEntry)i.next();
                        dos.writeLong(ce.id);
                        dos.writeUTF(ce.name);
                        dos.writeUTF(ce.address);
                    }
                }
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Ctalog State Report"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateCatalogEventReport(CatalogEntry ce, byte action) {
        Object object = lock;
        synchronized (object) {
            baos.reset();
            try {
                dos.writeByte(4);
                dos.writeByte(2);
                dos.writeLong(ce.id);
                dos.writeUTF(ce.name);
                dos.writeUTF(ce.address);
                dos.writeByte(action);
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseLog(502, new Object[]{"Catalog Event Report"}, e2, mn);
            }
            return baos.toByteArray();
        }
    }

    public static Report buildReport(byte[] msg, int start) {
        if (msg[start] == 1) {
            return ReportFactory.buildTopicInterestReport(msg, start);
        }
        if (msg[start] == 2) {
            return ReportFactory.buildCryingBabyReport(msg, start);
        }
        if (msg[start] == 3) {
            return ReportFactory.buildReceiverHeartbeatReport(msg, start);
        }
        if (msg[start] == 4) {
            if (msg[start + 1] == 2) {
                return ReportFactory.buildCatalogEventReport(msg, start);
            }
            if (msg[start + 1] == 1) {
                return ReportFactory.buildCatalogStateReport(msg, start);
            }
        } else if (msg[start] == 5) {
            return new AdminInfoReport(msg, start);
        }
        AdminClient.rmmLogger.baseError("Unknown report type " + msg[start], null, mn);
        return null;
    }

    private static Report buildTopicInterestReport(byte[] msg, int start) {
        return new TopicInterestReport(msg, start);
    }

    private static Report buildCryingBabyReport(byte[] msg, int start) {
        return new CryingBabyReport(msg, start);
    }

    private static Report buildReceiverHeartbeatReport(byte[] msg, int start) {
        return new ReceiverAckReport(msg, start);
    }

    private static Report buildCatalogStateReport(byte[] msg, int start) {
        return new CatalogStateReport(msg, start);
    }

    private static Report buildCatalogEventReport(byte[] msg, int start) {
        return new CatalogEventReport(msg, start);
    }
}

