/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.ifc.channel.ChannelIf;
import com.ibm.rmm.ifc.channel.ReportIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.util.RmmAddressIf;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Reporter
implements RmmAddressIf {
    private static final String mn = "Admin";
    private static final int MAX_TABLE_SIZE = 10000;
    private static Reporter myself;
    private static Map reporters;
    private static ChannelIf externalChannel;
    private Socket socket;
    private final InetAddress addr;
    private final int port;
    private final String key;

    static {
        reporters = Collections.synchronizedMap(new HashMap());
    }

    private Reporter(InetAddress addr, int port2) {
        if (myself == null) {
            myself = this;
        }
        this.addr = addr;
        this.port = port2;
        this.key = Reporter.getKey(addr, port2);
    }

    public static void setExternalChannel(ChannelIf channel) {
        externalChannel = channel;
    }

    public boolean equals(Object o) {
        if (o instanceof RmmAddressIf) {
            return this.hashCode() == o.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.key;
    }

    public String getName() {
        return this.key;
    }

    public static void close() {
        Iterator i = Reporter.getAllReporters();
        while (i.hasNext()) {
            Reporter reporter = (Reporter)i.next();
            if (reporter.socket == null) continue;
            try {
                reporter.socket.close();
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseError("Failed to close socket " + reporter.socket, e2, mn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getAllReporters() {
        Map map = reporters;
        synchronized (map) {
            LinkedList tmp = new LinkedList(reporters.values());
            return tmp.iterator();
        }
    }

    public static Reporter getReporter(String addr, int port2, boolean save) {
        if (addr == null || addr.equals("") || !Reporter.validPort(port2)) {
            return null;
        }
        String key = String.valueOf(addr) + ":" + port2;
        Reporter reporter = (Reporter)reporters.get(key);
        if (reporter == null) {
            try {
                reporter = new Reporter(InetAddress.getByName(addr), port2);
            }
            catch (UnknownHostException e2) {
                AdminClient.rmmLogger.baseError("No host for " + addr, e2, mn);
                return null;
            }
            if (save) {
                Reporter.saveReporter(key, reporter);
            }
        }
        return reporter;
    }

    public static Reporter getReporter(InetAddress addr, int port2, boolean save) {
        if (addr == null || !Reporter.validPort(port2)) {
            return null;
        }
        String key = Reporter.getKey(addr, port2);
        Reporter reporter = (Reporter)reporters.get(key);
        if (reporter == null) {
            reporter = new Reporter(addr, port2);
            if (save) {
                Reporter.saveReporter(key, reporter);
            }
        }
        return reporter;
    }

    public static Reporter getReporter(Socket socket, boolean save) {
        if (socket == null || socket.getInetAddress() == null || !Reporter.validPort(socket.getPort())) {
            return null;
        }
        Reporter reporter = Reporter.getReporter(socket.getInetAddress(), socket.getPort(), save);
        reporter.socket = socket;
        return reporter;
    }

    public static Reporter getReporter(RmmAddressIf rmmAddressIf, boolean save) {
        if (rmmAddressIf == null || rmmAddressIf.getInetAddress() == null) {
            return null;
        }
        return Reporter.getReporter(rmmAddressIf.getInetAddress(), rmmAddressIf.getPort(), save);
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean openConnection() {
        try {
            this.socket = new Socket(this.addr, this.port);
            AdminClient.rmmLogger.baseInfo("Open socket " + this.socket, mn);
            return true;
        }
        catch (IOException e2) {
            AdminClient.rmmLogger.baseLog(404, new Object[]{"" + this.port}, e2, mn);
            return false;
        }
    }

    public boolean connectionIsOpen() {
        return externalChannel != null && externalChannel.isOpen(this);
    }

    public boolean sendMessage(byte[] msg) {
        if (externalChannel != null && externalChannel.isOpen(this)) {
            try {
                externalChannel.sendReport(new ReportWrapper(msg), this);
                if (AdminClient.rmmLogger.isMaxLogLevel()) {
                    AdminClient.rmmLogger.maxInfo("Message sent over the external channel", mn);
                }
                return true;
            }
            catch (IOException e2) {
                AdminClient.rmmLogger.baseWarn("Failed to send message to " + this + " over the external channel", e2, mn);
            }
        }
        this.openConnection();
        if (this.socket != null) {
            try {
                this.socket.getOutputStream().write(msg);
                return true;
            }
            catch (IOException e3) {
                AdminClient.rmmLogger.baseLog(404, new Object[]{"send report"}, e3, mn);
            }
        }
        return false;
    }

    private static String getKey(InetAddress addr, int port2) {
        return String.valueOf(addr.getHostAddress()) + ":" + port2;
    }

    private static boolean validPort(int port2) {
        return port2 >= 0 && port2 <= 65536;
    }

    public int hashCode() {
        return Reporter.getKey(this.addr, this.port).hashCode();
    }

    private static void saveReporter(String key, Reporter reporter) {
        if (reporters.size() > 10000) {
            AdminClient.rmmLogger.baseWarn("Reporter.saveReporter can not save new reporter " + reporter + " reporters table is full.", null, mn);
        } else {
            reporters.put(key, reporter);
        }
    }

    private class ReportWrapper
    implements ReportIf {
        private byte[] data;

        ReportWrapper(byte[] msg) {
            this.data = msg;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

