/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.AckReporter;
import com.ibm.rmm.util.AckHeapIf;
import com.ibm.rmm.util.AckReporterIf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReportersHeap
implements AckHeapIf {
    private static final String mn = "Admin";
    private List items = Collections.synchronizedList(new ArrayList(64));

    private int percolateUp(int i) {
        int p;
        while ((p = this.parent(i)) >= 0 && this.greaterThen(this.value(p), this.value(i))) {
            this.replace(p, i);
            i = p;
        }
        return i;
    }

    private int percolateDown(int i) {
        int s = this.items.size();
        while (true) {
            int l = this.left(i);
            int r = this.right(i);
            int smallest = l < s && this.greaterThen(this.value(i), this.value(l)) ? l : i;
            if (r < s && this.greaterThen(this.value(smallest), this.value(r))) {
                smallest = r;
            }
            if (smallest == i) break;
            this.replace(i, smallest);
            i = smallest;
        }
        return i;
    }

    private int parent(int i) {
        return (i - 1) / 2;
    }

    private int left(int i) {
        return i * 2 + 1;
    }

    private int right(int i) {
        return this.left(i) + 1;
    }

    private void replace(int i, int j) {
        if (i == j) {
            return;
        }
        AckReporter ri = (AckReporter)this.items.get(i);
        AckReporter rj = (AckReporter)this.items.get(j);
        ri.setListIndex(j);
        rj.setListIndex(i);
        this.items.set(i, rj);
        this.items.set(j, ri);
    }

    private int value(int i) {
        AckReporter reporter = (AckReporter)this.items.get(i);
        return reporter.getContiguous();
    }

    private boolean greaterThen(int a, int b) {
        return a - b > 0;
    }

    private int getIndexOf(AckReporter reporter) {
        Object o;
        int i = reporter.getListIndex();
        if (i >= 0 && !reporter.equals(o = this.items.get(i))) {
            AdminClient.rmmLogger.baseError("getIndexOf: inconsistence data structure", null, mn);
            i = -2;
        }
        return i;
    }

    protected AckReporter first() {
        if (this.items.isEmpty()) {
            return null;
        }
        return (AckReporter)this.items.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(AckReporter reporter) {
        List list = this.items;
        synchronized (list) {
            if (this.getIndexOf(reporter) < 0) {
                int i = this.items.size();
                this.items.add(reporter);
                reporter.setListIndex(i);
                this.percolateUp(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(AckReporter reporter) {
        List list = this.items;
        synchronized (list) {
            int j;
            int i = this.getIndexOf(reporter);
            if (i >= 0 && (j = this.percolateDown(i)) == i) {
                this.percolateUp(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(AckReporter reporter) {
        List list = this.items;
        synchronized (list) {
            int i = this.getIndexOf(reporter);
            if (i >= 0) {
                int s = this.items.size() - 1;
                if (i < s) {
                    this.replace(i, s);
                    this.items.remove(s);
                    this.percolateDown(i);
                } else {
                    this.items.remove(s);
                }
            }
        }
    }

    protected boolean isEmpty() {
        return this.items.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHeap() {
        ArrayList<AckReporterIf> result = new ArrayList<AckReporterIf>();
        List list = this.items;
        synchronized (list) {
            int i = 0;
            while (i < this.items.size()) {
                AckReporterIf reporter = (AckReporterIf)this.items.get(i);
                result.add(reporter);
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer();
        List list = this.items;
        synchronized (list) {
            int i = 0;
            while (i < this.items.size()) {
                result.append(this.dumpReporter(i));
                ++i;
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check() {
        List list = this.items;
        synchronized (list) {
            int s = this.items.size();
            int i = 1;
            while (i < s) {
                int p = this.parent(i);
                if (this.greaterThen(this.value(p), this.value(i))) {
                    Exception e2 = new Exception("parent is " + this.value(p) + " child is " + this.value(i));
                    AdminClient.rmmLogger.baseError("Inconsistency at the heap", e2, mn);
                }
                ++i;
            }
        }
    }

    String dumpReporter(int i) {
        AckReporter reporter = (AckReporter)this.items.get(i);
        return reporter + "=" + reporter.getContiguous() + "\n\r";
    }
}

