/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.Reporter;
import com.ibm.rmm.ptl.admin.TcpChannel;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerTcpChannel
extends TcpChannel {
    private static final String mn = "Admin";
    private static ServerSocket sSocket;
    private boolean closed = false;
    private boolean goOn = true;

    private ServerTcpChannel(int port2) {
        this.open(port2);
        this.localPort = sSocket.getLocalPort();
        this.start();
    }

    private ServerTcpChannel() {
        this(0);
    }

    public ServerTcpChannel(ServerSocket socket) {
        sSocket = socket;
        this.localPort = sSocket.getLocalPort();
        this.start();
    }

    void open(int port2) {
        try {
            sSocket = new ServerSocket(port2);
        }
        catch (IOException e2) {
            AdminClient.rmmLogger.baseLog(414, new Object[]{"" + port2}, e2, mn);
        }
    }

    public boolean isOpen() {
        return sSocket != null;
    }

    public void close() {
        this.closed = true;
        this.interrupt();
        try {
            sSocket.close();
        }
        catch (IOException e2) {
            AdminClient.rmmLogger.baseError("Failed to close server socket", e2, mn);
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    public void run() {
        AdminClient.rmmLogger.baseLog(1, new Object[]{"Server Socket on port " + sSocket.getLocalPort()}, null, mn);
        while (this.goOn) {
            try {
                Socket socket = sSocket.accept();
                DataInputStream in = new DataInputStream(socket.getInputStream());
                byte[] data = new byte[100];
                in.read(data);
                Report report = ReportFactory.buildReport(data, 0);
                Reporter reporter = Reporter.getReporter(socket, false);
                if (AdminClient.rmmLogger.isMaxLogLevel()) {
                    AdminClient.rmmLogger.maxInfo("ServerTcpChannel.run report received " + report + " " + reporter, mn);
                }
                this.reportReceived(report, reporter);
            }
            catch (Exception e2) {
                if (!this.closed) {
                    AdminClient.rmmLogger.baseWarn("ServerTcpChannel.run interrupted ", e2, mn);
                }
                this.interrupt();
            }
        }
        AdminClient.rmmLogger.baseLog(2, new Object[]{"Server Socket"}, null, mn);
    }
}

