/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.admin;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.ptl.admin.Report;
import com.ibm.rmm.ptl.admin.ReportFactory;
import com.ibm.rmm.ptl.admin.TopicHandle;
import java.io.IOException;

public class TopicInterestReport
extends Report {
    private static final String mn = "Admin";
    public static final int VTI_REQUEST = 0;
    public static final int VTI_RESPONSE = 1;
    public static final int VTI_DONE = 2;
    public static final int VTI_NOT_INTERESTED = 3;
    public static final byte STREAM_ID_F = 1;
    public static final byte TRANSMITTER_ADDR_F = 2;
    public static final byte TRANSMITTER_PORT_F = 4;
    public static final byte MAX_RESPONSES_F = 8;
    public static final byte CENTER_ADDR_F = 16;
    private TopicHandle topic;
    private int sessionId;
    private byte flags;
    private String topicName;
    private long streamId;
    private String transmitterAddress = "";
    private int transmitterPort;
    private byte maxResponses;
    private String centerAddress;
    private int centerPort;

    public TopicInterestReport(byte[] data, int start) {
        super(data);
        this.parse(data, start);
    }

    private void parse(byte[] data, int start) {
        this.bais.reset();
        try {
            this.dis.skipBytes(start);
            this.type = this.dis.readByte();
            this.subType = this.dis.readByte();
            this.sessionId = this.dis.readInt();
            if (this.subType != 0) {
                return;
            }
            this.flags = this.dis.readByte();
            this.topicName = this.dis.readUTF();
            if (this.transmitterStreamFieldExist(this.flags)) {
                this.streamId = this.dis.readLong();
            }
            if (this.transmitterAddressFieldExist(this.flags)) {
                this.transmitterAddress = this.dis.readUTF();
            }
            if (this.transmitterPortFieldExist(this.flags)) {
                this.transmitterPort = this.dis.readInt();
            }
            if (this.maxResponsesFieldExist(this.flags)) {
                this.maxResponses = this.dis.readByte();
            }
            if (this.centerAddressFieldExist(this.flags)) {
                this.centerAddress = this.dis.readUTF();
                this.centerPort = this.dis.readInt();
            }
            this.topic = new TopicHandle(this.topicName, this.streamId, this.transmitterAddress, this.transmitterPort);
        }
        catch (IOException e2) {
            AdminClient.rmmLogger.baseLog(501, new Object[]{Sutils.pb(data, 30), "Topic Interest"}, e2, mn);
        }
    }

    public TopicHandle getTopicHandle() {
        return this.topic;
    }

    private boolean transmitterStreamFieldExist(byte f) {
        return (f & 1) == 1;
    }

    private boolean transmitterAddressFieldExist(byte f) {
        return (f & 2) == 2;
    }

    private boolean transmitterPortFieldExist(byte f) {
        return (f & 4) == 4;
    }

    private boolean maxResponsesFieldExist(byte f) {
        return (f & 8) == 8;
    }

    private boolean centerAddressFieldExist(byte f) {
        return (f & 0x10) == 16;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getMaxResponses() {
        return this.maxResponses;
    }

    public String getCenterAddress() {
        return this.centerAddress;
    }

    public int getCenterPort() {
        return this.centerPort;
    }

    public boolean isRequest() {
        return this.subType == 0;
    }

    public boolean isResponse() {
        return this.subType == 1;
    }

    public boolean isDone() {
        return this.subType == 2;
    }

    public byte[] generateResponse() {
        return ReportFactory.generateTopicInterestResponse(this.sessionId);
    }

    public byte[] generateNotInterestedResponse() {
        return ReportFactory.generateNotInterestedResponse(this.sessionId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("\nSub type     : " + this.subType);
        buffer.append("\nSession Id   : " + this.sessionId);
        buffer.append("\nFlags        : " + this.flags);
        buffer.append("\nTopic handle : " + this.getTopicHandle());
        buffer.append("\nMax Responses: " + this.maxResponses);
        buffer.append("\nCenter Host  : " + this.centerAddress);
        buffer.append("\nCenter Port  : " + this.centerPort);
        return buffer.toString();
    }
}

