/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.mstp.receiver.PEvent;
import com.ibm.rmm.ptl.mstp.receiver.PReceiver;
import com.ibm.rmm.ptl.mstp.receiver.StreamR;
import com.ibm.rmm.util.StackTracer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

final class NackAndHbProcessor
extends Thread {
    static final String moduleName = "PTL_R";
    PReceiver pRec;
    DatagramSocket uSocket;
    volatile int nRot;
    volatile int nNack;
    volatile int nPack;
    private MulticastSocket mSocket;
    private int maxNRanges;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private Random randomGen;
    private int totalRequested;
    private int sleepTime;
    private int hbTimeoutMillis;
    private StreamR[] myStreamList;
    private int myUpd;
    private int slSize;
    private int slMax;
    private boolean goOn = true;

    NackAndHbProcessor(PReceiver prc, DatagramSocket u_socket) {
        this.pRec = prc;
        this.slMax = 64;
        this.myStreamList = new StreamR[this.slMax];
        this.slSize = 0;
        this.myUpd = -1;
        this.sleepTime = this.pRec.config.nackPeriodSleep;
        if (this.pRec.config.hbTimeoutMillis > 0) {
            this.pRec.rmmLogger.baseInfo("HeartbeatTimeout specified for Receiver (" + this.pRec.config.hbTimeoutMillis + " millis). Overriding the values configured in Transmitter", moduleName);
            this.hbTimeoutMillis = this.pRec.config.hbTimeoutMillis;
            this.sleepTime = this.pRec.config.nackPeriodSleep < this.hbTimeoutMillis / 5 ? this.pRec.config.nackPeriodSleep : this.hbTimeoutMillis / 5;
        }
        this.pRec.rmmLogger.baseInfo("NackAndHbProcessor: Period time (millis): " + this.sleepTime, moduleName);
        this.uSocket = u_socket;
        try {
            this.mSocket = new MulticastSocket();
        }
        catch (IOException e2) {
            this.pRec.rmmLogger.baseError("Failed to create multicast Nack socket", e2, moduleName);
        }
        try {
            this.mSocket.setTimeToLive(1);
        }
        catch (IOException e3) {
            this.pRec.rmmLogger.baseError("Failed to set TTL on multicast Nack socket", e3, moduleName);
        }
        if (this.pRec.mcInterf != null) {
            try {
                this.mSocket.setInterface(this.pRec.mcInterf);
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseError("Failed to set interface on multicast Nack socket", ex, moduleName);
            }
        }
        this.maxNRanges = 186;
        this.randomGen = new Random(System.currentTimeMillis());
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildNack(StreamR stream, int front, boolean compare) {
        int offset;
        Object bais;
        int size = 0;
        this.totalRequested = 0;
        StreamBitmap nackmap = null;
        if (compare && !stream.caughtNacks.isEmpty()) {
            nackmap = new StreamBitmap(stream.trailSeqN, 4096, 4096);
            int nn = stream.caughtNacks.size();
            int i = 0;
            while (i < nn) {
                byte[] nack = (byte[])stream.caughtNacks.elementAt(i);
                bais = new ByteArrayInputStream(nack);
                DataInputStream dis = new DataInputStream((InputStream)bais);
                int n_ranges = nack.length / 8;
                int j = 0;
                while (j < n_ranges) {
                    try {
                        offset = dis.readInt();
                        size = dis.readInt();
                    }
                    catch (IOException ex) {
                        this.pRec.rmmLogger.baseWarn("Failed to parse received Nack. Stream: " + stream, ex, moduleName);
                        break;
                    }
                    nackmap.set(offset, size);
                    ++j;
                }
                try {
                    ((ByteArrayInputStream)bais).close();
                    dis.close();
                }
                catch (IOException ex) {
                    this.pRec.rmmLogger.baseWarn("Failed to close IO streams Stream: " + stream, ex, moduleName);
                }
                ++i;
            }
        }
        size = 0;
        offset = 0;
        int n_ranges = 0;
        boolean missing = false;
        try {
            bais = stream.strBitmap;
            synchronized (bais) {
                if (front - stream.trailSeqN < 0) {
                    return null;
                }
                if (stream.lastContigN - stream.trailSeqN <= 0) {
                    stream.lastContigN = stream.trailSeqN;
                }
                if (front - stream.lastContigN < 0) {
                    this.pRec.rmmLogger.baseError("NackAndHbProcessor.buildNack: front less than contigN. Stream: " + stream, null, moduleName);
                    return null;
                }
                int i = stream.lastContigN;
                while (i - front <= 0) {
                    boolean no_packet;
                    boolean bl = no_packet = !stream.strBitmap.has(i);
                    if (no_packet) {
                        if (!missing) {
                            stream.lastContigN = i;
                        }
                        missing = true;
                        if (nackmap != null && nackmap.has(i)) {
                            no_packet = false;
                        }
                    }
                    if (no_packet) {
                        if (size == 0) {
                            offset = i;
                        }
                        ++size;
                    } else if (size > 0) {
                        if (n_ranges == 0) {
                            this.baos.reset();
                            this.dos.writeByte(5);
                            this.dos.writeByte(3);
                            this.dos.writeLong(stream.id);
                        }
                        this.dos.writeInt(offset);
                        this.dos.writeInt(size);
                        this.totalRequested += size;
                        size = 0;
                        if (++n_ranges == this.maxNRanges) break;
                    }
                    ++i;
                }
                if (!missing) {
                    stream.lastContigN = front + 1;
                }
            }
            if (size > 0) {
                if (n_ranges == 0) {
                    this.baos.reset();
                    this.dos.writeByte(5);
                    this.dos.writeByte(3);
                    this.dos.writeLong(stream.id);
                }
                this.dos.writeInt(offset);
                this.dos.writeInt(size);
                this.totalRequested += size;
            }
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to write NACK packet. Stream: " + stream, ex, moduleName);
            return null;
        }
        if (this.totalRequested == 0) {
            return null;
        }
        return this.baos.toByteArray();
    }

    private long checkHeartBeat(StreamR stream) {
        long time = Clock.getTime();
        int timeout = this.hbTimeoutMillis > 0 ? this.hbTimeoutMillis : 1000 * stream.cpTimeout;
        long nextTime = stream.lastCPTime + (long)timeout;
        long diff = time - stream.lastCPTime;
        if (diff > (long)(timeout / 3) && diff < (long)(timeout / 3 + this.sleepTime * 2) && this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxWarn("No Heartbeat received in last " + timeout / 3 + " milliseconds on stream " + stream.id, null, moduleName);
        }
        if (time - stream.lastCPTime > (long)timeout) {
            if (!stream.firstHbTimeoutCall) {
                stream.firstHbTimeoutCall = true;
                return nextTime;
            }
            if (!stream.heartbeatTimeout) {
                if (stream.transClosed) {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("Heartbeat timeout on Stream " + stream + ". Was orderly closed by transmitter", moduleName);
                    }
                } else {
                    this.pRec.rmmLogger.baseWarn("Heartbeat timeout on Stream " + stream, null, moduleName);
                }
                PEvent ev = new PEvent(2, stream);
                stream.mySet.packetListener.onEvent(ev);
                if (stream.adminListener != null) {
                    stream.adminListener.onEvent(ev);
                }
                stream.mySet.packetListener.onHeartbeatTimeout(stream);
            }
            stream.heartbeatTimeout = true;
        } else {
            stream.firstHbTimeoutCall = false;
        }
        return nextTime;
    }

    private void checkMissingPackets() throws InterruptedException {
        byte[] nackp;
        StreamR stream;
        boolean any_nack = false;
        this.buildSL();
        int i = 0;
        while (i < this.slSize) {
            stream = this.myStreamList[i];
            if (stream.isReliable && stream.strBitmap != null && stream.lastContigN - stream.frontSeqN <= 0) {
                stream.tmpFront = stream.frontSeqN;
                nackp = this.buildNack(stream, stream.tmpFront, false);
                if (nackp != null) {
                    if (this.identicalNacks(nackp, stream.lastNack)) {
                        stream.lastNack = null;
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("Same Nack. Skip once. Stream: " + stream, moduleName);
                        }
                    } else {
                        stream.lastNack = nackp;
                        any_nack = true;
                        if (this.pRec.config.statBackoff > 0) {
                            stream.catchNacks = true;
                            stream.caughtNacks.removeAllElements();
                        } else if (!stream.nackSuspend) {
                            this.sendNack(nackp, stream, true, false, this.totalRequested);
                            this.nNack += this.totalRequested;
                            ++this.nPack;
                        }
                    }
                }
            }
            ++i;
        }
        if (any_nack && this.pRec.config.statBackoff > 0) {
            int backoff_time = 1 + (int)((double)this.pRec.config.statBackoff * this.randomGen.nextDouble());
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("NackSender: wait for " + backoff_time + " milliseconds", moduleName);
            }
            NackAndHbProcessor.sleep(backoff_time);
            this.buildSL();
            int i2 = 0;
            while (i2 < this.slSize) {
                stream = this.myStreamList[i2];
                if (stream.catchNacks) {
                    nackp = this.buildNack(stream, stream.tmpFront, true);
                    stream.catchNacks = false;
                    stream.caughtNacks.removeAllElements();
                    if (nackp == null) {
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("NackSender: nack suppressed. Stream: " + stream, moduleName);
                        }
                    } else if (!stream.nackSuspend) {
                        this.sendNack(nackp, stream, true, true, this.totalRequested);
                    }
                }
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNack(byte[] nackp, StreamR stream, boolean unicast, boolean multicast, int n_requested) {
        if (!unicast && !multicast) {
            this.pRec.rmmLogger.baseError("sendNack(false, false). Was not sent. Stream: " + stream, new StackTracer(), moduleName);
            return;
        }
        Object object = stream.nackLock;
        synchronized (object) {
            PEvent ev;
            if (unicast) {
                try {
                    stream.nackUPacket.setData(nackp);
                    this.uSocket.send(stream.nackUPacket);
                }
                catch (Exception ex) {
                    this.pRec.rmmLogger.baseError("Failed to send Unicast NACK. Stream: " + stream, ex, moduleName);
                    this.pRec.rmmLogger.baseLog(417, new Object[]{stream.nackUPacket.getAddress().getHostAddress()}, ex, moduleName);
                    ev = new PEvent(18, stream, stream.nackUPacket.getAddress(), stream.nackUPacket.getPort(), ex);
                    stream.mySet.packetListener.onEvent(ev);
                }
            }
            if (multicast && stream.nackMPacket.getAddress() != null) {
                try {
                    stream.nackMPacket.setData(nackp);
                    this.mSocket.send(stream.nackMPacket);
                }
                catch (Exception ex) {
                    this.pRec.rmmLogger.baseError("Failed to send Multicast NACK. Stream: " + stream, ex, moduleName);
                    this.pRec.rmmLogger.baseLog(417, new Object[]{stream.nackMPacket.getAddress().getHostAddress()}, ex, moduleName);
                    ev = new PEvent(18, stream);
                    stream.mySet.packetListener.onEvent(ev);
                }
            }
        }
        if (n_requested > 0 && this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Sending Nack for " + n_requested + " packet(s) on stream " + stream, moduleName);
        }
    }

    private boolean identicalNacks(byte[] new_nack, byte[] old_nack) {
        if (old_nack == null) {
            return false;
        }
        if (new_nack.length != old_nack.length) {
            return false;
        }
        int i = 0;
        while (i < new_nack.length) {
            if (new_nack[i] != old_nack[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean buildSL() {
        if (this.myUpd == this.pRec.nUpd) {
            return false;
        }
        Vector<StreamR> tmpStreamList = new Vector<StreamR>();
        this.myUpd = this.pRec.nUpd;
        Enumeration streams = this.pRec.getStreamList();
        while (streams.hasMoreElements()) {
            StreamR stream = (StreamR)streams.nextElement();
            if (stream == null) continue;
            tmpStreamList.add(stream);
        }
        this.slSize = tmpStreamList.size();
        if (this.slMax < this.slSize) {
            this.slMax = 5 * this.slSize / 4;
            this.myStreamList = new StreamR[this.slMax];
        }
        int i = 0;
        while (i < this.slSize) {
            this.myStreamList[i] = (StreamR)tmpStreamList.get(i);
            ++i;
        }
        return true;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"NackAndHbProcessor"}, null, moduleName);
        int exc_count = 0;
        long last_time = Clock.getTime();
        long next_hb_chk = 0L;
        while (this.goOn) {
            ++this.nRot;
            try {
                boolean upd = this.buildSL();
                long cur_time = Clock.getTime();
                if (upd || cur_time > next_hb_chk) {
                    next_hb_chk = 0L;
                    int i = 0;
                    while (i < this.slSize) {
                        StreamR stream = this.myStreamList[i];
                        long next = this.checkHeartBeat(stream);
                        if (stream.heartbeatTimeout) {
                            stream.mySet.removeStream(stream);
                        } else if (next_hb_chk == 0L || next_hb_chk > next) {
                            next_hb_chk = next;
                        }
                        ++i;
                    }
                }
                if (cur_time - last_time >= (long)this.pRec.config.nackPeriodSleep) {
                    this.checkMissingPackets();
                    last_time = cur_time;
                }
                NackAndHbProcessor nackAndHbProcessor = this;
                synchronized (nackAndHbProcessor) {
                    this.wait(this.sleepTime);
                }
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"NackAndHbProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("NackAndHbProcessor: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop NackAndHbProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"NackAndHbProcessor"}, ex, moduleName);
                break;
            }
        }
        this.pRec.rmmLogger.baseLog(2, new Object[]{"NackAndHbProcessor"}, null, moduleName);
    }
}

