/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.receiver;

import com.ibm.rmm.intrn.util.BaCyclQueue;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.PacketCyclQueue;
import com.ibm.rmm.intrn.util.PersistByteArrayInputStream;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.mstp.receiver.AdminEvent;
import com.ibm.rmm.ptl.mstp.receiver.LongStreamHash;
import com.ibm.rmm.ptl.mstp.receiver.NackAndHbProcessor;
import com.ibm.rmm.ptl.mstp.receiver.PEvent;
import com.ibm.rmm.ptl.mstp.receiver.PReceiver;
import com.ibm.rmm.ptl.mstp.receiver.PacketReceiver;
import com.ibm.rmm.ptl.mstp.receiver.StreamR;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

class PacketProcessor
extends Thread {
    static final String moduleName = "PTL_R";
    PReceiver pRec;
    boolean isSleeping;
    PacketReceiver packetReceiver;
    volatile int nRot;
    volatile boolean threadStopped = false;
    private DatagramPacket packet;
    private PersistByteArrayInputStream bais;
    private DataInputStream dis;
    private byte[] buffer;
    private byte[] tagBuf;
    private boolean goOn = true;
    LongStreamHash streamHash;

    PacketProcessor(PReceiver prc, PacketReceiver pr) {
        this.pRec = prc;
        this.packetReceiver = pr;
        this.packetReceiver.packetProcessor = this;
        this.streamHash = new LongStreamHash(10);
        this.tagBuf = new byte[Short.MAX_VALUE];
        this.bais = new PersistByteArrayInputStream(new byte[1]);
        this.dis = new DataInputStream(this.bais);
    }

    private StreamR fetchStream(boolean stream_closed, DatagramPacket packet, long sid, short tag_length, byte[] tag_buffer) {
        StreamR stream = this.streamHash.get(sid);
        if (stream != null) {
            return stream;
        }
        if (stream_closed) {
            return null;
        }
        stream = this.pRec.fetchStream(packet, this.streamHash, sid, tag_length, tag_buffer);
        return stream;
    }

    void removeStream(StreamRIf stream) {
        this.streamHash.remove(stream.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContrPack(StreamR stream, int packet_n, int trail_n, boolean lj_enabled, int lj_marker_pos) {
        String mcast_address;
        byte act;
        int new_front = packet_n;
        if (!stream.firstPack) {
            int gap = new_front - stream.frontSeqN;
            if (gap > 0) {
                StreamBitmap streamBitmap = stream.strBitmap;
                synchronized (streamBitmap) {
                    stream.frontSeqN = new_front;
                }
            }
            if ((gap = trail_n - stream.trailSeqN) > 0) {
                stream.advanceTrail(trail_n, gap);
            }
        } else if (lj_enabled) {
            this.pRec.rmmLogger.baseInfo("Late join in CP " + lj_marker_pos + " " + packet_n + ". Stream: " + stream, moduleName);
            stream.lateJoin = true;
            stream.lateJoinMarkPos = lj_marker_pos;
            stream.trailSeqN = lj_marker_pos;
            stream.frontSeqN = packet_n;
            stream.strBitmap = new StreamBitmap(stream.trailSeqN, 4096, 4096);
            stream.firstPack = false;
            NackAndHbProcessor gap = this.pRec.streamNackSender;
            synchronized (gap) {
                this.pRec.streamNackSender.notify();
            }
        }
        try {
            boolean isrel;
            stream.cpTimeout = this.dis.readShort();
            byte rel = this.dis.readByte();
            boolean bl = isrel = rel == 1;
            if (isrel != stream.isReliable && !stream.relEvSent) {
                PEvent ev = new PEvent(4, stream);
                stream.mySet.packetListener.onEvent(ev);
                if (stream.isReliable) {
                    stream.isReliable = false;
                }
                stream.relEvSent = true;
            }
            act = this.dis.readByte();
            mcast_address = this.dis.readUTF();
            int n_contr_opt = this.dis.readByte();
            int i = 0;
            while (i < n_contr_opt) {
                byte type = this.dis.readByte();
                int len = this.dis.readInt();
                byte[] opt = new byte[len];
                this.dis.read(opt, 0, len);
                if (stream.adminListener != null) {
                    AdminEvent ev = new AdminEvent(15, stream);
                    ev.objField = opt;
                    ev.intField = type;
                    stream.adminListener.onEvent(ev);
                } else {
                    this.pRec.rmmLogger.baseWarn("PacketProcessor.processControlPacket: No admin listener (to control options). Stream: " + stream, null, moduleName);
                }
                ++i;
            }
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to parse ControlPacket. Stream: " + stream, ex, moduleName);
            return;
        }
        if (act == 0 && !stream.transClosed) {
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Stream transmission closed by sender. Stream Id: " + stream.id, moduleName);
            }
            PEvent ev = new PEvent(5, stream);
            stream.mySet.packetListener.onEvent(ev);
            stream.transClosed = true;
            if (stream.adminListener != null) {
                AdminEvent aev = new AdminEvent(5, stream);
                stream.adminListener.onEvent(aev);
            }
        }
        if (stream.nackMPacket.getAddress() == null) {
            InetAddress ia = null;
            try {
                ia = InetAddress.getByName(mcast_address);
            }
            catch (UnknownHostException ex) {
                this.pRec.rmmLogger.baseError("Failed to parse MulticastGroup address " + mcast_address + " used for Nack suppression. Stream: " + stream, ex, moduleName);
                this.pRec.rmmLogger.baseLog(412, new Object[]{mcast_address}, ex, moduleName);
                return;
            }
            stream.nackMPacket.setAddress(ia);
            stream.mcastGroup = ia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnBuffer(byte[] buffer) {
        BaCyclQueue baCyclQueue = this.packetReceiver.bufferQueue;
        synchronized (baCyclQueue) {
            this.packetReceiver.bufferQueue.pushLast(buffer);
            if (this.packetReceiver.isSleeping) {
                this.packetReceiver.bufferQueue.notify();
            }
        }
    }

    void returnBuffer(DatagramPacket packet) {
        this.returnBuffer(packet.getData());
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketProcessor"}, null, moduleName);
        int packet_n = 0;
        int trail_n = 0;
        int cnt = 0;
        int lj_marker_pos = 0;
        short tag_len = 0;
        this.isSleeping = false;
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                int gap;
                if (this.packetReceiver.packetQueue.qSize() == 0) {
                    PacketProcessor.yield();
                }
                PacketCyclQueue packetCyclQueue = this.packetReceiver.packetQueue;
                synchronized (packetCyclQueue) {
                    while (this.packetReceiver.packetQueue.qSize() == 0) {
                        this.isSleeping = true;
                        this.packetReceiver.packetQueue.wait();
                    }
                    this.packet = this.packetReceiver.packetQueue.popFirst();
                }
                this.isSleeping = false;
                ++cnt;
                this.buffer = this.packet.getData();
                this.bais.setBuffer(this.buffer);
                boolean lj_enabled = false;
                boolean stream_closed = false;
                byte protver = this.dis.readByte();
                if (protver != 5) {
                    this.pRec.rmmLogger.baseWarn("Version conflict " + protver + " vs " + 5, null, moduleName);
                    this.returnBuffer(this.packet);
                    continue;
                }
                int opt_length = 1;
                byte packet_type = this.dis.readByte();
                long sid = this.dis.readLong();
                if (packet_type == 1 || packet_type == 2) {
                    packet_n = this.dis.readInt();
                    trail_n = this.dis.readInt();
                    int n_options = this.dis.readByte();
                    if (n_options > 0) {
                        int i = 0;
                        while (i < n_options) {
                            byte type = this.dis.readByte();
                            ++opt_length;
                            if (type == 1) {
                                lj_enabled = true;
                                lj_marker_pos = this.dis.readInt();
                                opt_length += 4;
                            }
                            if (type == 2) {
                                stream_closed = true;
                            }
                            ++i;
                        }
                    }
                    tag_len = this.dis.readShort();
                    this.dis.read(this.tagBuf, 0, tag_len);
                } else {
                    tag_len = -1;
                }
                StreamR stream = this.fetchStream(stream_closed, this.packet, sid, tag_len, this.tagBuf);
                if (stream == null) {
                    this.returnBuffer(this.packet);
                    continue;
                }
                stream.lastCPTime = Clock.getTime();
                if (packet_type != 1) {
                    if (packet_type == 2) {
                        this.processContrPack(stream, packet_n, trail_n, lj_enabled, lj_marker_pos);
                    } else if (packet_type == 3) {
                        if (stream.catchNacks) {
                            int nack_length = this.packet.getLength() - 10;
                            byte[] nack = new byte[nack_length];
                            this.dis.read(nack, 0, nack_length);
                            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                                this.pRec.rmmLogger.maxInfo("PacketProcessor: Caught NACK during backoff. Stream: " + stream, moduleName);
                            }
                            stream.caughtNacks.addElement(nack);
                        }
                    } else if (packet_type == 4) {
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("PacketProcessor: Report received", moduleName);
                        }
                        if (stream.adminListener != null) {
                            AdminEvent ev = new AdminEvent(16, stream);
                            byte[] report = new byte[this.packet.getLength()];
                            System.arraycopy(this.packet.getData(), 0, report, 0, this.packet.getLength());
                            ev.objField = report;
                            stream.adminListener.onEvent(ev);
                        }
                    }
                    this.returnBuffer(this.packet);
                    continue;
                }
                if (stream.dataSuspend) {
                    this.returnBuffer(this.packet);
                    continue;
                }
                stream.packSeqN = packet_n;
                if (stream.firstPack) {
                    if (lj_enabled) {
                        stream.trailSeqN = lj_marker_pos;
                        stream.lateJoin = true;
                        stream.lateJoinMarkPos = lj_marker_pos;
                    } else {
                        stream.trailSeqN = stream.packSeqN;
                        stream.lateJoin = false;
                    }
                    stream.strBitmap = new StreamBitmap(stream.trailSeqN, 4096, 4096);
                    stream.strBitmap.set(stream.packSeqN);
                    stream.frontSeqN = stream.packSeqN;
                    stream.firstPack = false;
                } else {
                    if (stream.strBitmap.has(stream.packSeqN)) {
                        this.returnBuffer(this.packet);
                        continue;
                    }
                    if (stream.packSeqN - stream.trailSeqN < 0) {
                        this.returnBuffer(this.packet);
                        continue;
                    }
                    stream.strBitmap.set(stream.packSeqN);
                    if (stream.packSeqN - stream.frontSeqN > 0) {
                        stream.frontSeqN = stream.packSeqN;
                    }
                }
                ++stream.pCounter;
                if (!stream.isReliable && stream.pCounter % 70 == 0) {
                    trail_n = stream.frontSeqN - 50;
                }
                if ((gap = trail_n - stream.trailSeqN) > 0) {
                    stream.advanceTrail(trail_n, gap);
                }
                int pack_data_offset = 20 + tag_len + opt_length;
                int pack_data_length = this.packet.getLength() - pack_data_offset;
                if (stream.dataListener == null) {
                    stream.mySet.packetListener.onFirstPacket(stream, stream.packSeqN, this.buffer, pack_data_offset, pack_data_length, stream.lateJoin, stream.lateJoinMarkPos);
                } else {
                    stream.dataListener.onPacket(stream.packSeqN, this.buffer, pack_data_offset, pack_data_length);
                }
                this.returnBuffer(this.packet);
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketProcessor: Exception in thread loop", ex, moduleName);
                this.returnBuffer(this.packet);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketProcessor"}, ex, moduleName);
                break;
            }
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketProcessor"}, null, moduleName);
    }
}

