/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.receiver;

import com.ibm.rmm.intrn.util.BaCyclQueue;
import com.ibm.rmm.intrn.util.PacketCyclQueue;
import com.ibm.rmm.ptl.mstp.receiver.PReceiver;
import com.ibm.rmm.ptl.mstp.receiver.PacketProcessor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Vector;

class PacketReceiver
extends Thread {
    static final String moduleName = "PTL_R";
    PReceiver pRec;
    PacketProcessor packetProcessor;
    Vector mcastGroups;
    MulticastSocket mcSocket;
    volatile int nRot;
    volatile boolean threadStopped = false;
    boolean isSleeping = false;
    BaCyclQueue bufferQueue;
    PacketCyclQueue packetQueue;
    private byte[] block;
    private int thePort;
    private boolean goOn = true;

    PacketReceiver(PReceiver prc, int port2) {
        this.pRec = prc;
        this.thePort = port2;
        this.bufferQueue = new BaCyclQueue(this.pRec.config.nBuffers);
        int i = 0;
        while (i < this.pRec.config.nBuffers) {
            this.block = new byte[this.pRec.config.packetSize];
            this.bufferQueue.pushLast(this.block);
            ++i;
        }
        this.packetQueue = new PacketCyclQueue(this.pRec.config.nBuffers);
        this.mcastGroups = new Vector();
        try {
            this.mcSocket = new MulticastSocket(this.thePort);
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(404, new Object[]{"" + this.thePort}, ex, moduleName);
        }
        if (this.pRec.config.socketBufferSize > 0) {
            try {
                this.mcSocket.setReceiveBufferSize(this.pRec.config.socketBufferSize);
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseLog(413, new Object[]{"Multicast UDP ReceiveBufferSize", "" + this.pRec.config.socketBufferSize}, ex, moduleName);
            }
        }
        int real_size = 0;
        try {
            real_size = this.mcSocket.getReceiveBufferSize();
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to measure Socket RecBuffer", ex, moduleName);
        }
        this.pRec.rmmLogger.baseInfo("Socket RecBufferSize set to " + real_size / 1024 + " Kbytes", moduleName);
        if (real_size < this.pRec.config.socketBufferSize && this.pRec.config.socketBufferSize > 0) {
            this.pRec.rmmLogger.baseWarn("Socket RecBufferSize set to " + real_size / 1024 + " Kbytes. Different from configured size." + "\nCan lead to poor reception performance. Consult sysadmin to configure the UDP Reception Buffer size parameter of the OS", null, moduleName);
            this.pRec.rmmLogger.baseLog(413, new Object[]{"Multicast UDP ReceiveBufferSize", "" + this.pRec.config.socketBufferSize}, null, moduleName);
        }
        if (this.pRec.mcInterf != null) {
            try {
                this.pRec.rmmLogger.baseInfo("PacketReceiver: Setting interface to " + this.pRec.mcInterf, moduleName);
                this.mcSocket.setInterface(this.pRec.mcInterf);
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseLog(405, new Object[]{this.pRec.mcInterf}, ex, moduleName);
            }
        }
        if (this.pRec.config.setLoopback != null) {
            boolean set = Boolean.valueOf(this.pRec.config.setLoopback);
            boolean res = false;
            try {
                this.mcSocket.setLoopbackMode(set);
                res = this.mcSocket.getLoopbackMode();
            }
            catch (SocketException e2) {
                this.pRec.rmmLogger.baseWarn("Failed to set/get Loopback mode", e2, moduleName);
            }
            if (set != res) {
                this.pRec.rmmLogger.baseWarn("Loopback mode set to " + res, null, moduleName);
            }
        }
    }

    boolean addGroup(InetAddress address) {
        int i = 0;
        while (i < this.mcastGroups.size()) {
            InetAddress tmp = (InetAddress)this.mcastGroups.elementAt(i);
            if (tmp.equals(address)) {
                return true;
            }
            ++i;
        }
        this.pRec.rmmLogger.baseInfo("Joining multicast group " + address.getHostAddress(), moduleName);
        this.mcastGroups.addElement(address);
        try {
            this.mcSocket.joinGroup(address);
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(408, new Object[]{address.getHostAddress()}, ex, moduleName);
            return false;
        }
        return true;
    }

    boolean leaveGroup(InetAddress address) {
        if (!this.mcastGroups.contains(address)) {
            return true;
        }
        this.pRec.rmmLogger.baseInfo("Leaving multicast group " + address.getHostAddress(), moduleName);
        this.mcastGroups.removeElement(address);
        try {
            this.mcSocket.leaveGroup(address);
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(409, new Object[]{address.getHostAddress()}, ex, moduleName);
            return false;
        }
        return true;
    }

    int getPort() {
        return this.thePort;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketReceiver"}, null, moduleName);
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                if (this.bufferQueue.qSize() == 0) {
                    PacketReceiver.yield();
                }
                BaCyclQueue baCyclQueue = this.bufferQueue;
                synchronized (baCyclQueue) {
                    while (this.bufferQueue.qSize() == 0) {
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxWarn("PacketReceiver: waiting for buffer", null, moduleName);
                        }
                        this.isSleeping = true;
                        this.bufferQueue.wait();
                    }
                    this.block = this.bufferQueue.popFirst();
                }
                this.isSleeping = false;
                DatagramPacket packet = new DatagramPacket(this.block, this.pRec.config.packetSize);
                this.mcSocket.receive(packet);
                if (packet.getLength() >= this.pRec.config.packetSize) {
                    this.pRec.rmmLogger.baseLog(415, new Object[]{"" + this.pRec.config.packetSize, packet.getAddress().getHostAddress()}, null, moduleName);
                    this.packetProcessor.returnBuffer(packet);
                    continue;
                }
                PacketCyclQueue packetCyclQueue = this.packetQueue;
                synchronized (packetCyclQueue) {
                    this.packetQueue.pushLast(packet);
                    if (this.packetProcessor.isSleeping) {
                        this.packetQueue.notify();
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException || ex instanceof InterruptedIOException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketReceiver"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketReceiver: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketReceiver", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketReceiver"}, ex, moduleName);
                break;
            }
        }
        try {
            this.mcSocket.close();
        }
        catch (Exception e2) {
            this.pRec.rmmLogger.baseError("PacketReceiver: failed to close socket", e2, moduleName);
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketReceiver"}, null, moduleName);
    }
}

