/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.receiver;

import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.admin.AckSessionR;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.mstp.receiver.PEvent;
import com.ibm.rmm.ptl.mstp.receiver.PReceiver;
import com.ibm.rmm.ptl.mstp.receiver.StreamSet;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Vector;

public class StreamR
implements StreamRIf {
    static final String moduleName = "PTL_R";
    PReceiver pRec;
    long id;
    byte[] tag;
    InetAddress sourceIP;
    InetAddress mcastGroup;
    int sourcePort;
    boolean isReliable;
    StreamSet mySet;
    DatagramPacket nackUPacket;
    DatagramPacket nackMPacket;
    StreamBitmap strBitmap;
    int packSeqN;
    int frontSeqN;
    int trailSeqN;
    int lastContigN;
    int lateJoinMarkPos;
    boolean lateJoin;
    int tmpFront;
    int pCounter;
    short cpTimeout;
    long lastCPTime;
    boolean transClosed;
    boolean heartbeatTimeout;
    boolean firstHbTimeoutCall;
    boolean catchNacks;
    Vector caughtNacks;
    boolean firstPack;
    byte[] lastNack;
    Object nackLock;
    boolean nackSuspend;
    boolean dataSuspend;
    AdminLayerListener adminListener;
    AckSessionR acker;
    ByteBuffer reportBB;
    boolean relEvSent;
    StreamRUpcalls dataListener;

    StreamR(StreamSet set, long id, byte[] tag, InetAddress nack_address, int nack_port, boolean fifo) {
        this.pRec = set.pRec;
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Receiving PTL stream " + id + " from " + nack_address.getHostAddress() + ":" + nack_port, moduleName);
        }
        if (fifo) {
            this.pRec.rmmLogger.baseError("StreamR: currently FIFO is not supported at PTL layer. Stream: " + id, null, moduleName);
        }
        this.mySet = set;
        this.id = id;
        this.sourceIP = nack_address;
        this.sourcePort = nack_port;
        this.tag = tag;
        this.nackLock = new Object();
        this.transClosed = false;
        this.heartbeatTimeout = false;
        this.isReliable = !this.mySet.relOff;
        this.firstPack = true;
        this.caughtNacks = new Vector();
        this.frontSeqN = -1;
        this.trailSeqN = 0;
        this.lastContigN = -1;
        this.pCounter = 0;
        this.cpTimeout = (short)60;
        this.lastCPTime = System.currentTimeMillis();
        this.nackUPacket = new DatagramPacket(new byte[1], 1);
        this.nackUPacket.setAddress(nack_address);
        this.nackUPacket.setPort(nack_port);
        this.nackMPacket = new DatagramPacket(new byte[1], 1);
        this.nackMPacket.setPort(this.pRec.config.dataPort);
    }

    public byte[] getTag() {
        return this.tag;
    }

    public long getId() {
        return this.id;
    }

    public InetAddress getSourceAddress() {
        return this.sourceIP;
    }

    public InetAddress getMulticastGroup() {
        return this.mcastGroup;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getFrontSeqN() {
        return this.frontSeqN;
    }

    public int getContigSeqN() {
        if (this.dataListener == null) {
            return -1;
        }
        return this.dataListener.getContigiousSeqN();
    }

    public int getTotPacks() {
        return this.pCounter;
    }

    public void sendReportPacket(byte[] report, boolean unicast, boolean multicast) {
        int len = 10 + report.length;
        if (this.reportBB == null || this.reportBB.array().length != len) {
            this.reportBB = ByteBuffer.allocate(len);
        }
        this.reportBB.clear();
        try {
            this.reportBB.put((byte)5);
            this.reportBB.put((byte)4);
            this.reportBB.putLong(this.id);
            this.reportBB.put(report);
        }
        catch (Exception ex) {
            this.pRec.rmmLogger.baseError("Failed to write report. Stream: " + this.toString(), ex, moduleName);
        }
        this.pRec.streamNackSender.sendNack(this.reportBB.array(), this, unicast, multicast, 0);
    }

    public void suspendDataAndNack() {
        this.pRec.rmmLogger.baseWarn("Reception suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(11, this);
        this.mySet.packetListener.onEvent(ev);
        this.dataSuspend = true;
        this.nackSuspend = true;
    }

    public void suspendDataReception() {
        this.pRec.rmmLogger.baseWarn("Reception suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(11, this);
        this.mySet.packetListener.onEvent(ev);
        this.dataSuspend = true;
    }

    public void suspendNackSending() {
        this.pRec.rmmLogger.baseWarn("Nacking suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(12, this);
        this.mySet.packetListener.onEvent(ev);
        this.nackSuspend = true;
    }

    public void resumeDataReception(boolean advance_contig) {
        PEvent ev = new PEvent(14, this);
        this.mySet.packetListener.onEvent(ev);
        if (advance_contig) {
            this.tmpFront = this.frontSeqN;
            this.lastContigN = this.frontSeqN;
        }
        this.dataSuspend = false;
    }

    public void resumeNackAndData() {
        PEvent ev = new PEvent(13, this);
        this.mySet.packetListener.onEvent(ev);
        this.tmpFront = this.frontSeqN;
        this.lastContigN = this.frontSeqN;
        this.dataSuspend = false;
        this.nackSuspend = false;
    }

    public int missingPackets(int from, int to) {
        int n_missing = 0;
        int gap = to - from;
        if (gap < 0) {
            this.pRec.rmmLogger.baseWarn("StreamR.missingPackets: 'to' less than 'from'. Stream: " + this.toString(), null, moduleName);
            return 0;
        }
        int i = from;
        while (i != to) {
            if (!this.strBitmap.has(i)) {
                ++n_missing;
            }
            ++i;
        }
        return n_missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advanceTrail(int new_trail, int gap) {
        if (this.isReliable && this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Trail advanced by " + (new_trail - this.trailSeqN) + " packet(s). Stream: " + this.toString(), moduleName);
            this.pRec.rmmLogger.maxInfo("old, new, front:" + this.trailSeqN + " " + new_trail + " " + this.frontSeqN + " Stream: " + this.toString(), moduleName);
        }
        int n_lost = 0;
        int tmp_gap = new_trail - this.trailSeqN;
        if (tmp_gap <= 0) {
            this.pRec.rmmLogger.baseError("StreamR.advanceTrail: new_trail less than trailSeqN. Stream: " + this.toString(), null, moduleName);
            return;
        }
        int i = this.trailSeqN;
        while (new_trail - i > 0) {
            if (!this.strBitmap.has(i)) {
                ++n_lost;
            }
            ++i;
        }
        if (n_lost > 0) {
            PEvent ev = new PEvent(1, this);
            ev.intField = n_lost;
            this.mySet.packetListener.onEvent(ev);
        }
        if (n_lost > 0 && this.isReliable) {
            this.pRec.rmmLogger.baseWarn("Unrecoverable loss of " + n_lost + " packet(s) out of " + gap + ". Stream: " + this.toString(), null, moduleName);
        }
        if (this.dataListener != null) {
            this.dataListener.onTrailAdvance(new_trail);
        }
        StreamBitmap streamBitmap = this.strBitmap;
        synchronized (streamBitmap) {
            this.trailSeqN = new_trail;
            this.strBitmap.setTrail(this.trailSeqN);
        }
    }

    public void setReliabilityOff() {
        this.isReliable = false;
    }

    public void setAdminListener(AdminLayerListener col) {
        if (this.adminListener != null) {
            this.pRec.rmmLogger.baseWarn("StreamR.setAdminListener: replacing existing listener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.adminListener = col;
    }

    public void setDataListener(StreamRUpcalls l) {
        this.dataListener = l;
    }

    public void removeAdminListener() {
        this.adminListener = null;
    }

    public String toString() {
        return "" + this.id;
    }

    public void setAckSessionR(AckSessionR acker) {
        this.acker = acker;
    }

    public AckSessionR getAckSessionR() {
        return this.acker;
    }

    public UnicastConnectionIf getConnection() {
        return null;
    }
}

