/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.receiver;

import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.mstp.receiver.AdminEvent;
import com.ibm.rmm.ptl.mstp.receiver.LongStreamHash;
import com.ibm.rmm.ptl.mstp.receiver.PReceiver;
import com.ibm.rmm.ptl.mstp.receiver.PacketReceiver;
import com.ibm.rmm.ptl.mstp.receiver.StreamR;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.StackTracer;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;

public class StreamSet
implements StreamSetIf {
    static final String moduleName = "PTL_R";
    PReceiver pRec;
    private StreamSelector theMatcher;
    boolean relOff;
    Vector streamList;
    StreamSetUpcalls packetListener;
    AdminLayerListener adminListener;

    StreamSet(PReceiver prc, boolean unreliable, boolean fifo) {
        this.pRec = prc;
        if (fifo) {
            this.pRec.rmmLogger.baseError("StreamSet: currently FIFO is not supported at PTL layer", null, moduleName);
        }
        this.relOff = unreliable;
        this.streamList = new Vector();
    }

    public void setStreamSelector(StreamSelector matcher) {
        if (this.theMatcher != null) {
            this.pRec.rmmLogger.baseWarn("Replacing StreamSelector", new StackTracer(), moduleName);
        }
        this.theMatcher = matcher;
    }

    public void setPacketListener(StreamSetUpcalls pl) {
        if (this.packetListener != null) {
            this.pRec.rmmLogger.baseWarn("Replacing PacketListener", new StackTracer(), moduleName);
        }
        this.packetListener = pl;
    }

    public StreamSelector getStreamSelector() {
        return this.theMatcher;
    }

    StreamR addStream(long sid, byte[] tag, InetAddress nack_address, int nack_port) {
        StreamR stream = new StreamR(this, sid, tag, nack_address, nack_port, false);
        this.streamList.add(stream);
        ++this.pRec.nUpd;
        return stream;
    }

    public void setAdminListener(AdminLayerListener listener) {
        if (this.adminListener != null) {
            this.pRec.rmmLogger.baseWarn("StreamSetR.setAdminListener: replacing existing listener", new StackTracer(), moduleName);
        }
        this.adminListener = listener;
    }

    public Enumeration getStreamList() {
        return new EnumArray(this.streamList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(StreamRIf stream) {
        int j = 0;
        while (j < this.pRec.packetReceivers.size()) {
            PacketReceiver pr = (PacketReceiver)this.pRec.packetReceivers.elementAt(j);
            LongStreamHash longStreamHash = pr.packetProcessor.streamHash;
            synchronized (longStreamHash) {
                pr.packetProcessor.streamHash.remove(stream.getId());
            }
            ++j;
        }
        this.streamList.remove(stream);
        ++this.pRec.nUpd;
        if (this.adminListener != null) {
            AdminEvent ev = new AdminEvent(6, stream);
            this.adminListener.onEvent(ev);
        }
    }

    public void close() {
        if (this.adminListener != null) {
            EnumArray e2 = new EnumArray(this.streamList);
            while (e2.hasMoreElements()) {
                StreamRIf stream = (StreamRIf)e2.nextElement();
                if (stream == null) continue;
                AdminEvent ev = new AdminEvent(6, stream);
                this.adminListener.onEvent(ev);
            }
        }
        this.pRec.removeStreamSet(this);
    }
}

