/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.util.RmmLogger;
import java.util.Properties;

public class Config {
    static final String moduleName = "PTL_T";
    RmmLogger rmmLogger;
    public static final byte PROTOCOL_VERSION = 5;
    public static final int MAX_EXC_COUNT = 0;
    public static final int MAX_SEND_RETRIES = 10;
    public static final short SDP_MIN_HEADER_SIZE = 18;
    public static final int SNP_HEADER_SIZE = 10;
    static final short SDP_TRAIL_POS = 14;
    static final short SDP_PN_POS = 10;
    static final short SCP_FPN_POS = 10;
    static final short SCP_TPN_POS = 14;
    public static final byte STREAM_DATA = 1;
    public static final byte STREAM_CP = 2;
    public static final byte STREAM_NACK = 3;
    public static final byte STREAM_REPORT = 4;
    public static final int NO_RATE_LIMIT = 0;
    public static final int STATIC_RATE_LIMIT = 1;
    public static final int DYNAMIC_RATE_LIMIT = 2;
    int dataPort;
    int cpTimeout;
    int heartbeatInterval;
    int timeToLive;
    short packetSize;
    int nackTimeout;
    int limitRate;
    int transmissionRateKbps;
    int maxStreamHistorySize;
    int maxPendingSize;
    boolean persistenceSupport = false;
    int statsPeriod = 2000;
    boolean collectStats;
    float lowerLossRateTreshold = 1.0E-4f;
    float upperLossRateTreshold = 0.01f;
    float heavyLossRateTreshold = 0.3f;
    float slowStartConst = 1.3f;
    float adaptiveConst = 1.02f;
    float ssThresConst = 0.5f;
    float minRateConst = 0.005f;
    int socketBufferSize = 0;
    boolean isOK;

    protected Config() {
    }

    Config(RmmLogger rlog, Properties props) {
        this.rmmLogger = rlog;
        this.isOK = true;
        String tmp = props.getProperty("DataPort");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"DataPort"}, null, moduleName);
        } else {
            try {
                this.dataPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("DataPort", tmp, e2, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.dataPort <= 0 || this.dataPort > 65536) {
            this.rmmLogger.baseBadParam("DataPort", "" + this.dataPort, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("NackAccumulationTimeMillis");
        if (tmp == null) {
            this.nackTimeout = 300;
        } else {
            try {
                this.nackTimeout = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("NackAccumulationTimeMillis", tmp, e3, moduleName);
                this.isOK = false;
                return;
            }
            if (this.nackTimeout < 0 || this.nackTimeout > 10000) {
                this.rmmLogger.baseBadParam("NackAccumulationTimeMillis", "" + this.nackTimeout, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.nackTimeout <= 0) {
            this.rmmLogger.baseInfo("Using default NackAccumulationTimeMillis: 300 millis", moduleName);
            this.nackTimeout = 300;
        }
        if ((tmp = props.getProperty("LimitTransRate")) == null) {
            this.rmmLogger.baseLog(402, new Object[]{"LimitTransRate"}, null, moduleName);
            this.limitRate = 0;
        } else if (tmp.equalsIgnoreCase("dynamic")) {
            this.limitRate = 2;
        } else if (tmp.equalsIgnoreCase("static")) {
            this.limitRate = 1;
        } else if (tmp.equalsIgnoreCase("disabled")) {
            this.limitRate = 0;
        } else {
            this.limitRate = 0;
            this.rmmLogger.baseBadParam("LimitTransRate", tmp, null, moduleName);
            this.isOK = false;
            return;
        }
        if (this.limitRate != 0) {
            tmp = props.getProperty("TransRateLimitKbps");
            if (tmp == null) {
                this.rmmLogger.baseLog(402, new Object[]{"TransRateLimitKbps"}, null, moduleName);
                this.isOK = false;
                return;
            }
            try {
                this.transmissionRateKbps = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e4) {
                this.rmmLogger.baseBadParam("TransRateLimitKbps", tmp, e4, moduleName);
                this.isOK = false;
                return;
            }
            if (this.transmissionRateKbps <= 10) {
                this.rmmLogger.baseBadParam("TransRateLimitKbps", "" + this.transmissionRateKbps, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("HeartbeatTimeoutSec")) == null) {
            this.rmmLogger.baseLog(402, new Object[]{"HeartbeatTimeoutSec"}, null, moduleName);
        } else {
            try {
                this.cpTimeout = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutSec", tmp, e5, moduleName);
                this.isOK = false;
                return;
            }
            if (this.cpTimeout <= 2000) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutSec", "" + this.cpTimeout, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.cpTimeout == 0) {
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("PacketSizeBytes");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"PacketSizeBytes"}, null, moduleName);
            this.isOK = false;
            return;
        }
        try {
            this.packetSize = Short.parseShort(tmp);
        }
        catch (NumberFormatException e6) {
            this.rmmLogger.baseBadParam("PacketSizeBytes", tmp, e6, moduleName);
            this.isOK = false;
            return;
        }
        if (this.packetSize < 100 || this.packetSize > 32000) {
            this.rmmLogger.baseBadParam("PacketSizeBytes", "" + this.packetSize, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("MinimalHistoryKBytes");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"MinimalHistoryKBytes"}, null, moduleName);
            this.isOK = false;
            return;
        }
        try {
            this.maxStreamHistorySize = 1024 * Integer.parseInt(tmp);
        }
        catch (NumberFormatException e7) {
            this.rmmLogger.baseBadParam("MinimalHistoryKBytes", tmp, e7, moduleName);
            this.isOK = false;
            return;
        }
        if (this.maxStreamHistorySize < this.packetSize) {
            this.rmmLogger.baseBadParam("MinimalHistoryKBytes", "" + this.maxStreamHistorySize, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("MaximalPendingQueueKBytes");
        if (tmp == null) {
            this.maxPendingSize = 0x400000;
        } else {
            try {
                this.maxPendingSize = 1024 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e8) {
                this.rmmLogger.baseBadParam("MaximalPendingQueueKBytes", tmp, e8, moduleName);
                this.isOK = false;
                return;
            }
            if (this.maxPendingSize < this.packetSize) {
                this.rmmLogger.baseBadParam("MaximalPendingQueueKBytes", "" + this.maxPendingSize, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        tmp = props.getProperty("McastSocketTTL");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"McastSocketTTL"}, null, moduleName);
        } else {
            try {
                this.timeToLive = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e9) {
                this.rmmLogger.baseBadParam("McastSocketTTL", tmp, e9, moduleName);
                this.isOK = false;
                return;
            }
            if (this.timeToLive < 0) {
                this.rmmLogger.baseBadParam("McastSocketTTL", "" + this.timeToLive, null, moduleName);
                this.isOK = false;
                return;
            }
            if (this.timeToLive == 0) {
                this.rmmLogger.baseWarn("TTL=0. Multicast restricted to host only", null, moduleName);
            }
        }
        tmp = props.getProperty("HeartbeatIntervalMillis");
        if (tmp != null) {
            try {
                this.heartbeatInterval = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e10) {
                this.rmmLogger.baseBadParam("HeartbeatIntervalMillis", tmp, e10, moduleName);
                this.isOK = false;
                return;
            }
            if (this.heartbeatInterval <= 10) {
                this.rmmLogger.baseBadParam("HeartbeatIntervalMillis", "" + this.heartbeatInterval, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.heartbeatInterval <= 10) {
            this.rmmLogger.baseInfo("Using default HeartbeatIntervalMillis: 1000", moduleName);
            this.heartbeatInterval = 1000;
        }
        try {
            tmp = props.getProperty("LowerLossRateThreshold");
            if (tmp != null) {
                this.lowerLossRateTreshold = Float.parseFloat(tmp);
            }
            if ((tmp = props.getProperty("UpperLossRateThreshold")) != null) {
                this.upperLossRateTreshold = Float.parseFloat(tmp);
            }
            if ((tmp = props.getProperty("HeavyLossRateThreshold")) != null) {
                this.heavyLossRateTreshold = Float.parseFloat(tmp);
            }
            if ((tmp = props.getProperty("SlowStartConst")) != null) {
                this.slowStartConst = Float.parseFloat(tmp);
            }
            if ((tmp = props.getProperty("AdaptiveConst")) != null) {
                this.adaptiveConst = Float.parseFloat(tmp);
            }
            if ((tmp = props.getProperty("SlowStartThresConst")) != null) {
                this.ssThresConst = Float.parseFloat(tmp);
            }
            if ((tmp = props.getProperty("MinimalRateConst")) != null) {
                this.minRateConst = Float.parseFloat(tmp);
            }
        }
        catch (NumberFormatException e11) {
            this.rmmLogger.baseError("Bad number format in Congestion control parameters", e11, moduleName);
        }
        tmp = props.getProperty("SocketBufferSizeKbytes");
        try {
            if (tmp != null) {
                this.socketBufferSize = 1024 * Integer.parseInt(tmp);
            }
        }
        catch (NumberFormatException e1) {
            this.rmmLogger.baseBadParam("SocketBufferSizeKbytes", tmp, e1, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("CollectStats");
        if (tmp != null) {
            this.collectStats = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("StatisticsPeriodSec")) != null) {
            try {
                this.statsPeriod = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e12) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", tmp, e12, moduleName);
                this.isOK = false;
                return;
            }
            if (this.statsPeriod <= 0) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", "" + this.statsPeriod, null, moduleName);
                this.isOK = false;
                return;
            }
        }
    }
}

