/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.ptl.mstp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.mstp.transmitter.StreamT;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;

class ControlPacketSender
extends Thread {
    static final String moduleName = "PTL_T";
    MulticastSocket mSocket;
    PTransmitter pTrans;
    volatile int nRot;
    volatile int curPos;
    boolean isSleeping;
    boolean notifyPending;
    private boolean goOn = true;

    ControlPacketSender(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            ControlPacketSender controlPacketSender = this;
            synchronized (controlPacketSender) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.mSocket = new MulticastSocket();
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseLog(404, new Object[]{""}, ex, moduleName);
            return;
        }
        try {
            this.mSocket.setTimeToLive(this.pTrans.config.timeToLive);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseLog(407, new Object[]{"" + this.pTrans.config.timeToLive}, ex, moduleName);
        }
        if (this.pTrans.mcInterf != null) {
            try {
                this.mSocket.setInterface(this.pTrans.mcInterf);
            }
            catch (SocketException ex) {
                this.pTrans.rmmLogger.baseLog(405, new Object[]{"" + this.pTrans.mcInterf}, ex, moduleName);
            }
        }
        if (this.pTrans.config.socketBufferSize != 0) {
            try {
                this.mSocket.setSendBufferSize(this.pTrans.config.socketBufferSize);
            }
            catch (SocketException e2) {
                this.pTrans.rmmLogger.baseLog(413, new Object[]{"Multicast UDP SendBufferSize", "" + this.pTrans.config.socketBufferSize}, e2, moduleName);
            }
            this.pTrans.rmmLogger.baseInfo("Setting Socket SendBuffer size to: " + this.pTrans.config.socketBufferSize, moduleName);
        }
        this.curPos = 1;
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"ControlPacketSender"}, null, moduleName);
        DatagramPacket udpPacket = new DatagramPacket(new byte[1], 1);
        udpPacket.setPort(this.pTrans.config.dataPort);
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                long curTime = Clock.getTime();
                this.curPos = 2;
                int i22 = this.pTrans.nStreams - 1;
                while (i22 >= 0) {
                    StreamT stream = this.pTrans.streamList[i22];
                    if (stream != null) {
                        this.curPos = 4;
                        if (!stream.isActive && curTime - stream.closeTime > (long)this.pTrans.config.cpTimeout) {
                            this.curPos = 5;
                            stream.isClosed = true;
                            this.curPos = 51;
                            this.pTrans.removeStream(stream);
                            this.curPos = 52;
                            stream.cleanAfterClose();
                        } else if (stream.cpSend || curTime - stream.cpLastTime >= (long)this.pTrans.config.heartbeatInterval) {
                            this.curPos = 6;
                            stream.cpSend = false;
                            stream.cpLastTime = curTime;
                            stream.writeCP();
                            udpPacket.setData(stream.controlPacket, 0, stream.controlPacketLength);
                            udpPacket.setAddress(stream.mcastGroup);
                            int r = 0;
                            while (r < 10) {
                                try {
                                    this.mSocket.send(udpPacket);
                                    break;
                                }
                                catch (IOException ex) {
                                    if (r == 9) {
                                        this.pTrans.rmmLogger.baseError("Failed to send control packet. Stream: " + stream, ex, moduleName);
                                        this.pTrans.rmmLogger.baseLog(417, new Object[]{udpPacket.getAddress().getHostAddress()}, ex, moduleName);
                                    } else {
                                        ControlPacketSender.sleep(1L);
                                    }
                                    ++r;
                                }
                            }
                        }
                    }
                    --i22;
                }
                this.curPos = 7;
                ControlPacketSender i22 = this;
                synchronized (i22) {
                    if (this.notifyPending) {
                        this.notifyPending = false;
                    } else {
                        this.isSleeping = true;
                        this.wait(this.pTrans.config.heartbeatInterval);
                        this.isSleeping = false;
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"ControlPacketSender"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("ControlPacketSender: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop ControlPacketSender", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"ControlPacketSender"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"ControlPacketSender"}, null, moduleName);
        this.mSocket.close();
    }
}

