/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.mstp.transmitter.AdminEvent;
import com.ibm.rmm.ptl.mstp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.mstp.transmitter.StreamT;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

class NackServer
extends Thread {
    static final String moduleName = "PTL_T";
    PTransmitter pTrans;
    volatile int nRot;
    volatile int nNacks;
    private DatagramSocket socket;
    private byte[] nack;
    private ByteArrayInputStream bais;
    private DataInputStream dis;
    private boolean goOn = true;
    AdminEvent ev;

    NackServer(PTransmitter ptr, DatagramSocket socket) {
        this.pTrans = ptr;
        this.socket = socket;
        this.nack = new byte[2 * this.pTrans.packetSize];
        this.bais = new ByteArrayInputStream(this.nack);
        this.dis = new DataInputStream(this.bais);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processStreamNack(byte ptype, short id, DatagramPacket packet) {
        StreamT stream = null;
        try {
            Short key = new Short(id);
            stream = (StreamT)this.pTrans.streamHT.get(key);
            if (stream == null) {
                return false;
            }
            if (ptype == 4) {
                if (stream.adminListener != null) {
                    if (this.ev == null) {
                        this.ev = new AdminEvent(1, packet.getAddress(), packet.getPort());
                    } else {
                        this.ev.type = 1;
                        this.ev.sourceAddress = packet.getAddress();
                        this.ev.sourcePort = packet.getPort();
                    }
                    this.ev.objField = packet.getData();
                    this.ev.intField = 10;
                    stream.adminListener.onEvent(this.ev);
                }
                return false;
            }
            if (!stream.isReliable) {
                return false;
            }
            if (stream.nack_bitmap == null) {
                stream.nack_bitmap = new StreamBitmap(stream.trailSeqN, 4096, 4096);
            }
            int pack_length = packet.getLength();
            int n_ranges = (pack_length - 10) / 8;
            int tot_mis = 0;
            StreamBitmap streamBitmap = stream.nack_bitmap;
            synchronized (streamBitmap) {
                stream.nack_bitmap.setTrail(stream.trailSeqN);
                int i = 0;
                while (i < n_ranges) {
                    int offset = this.dis.readInt();
                    int size = this.dis.readInt();
                    tot_mis += size;
                    stream.nack_bitmap.set(offset, size);
                    if (offset - stream.minNackSeqN < 0) {
                        stream.minNackSeqN = offset;
                    }
                    ++i;
                }
            }
            stream.lastNackTime = Clock.getTime();
            stream.lastNackSource = packet.getAddress();
            stream.lastNackQuant = tot_mis;
            stream.lastNackPort = packet.getPort();
            this.pTrans.rmmLogger.maxLog(3, new Object[]{String.valueOf(tot_mis) + " on Stream " + stream, stream.lastNackSource.getHostAddress()}, null, moduleName);
            if (stream.adminListener != null) {
                AdminEvent ev = new AdminEvent(2, stream.lastNackSource, stream.lastNackPort);
                ev.intField = tot_mis;
                ev.longField = stream.lastNackTime;
                stream.adminListener.onEvent(ev);
            }
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseWarn("Failed Nack processing. Stream: " + stream, ex, moduleName);
        }
        return true;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"NackServer"}, null, moduleName);
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                DatagramPacket packet = new DatagramPacket(this.nack, 2 * this.pTrans.packetSize);
                try {
                    this.socket.receive(packet);
                }
                catch (SocketException ex) {
                    if (!this.pTrans.isRunning) continue;
                    this.pTrans.rmmLogger.baseWarn("Failed Nack reception", ex, moduleName);
                    continue;
                }
                this.bais.reset();
                this.dis.readByte();
                byte pack_type = this.dis.readByte();
                short stream_id = this.dis.readShort();
                this.dis.readInt();
                this.dis.readShort();
                boolean isNack = this.processStreamNack(pack_type, stream_id, packet);
                if (!isNack) continue;
                ++this.nNacks;
                this.pTrans.streamRepairer.wakeUp(true);
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException || ex instanceof InterruptedIOException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"NackServer"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("NackServer: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop NackServer", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"NackServer"}, ex, moduleName);
                break;
            }
        }
        this.socket.close();
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"NackServer"}, null, moduleName);
    }
}

