/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.BufferPool;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.mstp.transmitter.Config;
import com.ibm.rmm.ptl.mstp.transmitter.ControlPacketSender;
import com.ibm.rmm.ptl.mstp.transmitter.NackServer;
import com.ibm.rmm.ptl.mstp.transmitter.PacketFireout;
import com.ibm.rmm.ptl.mstp.transmitter.Repairer;
import com.ibm.rmm.ptl.mstp.transmitter.StreamT;
import com.ibm.rmm.ptl.mstp.transmitter.TimingThread;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PTransmitter
implements PTransmitterIf {
    PReceiverIf myPReceiver;
    Config config;
    RmmLogger rmmLogger;
    RmmAddress rmmAddress;
    TaskManager taskMan;
    static final String moduleName = "PTL_T";
    private DatagramSocket nackSocket;
    int nackPort;
    byte[] ipAddress;
    BufferPool bufferPool;
    int packetSize;
    int ptlHeaderSize;
    int tracingLevel;
    TokenBucket tokenBucket;
    int maxTrans;
    int nPending;
    int nPendingMax;
    int nSentMax;
    InetAddress mcInterf;
    Vector fullBufListeners;
    public Object memCleanMutex;
    long memCleanTime;
    long memCleanTimer = 0L;
    long memCleanTimeout;
    int mc_nCalls;
    int mc_nIdle;
    int mc_nGood;
    int mc_nFree;
    int n_packs;
    int n_hist;
    int n_pend;
    int n_idle;
    Object streamListLock;
    Hashtable streamHT;
    private int nStreamsMax;
    StreamT[] streamList;
    int nStreams;
    boolean isRunning;
    private short idSeed;
    PacketFireout streamFireout;
    NackServer nackServer;
    Repairer streamRepairer;
    ControlPacketSender hbSender;
    TimingThread timingThrd;
    private boolean needRelServices = false;
    private boolean relSrvRun = false;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, short max_packet_size, InetAddress interf) {
        try {
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.packetSize = max_packet_size;
            this.ptlHeaderSize = 27;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            this.nPendingMax = this.config.maxPendingSize / this.packetSize;
            this.nSentMax = this.config.maxStreamHistorySize / this.packetSize;
            this.bufferPool = new BufferPool((int)(1.5 * (double)this.nSentMax + (double)this.nPendingMax), this.packetSize + 100);
            if (this.nSentMax + this.nPendingMax < 300) {
                this.rmmLogger.baseWarn("Very low buffer space allocated for multicast transmitter " + this.nPendingMax + " " + this.nPendingMax, null, moduleName);
            }
            this.fullBufListeners = new Vector();
            this.memCleanMutex = new Object();
            this.memCleanTimeout = this.config.cpTimeout / 4;
            if (this.memCleanTimeout < 5000L) {
                this.memCleanTimeout = 5000L;
            }
            this.maxTrans = 50;
            if (this.config.limitRate != 0) {
                this.tokenBucket = new TokenBucket(this.config.transmissionRateKbps, this.rmmLogger, this.taskMan);
            }
            if (this.config.limitRate == 2) {
                this.rmmLogger.baseInfo("Starting Global Congestion Control", moduleName);
            }
            this.idSeed = 0;
            this.mcInterf = interf;
            this.nackSocket = this.rmmAddress.getUdpSocket();
            this.nackPort = this.nackSocket.getLocalPort();
            this.rmmLogger.baseInfo("Nack port:" + this.nackPort, moduleName);
            byte[] addr = this.rmmAddress.getInetAddress().getAddress();
            if (addr.length == 4) {
                this.ipAddress = addr;
                this.rmmLogger.baseInfo("Building GSI I - use IPV4 address", moduleName);
            } else {
                String host_name = this.rmmAddress.getInetAddress().getCanonicalHostName();
                int host_name_hash = host_name.hashCode();
                this.ipAddress = new byte[4];
                Sutils.insertInt(this.ipAddress, 0, host_name_hash);
                this.rmmLogger.baseInfo("Building GSI I - Address length - " + addr.length + ". Not IPv4. Using hash of the Canonical host name " + host_name, moduleName);
            }
            this.rmmLogger.baseInfo("GSI I: " + this.ipAddress[0] + ":" + this.ipAddress[1] + ":" + this.ipAddress[2] + ":" + this.ipAddress[3], moduleName);
            this.streamListLock = new Object();
            this.streamHT = new Hashtable();
            this.nStreamsMax = 100;
            this.streamList = new StreamT[this.nStreamsMax];
            this.nStreams = 0;
            this.streamFireout = new PacketFireout(this);
            this.streamFireout.setName("Ptl_Mstp_Fireout");
            this.streamFireout.setPriority(10);
            this.hbSender = new ControlPacketSender(this);
            this.hbSender.setName("Ptl_Mstp_ControlPacketSender");
            this.hbSender.setPriority(10);
            this.timingThrd = new TimingThread(this);
            this.timingThrd.setName("Ptl_Mstp_TimingThread");
            this.timingThrd.setPriority(10);
            this.start();
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PTransmitter", e2, moduleName);
            return false;
        }
        return true;
    }

    public synchronized StreamTIf createStreamTransmitter(boolean reliable, InetAddress address, int port2, byte[] tag, boolean lj_enabled) {
        if (tag != null && tag.length > this.config.packetSize / 2) {
            this.rmmLogger.baseError("Tag (topic) length is " + tag.length + " exceeds limit " + this.config.packetSize / 2, null, moduleName);
            return null;
        }
        short sid = this.idSeed;
        while ((sid = (short)(sid + 1)) != this.idSeed) {
            if (this.streamHT.containsKey(new Short(sid))) continue;
        }
        if (sid == this.idSeed) {
            this.rmmLogger.baseError("Could not assign a unique stream id for a new stream", null, moduleName);
            return null;
        }
        this.idSeed = sid;
        StreamT str = new StreamT(this);
        if (port2 < 0) {
            port2 = this.config.dataPort;
        }
        if (!str.init(tag, sid, reliable, address, port2, lj_enabled)) {
            return null;
        }
        if (this.config.limitRate == 2) {
            str.startCongestionControl(this.config.transmissionRateKbps);
        }
        this.addStream(str);
        if (!this.needRelServices && reliable) {
            this.needRelServices = true;
            if (this.isRunning && !this.relSrvRun) {
                this.startRelServices();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            if (this.nStreams == this.nStreamsMax) {
                StreamT[] tmp = new StreamT[2 * this.nStreamsMax];
                int i = 0;
                while (i < this.nStreamsMax) {
                    tmp[i] = this.streamList[i];
                    ++i;
                }
                this.nStreamsMax *= 2;
                this.streamList = tmp;
            }
            this.streamList[this.nStreams] = stream;
            ++this.nStreams;
            this.streamHT.put(new Short(stream.shortId), stream);
        }
        this.streamFireout.sleepTime = 32 + this.nStreams;
        if (this.nStreams == 1) {
            this.streamFireout.wakeUp(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            int i = 0;
            while (i < this.nStreams) {
                if (this.streamList[i] == stream) break;
                ++i;
            }
            if (i == this.nStreams) {
                this.rmmLogger.baseWarn("Removing stream twice from Fireout list", null, moduleName);
                return;
            }
            --this.nStreams;
            this.streamList[i] = this.streamList[this.nStreams];
            this.streamList[this.nStreams] = null;
            this.streamHT.remove(new Short(stream.shortId));
        }
        this.streamFireout.sleepTime = this.nStreams == 0 ? 100 : 32 + this.nStreams;
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Removing stream from Fireout list " + stream, moduleName);
        }
    }

    public int bufferStatus() {
        return this.bufferPool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RmmBuffer getBuffer(StreamT stream) {
        RmmBuffer res;
        while (this.bufferPool.getUtilization() > 85) {
            int streamShare;
            if (!stream.isActive) {
                return null;
            }
            int streamBuffs = stream.sentPackets.qSize() + stream.pendingPackets.qSize();
            if (streamBuffs <= (streamShare = this.bufferPool.fullSize() / this.nStreams)) break;
            Object object = this.memCleanMutex;
            synchronized (object) {
                if (!this.tryToCleanMemory()) {
                    try {
                        this.memCleanMutex.wait(50L);
                    }
                    catch (InterruptedException ex) {
                        this.rmmLogger.baseLog(406, new Object[]{"Waiting on stream buffers."}, ex, moduleName);
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        }
        while (true) {
            try {
                res = this.bufferPool.getBuffer();
                if (res != null) break;
                if (!stream.isActive) {
                    return null;
                }
                Object streamBuffs = this.memCleanMutex;
                synchronized (streamBuffs) {
                    if (!this.tryToCleanMemory()) {
                        try {
                            this.memCleanMutex.wait(50L);
                        }
                        catch (InterruptedException ex) {
                            this.rmmLogger.baseLog(406, new Object[]{"Waiting on empty buffer pool."}, ex, moduleName);
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            }
            catch (Throwable e2) {
                this.rmmLogger.baseError("getBuffer: failed to allocate new buffer, more memory is probably needed.", e2, moduleName);
                res = null;
                break;
            }
        }
        return res;
    }

    void returnBuffer(RmmBuffer buffer) {
        this.bufferPool.returnBuffer(buffer);
    }

    public void changeTransmissionRate(int new_rate_Kbps) {
        this.tokenBucket.setRate(new_rate_Kbps);
    }

    public double getAverageRetransmissionRate() {
        return this.streamRepairer.averageTotalLossRate;
    }

    public long getPendingQueueSize() {
        return this.nPending * this.packetSize;
    }

    public String getProtocolVersion() {
        return "5";
    }

    public String getStatusLog() {
        StringBuffer stat = new StringBuffer();
        try {
            stat.append("Fireout: p").append(this.streamFireout.curPos).append(" r").append(this.streamFireout.nRot);
            stat.append(". HBSender: p").append(this.hbSender.curPos).append(" r").append(this.hbSender.nRot).append(". NS: r" + this.nackServer.nRot + " n" + this.nackServer.nNacks);
            stat.append(". Rep: r").append(String.valueOf(this.streamRepairer.nRot) + " n" + this.streamRepairer.nRep).append(". TimingT: p" + this.timingThrd.curPos + " r" + this.timingThrd.nRot + " mc" + this.timingThrd.cmCalls);
            stat.append("\n_RMM_STATS_ Buffers: " + this.n_packs + " " + this.n_hist + "(" + this.nSentMax + ") " + this.n_pend + " " + this.n_idle);
            stat.append("\n_RMM_STATS_ memClean: " + this.mc_nCalls + " " + this.mc_nIdle + " " + this.mc_nGood + " " + this.mc_nFree + "\n");
            return stat.toString();
        }
        catch (NullPointerException ex) {
            return "Not started";
        }
    }

    public StreamTIf getStream(byte[] tag) {
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && Sutils.compareByteArrays(stream.getTag(), tag)) {
                return stream;
            }
            --i;
        }
        return null;
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public Enumeration listStreams() {
        return new EnumArray(this.streamHT, false);
    }

    public void addFullBufferListener(FullBufferListener list) {
        this.fullBufListeners.add(list);
    }

    public void removeFullBufferListener(FullBufferListener list) {
        this.fullBufListeners.remove(list);
    }

    private void startRelServices() {
        this.nackServer = new NackServer(this, this.nackSocket);
        this.nackServer.setName("Ptl_Mstp_NackServer");
        this.nackServer.setPriority(10);
        this.nackServer.start();
        this.streamRepairer = new Repairer(this);
        this.streamRepairer.setName("Ptl_Mstp_Repairer");
        this.streamRepairer.setPriority(10);
        this.streamRepairer.start();
        this.relSrvRun = true;
    }

    private void start() {
        this.isRunning = true;
        this.streamFireout.start();
        this.hbSender.start();
        this.timingThrd.start();
        if (this.needRelServices) {
            this.startRelServices();
        }
    }

    public synchronized boolean stop(boolean soft) {
        this.rmmLogger.baseLog(2, new Object[]{"PTransmitter"}, null, moduleName);
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null) {
                stream.close(soft);
            }
            --i;
        }
        if (soft && this.nStreams > 0) {
            this.rmmLogger.baseInfo("Waiting for " + this.config.cpTimeout / 1000 + "sec (control packet timeout)\n" + "to let transmitter send pending packets and receivers complete the reception", moduleName);
            try {
                Thread.sleep(this.config.cpTimeout);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.rmmLogger.baseInfo("Fast PTL Transmitter Stop", moduleName);
        }
        this.isRunning = false;
        this.hbSender.interrupt();
        this.timingThrd.interrupt();
        if (this.streamFireout != null) {
            this.streamFireout.interrupt();
        }
        if (this.nackServer != null) {
            this.nackServer.interrupt();
            this.nackSocket.close();
        }
        if (this.streamRepairer != null) {
            this.streamRepairer.interrupt();
        }
        if (this.tokenBucket != null) {
            this.tokenBucket.stop();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryToCleanMemory() {
        StreamT stream;
        RmmBuffer packet = null;
        ++this.mc_nCalls;
        this.n_packs = 0;
        this.n_hist = 0;
        this.n_pend = 0;
        this.n_idle = 0;
        int i = this.nStreams - 1;
        while (i >= 0) {
            stream = this.streamList[i];
            if (stream != null) {
                this.n_hist += stream.sentPackets.qSize();
                this.n_pend += stream.pendingPackets.qSize();
            }
            --i;
        }
        int to_erase = this.n_hist - this.nSentMax;
        this.n_idle = this.bufferStatus();
        this.n_packs = this.n_idle + this.n_pend + this.n_hist;
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Pool: " + this.n_idle + " Pending: " + this.n_pend + ". History: " + this.n_hist + " nSentMax: " + this.nSentMax + ". Total Buffers: " + this.n_packs + " to erase " + to_erase, moduleName);
        }
        if (to_erase <= 0) {
            ++this.mc_nIdle;
            return false;
        }
        boolean cleaned = false;
        boolean had_to_clean = false;
        int i2 = this.nStreams - 1;
        while (i2 >= 0) {
            block21: {
                int s_to_erase;
                block23: {
                    int mustkeep;
                    int sps;
                    block22: {
                        int delta;
                        stream = this.streamList[i2];
                        if (stream == null || !stream.isReliable || (s_to_erase = (sps = stream.sentPackets.qSize()) * to_erase / this.n_hist) < 1) break block21;
                        had_to_clean = true;
                        mustkeep = stream.pendFrontSeqN + 1000;
                        int tmpmark = stream.getRedLine();
                        if (mustkeep - tmpmark > 0) {
                            mustkeep = tmpmark;
                        }
                        if (mustkeep - (tmpmark = stream.getPossibleJoin()) > 0) {
                            mustkeep = tmpmark;
                        }
                        if ((delta = s_to_erase - ((mustkeep -= 2) - stream.trailSeqN)) <= 0) break block22;
                        s_to_erase = mustkeep - stream.trailSeqN;
                        if (this.rmmLogger.isMaxLogLevel()) {
                            this.rmmLogger.maxWarn("Cannot erase enough packets: hit red line (" + stream.redLine + "," + stream.ljOptionValue + "). Stream: " + stream, null, moduleName);
                        }
                        if (s_to_erase >= 1) break block23;
                        break block21;
                    }
                    if (stream.redLineSet && stream.ljOptionSet) {
                        s_to_erase = Math.min(sps - 2, mustkeep - stream.trailSeqN);
                    }
                }
                BufferCyclQueue bufferCyclQueue = stream.sentPackets;
                synchronized (bufferCyclQueue) {
                    int j = 0;
                    while (j < s_to_erase) {
                        this.returnBuffer(stream.sentPackets.popFirst());
                        ++j;
                    }
                    packet = stream.sentPackets.seeElement(0);
                    System.arraycopy(packet.dataBuffer, 10, stream.trailSeqNBytes, 0, 4);
                }
                stream.cpSend = true;
                this.rmmLogger.maxLog(100, new Object[]{" Stream " + stream + ". Np " + s_to_erase}, null, moduleName);
                this.mc_nFree += s_to_erase;
                cleaned = true;
                stream.trailSeqN += s_to_erase;
            }
            --i2;
        }
        if (!cleaned && had_to_clean) {
            if (this.memCleanTimer == 0L) {
                this.memCleanTimer = Clock.getTime();
            } else if (Clock.getTime() > this.memCleanTimer + this.memCleanTimeout) {
                if (this.fullBufListeners.size() > 0) {
                    i2 = 0;
                    while (i2 < this.fullBufListeners.size()) {
                        ((FullBufferListener)this.fullBufListeners.elementAt(i2)).onFullBuffer(to_erase);
                        ++i2;
                    }
                } else {
                    this.rmmLogger.baseWarn("MemCleaner: Failed to free " + to_erase + " packets. Due to red lines.", null, moduleName);
                }
                this.memCleanTimer = 0L;
            }
        }
        if (cleaned) {
            ++this.mc_nGood;
            this.memCleanTimer = 0L;
            this.memCleanTime = Clock.getTime();
            this.hbSender.wakeUp(true);
        }
        return cleaned;
    }

    public synchronized void setPreceiver(PReceiverIf pReceiver) {
        this.myPReceiver = pReceiver;
    }

    public synchronized boolean receiverReportConnection(InetSocketAddress remoteAddress, Object socket, boolean closed, Object connection) {
        this.rmmLogger.baseError("receiverReportConnection called on Multicast transmitter", null, moduleName);
        return false;
    }

    public int getHeaderSize() {
        return this.ptlHeaderSize;
    }

    public void gotConnStreams(Object socket, long[] stream_ids, int nstreams) {
        this.rmmLogger.baseError("gotConnStreams called on Multicast Transmitter", null, moduleName);
    }

    public boolean stopChfw() {
        return false;
    }
}

