/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.ptl.mstp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.mstp.transmitter.StreamT;
import com.ibm.rmm.ptl.mstp.transmitter.TEvent;
import java.io.IOException;
import java.net.MulticastSocket;
import java.net.SocketException;

class PacketFireout
extends Thread {
    static final String moduleName = "PTL_T";
    PTransmitter pTrans;
    boolean isSleeping;
    boolean notifyPending;
    int sleepTime = 100;
    MulticastSocket mSocket;
    volatile int nRot;
    volatile int curPos;
    private boolean goOn = true;

    PacketFireout(PTransmitter ptr) {
        this.pTrans = ptr;
        this.isSleeping = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            PacketFireout packetFireout = this;
            synchronized (packetFireout) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.mSocket = new MulticastSocket();
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseLog(404, new Object[]{""}, ex, moduleName);
            return;
        }
        try {
            this.mSocket.setTimeToLive(this.pTrans.config.timeToLive);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseLog(407, new Object[]{"" + this.pTrans.config.timeToLive}, ex, moduleName);
        }
        if (this.pTrans.mcInterf != null) {
            try {
                this.mSocket.setInterface(this.pTrans.mcInterf);
            }
            catch (SocketException ex) {
                this.pTrans.rmmLogger.baseLog(405, new Object[]{"" + this.pTrans.mcInterf}, ex, moduleName);
            }
        }
        if (this.pTrans.config.socketBufferSize != 0) {
            try {
                this.mSocket.setSendBufferSize(this.pTrans.config.socketBufferSize);
            }
            catch (SocketException e2) {
                this.pTrans.rmmLogger.baseError("Failed to set Socket SendBuffer size", e2, moduleName);
                this.pTrans.rmmLogger.baseLog(413, new Object[]{"Multicast UDP SendBufferSize", "" + this.pTrans.config.socketBufferSize}, e2, moduleName);
            }
            this.pTrans.rmmLogger.baseInfo("Setting Socket SendBuffer size to: " + this.pTrans.config.socketBufferSize, moduleName);
        }
        try {
            int buf_s = this.mSocket.getSendBufferSize();
            this.pTrans.rmmLogger.baseInfo("Socket SendBufferSize is " + buf_s, moduleName);
            if (this.pTrans.config.socketBufferSize != 0 && buf_s != this.pTrans.config.socketBufferSize) {
                this.pTrans.rmmLogger.baseWarn("SendBufferSize is different from configures", null, moduleName);
            }
            if (buf_s < this.pTrans.config.packetSize) {
                this.pTrans.rmmLogger.baseError("SendBufferSize is smaller than PacketSize", null, moduleName);
                this.pTrans.rmmLogger.baseLog(413, new Object[]{"Multicast UDP SendBufferSize", "" + this.pTrans.config.socketBufferSize}, null, moduleName);
            }
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to measure Socket SendBuffer size", ex, moduleName);
        }
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"PacketFireout"}, null, moduleName);
        this.curPos = 1;
        this.isSleeping = false;
        int n_max = this.pTrans.maxTrans;
        RmmBuffer[] tmpQ = new RmmBuffer[n_max];
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                boolean sent = false;
                boolean ttNotified = false;
                int n_pend = 0;
                this.curPos = 3;
                int i2 = this.pTrans.nStreams - 1;
                while (i2 >= 0) {
                    StreamT stream = this.pTrans.streamList[i2];
                    if (stream != null) {
                        this.curPos = 4;
                        int n_pckts = stream.pendingPackets.qSize();
                        n_pend += n_pckts;
                        if (!stream.limitRate || stream.oDataBucket.hasToken()) {
                            this.curPos = 5;
                            int n_trans = 0;
                            if (n_pckts > 0) {
                                n_trans = n_pckts > n_max ? n_max : n_pckts;
                            } else {
                                this.curPos = 6;
                                if (!ttNotified && stream.mtlSize > 0) {
                                    ttNotified = true;
                                    this.pTrans.timingThrd.wakeUp(true);
                                }
                            }
                            if (n_trans != 0) {
                                RmmBuffer packet;
                                int j;
                                this.curPos = 10;
                                sent = true;
                                BufferCyclQueue bufferCyclQueue = stream.pendingPackets;
                                synchronized (bufferCyclQueue) {
                                    j = 0;
                                    while (j < n_trans) {
                                        tmpQ[j] = packet = stream.pendingPackets.popFirst();
                                        this.curPos = 11;
                                        if (stream.limitRate) {
                                            stream.oDataBucket.commitToken(packet.dataLength);
                                            if (!stream.oDataBucket.hasToken()) {
                                                n_trans = j + 1;
                                                break;
                                            }
                                        }
                                        ++j;
                                    }
                                    if (stream.isWaiting) {
                                        stream.pendingPackets.notify();
                                    }
                                }
                                this.curPos = 12;
                                int j22 = 0;
                                while (j22 < n_trans) {
                                    packet = tmpQ[j22];
                                    if (stream.isReliable) {
                                        System.arraycopy(stream.trailSeqNBytes, 0, packet.dataBuffer, 14, 4);
                                    }
                                    stream.udpPacket.setData(packet.dataBuffer, 0, packet.dataLength);
                                    this.curPos = 13;
                                    if (this.pTrans.config.limitRate != 0) {
                                        this.pTrans.tokenBucket.waitForToken(packet.dataLength);
                                    }
                                    this.curPos = 14;
                                    int r = 0;
                                    while (r < 10) {
                                        try {
                                            this.mSocket.send(stream.udpPacket);
                                            break;
                                        }
                                        catch (IOException ex) {
                                            if (r == 9) {
                                                this.pTrans.rmmLogger.baseError("Failed to send data packet. Stream: " + stream, ex, moduleName);
                                                this.pTrans.rmmLogger.baseLog(417, new Object[]{stream.udpPacket.getAddress().getHostAddress()}, ex, moduleName);
                                                TEvent ev = new TEvent(4, 0L, 0, ex, stream.longId, stream.udpPacket.getAddress(), stream.udpPacket.getPort());
                                                stream.eventListener.onEvent(ev);
                                            } else {
                                                PacketFireout.sleep(1L);
                                            }
                                            ++r;
                                        }
                                    }
                                    ++j22;
                                }
                                this.curPos = 15;
                                if (stream.isReliable) {
                                    BufferCyclQueue j22 = stream.sentPackets;
                                    synchronized (j22) {
                                        j = 0;
                                        while (j < n_trans) {
                                            stream.sentPackets.pushLast(tmpQ[j]);
                                            ++j;
                                        }
                                    }
                                    stream.sentFrontSeqN += n_trans;
                                } else {
                                    j22 = 0;
                                    while (j22 < n_trans) {
                                        packet = tmpQ[j22];
                                        this.pTrans.returnBuffer(packet);
                                        ++j22;
                                    }
                                    stream.sentFrontSeqN += n_trans;
                                }
                                this.curPos = 16;
                                PacketFireout.yield();
                            }
                        }
                    }
                    --i2;
                }
                this.pTrans.nPending = n_pend;
                this.curPos = 17;
                if (!sent) {
                    PacketFireout i2 = this;
                    synchronized (i2) {
                        if (this.notifyPending) {
                            this.notifyPending = false;
                        } else {
                            this.isSleeping = true;
                            this.wait(this.sleepTime);
                            this.isSleeping = false;
                        }
                    }
                } else {
                    this.notifyPending = false;
                }
                this.curPos = 18;
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"PacketFireout"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("PacketFireout: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop PacketFireout", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"PacketFireout"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"PacketFireout"}, null, moduleName);
        this.mSocket.close();
    }
}

