/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.mstp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.mstp.transmitter.StreamT;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;

class Repairer
extends Thread {
    static final String moduleName = "PTL_T";
    PTransmitter pTrans;
    MulticastSocket mSocket;
    DatagramPacket udpPacket;
    double averageTotalLossRate;
    volatile int nRot;
    volatile int nRep;
    private long lastLRTime;
    private double runningAverageLR;
    private int runningAverageLRCount;
    boolean isSleeping;
    boolean notifyPending;
    private boolean goOn = true;

    Repairer(PTransmitter ptr) {
        this.pTrans = ptr;
        this.udpPacket = new DatagramPacket(new byte[1], 1);
        this.udpPacket.setPort(this.pTrans.config.dataPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            Repairer repairer = this;
            synchronized (repairer) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"Repairer"}, null, moduleName);
        try {
            this.mSocket = new MulticastSocket();
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseLog(404, new Object[]{""}, ex, moduleName);
            return;
        }
        try {
            this.mSocket.setTimeToLive(this.pTrans.config.timeToLive);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseLog(407, new Object[]{"" + this.pTrans.config.timeToLive}, ex, moduleName);
        }
        if (this.pTrans.mcInterf != null) {
            try {
                this.mSocket.setInterface(this.pTrans.mcInterf);
            }
            catch (SocketException ex) {
                this.pTrans.rmmLogger.baseLog(405, new Object[]{"" + this.pTrans.mcInterf}, ex, moduleName);
            }
        }
        if (this.pTrans.config.socketBufferSize != 0) {
            try {
                this.mSocket.setSendBufferSize(this.pTrans.config.socketBufferSize);
            }
            catch (SocketException e2) {
                this.pTrans.rmmLogger.baseError("Failed to set Socket SendBuffer size", e2, moduleName);
                this.pTrans.rmmLogger.baseLog(413, new Object[]{"Multicast UDP SendBufferSize", "" + this.pTrans.config.socketBufferSize}, e2, moduleName);
            }
            this.pTrans.rmmLogger.baseInfo("Setting Socket SendBuffer size to: " + this.pTrans.config.socketBufferSize, moduleName);
        }
        try {
            this.pTrans.rmmLogger.baseInfo("Socket SendBufferSize is " + this.mSocket.getSendBufferSize(), moduleName);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to measure Socket SendBuffer size", ex, moduleName);
        }
        double loss_rate = 0.0;
        int exc_count = 0;
        this.lastLRTime = Clock.getTime();
        while (this.goOn) {
            ++this.nRot;
            try {
                Repairer repairer = this;
                synchronized (repairer) {
                    if (this.notifyPending) {
                        this.notifyPending = false;
                    } else {
                        this.isSleeping = true;
                        this.wait();
                        this.isSleeping = false;
                    }
                }
                int total_advance = 0;
                int total_loss = 0;
                int k = this.pTrans.nStreams - 1;
                while (k >= 0) {
                    StreamT stream = this.pTrans.streamList[k];
                    if (!(stream == null || stream.isClosed || stream.limitRate && !stream.oDataBucket.hasCreditToken())) {
                        int n_pack = 0;
                        int n_missing = 0;
                        int n_new = 0;
                        if (stream.nack_bitmap != null) {
                            Object object = this.pTrans.memCleanMutex;
                            synchronized (object) {
                                StreamBitmap streamBitmap = stream.nack_bitmap;
                                synchronized (streamBitmap) {
                                    int gap;
                                    stream.nack_bitmap.setTrail(stream.trailSeqN);
                                    if (stream.minNackSeqN - stream.trailSeqN < 0) {
                                        stream.minNackSeqN = stream.trailSeqN;
                                    }
                                    if ((gap = stream.sentFrontSeqN - stream.minNackSeqN) >= 0) {
                                        boolean noMoreStreamTokens = false;
                                        this.udpPacket.setAddress(stream.mcastGroup);
                                        this.udpPacket.setPort(stream.dataPort);
                                        int sn = stream.minNackSeqN;
                                        while (sn != stream.sentFrontSeqN + 1) {
                                            if (stream.nack_bitmap.has(sn)) {
                                                ++n_missing;
                                                if (sn - stream.oldFront > 0) {
                                                    ++n_new;
                                                }
                                                if (!noMoreStreamTokens) {
                                                    if (stream.limitRate && !stream.oDataBucket.hasCreditToken()) {
                                                        noMoreStreamTokens = true;
                                                    } else {
                                                        RmmBuffer packet;
                                                        gap = sn - stream.trailSeqN;
                                                        BufferCyclQueue bufferCyclQueue = stream.sentPackets;
                                                        synchronized (bufferCyclQueue) {
                                                            packet = stream.sentPackets.seeElement(gap);
                                                        }
                                                        if (packet != null) {
                                                            System.arraycopy(stream.trailSeqNBytes, 0, packet.dataBuffer, 14, 4);
                                                            int pl = packet.dataLength;
                                                            this.udpPacket.setData(packet.dataBuffer, 0, pl);
                                                            if (this.pTrans.config.limitRate != 0) {
                                                                this.pTrans.tokenBucket.waitForCreditToken(pl);
                                                            }
                                                            if (stream.limitRate) {
                                                                stream.oDataBucket.commitToken(pl);
                                                            }
                                                            int r = 0;
                                                            while (r < 10) {
                                                                try {
                                                                    this.mSocket.send(this.udpPacket);
                                                                    break;
                                                                }
                                                                catch (IOException ex) {
                                                                    if (r == 9) {
                                                                        this.pTrans.rmmLogger.baseError("Failed to send repair packet. Stream: " + stream, ex, moduleName);
                                                                        this.pTrans.rmmLogger.baseLog(417, new Object[]{this.udpPacket.getAddress().getHostAddress()}, ex, moduleName);
                                                                    } else {
                                                                        Repairer.sleep(1L);
                                                                    }
                                                                    ++r;
                                                                }
                                                            }
                                                            if (this.pTrans.config.collectStats) {
                                                                stream.bytesRetransmitted += (long)pl;
                                                            }
                                                            stream.nack_bitmap.clear(sn);
                                                            stream.minNackSeqN = sn;
                                                            ++n_pack;
                                                        }
                                                    }
                                                }
                                            }
                                            ++sn;
                                        }
                                        if (n_missing == 0) {
                                            stream.minNackSeqN = stream.sentFrontSeqN;
                                        }
                                    } else {
                                        this.pTrans.rmmLogger.baseWarn("Repairer: sentFront smaller than min Nack seq N " + stream.sentFrontSeqN + " " + stream.trailSeqN + ". Stream: " + stream, null, moduleName);
                                    }
                                }
                            }
                        }
                        int rep_win_size = stream.sentFrontSeqN - stream.oldFront;
                        stream.oldFront = stream.sentFrontSeqN;
                        if (stream.limitRate && stream.congestionControl != null) {
                            stream.congestionControl.calculateNextRate(n_missing, rep_win_size, n_new, stream.sentFrontSeqN);
                        }
                        loss_rate = n_pack + rep_win_size > 0 ? (double)n_pack / (double)(n_pack + rep_win_size) : 0.0;
                        total_advance += rep_win_size;
                        total_loss += n_pack;
                        stream.avrgLossRate = 0.8 * stream.avrgLossRate + 0.2 * loss_rate;
                        if (n_pack != 0) {
                            if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                                this.pTrans.rmmLogger.maxInfo("Send " + n_pack + " rep packets. Front advance: " + rep_win_size + " orig packets. Ratio (r/(o+r)): " + (float)loss_rate + " Avr Ratio: " + (float)stream.avrgLossRate + ". Stream: " + stream, moduleName);
                            }
                            this.nRep += n_pack;
                        }
                    }
                    --k;
                }
                double total_loss_rate = total_loss + total_advance > 0 ? (double)total_loss / (double)(total_loss + total_advance) : 0.0;
                this.runningAverageLR += total_loss_rate;
                ++this.runningAverageLRCount;
                long time = Clock.getTime();
                if (time - this.lastLRTime <= (long)this.pTrans.config.statsPeriod) continue;
                this.averageTotalLossRate = this.runningAverageLR / (double)this.runningAverageLRCount;
                this.lastLRTime = time;
                this.runningAverageLR = 0.0;
                this.runningAverageLRCount = 0;
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"Repairer"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("Repairer: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop Repairer", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"Repairer"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"Repairer"}, null, moduleName);
        this.mSocket.close();
    }
}

