/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.PersistByteArrayOutputStream;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.transmitter.BufferRequestListener;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.ifc.transmitter.EventListener;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.mstp.transmitter.AdminEvent;
import com.ibm.rmm.ptl.mstp.transmitter.CongestionControl;
import com.ibm.rmm.ptl.mstp.transmitter.PTransmitter;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class StreamT
implements StreamTIf {
    static final String moduleName = "PTL_T";
    PTransmitter pTrans;
    private static final int nPendingMax = 10;
    short shortId;
    long longId;
    byte[] tag;
    short tagLength;
    boolean isReliable;
    InetAddress mcastGroup;
    int dataPort;
    DatagramPacket udpPacket;
    String mcastAddress;
    long cpTimestamp;
    long lastNackTime;
    InetAddress lastNackSource;
    int lastNackQuant;
    int lastNackPort;
    int pendFrontSeqN;
    int sentFrontSeqN;
    int trailSeqN;
    byte[] trailSeqNBytes;
    byte[] controlPacket;
    int controlPacketLength;
    BufferCyclQueue pendingPackets;
    BufferCyclQueue sentPackets;
    int oldFront;
    boolean isActive;
    boolean isClosed;
    boolean isWaiting;
    long closeTime;
    Object ljLock = new Object();
    boolean lateJoinEnabled;
    boolean ljOptionSet;
    int ljOptionValue;
    int optFieldLen;
    byte nOptions;
    long cpLastTime;
    boolean cpSend;
    private DataOutputStream dos;
    private DataOutputStream cpDos;
    private PersistByteArrayOutputStream pbaos;
    private PersistByteArrayOutputStream cpBaos;
    private BufferRequestListener bufferRequestListener;
    AdminLayerListener adminListener;
    TokenBucket oDataBucket;
    CongestionControl congestionControl;
    StreamTUpcalls mCleanUp;
    boolean limitRate = false;
    byte[] optionsField;
    private int ncOptions;
    private byte[] cOptionType;
    private byte[][] cOptionVal;
    private Object cOptionLock;
    int noReListContr;
    Object redLock = new Object();
    boolean redLineSet = false;
    int redLine;
    int minNackSeqN;
    double avrgLossRate;
    StreamBitmap nack_bitmap;
    long bytesTransmitted;
    long bytesRetransmitted;
    int mtlSize;
    boolean sendPartial;
    Object sendPartialMutex;
    EventListener eventListener;

    StreamT(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    boolean init(byte[] tag, short id, boolean is_reliable, InetAddress mcast_address, int port2, boolean lj_enabled) {
        this.tag = tag;
        this.tagLength = (short)tag.length;
        this.shortId = id;
        this.isReliable = is_reliable;
        this.lateJoinEnabled = lj_enabled;
        this.mcastGroup = mcast_address;
        this.dataPort = port2;
        this.mcastAddress = this.mcastGroup.getHostAddress();
        this.nOptions = 0;
        this.ncOptions = 0;
        this.cOptionType = new byte[64];
        this.cOptionVal = new byte[64][];
        this.cOptionLock = new Object();
        this.noReListContr = 0;
        this.isActive = true;
        this.isClosed = false;
        this.isWaiting = false;
        this.udpPacket = new DatagramPacket(new byte[1], 1, this.mcastGroup, this.dataPort);
        this.pbaos = new PersistByteArrayOutputStream();
        this.dos = new DataOutputStream(this.pbaos);
        this.cpBaos = new PersistByteArrayOutputStream();
        this.cpDos = new DataOutputStream(this.cpBaos);
        this.sendPartialMutex = new Object();
        this.sendPartial = false;
        this.pendFrontSeqN = 0;
        this.sentFrontSeqN = this.pendFrontSeqN - 1;
        this.trailSeqN = this.pendFrontSeqN;
        this.ljOptionValue = this.pendFrontSeqN - 1;
        ByteBuffer bb = ByteBuffer.allocate(8);
        try {
            this.trailSeqNBytes = new byte[4];
            bb.clear();
            bb.putInt(this.trailSeqN);
            bb.flip();
            bb.get(this.trailSeqNBytes);
        }
        catch (Exception ex) {
            this.pTrans.rmmLogger.baseError("Failed to write trail byte array", ex, moduleName);
            return false;
        }
        try {
            bb.clear();
            bb.putShort(this.shortId);
            bb.put(this.pTrans.ipAddress, 0, 4);
            bb.putShort((short)this.pTrans.nackPort);
            bb.flip();
            this.longId = bb.getLong();
        }
        catch (Exception ex) {
            this.pTrans.rmmLogger.baseError("Failed to write stream id", ex, moduleName);
            return false;
        }
        bb = null;
        this.cpSend = true;
        this.pTrans.hbSender.wakeUp(true);
        this.pendingPackets = new BufferCyclQueue(128);
        if (this.isReliable) {
            this.sentPackets = new BufferCyclQueue(128);
        }
        return true;
    }

    public synchronized boolean close(boolean soft) {
        if (!this.isActive) {
            return true;
        }
        this.isActive = false;
        this.nOptions = (byte)(this.nOptions + 1);
        this.closeTime = Clock.getTime();
        this.pTrans.rmmLogger.baseInfo(String.valueOf(soft ? "Soft " : "Fast ") + "Closing Transmitter Stream: " + this.longId, moduleName);
        if (!soft) {
            this.pTrans.hbSender.wakeUp(true);
            Thread.yield();
            this.isClosed = true;
            this.pTrans.removeStream(this);
            this.cleanAfterClose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAfterClose() {
        int i;
        int sps;
        if (this.oDataBucket != null) {
            this.oDataBucket.stop();
        }
        BufferCyclQueue bufferCyclQueue = this.pendingPackets;
        synchronized (bufferCyclQueue) {
            sps = this.pendingPackets.qSize();
            i = 0;
            while (i < sps) {
                this.pTrans.returnBuffer(this.pendingPackets.popFirst());
                ++i;
            }
        }
        if (this.sentPackets != null) {
            bufferCyclQueue = this.sentPackets;
            synchronized (bufferCyclQueue) {
                sps = this.sentPackets.qSize();
                i = 0;
                while (i < sps) {
                    this.pTrans.returnBuffer(this.sentPackets.popFirst());
                    ++i;
                }
            }
        }
        if (this.mCleanUp != null) {
            this.mCleanUp.cleanAfterClose();
        }
        this.mCleanUp = null;
        this.bufferRequestListener = null;
    }

    public int cleanBuffer(int new_trail) {
        return 0;
    }

    public int getFrontSeqNum() {
        return this.pendFrontSeqN - 1;
    }

    public int getTrailSeqNum() {
        return this.trailSeqN;
    }

    public InetAddress getMulticastGroup() {
        return this.mcastGroup;
    }

    public long getId() {
        return this.longId;
    }

    public long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    public long getPendingQueueSize() {
        return this.pendingPackets.qSize() * this.pTrans.packetSize;
    }

    public long getBytesRetransmitted() {
        return this.bytesRetransmitted;
    }

    public int getPort() {
        return this.dataPort;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public short getTagLength() {
        return this.tagLength;
    }

    public long lastNackTime() {
        return this.lastNackTime;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isReliable() {
        return this.isReliable;
    }

    public boolean isConnected(String address, int port2) {
        return false;
    }

    public boolean isQuarantined() {
        return false;
    }

    boolean requestPartialPacket() {
        boolean ret;
        if (this.bufferRequestListener != null) {
            ret = this.bufferRequestListener.onRequest();
        } else {
            ++this.noReListContr;
            if (this.noReListContr > 5) {
                this.pTrans.rmmLogger.baseWarn("StreamT:requestPartialPacket bufferRequestListener is null. Stream: " + this.toString(), null, moduleName);
            }
            ret = false;
        }
        return ret;
    }

    public void setBufReqListener(BufferRequestListener listener) {
        if (this.bufferRequestListener != null) {
            this.pTrans.rmmLogger.baseWarn("Replacing bufferRequestListener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.bufferRequestListener = listener;
    }

    public void setAdminListener(AdminLayerListener fl) {
        this.adminListener = fl;
        if (this.adminListener == null) {
            return;
        }
        if (this.lastNackSource != null) {
            AdminEvent ev = new AdminEvent(2, this.lastNackSource, this.lastNackPort);
            ev.intField = this.lastNackQuant;
            ev.longField = this.lastNackTime;
            fl.onEvent(ev);
        }
    }

    public void setCleanUpListener(StreamTUpcalls mcu) {
        this.mCleanUp = mcu;
    }

    public void setEventListener(EventListener el) {
        this.eventListener = el;
    }

    public void setLjMarker() {
        this.advanceLjMarker(this.pendFrontSeqN);
    }

    public boolean addP2Pdestination(InetSocketAddress dest, boolean useExisting) {
        this.pTrans.rmmLogger.baseError("Adding p2p destination on multicast stream. No effect", null, moduleName);
        return false;
    }

    public boolean addP2PdestinationNonBlocking(InetSocketAddress dest, CreateConnectionListener listener, int timeout) {
        this.pTrans.rmmLogger.baseError("Adding p2p destination on multicast stream. No effect", null, moduleName);
        return false;
    }

    public void removeP2Pdestination(InetSocketAddress dest) {
        this.pTrans.rmmLogger.baseError("Removing p2p destination on multicast stream. No effect", null, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceLjMarker(int pack_n) {
        if (pack_n - this.pendFrontSeqN > 0) {
            this.pTrans.rmmLogger.baseWarn("Trying to set late join mark " + pack_n + " past current front " + this.pendFrontSeqN + ". Ignored. Stream: " + this.toString(), null, moduleName);
            return;
        }
        if (pack_n - this.trailSeqN < 0) {
            if (this.pendFrontSeqN - this.trailSeqN > 0) {
                this.pTrans.rmmLogger.baseWarn("Trying to set late join mark " + pack_n + " below current trail " + this.trailSeqN + " Setting to trail. Stream:" + this, null, moduleName);
            }
            pack_n = this.trailSeqN;
        }
        Object object = this.ljLock;
        synchronized (object) {
            if (!this.ljOptionSet) {
                this.nOptions = (byte)(this.nOptions + 1);
                this.ljOptionSet = true;
            } else if (pack_n - this.ljOptionValue < 0) {
                this.pTrans.rmmLogger.baseWarn("StreamT.advanceLjMarker: new packet " + pack_n + " lower than previously set " + this.ljOptionValue + ". Ignored. Stream: " + this, null, moduleName);
                return;
            }
            this.ljOptionValue = pack_n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitPacketData(byte[] mtlhdr, int off1, int len1, byte[] mtldat, int off2, int len2) {
        RmmBuffer packet = this.pTrans.getBuffer(this);
        if (packet == null) {
            return false;
        }
        this.pbaos.setBuffer(packet.dataBuffer);
        try {
            this.dos.writeByte(5);
            this.dos.writeByte(1);
            this.dos.writeShort(this.shortId);
            this.dos.write(this.pTrans.ipAddress, 0, 4);
            this.dos.writeShort(this.pTrans.nackPort);
            this.dos.writeInt(this.pendFrontSeqN);
            this.dos.writeInt(this.trailSeqN);
            this.dos.writeByte(this.nOptions);
            if (this.ljOptionSet) {
                this.dos.writeByte(1);
                this.dos.writeInt(this.ljOptionValue);
            }
            if (!this.isActive) {
                this.dos.writeByte(2);
            }
            this.dos.writeShort(this.tagLength);
            this.dos.write(this.tag, 0, this.tagLength);
            this.dos.write(mtlhdr, off1, len1);
            this.dos.write(mtldat, off2, len2);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write data packet. Stream: " + this.toString(), ex, moduleName);
            this.pTrans.returnBuffer(packet);
            return false;
        }
        packet.dataLength = this.pbaos.getPosition();
        BufferCyclQueue bufferCyclQueue = this.pendingPackets;
        synchronized (bufferCyclQueue) {
            if (this.isClosed) {
                this.pTrans.returnBuffer(packet);
                return false;
            }
            while (this.isCongested()) {
                try {
                    this.isWaiting = true;
                    this.pendingPackets.wait(50L);
                    this.isWaiting = false;
                }
                catch (InterruptedException ex) {
                    this.isWaiting = false;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"Waiting on full pending queue. Stream: " + this.getId()}, ex, moduleName);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            this.pendingPackets.pushLast(packet);
        }
        this.pTrans.streamFireout.wakeUp(true);
        if (this.pTrans.config.collectStats) {
            this.bytesTransmitted += (long)this.pbaos.getPosition();
        }
        ++this.pendFrontSeqN;
        return true;
    }

    public boolean isCongested() {
        return this.pTrans.nPending > this.pTrans.nPendingMax && this.pendingPackets.qSize() > 10;
    }

    public void wakeUp() {
        this.pTrans.streamFireout.wakeUp(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCP() {
        this.cpBaos.reset();
        try {
            this.cpDos.writeByte(5);
            this.cpDos.writeByte(2);
            this.cpDos.writeShort(this.shortId);
            this.cpDos.write(this.pTrans.ipAddress, 0, 4);
            this.cpDos.writeShort(this.pTrans.nackPort);
            this.cpDos.writeInt(this.sentFrontSeqN);
            this.cpDos.writeInt(this.trailSeqN);
            this.cpDos.writeByte(this.nOptions);
            if (this.ljOptionSet) {
                this.cpDos.writeByte(1);
                this.cpDos.writeInt(this.ljOptionValue);
            }
            if (!this.isActive) {
                this.cpDos.writeByte(2);
            }
            this.cpDos.writeShort(this.tagLength);
            this.cpDos.write(this.tag, 0, this.tagLength);
            this.cpDos.writeShort((short)(this.pTrans.config.cpTimeout / 1000));
            this.cpDos.writeByte(this.isReliable ? 1 : 0);
            this.cpDos.writeByte(this.isActive ? 1 : 0);
            this.cpDos.writeUTF(this.mcastAddress);
            Object object = this.cOptionLock;
            synchronized (object) {
                this.cpDos.writeByte(this.ncOptions);
                int i = 0;
                while (i < this.ncOptions) {
                    this.cpDos.writeByte(this.cOptionType[i]);
                    this.cpDos.writeInt(this.cOptionVal[i].length);
                    this.cpDos.write(this.cOptionVal[i]);
                    ++i;
                }
            }
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write ControlPacket. Stream: " + this.toString(), ex, moduleName);
        }
        this.controlPacket = this.cpBaos.getBuffer();
        this.controlPacketLength = this.cpBaos.getPosition();
    }

    public void setTransmissionRate(int rate_kbps) {
        if (this.oDataBucket == null) {
            this.oDataBucket = new TokenBucket(rate_kbps, this.pTrans.rmmLogger, this.pTrans.taskMan);
            this.limitRate = true;
        }
        if (this.congestionControl == null) {
            this.oDataBucket.setRate(rate_kbps);
        } else {
            this.congestionControl.resetValues(rate_kbps);
        }
    }

    public void startCongestionControl(int rate_kbps) {
        if (this.oDataBucket == null) {
            this.oDataBucket = new TokenBucket(rate_kbps, this.pTrans.rmmLogger, this.pTrans.taskMan);
        }
        if (this.congestionControl == null) {
            this.congestionControl = new CongestionControl(this.pTrans.config, this.oDataBucket, rate_kbps, this);
        } else {
            this.congestionControl.resetValues(rate_kbps);
        }
        this.limitRate = true;
    }

    public void stopCongestionControl() {
        this.congestionControl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdminOption(byte type, byte[] option) {
        Object object = this.cOptionLock;
        synchronized (object) {
            int i = 0;
            while (i < this.ncOptions) {
                if (this.cOptionType[i] == type) break;
                ++i;
            }
            if (i >= this.ncOptions) {
                if (this.ncOptions >= this.cOptionType.length) {
                    this.pTrans.rmmLogger.baseWarn("StreamT.setControlOption: failed: too many options set. Stream: " + this.toString(), null, moduleName);
                    return;
                }
                this.cOptionType[this.ncOptions++] = type;
            }
            if (this.cOptionVal[i] == null || this.cOptionVal[i].length != option.length) {
                this.cOptionVal[i] = new byte[option.length];
            }
            System.arraycopy(option, 0, this.cOptionVal[i], 0, option.length);
        }
        this.cpSend = true;
        this.pTrans.hbSender.wakeUp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedLine(int pack_seq_n) {
        if (pack_seq_n - this.pendFrontSeqN > 0) {
            this.pTrans.rmmLogger.baseWarn("Trying to set red line " + pack_seq_n + " past current front " + this.pendFrontSeqN + ". Ignored. Stream: " + this.toString(), null, moduleName);
            return;
        }
        if (pack_seq_n - this.trailSeqN < 0) {
            if (this.pendFrontSeqN - this.trailSeqN > 0) {
                this.pTrans.rmmLogger.baseWarn("Trying to set red line " + pack_seq_n + " below current trail. Setting it to trail " + this.trailSeqN + ". Stream:" + this, null, moduleName);
            }
            pack_seq_n = this.trailSeqN;
        }
        Object object = this.redLock;
        synchronized (object) {
            this.redLineSet = true;
            if (pack_seq_n - this.redLine < 0) {
                this.pTrans.rmmLogger.baseWarn("Trying to set red line " + pack_seq_n + " below current redLine " + this.redLine + ". Ignored. Stream: " + this.toString(), null, moduleName);
                return;
            }
            this.redLine = pack_seq_n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRedLine() {
        Object object = this.redLock;
        synchronized (object) {
            if (this.redLineSet) {
                return this.redLine;
            }
            return this.getFrontSeqNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRedLine() {
        Object object = this.redLock;
        synchronized (object) {
            this.redLineSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPossibleJoin() {
        Object object = this.ljLock;
        synchronized (object) {
            if (this.ljOptionSet) {
                return this.ljOptionValue;
            }
            return this.getFrontSeqNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdminOption(byte type) {
        Object object = this.cOptionLock;
        synchronized (object) {
            int i = 0;
            while (i < this.ncOptions) {
                if (this.cOptionType[i] == type) {
                    --this.ncOptions;
                    this.cOptionType[i] = this.cOptionType[this.ncOptions];
                    this.cOptionVal[i] = this.cOptionVal[this.ncOptions];
                    break;
                }
                ++i;
            }
        }
        this.cpSend = true;
        this.pTrans.hbSender.wakeUp(true);
    }

    public String toString() {
        return "" + this.longId;
    }

    public boolean sendHeartbeat() {
        this.pTrans.rmmLogger.baseWarn("sendHeartbeat() (API) called on multicast topic", null, moduleName);
        return false;
    }

    public UnicastConnectionIf getUnicastConnection() {
        this.pTrans.rmmLogger.baseWarn("getUnicastConnection() (API) called on multicast topic", null, moduleName);
        return null;
    }

    public boolean addP2Pdestination(UnicastConnectionIf connection) {
        this.pTrans.rmmLogger.baseWarn("addP2Pdestination() (API) called on multicast topic", null, moduleName);
        return false;
    }

    public void setMtlSize(int size) {
        this.mtlSize = size;
    }
}

