/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.mstp.transmitter;

import com.ibm.rmm.ptl.mstp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.mstp.transmitter.StreamT;

class TimingThread
extends Thread {
    static final String moduleName = "PTL_T";
    PTransmitter pTrans;
    volatile int nRot;
    volatile int curPos;
    volatile int cmCalls;
    boolean isSleeping;
    boolean notifyPending;
    private boolean goOn = true;

    TimingThread(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            TimingThread timingThread = this;
            synchronized (timingThread) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.curPos = 1;
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"TimingThread"}, null, moduleName);
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                boolean ok2cont = true;
                if (this.pTrans.bufferPool.getUtilization() > 80) {
                    ++this.cmCalls;
                    Object object = this.pTrans.memCleanMutex;
                    synchronized (object) {
                        ok2cont = this.pTrans.tryToCleanMemory();
                    }
                }
                this.curPos = 2;
                if (ok2cont) {
                    int i = 0;
                    while (i < this.pTrans.nStreams) {
                        StreamT stream = this.pTrans.streamList[i];
                        if (stream != null) {
                            this.curPos = 3;
                            if (stream.pendingPackets.qSize() == 0 && stream.mtlSize > 0) {
                                stream.requestPartialPacket();
                            }
                        }
                        ++i;
                    }
                }
                this.curPos = 6;
                TimingThread i = this;
                synchronized (i) {
                    if (this.notifyPending) {
                        this.notifyPending = false;
                    } else {
                        this.isSleeping = true;
                        this.wait();
                        this.isSleeping = false;
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"TimingThread"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("TimingThread: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop TimingThread", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"TimingThread"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"TimingThread"}, null, moduleName);
    }
}

