/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.receiver;

import com.ibm.rmm.ptl.pgm.transmitter.PgmConst;
import com.ibm.rmm.util.RmmLogger;
import java.util.Properties;

class Config
implements PgmConst {
    static final String moduleName = "PTL_PGM_R";
    int statBackoff;
    int nackPeriodSleep;
    int socketBufferSize;
    int packetSize;
    int dataPort;
    int nBuffers;
    boolean pgmOverIp;
    boolean optAcc2Rfc;
    RmmLogger rmmLogger;
    String setLoopback;
    int firstSourceTimeout;
    boolean isOK;

    Config(RmmLogger rlog, Properties java_props) {
        this.rmmLogger = rlog;
        this.isOK = true;
        String tmp = java_props.getProperty("ProtocolType");
        if (tmp != null) {
            this.pgmOverIp = tmp.equalsIgnoreCase("PGM/IP");
        }
        String rep = this.pgmOverIp ? "PGM/IP" : "UDP encapsulated PGM";
        this.rmmLogger.baseInfo("PTL Protocol: " + rep, moduleName);
        tmp = java_props.getProperty("DataPort");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"DataPort"}, null, moduleName);
        } else {
            try {
                this.dataPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("DataPort", tmp, e2, moduleName);
            }
        }
        if (this.dataPort <= 0 || this.dataPort > 65536) {
            this.rmmLogger.baseBadParam("DataPort", "" + this.dataPort, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = java_props.getProperty("BackoffTimeMillis");
        if (tmp == null) {
            this.statBackoff = 0;
        } else {
            try {
                this.statBackoff = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("BackoffTimeMillis", tmp, e3, moduleName);
                this.statBackoff = 0;
            }
            if (this.statBackoff < 0) {
                this.rmmLogger.baseBadParam("BackoffTimeMillis", "" + this.statBackoff, null, moduleName);
                this.statBackoff = 0;
            } else if (this.statBackoff > 5000) {
                this.rmmLogger.baseWarn("High BackoffTimeMillis value: " + this.statBackoff, null, moduleName);
            }
        }
        tmp = java_props.getProperty("NackCheckPeriodMillis");
        if (tmp == null) {
            this.nackPeriodSleep = 300;
        } else {
            try {
                this.nackPeriodSleep = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e4) {
                this.rmmLogger.baseBadParam("NackCheckPeriodMillis", tmp, e4, moduleName);
            }
            if (this.nackPeriodSleep <= 0) {
                this.rmmLogger.baseBadParam("NackCheckPeriodMillis", "" + this.nackPeriodSleep, null, moduleName);
            } else if (this.nackPeriodSleep < 10 || this.nackPeriodSleep > 5000) {
                this.rmmLogger.baseWarn("NackCheckPeriodMillis value: " + this.nackPeriodSleep, null, moduleName);
            }
        }
        if (this.nackPeriodSleep <= 10) {
            this.rmmLogger.baseInfo("Using default NackCheckPeriodMillis: 300 msec", moduleName);
            this.nackPeriodSleep = 300;
        }
        if ((tmp = java_props.getProperty("SocketBufferSizeKbytes")) == null) {
            tmp = java_props.getProperty("SocketBufferSizeKbyte");
        }
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"SocketBufferSizeKbytes"}, null, moduleName);
        } else {
            try {
                this.socketBufferSize = 1024 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("SocketBufferSizeKbyte", tmp, e5, moduleName);
            }
            if (this.socketBufferSize <= 0) {
                this.rmmLogger.baseBadParam("SocketBufferSizeKbyte", "" + this.socketBufferSize, null, moduleName);
            } else if (this.socketBufferSize < 65000 || this.socketBufferSize > 100000000) {
                this.rmmLogger.baseWarn("SocketBufferSizeKbyte value: " + this.socketBufferSize, null, moduleName);
            }
        }
        tmp = java_props.getProperty("PacketBuffers");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"PacketBuffers"}, null, moduleName);
        } else {
            try {
                this.nBuffers = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e6) {
                this.rmmLogger.baseBadParam("PacketBuffers", tmp, e6, moduleName);
            }
            if (this.nBuffers <= 0) {
                this.rmmLogger.baseBadParam("PacketBuffers", "" + this.nBuffers, null, moduleName);
            } else if (this.nBuffers > 5000) {
                this.rmmLogger.baseWarn("PacketBuffers value: " + this.nBuffers, null, moduleName);
            }
        }
        if (this.nBuffers <= 0) {
            this.rmmLogger.baseInfo("Using default PacketBuffers: 500", moduleName);
            this.nBuffers = 500;
        }
        this.optAcc2Rfc = (tmp = java_props.getProperty("PgmOptionSet")) != null ? tmp.toLowerCase().indexOf("optrfc") > 0 : false;
        tmp = java_props.getProperty("PacketBufferSizeBytes");
        if (tmp == null) {
            this.packetSize = 33000;
        } else {
            try {
                this.packetSize = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e7) {
                this.rmmLogger.baseBadParam("PacketBufferSizeBytes", tmp, e7, moduleName);
                this.packetSize = 33000;
            }
            if (this.packetSize < 1500 || this.packetSize > 33000) {
                this.rmmLogger.baseWarn("PacketBufferSizeBytes value: " + this.packetSize, null, moduleName);
            }
            this.packetSize += 100;
        }
        this.setLoopback = java_props.getProperty("SetLoopbackMode");
        tmp = java_props.getProperty("FirstSourceTimeoutSec");
        if (tmp != null) {
            try {
                this.firstSourceTimeout = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e8) {
                this.rmmLogger.baseBadParam("FirstSourceTimeoutSec", tmp, e8, moduleName);
            }
        }
        if (this.firstSourceTimeout <= 0) {
            this.firstSourceTimeout = 60000;
        }
    }
}

