/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import com.ibm.rmm.intrn.util.PgmIpSocket;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.pgm.receiver.PEvent;
import com.ibm.rmm.ptl.pgm.receiver.PReceiver;
import com.ibm.rmm.ptl.pgm.receiver.StreamR;
import com.ibm.rmm.util.StackTracer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

final class NackGenerator
extends Thread {
    static final String moduleName = "PTL_PGM_R";
    static final int NAK_BACK_OFF_STATE = 0;
    static final int NAK_WAIT_NCF_STATE = 1;
    static final int NAK_WAIT_DATA_STATE = 2;
    static final int MAX_SQN_PER_NAK = 63;
    static final int NackTimeoutNCF = 200;
    static final int NackTimeoutData = 500;
    static final int NackTimeoutBOF = 5;
    static final int NackRetriesNCF = 256;
    static final int NackRetriesData = 512;
    DatagramSocket udpUcSocket;
    MulticastSocket udpMcSocket;
    PgmIpSocket ipUcSocket;
    PgmIpSocket ipMcSocket;
    volatile int nRot;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private PReceiver pRec;
    private boolean goOn = true;

    NackGenerator(PReceiver prc, DatagramSocket u_socket) {
        this.pRec = prc;
        this.udpUcSocket = u_socket;
        if (this.pRec.config.pgmOverIp) {
            try {
                this.ipMcSocket = PgmIpLayer.createTrIpSocket(true, 1, this.pRec.mcInterf, -1, 0);
            }
            catch (IOException e2) {
                this.pRec.rmmLogger.baseError("Failed to create multicast Nack socket", e2, moduleName);
            }
            try {
                this.ipUcSocket = PgmIpLayer.createTrIpSocket(false, -1, this.pRec.mcInterf, -1, 0);
            }
            catch (IOException e3) {
                this.pRec.rmmLogger.baseLog(404, new Object[]{""}, e3, moduleName);
            }
        } else {
            try {
                this.udpMcSocket = new MulticastSocket();
            }
            catch (IOException e4) {
                this.pRec.rmmLogger.baseError("Failed to create multicast Nack socket", e4, moduleName);
            }
            try {
                this.udpMcSocket.setTimeToLive(1);
            }
            catch (IOException e5) {
                this.pRec.rmmLogger.baseError("Failed to set TTL on multicast Nack socket", e5, moduleName);
            }
            if (this.pRec.mcInterf != null) {
                try {
                    this.udpMcSocket.setInterface(this.pRec.mcInterf);
                }
                catch (IOException ex) {
                    this.pRec.rmmLogger.baseError("Failed to set interface on multicast Nack socket", ex, moduleName);
                }
            }
        }
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[MONITOR]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkHeartBeat(StreamR stream) {
        long time = Clock.getTime();
        if (time - stream.lastSpmOrDataTime > (long)stream.hbTimeout) {
            if (!stream.firstHbTimeoutCall) {
                stream.firstHbTimeoutCall = true;
                return;
            }
            if (!stream.hbHasTimedOut) {
                if (stream.transClosed) {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("Heartbeat timeout on Stream " + stream + ". Was orderly closed by transmitter", moduleName);
                    }
                } else {
                    this.pRec.rmmLogger.baseWarn("Heartbeat timeout on Stream " + stream, null, moduleName);
                }
                PEvent ev = new PEvent(2, stream);
                stream.mySet.packetListener.onEvent(ev);
                if (stream.adminListener != null) {
                    stream.adminListener.onEvent(ev);
                }
                stream.mySet.packetListener.onHeartbeatTimeout(stream);
            }
            stream.hbHasTimedOut = true;
        } else {
            stream.firstHbTimeoutCall = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkNakElement(NackInfo pnk, StreamR pst) {
        boolean dataOk;
        StreamBitmap streamBitmap = pst.strBitmap;
        synchronized (streamBitmap) {
            dataOk = pst.strBitmap.has(pnk.pSN);
        }
        if (dataOk) {
            return -1;
        }
        if (pnk.pSN - pst.trailSeqN < 0) {
            return -1;
        }
        if (pnk.oldNakNcfTime < pnk.newNakNcfTime) {
            pnk.oldNakNcfTime = pnk.newNakNcfTime;
            pnk.timer = pnk.newNakNcfTime;
            if (pnk.flag == 10) {
                pnk.state = 2;
            } else if (pnk.state == 0) {
                pnk.state = 1;
            }
        }
        if (pnk.state == 0) {
            if (Clock.getTime() - pnk.timer >= 5L) {
                pnk.state = 1;
                pnk.timer = Clock.getTime();
                return 1;
            }
            return 0;
        }
        if (pnk.state == 1) {
            if (Clock.getTime() - pnk.timer >= 200L) {
                if (pnk.ncfRetryCount++ > 256) {
                    return -1;
                }
                pnk.state = 0;
            }
            return 0;
        }
        if (pnk.state == 2) {
            if (Clock.getTime() - pnk.timer >= 500L) {
                if (pnk.dataRetryCount++ > 512) {
                    return -1;
                }
                pnk.state = 0;
            }
            return 0;
        }
        return -1;
    }

    private byte[] writeNack(StreamR stream, int n_missing, int[] missing) {
        if (n_missing <= 0 || n_missing > 63) {
            this.pRec.rmmLogger.baseWarn("Trying to write Nack for " + n_missing + " missing packets", null, moduleName);
        }
        this.baos.reset();
        try {
            this.dos.writeShort(this.pRec.config.dataPort);
            this.dos.write(stream.localId);
            this.dos.writeByte(8);
            if (n_missing > 1) {
                if (this.pRec.config.optAcc2Rfc) {
                    this.dos.writeByte(-64);
                } else {
                    this.dos.writeByte(3);
                }
            } else {
                this.dos.writeByte(0);
            }
            this.dos.writeShort(0);
            this.dos.write(stream.gSi, 0, 6);
            this.dos.writeShort(0);
            this.dos.writeInt(missing[0]);
            if (stream.sourceIPbytes.length == 16) {
                this.dos.writeShort(2);
            } else {
                this.dos.writeShort(1);
            }
            this.dos.writeShort(0);
            this.dos.write(stream.sourceIPbytes);
            if (stream.mcastGroupBytes.length == 16) {
                this.dos.writeShort(2);
            } else {
                this.dos.writeShort(1);
            }
            this.dos.writeShort(0);
            this.dos.write(stream.mcastGroupBytes);
            if (n_missing > 1) {
                this.dos.writeByte(0);
                this.dos.writeByte(4);
                this.dos.writeShort(8 + 4 * (n_missing - 1));
                this.dos.writeByte(-126);
                this.dos.writeByte(4 + 4 * (n_missing - 1));
                this.dos.writeShort(0);
                int i = 1;
                while (i < n_missing) {
                    this.dos.writeInt(missing[i]);
                    ++i;
                }
            }
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to write NACK packet. Stream: " + stream, ex, moduleName);
            return null;
        }
        return this.baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNack(byte[] nackp, StreamR stream, boolean unicast, boolean multicast) {
        if (!unicast && !multicast) {
            this.pRec.rmmLogger.baseError("sendNack(false, false). Was not sent. Stream: " + stream, new StackTracer(), moduleName);
            return;
        }
        Object object = stream.nackLock;
        synchronized (object) {
            block21: {
                boolean isUnicast = false;
                try {
                    DatagramSocket datagramSocket;
                    if (this.pRec.config.pgmOverIp) {
                        PgmIpSocket pgmIpSocket;
                        if (unicast) {
                            isUnicast = true;
                            pgmIpSocket = this.ipUcSocket;
                            synchronized (pgmIpSocket) {
                                this.ipUcSocket.send(stream.nackAddressHandle, nackp, nackp.length);
                            }
                        }
                        if (!multicast) break block21;
                        isUnicast = false;
                        if (stream.mcastGroupHandle <= 0) break block21;
                        pgmIpSocket = this.ipMcSocket;
                        synchronized (pgmIpSocket) {
                            this.ipMcSocket.send(stream.mcastGroupHandle, nackp, nackp.length);
                            break block21;
                        }
                    }
                    stream.nackUPacket.setData(nackp);
                    stream.nackUPacket.setLength(nackp.length);
                    stream.nackMPacket.setData(nackp);
                    stream.nackMPacket.setLength(nackp.length);
                    if (unicast) {
                        isUnicast = true;
                        datagramSocket = this.udpUcSocket;
                        synchronized (datagramSocket) {
                            this.udpUcSocket.send(stream.nackUPacket);
                        }
                    }
                    if (!multicast) break block21;
                    isUnicast = false;
                    if (stream.nackMPacket.getAddress() == null) break block21;
                    datagramSocket = this.udpMcSocket;
                    synchronized (datagramSocket) {
                        this.udpMcSocket.send(stream.nackMPacket);
                    }
                }
                catch (Exception ex) {
                    String msg = isUnicast ? "Failed to send Unicast NACK. Stream: " : "Failed to send Multicast NACK. Stream: ";
                    InetAddress ia = isUnicast ? stream.nackAddress : stream.mcastGroup;
                    this.pRec.rmmLogger.baseError(String.valueOf(msg) + stream, ex, moduleName);
                    this.pRec.rmmLogger.baseLog(417, new Object[]{ia.getHostAddress()}, ex, moduleName);
                }
            }
        }
    }

    public class NackInfo {
        int pSN;
        int state;
        long timer;
        long oldNakNcfTime;
        long newNakNcfTime;
        int ncfRetryCount;
        int dataRetryCount;
        byte flag;
    }
}

