/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.receiver;

import com.ibm.rmm.intrn.util.PacManOut;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetUpcalls;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.pgm.receiver.Config;
import com.ibm.rmm.ptl.pgm.receiver.LongStreamHash;
import com.ibm.rmm.ptl.pgm.receiver.NackGenerator;
import com.ibm.rmm.ptl.pgm.receiver.PEvent;
import com.ibm.rmm.ptl.pgm.receiver.PacketProcessor;
import com.ibm.rmm.ptl.pgm.receiver.PacketReceiver;
import com.ibm.rmm.ptl.pgm.receiver.StreamR;
import com.ibm.rmm.ptl.pgm.receiver.StreamSet;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PReceiver
implements PReceiverIf {
    static final String moduleName = "PTL_PGM_R";
    PTransmitterIf myPTransmitter;
    RmmAddress rmmAddress;
    RmmLogger rmmLogger;
    TaskManager taskMan;
    Config config;
    NackGenerator streamNackSender;
    InetAddress mcInterf;
    Vector packetReceivers;
    boolean isRunning;
    boolean relSrvRun = false;
    int nSets;
    private int setQsize = 100;
    StreamSet[] setList;
    private long[] rejectedStreams;
    private int rejectedStreamNumber;
    private int rejectedStreamSize;
    private Object rejectedStreamLock;
    private int rejectedVersion;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, InetAddress mc_interf) {
        try {
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.isRunning = true;
            this.mcInterf = mc_interf;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            if (this.config.pgmOverIp) {
                PgmIpLayer.init(this.rmmLogger);
            }
            this.rejectedStreamNumber = 0;
            this.rejectedStreamSize = 10;
            this.rejectedStreams = new long[this.rejectedStreamSize];
            this.rejectedStreamLock = new Object();
            this.rejectedVersion = 0;
            this.nSets = 0;
            this.setList = new StreamSet[this.setQsize];
            this.packetReceivers = new Vector();
            this.streamNackSender = new NackGenerator(this, this.rmmAddress.getUdpSocket());
            this.streamNackSender.setName("Ptl_Pgm_NackGenerator");
            this.streamNackSender.setPriority(10);
            this.streamNackSender.start();
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PReceiver", e2, moduleName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StreamR fetchStream(long sid, LongStreamHash str_hash, DatagramPacket packet, byte[] jni_address, int jni_addr_len, byte[] tag_buffer, int tag_length) {
        StreamSet[] streamSetArray = this.rejectedStreamLock;
        synchronized (this.rejectedStreamLock) {
            int i = 0;
            while (i < this.rejectedStreamNumber) {
                if (this.rejectedStreams[i] == sid) {
                    // ** MonitorExit[var11_8] (shouldn't be in output)
                    return null;
                }
                ++i;
            }
            // ** MonitorExit[var11_8] (shouldn't be in output)
            if (tag_length == -1) {
                return null;
            }
            streamSetArray = this.setList;
            synchronized (this.setList) {
                int rv;
                i = 0;
                while (i < this.rejectedStreamNumber) {
                    if (this.rejectedStreams[i] == sid) {
                        // ** MonitorExit[var11_8] (shouldn't be in output)
                        return null;
                    }
                    ++i;
                }
                int tmp = (int)sid;
                int nack_port = tmp;
                if (nack_port < 0) {
                    nack_port -= -65536;
                }
                Object object = this.rejectedStreamLock;
                synchronized (object) {
                    rv = this.rejectedVersion;
                }
                int i2 = 0;
                while (i2 < this.nSets) {
                    StreamSet set = this.setList[i2];
                    InetAddress source = null;
                    if (this.config.pgmOverIp) {
                        try {
                            byte[] addr = new byte[jni_addr_len];
                            System.arraycopy(jni_address, 0, addr, 0, jni_addr_len);
                            source = InetAddress.getByAddress(addr);
                        }
                        catch (UnknownHostException e2) {
                            String address = String.valueOf(jni_address[0]) + "." + jni_address[1] + "." + jni_address[2] + "." + jni_address[3];
                            this.rmmLogger.baseLog(412, new Object[]{address}, e2, moduleName);
                            // ** MonitorExit[var11_8] (shouldn't be in output)
                            return null;
                        }
                    } else {
                        source = packet.getAddress();
                    }
                    boolean accept = set.getStreamSelector().acceptStream(tag_buffer, tag_length, sid, source, nack_port);
                    if (accept) {
                        byte[] tag = new byte[tag_length];
                        System.arraycopy(tag_buffer, 0, tag, 0, tag_length);
                        StreamR stream = set.addStream(sid, tag, source, nack_port);
                        PEvent ev = new PEvent(10, stream);
                        ev.objField = tag;
                        set.packetListener.onEvent(ev);
                        if (set.adminListener != null) {
                            set.adminListener.onEvent(ev);
                        }
                        str_hash.put(sid, stream);
                        // ** MonitorExit[var11_8] (shouldn't be in output)
                        return stream;
                    }
                    ++i2;
                }
                Object object2 = this.rejectedStreamLock;
                synchronized (object2) {
                    if (rv == this.rejectedVersion) {
                        if (this.rejectedStreamNumber == this.rejectedStreamSize) {
                            long[] tmpl = this.rejectedStreams;
                            this.rejectedStreamSize *= 2;
                            this.rejectedStreams = new long[this.rejectedStreamSize];
                            int i3 = 0;
                            while (i3 < this.rejectedStreamNumber) {
                                this.rejectedStreams[i3] = tmpl[i3];
                                ++i3;
                            }
                        }
                        this.rejectedStreams[this.rejectedStreamNumber] = sid;
                        ++this.rejectedStreamNumber;
                    }
                }
                // ** MonitorExit[var11_8] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamSet(StreamSet set) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            this.setList[this.nSets] = set;
            ++this.nSets;
            if (this.nSets == this.setQsize) {
                StreamSet[] tmp = this.setList;
                this.setList = new StreamSet[2 * this.setQsize];
                int i = 0;
                while (i < this.nSets) {
                    this.setList[i] = tmp[i];
                    ++i;
                }
                this.setQsize *= 2;
            }
            this.clearRejectedStreamList();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRejectedStreamList() {
        Object object = this.rejectedStreamLock;
        synchronized (object) {
            this.rejectedStreamNumber = 0;
            this.rejectedStreamSize = 10;
            this.rejectedStreams = new long[this.rejectedStreamSize];
            ++this.rejectedVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStreamSet(StreamSet set) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            int ind = 0;
            boolean found = false;
            int i = 0;
            while (i < this.nSets) {
                if (this.setList[i] == set) {
                    ind = i;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.rmmLogger.baseWarn("removeStreamSet: no set found", null, moduleName);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            i = ind;
            while (i < this.nSets - 1) {
                this.setList[i] = this.setList[i + 1];
                ++i;
            }
            --this.nSets;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int i2 = 0;
            while (i2 < set.streamList.size()) {
                StreamR str = (StreamR)set.streamList.elementAt(i2);
                int j = 0;
                while (j < this.packetReceivers.size()) {
                    PacketReceiver pr = (PacketReceiver)this.packetReceivers.elementAt(j);
                    LongStreamHash longStreamHash = pr.packetProcessor.streamHash;
                    synchronized (longStreamHash) {
                        pr.packetProcessor.streamHash.remove(str.id);
                    }
                    ++j;
                }
                ++i2;
            }
            return;
        }
    }

    public StreamSetIf createStreamSet(StreamSelector matcher, StreamSetUpcalls list, boolean reliable, boolean fifo) {
        if (fifo) {
            this.rmmLogger.baseError("PReceiver: currently FIFO is not supported at PTL layer", null, moduleName);
        }
        StreamSet str_set = new StreamSet(this, !reliable, false);
        str_set.setStreamSelector(matcher);
        str_set.setPacketListener(list);
        this.addStreamSet(str_set);
        return str_set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinMulticastGroup(InetAddress address, int port2) {
        if (port2 < 0) {
            port2 = this.config.dataPort;
        }
        Vector vector = this.packetReceivers;
        synchronized (vector) {
            PacketReceiver pr;
            block7: {
                int i = 0;
                while (i < this.packetReceivers.size()) {
                    PacketReceiver pr2 = (PacketReceiver)this.packetReceivers.elementAt(i);
                    if (pr2.getPort() == port2) {
                        return pr2.addGroup(address);
                    }
                    ++i;
                }
                pr = new PacketReceiver(this, port2);
                pr.setName("Ptl_Pgm_PacketReceiver_port:" + port2);
                pr.setPriority(10);
                boolean res = pr.addGroup(address);
                if (res) break block7;
                return false;
            }
            PacketProcessor pp = new PacketProcessor(this, pr);
            pp.setName("Ptl_Pgm_PacketProcessor_port:" + port2);
            pp.setPriority(10);
            this.packetReceivers.add(pr);
            pr.start();
            pp.start();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveMulticastGroup(InetAddress address, int port2) {
        if (port2 < 0) {
            port2 = this.config.dataPort;
        }
        Vector vector = this.packetReceivers;
        synchronized (vector) {
            PacketReceiver pr = null;
            int i = 0;
            while (i < this.packetReceivers.size()) {
                pr = (PacketReceiver)this.packetReceivers.elementAt(i);
                if (pr.getPort() == port2) {
                    return pr.leaveGroup(address);
                }
                ++i;
            }
            return false;
        }
    }

    public boolean stop() {
        this.rmmLogger.baseInfo("STOPPING RMReceiver", moduleName);
        this.isRunning = false;
        PacketReceiver pr = null;
        int j = 0;
        while (j < this.packetReceivers.size()) {
            pr = (PacketReceiver)this.packetReceivers.elementAt(j);
            int i = 0;
            while (i < pr.mcastGroups.size()) {
                InetAddress ma = (InetAddress)pr.mcastGroups.elementAt(i);
                try {
                    if (this.config.pgmOverIp) {
                        pr.ipMcSocket.leaveGroup(ma);
                    } else {
                        pr.udpMcSocket.leaveGroup(ma);
                    }
                }
                catch (IOException ex) {
                    this.rmmLogger.baseError("Failed to leave mcast group: " + ma, ex, moduleName);
                    this.rmmLogger.baseLog(409, new Object[]{ma.getHostAddress()}, ex, moduleName);
                }
                ++i;
            }
            pr.interrupt();
            try {
                Thread.sleep(10L);
                if (pr.isAlive()) {
                    if (this.config.pgmOverIp) {
                        pr.ipMcSocket.close();
                    } else {
                        pr.udpMcSocket.close();
                    }
                }
            }
            catch (Exception e2) {
                this.rmmLogger.baseError("Failed to close PacketReceiver socket", e2, moduleName);
            }
            pr.packetProcessor.interrupt();
            ++j;
        }
        int i = 0;
        while (!pr.threadStopped && i < 5) {
            pr.interrupt();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        if (!pr.threadStopped) {
            this.rmmLogger.baseError("Failed to properly stop PacketReceiver thread", null, moduleName);
        }
        i = 0;
        while (!pr.packetProcessor.threadStopped && i < 5) {
            pr.packetProcessor.interrupt();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        if (!pr.packetProcessor.threadStopped) {
            this.rmmLogger.baseError("Failed to properly stop PacketProcessor thread", null, moduleName);
        }
        this.streamNackSender.interrupt();
        if (this.config.pgmOverIp) {
            PgmIpLayer.stop();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamRIf getStream(long id) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            int j = 0;
            while (j < this.nSets) {
                int i = 0;
                while (i < this.setList[j].streamList.size()) {
                    StreamR stream = (StreamR)this.setList[j].streamList.elementAt(i);
                    if (stream.getId() == id) {
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return stream;
                    }
                    ++i;
                }
                ++j;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamRIf getStream(byte[] tag, InetAddress source_addr, int source_port) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            int j = 0;
            while (j < this.nSets) {
                int i = 0;
                while (i < this.setList[j].streamList.size()) {
                    StreamR stream = (StreamR)this.setList[j].streamList.elementAt(i);
                    if (Sutils.compareByteArrays(stream.getTag(), tag) && stream.getSourceAddress().equals(source_addr) && stream.getSourcePort() == source_port) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return stream;
                    }
                    ++i;
                }
                ++j;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getStreamList() {
        Vector<StreamR> tmp = new Vector<StreamR>();
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            int j = 0;
            while (j < this.nSets) {
                int n = this.setList[j].streamList.size();
                int i = 0;
                while (i < n) {
                    StreamR stream = (StreamR)this.setList[j].streamList.elementAt(i);
                    if (stream != null) {
                        tmp.add(stream);
                    }
                    ++i;
                }
                ++j;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tmp.elements();
        }
    }

    public String getProtocolVersion() {
        return "PGM";
    }

    public String getStatusLog() {
        if (this.packetReceivers.size() == 0) {
            return "";
        }
        StringBuffer stat = new StringBuffer();
        try {
            stat.append("NHB r: ").append(this.streamNackSender.nRot);
            stat.append(". PProc r: ").append(((PacketReceiver)this.packetReceivers.elementAt((int)0)).packetProcessor.nRot);
            stat.append(". PRec r: " + ((PacketReceiver)this.packetReceivers.elementAt((int)0)).nRot);
            return stat.toString();
        }
        catch (NullPointerException ex) {
            return "Not started";
        }
    }

    public synchronized void setPtransmitter(PTransmitterIf pTransmitter) {
        this.myPTransmitter = pTransmitter;
    }

    public int getServerSocketPort() {
        this.rmmLogger.baseError("getServerSocketPort called on Multicast Receiver", null, moduleName);
        return -1;
    }

    public void registerNewConnection(Object socket, InetAddress address, int port2) throws Exception {
        this.rmmLogger.baseError("registerNewConnection called on Multicast Receiver", null, moduleName);
        Exception ex = new Exception("registerNewConnection called on Multicast Receiver");
        throw ex;
    }

    public boolean checkOrRemoveConnection(Object socket, InetSocketAddress address, boolean checkOnly) {
        this.rmmLogger.baseError("removeConnection called on Multicast Receiver", null, moduleName);
        return false;
    }

    public int getConnStreams(Object socket, PacManOut pmo) {
        this.rmmLogger.baseError("getConnStreams called on Multicast Receiver", null, moduleName);
        return -1;
    }

    public int updSendSnp(int add) {
        this.rmmLogger.baseError("updSendSnp called on Multicast Receiver", null, moduleName);
        return -1;
    }
}

